/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.EscDialog;
import gui.Globals;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.json.JSONObject;
import sesim.Sim;

public class EditExchangeDialog
extends EscDialog {
    private JCheckBox autoInitialPrice;
    private JSpinner initialPrice;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSpinner moneyDecimalsSpinner;
    private JButton okButton;
    private JSpinner sharesDecimalsSpinner;

    public EditExchangeDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        JSONObject jo = Sim.getExchangeCfg(Globals.getConfig());
        this.moneyDecimalsSpinner.setValue(jo.optInt(Globals.sim.getExchange().CFG_MONEY_DECIMALS, 2));
        this.sharesDecimalsSpinner.setValue(jo.optInt(Globals.sim.getExchange().CFG_SHARES_DECIMALS, 0));
        this.initialPrice.setValue(jo.optDouble(Globals.sim.getExchange().CFG_INITIAL_PRICE, 100.0));
        boolean autoCalc = jo.optBoolean(Globals.sim.getExchange().CFG_AUTO_INITIAL_PRICE, true);
        this.autoInitialPrice.setSelected(autoCalc);
        this.initialPrice.setEnabled(!autoCalc);
    }

    int showdialog() {
        this.setVisible(true);
        return 3;
    }

    private void initComponents() {
        this.sharesDecimalsSpinner = new JSpinner();
        this.jLabel1 = new JLabel();
        this.moneyDecimalsSpinner = new JSpinner();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.okButton = new JButton();
        this.initialPrice = new JSpinner();
        this.jLabel3 = new JLabel();
        this.autoInitialPrice = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("SeSim ExchangeSettings");
        this.setMinimumSize(new Dimension(300, 142));
        this.setModal(true);
        this.sharesDecimalsSpinner.setModel(new SpinnerNumberModel(0, 0, 10, 1));
        this.jLabel1.setText("Shares decimals:");
        this.moneyDecimalsSpinner.setModel(new SpinnerNumberModel(2, 0, 10, 1));
        this.jLabel2.setText("Currency decimals:");
        this.jButton1.setText("Cancel");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditExchangeDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditExchangeDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.initialPrice.setModel(new SpinnerNumberModel((Number)0.0, Double.valueOf(0.0), null, (Number)1.0));
        this.jLabel3.setText("Initial price:");
        this.autoInitialPrice.setText("Calculate initial price automatically");
        this.autoInitialPrice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditExchangeDialog.this.autoInitialPriceActionPerformed(evt);
            }
        });
        GroupLayout layout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel3).addComponent(this.jLabel2, -1, 163, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout2.createSequentialGroup().addGap(42, 42, 42).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sharesDecimalsSpinner).addComponent(this.moneyDecimalsSpinner).addComponent(this.initialPrice, GroupLayout.Alignment.TRAILING))).addGroup(GroupLayout.Alignment.TRAILING, layout2.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)))).addGroup(layout2.createSequentialGroup().addComponent(this.autoInitialPrice).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addGap(15, 15, 15).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sharesDecimalsSpinner, -2, 28, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.moneyDecimalsSpinner, -2, 28, -2).addComponent(this.jLabel2)).addGap(29, 29, 29).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.initialPrice, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoInitialPrice).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 21, Short.MAX_VALUE).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.okButton)).addContainerGap()));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        JSONObject jo = new JSONObject();
        jo.put(Globals.sim.getExchange().CFG_MONEY_DECIMALS, (Integer)this.moneyDecimalsSpinner.getValue());
        jo.put(Globals.sim.getExchange().CFG_SHARES_DECIMALS, (Integer)this.sharesDecimalsSpinner.getValue());
        jo.put(Globals.sim.getExchange().CFG_INITIAL_PRICE, (Double)this.initialPrice.getValue());
        jo.put(Globals.sim.getExchange().CFG_AUTO_INITIAL_PRICE, (Object)this.autoInitialPrice.isSelected());
        JSONObject cfg = Globals.getConfig();
        Sim.putExchangeCfg(cfg, jo);
        Globals.putConfig(cfg);
        this.dispose();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void autoInitialPriceActionPerformed(ActionEvent evt) {
        this.initialPrice.setEnabled(!this.autoInitialPrice.isSelected());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(EditExchangeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(EditExchangeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(EditExchangeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(EditExchangeDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditExchangeDialog dialog = new EditExchangeDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

