/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.EscDialog;
import gui.Globals;
import gui.NewStrategyDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.json.JSONException;
import org.json.JSONObject;
import sesim.AutoTraderGui;
import sesim.AutoTraderInterface;
import sesim.Logger;

public final class EditStrategiesDialog
extends EscDialog {
    transient AutoTraderInterface currentAutoTrader = null;
    AutoTraderGui acgui;
    TreeMap<String, JSONObject> strategies = new TreeMap();
    private JLabel baseLabel;
    private JButton closeButton;
    private JPanel defaultGuiPanel;
    private JLabel defaultText;
    private JPanel guiPanel;
    private JLabel jLabel1;
    private JButton newButton;
    private JButton removeButton;
    private JButton saveAsButton;
    private JButton saveButton;
    private JScrollPane scrollPane;
    private JComboBox<String> strategySelectComboBox;

    public EditStrategiesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setMinimumSize(this.getPreferredSize());
        this.setLocationRelativeTo(this.getParent());
        String lastUsed = Globals.prefs_new.get("last_edited_strategy", null);
        this.initComboBox();
        this.pack();
        this.setSize(this.getPreferredSize());
        this.strategySelectComboBox.setSelectedItem(lastUsed);
    }

    void initComboBox() {
        this.reloadStrategyConfigs();
        this.strategySelectComboBox.removeAllItems();
        Iterator<String> i = this.strategies.keySet().iterator();
        while (i.hasNext()) {
            this.strategySelectComboBox.addItem(i.next());
        }
    }

    private void reloadStrategyConfigs() {
        this.strategies = new TreeMap();
        JSONObject cfgs = Globals.getStrategies();
        Iterator<String> i = cfgs.keys();
        while (i.hasNext()) {
            String k = i.next();
            JSONObject o = cfgs.getJSONObject(k);
            this.strategies.put(k, o);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.defaultGuiPanel = new JPanel();
        this.defaultText = new JLabel();
        this.strategySelectComboBox = new JComboBox();
        this.scrollPane = new JScrollPane();
        this.guiPanel = new JPanel();
        this.saveButton = new JButton();
        this.closeButton = new JButton();
        this.saveAsButton = new JButton();
        this.removeButton = new JButton();
        this.newButton = new JButton();
        this.baseLabel = new JLabel();
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("No config available");
        this.defaultGuiPanel.setPreferredSize(new Dimension(100, 100));
        this.defaultText.setHorizontalAlignment(0);
        this.defaultText.setText("No config available");
        this.defaultText.setHorizontalTextPosition(0);
        GroupLayout defaultGuiPanelLayout = new GroupLayout(this.defaultGuiPanel);
        this.defaultGuiPanel.setLayout(defaultGuiPanelLayout);
        defaultGuiPanelLayout.setHorizontalGroup(defaultGuiPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(defaultGuiPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.defaultText, -1, 815, Short.MAX_VALUE).addContainerGap()));
        defaultGuiPanelLayout.setVerticalGroup(defaultGuiPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(defaultGuiPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.defaultText, -1, 435, Short.MAX_VALUE).addContainerGap()));
        this.setDefaultCloseOperation(2);
        this.strategySelectComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.strategySelectComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditStrategiesDialog.this.strategySelectComboBoxActionPerformed(evt);
            }
        });
        this.scrollPane.setViewportBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.guiPanel.setLayout(new BorderLayout());
        this.scrollPane.setViewportView(this.guiPanel);
        this.saveButton.setMnemonic('s');
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditStrategiesDialog.this.saveButtonActionPerformed(evt);
            }
        });
        this.closeButton.setMnemonic('c');
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditStrategiesDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.saveAsButton.setMnemonic('a');
        this.saveAsButton.setText("Save as ...");
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditStrategiesDialog.this.saveAsButtonActionPerformed(evt);
            }
        });
        this.removeButton.setMnemonic('r');
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditStrategiesDialog.this.removeButtonActionPerformed(evt);
            }
        });
        this.newButton.setMnemonic('n');
        this.newButton.setText("New ...");
        this.newButton.setToolTipText("");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditStrategiesDialog.this.newButtonActionPerformed(evt);
            }
        });
        this.baseLabel.setText("base");
        GroupLayout layout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout2.createSequentialGroup().addComponent(this.baseLabel, -1, 292, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.strategySelectComboBox, -2, 361, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout2.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.newButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveAsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton))).addContainerGap()));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.strategySelectComboBox, -2, -1, -2).addComponent(this.baseLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -1, 469, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.saveAsButton).addComponent(this.saveButton).addComponent(this.removeButton).addComponent(this.newButton)).addContainerGap()));
        this.pack();
    }

    private void strategySelectComboBoxActionPerformed(ActionEvent evt) {
        String base;
        JSONObject cfgs = Globals.getStrategies();
        String selectedStrategy = (String)this.strategySelectComboBox.getSelectedItem();
        if (selectedStrategy == null) {
            this.guiPanel.removeAll();
            this.defaultGuiPanel.setVisible(true);
            return;
        }
        JSONObject o = null;
        try {
            o = (JSONObject)cfgs.get(selectedStrategy);
            base = o.getString("base");
        }
        catch (JSONException e) {
            base = selectedStrategy;
        }
        this.currentAutoTrader = Globals.sim.tloader.getStrategyBase(base);
        if (this.currentAutoTrader == null) {
            Logger.error(String.format("Can't load trader: %s\n", base), new Object[0]);
            return;
        }
        this.currentAutoTrader.setConfig(o);
        this.baseLabel.setText(base);
        this.acgui = this.currentAutoTrader.getGui();
        this.guiPanel.removeAll();
        if (this.acgui != null) {
            System.out.println("acgui class: " + this.acgui.getClass().getName());
            System.out.println("acgui preferredSize: " + this.acgui.getPreferredSize());
            System.out.println("acgui minimumSize: " + this.acgui.getMinimumSize());
            System.out.println("acgui maximumSize: " + this.acgui.getMaximumSize());
            this.guiPanel.add((Component)this.acgui, "Center");
            System.out.println("guiPanel preferredSize nach add: " + this.guiPanel.getPreferredSize());
            Dimension pref = this.acgui.getPreferredSize();
            this.guiPanel.setPreferredSize(pref);
            this.guiPanel.setMinimumSize(pref);
            this.acgui.setVisible(true);
        } else {
            this.defaultGuiPanel.setVisible(true);
        }
        this.revalidate();
        this.repaint();
        this.guiPanel.revalidate();
        this.guiPanel.repaint();
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
        this.pack();
        this.setSize(this.getPreferredSize());
        Globals.prefs_new.put("last_edited_strategy", selectedStrategy);
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        if (this.currentAutoTrader == null) {
            return;
        }
        if (this.acgui != null) {
            this.acgui.save();
        }
        JSONObject strategyCfg = this.currentAutoTrader.getConfig();
        String strategyName = (String)this.strategySelectComboBox.getSelectedItem();
        strategyCfg.put("base", this.currentAutoTrader.getClass().getCanonicalName());
        JSONObject cfgs = Globals.getStrategies();
        cfgs.put(strategyName, strategyCfg);
        Globals.putStrategies(cfgs);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        String selected = (String)this.strategySelectComboBox.getSelectedItem();
        JSONObject cfgs = Globals.getStrategies();
        cfgs.remove(selected);
        Globals.putStrategies(cfgs);
        this.acgui = null;
        this.currentAutoTrader = null;
        this.initComboBox();
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        NewStrategyDialog sd = new NewStrategyDialog((Frame)this.getParent(), true);
        sd.setLocationRelativeTo(this);
        sd.setVisible(true);
        if (sd.result == null) {
            return;
        }
        AutoTraderInterface ac = Globals.sim.tloader.getStrategyBase(sd.result.base);
        JSONObject cfg = ac.getConfig();
        cfg.put("base", ac.getClass().getCanonicalName());
        Globals.saveStrategy(sd.result.name, cfg);
        this.initComboBox();
        this.strategySelectComboBox.setSelectedItem(sd.result.name);
    }

    private void saveAsButtonActionPerformed(ActionEvent evt) {
        if (this.currentAutoTrader == null) {
            return;
        }
        NewStrategyDialog sd = new NewStrategyDialog((Frame)this.getParent(), true, this.currentAutoTrader.getClass().getCanonicalName());
        sd.setLocationRelativeTo(this);
        sd.setTitle("Save Straegy as");
        sd.setVisible(true);
        if (sd.result == null) {
            return;
        }
        JSONObject strategyCfg = this.currentAutoTrader.getConfig();
        String strategyName = sd.result.name;
        strategyCfg.put("base", this.currentAutoTrader.getClass().getCanonicalName());
        JSONObject cfgs = Globals.getStrategies();
        cfgs.put(strategyName, strategyCfg);
        Globals.putStrategies(cfgs);
        this.initComboBox();
        this.strategySelectComboBox.setSelectedItem(sd.result.name);
    }
}

