/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class LogPanel
extends JPanel {
    private final Logger logger = Logger.getLogger("de.uniadmin.sesim");
    private JScrollPane jScrollPane1;
    private JTextPane logArea;

    public LogPanel() {
        this.initComponents();
        this.logArea.setEditable(true);
        this.logArea.setFont(new Font("Monospaced", 0, 12));
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder());
        this.logger.setLevel(Level.INFO);
        this.logger.setFilter(record -> {
            Level level = record.getLevel();
            return level == Level.INFO || level == Level.SEVERE;
        });
        LogPanelHandler handler = new LogPanelHandler(this);
        handler.setFormatter(new MessageOnlyFormatter());
        this.logger.addHandler(handler);
    }

    public void appendLog(String level, String text) {
        SwingUtilities.invokeLater(() -> {
            StyledDocument doc = this.logArea.getStyledDocument();
            Style style = this.logArea.addStyle("Style", null);
            switch (level) {
                case "SEVERE": {
                    StyleConstants.setForeground(style, Color.RED);
                    break;
                }
                case "WARN": {
                    StyleConstants.setForeground(style, Color.ORANGE.darker());
                    break;
                }
                default: {
                    StyleConstants.setForeground(style, Color.BLACK);
                }
            }
            try {
                doc.insertString(doc.getLength(), text, style);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.logArea.setCaretPosition(doc.getLength());
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.logArea = new JTextPane();
        this.logArea.setCursor(new Cursor(2));
        this.jScrollPane1.setViewportView(this.logArea);
        GroupLayout layout2 = new GroupLayout(this);
        this.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout2.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 388, Short.MAX_VALUE).addContainerGap()));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout2.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 288, Short.MAX_VALUE).addContainerGap()));
    }

    public class LogPanelHandler
    extends Handler {
        private final LogPanel logPanel;

        public LogPanelHandler(LogPanel l) {
            this.logPanel = l;
        }

        @Override
        public void publish(LogRecord record) {
            if (!this.isLoggable(record)) {
                return;
            }
            String msg = this.getFormatter().format(record);
            this.logPanel.appendLog(record.getLevel().getName(), msg);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    public class MessageOnlyFormatter
    extends Formatter {
        private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        private String formatTime(long millis) {
            return this.dateFormat.format(new Date(millis));
        }

        @Override
        public String format(LogRecord record) {
            String levelStr;
            String timeStr = this.formatTime(record.getMillis());
            switch (record.getLevel().getName()) {
                case "SEVERE": {
                    levelStr = "ERROR";
                    break;
                }
                case "WARNING": {
                    levelStr = "WARN";
                    break;
                }
                default: {
                    levelStr = record.getLevel().getName();
                }
            }
            return String.format("[%s] [%s] %s\n", timeStr, levelStr, record.getMessage());
        }
    }
}

