/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Globals;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.LookAndFeel;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LookAndFeelManager {
    public static boolean changeLookAndFeel(String lafClassName) {
        LookAndFeel oldLookAndFeel = null;
        try {
            oldLookAndFeel = UIManager.getLookAndFeel();
            UIManager.setLookAndFeel(lafClassName);
            LookAndFeelManager.updateAllWindows();
            LookAndFeelManager.updatePopupMenus();
            Globals.prefs_new.put("laf", lafClassName);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                UIManager.setLookAndFeel(oldLookAndFeel);
                LookAndFeelManager.updateAllWindows();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    private static void updateAllWindows() {
        for (Window window : Window.getWindows()) {
            if (!window.isDisplayable()) continue;
            SwingUtilities.updateComponentTreeUI(window);
            window.repaint();
            if (window instanceof JFrame) {
                LookAndFeelManager.updateFrame((JFrame)window);
                continue;
            }
            if (!(window instanceof JDialog)) continue;
            LookAndFeelManager.updateDialog((JDialog)window);
        }
    }

    private static void updateFrame(JFrame frame) {
        JMenuBar menuBar = frame.getJMenuBar();
        if (menuBar != null) {
            SwingUtilities.updateComponentTreeUI(menuBar);
        }
        frame.getRootPane().updateUI();
    }

    private static void updateDialog(JDialog dialog) {
        JMenuBar menuBar = dialog.getJMenuBar();
        if (menuBar != null) {
            SwingUtilities.updateComponentTreeUI(menuBar);
        }
        dialog.getRootPane().updateUI();
    }

    private static void updatePopupMenus() {
        PopupFactory.setSharedInstance(new PopupFactory());
    }
}

