/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Globals;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LookAndFeelUtils {
    public static boolean applyLookAndFeel(String lafNameOrClassName) {
        try {
            String className = LookAndFeelUtils.findClassNameForLAF(lafNameOrClassName);
            UIManager.setLookAndFeel(className);
            LookAndFeelUtils.updateBasicUI();
            Globals.prefs_new.put("laf", lafNameOrClassName);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Fehler beim LookAndFeel-Wechsel: " + e.getMessage(), "Fehler", 0);
            return false;
        }
    }

    private static void updateBasicUI() {
        for (Window window : Window.getWindows()) {
            JMenuBar menuBar;
            if (!window.isDisplayable()) continue;
            SwingUtilities.updateComponentTreeUI(window);
            if (!(window instanceof JFrame) || (menuBar = ((JFrame)window).getJMenuBar()) == null) continue;
            SwingUtilities.updateComponentTreeUI(menuBar);
        }
        try {
            PopupFactory.setSharedInstance(new PopupFactory());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String findClassNameForLAF(String lafName) {
        UIManager.LookAndFeelInfo[] lafInfo;
        for (UIManager.LookAndFeelInfo info : lafInfo = UIManager.getInstalledLookAndFeels()) {
            if (!info.getName().equals(lafName)) continue;
            return info.getClassName();
        }
        return lafName;
    }
}

