/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.util.NummericCellRenderer;
import gui.util.PercentageCellRenderer;
import gui.util.PercentageValue;
import gui.util.UpdateExecutor;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import sesim.Position;

public class PositionsListPanel
extends JPanel {
    private Map<Position, Position> list;
    DefaultTableModel model;
    UpdateExecutor executor = new UpdateExecutor(100);
    private JScrollPane scrollPane;
    private JTable table;

    public PositionsListPanel() {
        this.initComponents();
        if (this.table == null) {
            return;
        }
        this.table.getColumnModel().getColumn(9).setCellRenderer(new PercentageCellRenderer());
        this.table.getColumnModel().getColumn(7).setCellRenderer(new NummericCellRenderer(2));
        this.table.setAutoCreateRowSorter(true);
        this.model = (DefaultTableModel)this.table.getModel();
        this.model.setRowCount(0);
        this.table.setFillsViewportHeight(true);
    }

    public final void updateModel() {
        if (this.list == null) {
            return;
        }
        this.executor.update(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PositionsListPanel.this.model.setRowCount(0);
                        for (Position p : PositionsListPanel.this.list.values()) {
                            Object[] rowData = new Object[]{p.getName(), Float.valueOf(p.getShares()), Float.valueOf(p.getLeverage()), Float.valueOf(p.getMargin()), Float.valueOf(p.getShadowCash()), Float.valueOf(p.getTotalEntryCost()), Float.valueOf(p.getEntryPrice()), Float.valueOf(p.getEquityValue()), Float.valueOf(p.getStopPrice()), new PercentageValue(p.getPnLPercent())};
                            PositionsListPanel.this.model.addRow(rowData);
                        }
                        PositionsListPanel.this.table.getRowSorter().allRowsChanged();
                    }
                });
            }
        });
    }

    public void setPositionList(Map m) {
        this.list = m;
        SwingUtilities.invokeLater(this::updateModel);
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null}}, new String[]{"Name", "Volume", "Leverage", "Margin", "Shadow", "Entry", "Entry Price", "Equity Val", "Stop Price", "PnL"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Float.class, Float.class, Float.class, Float.class, Float.class, Float.class, Float.class, Float.class, Object.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table.setColumnSelectionAllowed(true);
        this.scrollPane.setViewportView(this.table);
        this.table.getColumnModel().getSelectionModel().setSelectionMode(0);
        GroupLayout layout2 = new GroupLayout(this);
        this.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 671, Short.MAX_VALUE));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 258, Short.MAX_VALUE));
    }
}

