/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Globals;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import sesim.Market;
import sesim.Quote;

public class QuotePanel
extends JPanel
implements Market.QuoteReceiver {
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel lastPrice;

    public QuotePanel() {
        this.initComponents();
        if (Globals.sim == null) {
            return;
        }
        Globals.sim.getExchange().addQuoteReceiver(this);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.lastPrice = new JLabel();
        this.jLabel3 = new JLabel();
        this.setBorder(null);
        GridBagLayout layout2 = new GridBagLayout();
        layout2.columnWidths = new int[]{0, 5, 0, 5, 0};
        layout2.rowHeights = new int[]{0};
        this.setLayout(layout2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.lastPrice.setFont(this.lastPrice.getFont().deriveFont(this.lastPrice.getFont().getStyle() | 1, this.lastPrice.getFont().getSize() + 4));
        this.lastPrice.setHorizontalAlignment(0);
        this.lastPrice.setText("0.00");
        this.lastPrice.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.9;
        this.add((Component)this.lastPrice, gridBagConstraints);
        this.jLabel3.setPreferredSize(new Dimension(30, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jLabel3, gridBagConstraints);
    }

    @Override
    public void UpdateQuote(Quote q) {
        class Updater
        implements Runnable {
            QuotePanel qp;
            String text = "";
            Color color = Color.BLUE;

            Updater() {
            }

            @Override
            public void run() {
                this.qp.lastPrice.setText(this.text);
                this.qp.lastPrice.setForeground(this.color);
            }
        }
        Updater u = new Updater();
        u.qp = this;
        if (q.getPrice() == q.getBid()) {
            u.color = new Color(172, 0, 0);
        }
        if (q.getPrice() == q.getAsk()) {
            u.color = new Color(0, 120, 0);
        }
        u.text = String.format("%.8f\n(%.0f)", Float.valueOf(q.getPrice()), Float.valueOf(q.getVolume()));
        SwingUtilities.invokeLater(u);
    }
}

