/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Globals;
import gui.util.NummericCellRenderer;
import gui.util.PercentageCellRenderer;
import gui.util.PercentageValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.GroupLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sesim.Account;
import sesim.AutoTraderInterface;

public class TraderListPanel
extends JPanel {
    DefaultTableModel model;
    Frame parentFrame = null;
    TimerTask updater;
    private final Map<Column, TableColumn> hiddenColumns = new HashMap<Column, TableColumn>();
    Column[] columnList = Column.values();
    private JScrollPane jScrollPane1;
    private JTable list;

    public TraderListPanel(Frame parent) {
        this();
        this.parentFrame = parent;
    }

    public TraderListPanel(Frame parent, Column[] columnList) {
        this.initComponents();
        if (Globals.sim == null) {
            return;
        }
        this.setupTable();
        this.addContextMenu();
        TableColumnModel colModel = this.list.getColumnModel();
        for (int i = colModel.getColumnCount() - 1; i >= 0; --i) {
            TableColumn col = colModel.getColumn(i);
            Column columnEnum = (Column)((Object)col.getIdentifier());
            if (Arrays.asList(columnList).contains((Object)columnEnum)) continue;
            this.hideColumn(columnEnum);
        }
    }

    public TraderListPanel() {
        this.initComponents();
        if (Globals.sim == null) {
            return;
        }
        this.setupTable();
        this.addContextMenu();
    }

    private void setupTable() {
        this.model = new MyModel(Column.values());
        this.list.setModel(this.model);
        for (Column a : Column.values()) {
            this.list.getColumnModel().getColumn(a.ordinal()).setHeaderValue(a.header);
            this.list.getColumnModel().getColumn(a.ordinal()).setIdentifier((Object)a);
            this.list.getColumnModel().getColumn(a.ordinal()).setCellRenderer(a.getRenderer());
        }
        TableColumnModel colModel = this.list.getColumnModel();
        for (int i = colModel.getColumnCount() - 1; i >= 0; --i) {
            TableColumn col = colModel.getColumn(i);
            Column columnEnum = (Column)((Object)col.getIdentifier());
            if (Arrays.asList(this.columnList).contains((Object)columnEnum)) continue;
            this.hiddenColumns.put(columnEnum, col);
            colModel.removeColumn(col);
        }
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        this.list.getColumnModel().getColumn(Column.ID.ordinal()).setCellRenderer(centerRenderer);
        String widestText = "-100.0%";
        FontMetrics fm = this.list.getFontMetrics(this.list.getFont());
        int textWidth = fm.stringWidth(widestText);
        int padding = 12;
        int preferredWidth = textWidth + padding;
        int maxWidth = 100 * preferredWidth;
        final AtomicBoolean running = new AtomicBoolean(false);
        Timer timer = new Timer();
        this.updater = new TimerTask(){

            @Override
            public void run() {
                if (running.get()) {
                    return;
                }
                running.set(true);
                try {
                    TraderListPanel.this.updateModel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                running.set(false);
            }
        };
        timer.schedule(this.updater, 0L, 1000L);
    }

    final void updateModel() {
        if (Globals.sim == null) {
            return;
        }
        if (Globals.sim.getExchange() == null) {
            return;
        }
        if (Globals.sim.traders == null) {
            return;
        }
        int size2 = Globals.sim.traders.size();
        float price = Globals.sim.getExchange().getLastPrice();
        this.model.setRowCount(size2);
        for (int i = 0; i < size2; ++i) {
            AutoTraderInterface at = Globals.sim.traders.get(i);
            Account a = at.getAccount();
            this.model.setValueAt(i, i, Column.ID.ordinal());
            int[] atc = at.getColor();
            Color c = null;
            if (atc != null) {
                c = new Color(atc[0], atc[1], atc[2]);
            }
            this.model.setValueAt(new NameValue(at.getName(), c), i, Column.NAME.ordinal());
            this.model.setValueAt(at.getStatus(), i, Column.STATUS.ordinal());
            this.model.setValueAt(Float.valueOf(a.getMoney()), i, Column.CASH.ordinal());
            this.model.setValueAt(Float.valueOf(a.getShares()), i, Column.SHARES.ordinal());
            this.model.setValueAt(Float.valueOf(a.getEquity()), i, Column.EQUITY.ordinal());
            this.model.setValueAt(Float.valueOf(a.getMarginUsed()), i, Column.MARGIN.ordinal());
            this.model.setValueAt(Float.valueOf(a.getFreeMargin()), i, Column.FREEMARGIN.ordinal());
            this.model.setValueAt(new PercentageValue(a.getPerformance(price)), i, Column.PNL.ordinal());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List<RowSorter.SortKey> l;
                Long selectedTraderId = null;
                int selectedViewRow = TraderListPanel.this.list.getSelectedRow();
                if (selectedViewRow != -1) {
                    int selectedModelRow = TraderListPanel.this.list.convertRowIndexToModel(selectedViewRow);
                    Object value = TraderListPanel.this.model.getValueAt(selectedModelRow, Column.ID.ordinal());
                    if (value instanceof Long) {
                        selectedTraderId = (Long)value;
                    } else if (value instanceof Integer) {
                        selectedTraderId = ((Integer)value).longValue();
                    }
                }
                if (!(l = TraderListPanel.this.list.getRowSorter().getSortKeys()).isEmpty()) {
                    TraderListPanel.this.list.getRowSorter().allRowsChanged();
                } else {
                    TraderListPanel.this.model.fireTableDataChanged();
                }
                if (selectedTraderId != null) {
                    for (int i = 0; i < TraderListPanel.this.model.getRowCount(); ++i) {
                        Object value = TraderListPanel.this.model.getValueAt(i, Column.ID.ordinal());
                        Long currentId = null;
                        if (value instanceof Long) {
                            currentId = (Long)value;
                        } else if (value instanceof Integer) {
                            currentId = ((Integer)value).longValue();
                        }
                        if (!selectedTraderId.equals(currentId)) continue;
                        int viewRow = TraderListPanel.this.list.convertRowIndexToView(i);
                        TraderListPanel.this.list.getSelectionModel().setSelectionInterval(viewRow, viewRow);
                        break;
                    }
                }
            }
        });
    }

    private void addContextMenu() {
        final JPopupMenu popupMenu = new JPopupMenu("Spalten verwalten");
        for (final Column colEnum : Column.values()) {
            String header = colEnum.header;
            boolean isVisible = this.list.getColumnModel().getColumnIndex((Object)colEnum) != -1;
            final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(header, isVisible);
            menuItem.setName(header);
            if (colEnum == Column.ID) {
                // empty if block
            }
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (menuItem.isSelected()) {
                        TraderListPanel.this.showColumn(colEnum);
                    } else {
                        TraderListPanel.this.hideColumn(colEnum);
                    }
                }
            });
            popupMenu.add(menuItem);
        }
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    private void hideColumn(Column colEnum) {
        TableColumnModel colModel = this.list.getColumnModel();
        try {
            int viewIndex = colModel.getColumnIndex((Object)colEnum);
            TableColumn col = colModel.getColumn(viewIndex);
            colModel.removeColumn(col);
            this.hiddenColumns.put(colEnum, col);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void showColumn(Column colEnum) {
        TableColumn col = this.hiddenColumns.get((Object)colEnum);
        if (col != null) {
            Column current;
            TableColumnModel colModel = this.list.getColumnModel();
            int insertIndex = 0;
            Column[] allColumns = Column.values();
            for (int i = 0; i < allColumns.length && (current = allColumns[i]) != colEnum; ++i) {
                if (this.hiddenColumns.containsKey((Object)current)) continue;
                ++insertIndex;
            }
            colModel.addColumn(col);
            colModel.moveColumn(colModel.getColumnCount() - 1, insertIndex);
            this.hiddenColumns.remove((Object)colEnum);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.list = new JTable();
        this.list.setAutoCreateRowSorter(true);
        this.list.setModel(new DefaultTableModel(new Object[0][], new String[]{"ID", "Name", "Status", "Shares", "Cash", "Free Margin", "Total", "PnL%"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Long.class, Object.class, String.class, Float.class, Float.class, Float.class, Float.class, Double.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.list.setDoubleBuffered(true);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TraderListPanel.this.listMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        if (this.list.getColumnModel().getColumnCount() > 0) {
            this.list.getColumnModel().getColumn(0).setPreferredWidth(20);
            this.list.getColumnModel().getColumn(0).setMaxWidth(70);
            this.list.getColumnModel().getColumn(7).setPreferredWidth(50);
            this.list.getColumnModel().getColumn(7).setMaxWidth(80);
        }
        GroupLayout layout2 = new GroupLayout(this);
        this.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 574, Short.MAX_VALUE));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 292, Short.MAX_VALUE));
    }

    private void listMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int index = this.list.rowAtPoint(evt.getPoint());
            index = this.list.getRowSorter().convertRowIndexToModel(index);
            Integer tid = (Integer)this.model.getValueAt(index, 0);
            JDialog console = Globals.sim.traders.get(tid).getGuiConsole(this.parentFrame);
            if (console == null) {
                return;
            }
            console.setVisible(true);
        }
    }

    public static enum Column {
        ID("ID", null, Long.class),
        NAME("Name", new NameCellRenderer(), Object.class),
        STATUS("Status", null, String.class),
        SHARES("Shares", null, Float.class),
        MARGIN("Margin", null, Float.class),
        EQUITY("Equtiy", null, Float.class),
        FREEMARGIN("Free Margin", null, Float.class),
        CASH("Cash", null, Float.class),
        PNL("PnL", new PercentageCellRenderer(), PercentageValue.class);

        public final String header;
        private TableCellRenderer renderer;
        public final Class cls;

        private Column(String header, TableCellRenderer r, Class cls) {
            this.header = header;
            this.renderer = r;
            this.cls = cls;
        }

        public TableCellRenderer getRenderer() {
            if (this.renderer == null) {
                switch (this.ordinal()) {
                    case 3: {
                        this.renderer = new NummericCellRenderer(Globals.sim.getExchange().getSharesDecimals());
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.renderer = new NummericCellRenderer(Globals.sim.getExchange().getMoneyDecimals());
                        break;
                    }
                }
            }
            return this.renderer;
        }
    }

    public static class MyModel
    extends DefaultTableModel {
        Column[] def;

        public MyModel(Object[][] arg0, Object[] arg1) {
            super(arg0, arg1);
        }

        public MyModel(Column[] d) {
            this.def = d;
        }

        @Override
        public int getColumnCount() {
            return this.def.length;
        }

        public Class getColumnClass(int columnIndex) {
            return this.def[columnIndex].cls;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public void fireTableDataChanged() {
            super.fireTableDataChanged();
        }

        @Override
        public void fireTableStructureChanged() {
        }

        @Override
        public void fireTableRowsUpdated(int firstRow, int lastRow) {
        }

        @Override
        public void fireTableCellUpdated(int row, int column) {
        }
    }

    public class NameValue
    implements Comparable<NameValue> {
        private final String value;
        private final Color color;

        public NameValue(String value, Color color) {
            this.value = value;
            this.color = color;
        }

        public String toString() {
            return this.value;
        }

        @Override
        public int compareTo(NameValue other) {
            return this.value.compareTo(other.value);
        }

        public String getValue() {
            return this.value;
        }

        public Color getColor() {
            return this.color;
        }
    }

    public static class NameCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            NameValue n = (NameValue)value;
            Component c = super.getTableCellRendererComponent(table2, n.toString(), isSelected, hasFocus, row, column);
            if (!isSelected) {
                Color color = n.getColor();
                if (color != null) {
                    this.setBackground(n.getColor());
                } else {
                    this.setBackground(table2.getBackground());
                }
            }
            return c;
        }
    }
}

