/*
 * Decompiled with CFR 0.152.
 */
package gui.orderbook;

import gui.Globals;
import gui.util.NummericCellRenderer;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sesim.Market;
import sesim.OrderBookEntry;

public class RawOrderBook
extends JPanel
implements Market.BookListener {
    RawOrderBookModel model;
    TableColumn trader_column = null;
    TableColumn price_column = null;
    TableColumn vol_column = null;
    ExecutorService executor = Executors.newSingleThreadExecutor();
    volatile boolean busy;
    volatile boolean update = true;
    protected byte type = (byte)2;
    protected int depth = 40;
    Market se;
    private byte priceColumn;
    private JScrollPane jScrollPane1;
    protected JTable list;

    public RawOrderBook() {
        this.initComponents();
        if (Globals.sim == null) {
            return;
        }
        this.model = (RawOrderBookModel)this.list.getModel();
        this.trader_column = this.list.getColumnModel().getColumn(0);
        this.price_column = this.list.getColumnModel().getColumn(1);
        this.vol_column = this.list.getColumnModel().getColumn(2);
    }

    public void start(Market se, byte type) {
        this.se = se;
        this.type = type;
        this.stop();
        se.addBookListener(type, this);
        this.UpdateOrderBook();
    }

    public void stop() {
        this.se.removeBookListener(this);
    }

    public void setGodMode(boolean on) {
        TableColumnModel tcm = this.list.getColumnModel();
        if (on) {
            if (this.list.getColumnCount() == 3) {
                return;
            }
            tcm.addColumn(this.trader_column);
            tcm.moveColumn(2, 0);
        } else {
            if (this.list.getColumnCount() == 2) {
                return;
            }
            tcm.removeColumn(tcm.getColumn(0));
        }
    }

    protected ArrayList<? extends OrderBookEntry> getOrderBook() {
        return Globals.sim.getExchange().getRawOrderBook(this.type, this.depth);
    }

    public void setPriceColumn(byte t) {
        this.priceColumn = t;
    }

    @Override
    public void UpdateOrderBook() {
        if (this.busy) {
            this.update = true;
            return;
        }
        this.busy = true;
        this.update = true;
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                block7: {
                    block5: while (true) {
                        while (RawOrderBook.this.update) {
                            RawOrderBook.this.update = false;
                            final ArrayList<? extends OrderBookEntry> newOb = RawOrderBook.this.getOrderBook();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    RawOrderBook.this.setGodMode(Globals.prefs_new.get("godmode", "false").equals("true"));
                                    RawOrderBook.this.vol_column.setCellRenderer(new NummericCellRenderer(Globals.sim.getExchange().getSharesFormatter()));
                                    RawOrderBook.this.price_column.setCellRenderer(new NummericCellRenderer(Globals.sim.getExchange().getMoneyFormatter()));
                                    RawOrderBook.this.model.setData(newOb);
                                    RawOrderBook.this.model.fireTableDataChanged();
                                }
                            });
                            try {
                                Thread.sleep(50L);
                                continue block5;
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                        break block7;
                        {
                            continue block5;
                            break;
                        }
                        break;
                    }
                    finally {
                        RawOrderBook.this.busy = false;
                    }
                }
            }
        });
    }

    protected AbstractTableModel createModel() {
        return new RawOrderBookModel();
    }

    protected JTable createList() {
        return new JTable();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.list = this.createList();
        this.list.setModel(this.createModel());
        this.jScrollPane1.setViewportView(this.list);
        GroupLayout layout2 = new GroupLayout(this);
        this.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 389, Short.MAX_VALUE));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 284, Short.MAX_VALUE));
    }

    class RawOrderBookModel
    extends AbstractTableModel {
        ArrayList<? extends OrderBookEntry> myOb = null;
        final String[] colNames = new String[]{"Trader", "Price", "Volume"};
        final Class[] colTypes = new Class[]{String.class, Float.class, Float.class};

        RawOrderBookModel() {
        }

        void setData(ArrayList<? extends OrderBookEntry> d) {
            this.myOb = d;
        }

        @Override
        public int getRowCount() {
            if (this.myOb == null) {
                return 0;
            }
            return this.myOb.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.myOb.get(rowIndex).getOwnerName();
                }
                case 1: {
                    switch (RawOrderBook.this.priceColumn) {
                        case 4: {
                            return Float.valueOf(this.myOb.get(rowIndex).getStop());
                        }
                    }
                    return Float.valueOf(this.myOb.get(rowIndex).getLimit());
                }
                case 2: {
                    return Float.valueOf(this.myOb.get(rowIndex).getVolume());
                }
            }
            return null;
        }

        @Override
        public void fireTableRowsUpdated(int firstRow, int lastRow) {
        }

        @Override
        public void fireTableCellUpdated(int row, int column) {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            return this.colNames[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.colTypes[columnIndex];
        }
    }
}

