/*
 * Decompiled with CFR 0.152.
 */
package gui.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public final class ColorUtils {
    private static final Map<String, Color> CACHE = new HashMap<String, Color>();

    private ColorUtils() {
    }

    private static String key(Color base, Color bg) {
        return base.getRGB() + ":" + bg.getRGB();
    }

    public static Color readableRed(Color background) {
        return ColorUtils.readable(new Color(255, 0, 0), background);
    }

    public static Color readableGreen(Color background) {
        return ColorUtils.readable(new Color(0, 180, 0), background);
    }

    public static Color readableGrey(Color background) {
        return ColorUtils.readable(new Color(128, 128, 128), background);
    }

    public static Color readable(Color base, Color background) {
        String k = ColorUtils.key(base, background);
        if (CACHE.containsKey(k)) {
            return CACHE.get(k);
        }
        Color result = ColorUtils.isGray(base) ? ColorUtils.adjustGray(base, background) : ColorUtils.adjustColored(base, background);
        CACHE.put(k, result);
        return result;
    }

    private static boolean isGray(Color c) {
        int min2;
        int max2 = Math.max(c.getRed(), Math.max(c.getGreen(), c.getBlue()));
        return max2 - (min2 = Math.min(c.getRed(), Math.min(c.getGreen(), c.getBlue()))) < 16;
    }

    private static Color adjustGray(Color base, Color background) {
        float bgLum = (float)ColorUtils.luminance(background);
        float l = ColorUtils.rgbToHsl(base)[2];
        l = bgLum < 0.5f ? Math.max(l, 0.8f) : Math.min(l, 0.2f);
        return ColorUtils.hslToRgb(new float[]{0.0f, 0.0f, l});
    }

    private static Color adjustColored(Color base, Color background) {
        float[] hsl = ColorUtils.rgbToHsl(base);
        float h = hsl[0];
        float s = Math.max(hsl[1], 0.6f);
        float l = hsl[2];
        float bgLum = (float)ColorUtils.luminance(background);
        float targetL = bgLum < 0.5f ? Math.min(0.8f, l + 0.3f) : Math.max(0.2f, l - 0.3f);
        return ColorUtils.hslToRgb(new float[]{h, s, targetL});
    }

    private static double luminance(Color c) {
        double r = (double)c.getRed() / 255.0;
        double g = (double)c.getGreen() / 255.0;
        double b = (double)c.getBlue() / 255.0;
        return 0.2126 * r + 0.7152 * g + 0.0722 * b;
    }

    private static float[] rgbToHsl(Color c) {
        float h;
        float s;
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        float max2 = Math.max(r, Math.max(g, b));
        float min2 = Math.min(r, Math.min(g, b));
        float l = (max2 + min2) / 2.0f;
        if (max2 == min2) {
            s = 0.0f;
            h = 0.0f;
        } else {
            float d = max2 - min2;
            float f = s = l > 0.5f ? d / (2.0f - max2 - min2) : d / (max2 + min2);
            h = max2 == r ? (g - b) / d + (g < b ? 6.0f : 0.0f) : (max2 == g ? (b - r) / d + 2.0f : (r - g) / d + 4.0f);
            h /= 6.0f;
        }
        return new float[]{h, s, l};
    }

    private static Color hslToRgb(float[] hsl) {
        float r;
        float g;
        float b;
        float h = hsl[0];
        float s = hsl[1];
        float l = hsl[2];
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = ColorUtils.hueToRgb(p, q, h + 0.33333334f);
            g = ColorUtils.hueToRgb(p, q, h);
            b = ColorUtils.hueToRgb(p, q, h - 0.33333334f);
        }
        return new Color(ColorUtils.clamp(r), ColorUtils.clamp(g), ColorUtils.clamp(b));
    }

    private static float hueToRgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }

    private static int clamp(float v) {
        return Math.max(0, Math.min(255, Math.round(v * 255.0f)));
    }
}

