/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.list.primitive;

import java.util.Comparator;
import java.util.Random;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.block.comparator.primitive.CharComparator;
import org.eclipse.collections.api.block.function.primitive.CharIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.CharList;
import org.eclipse.collections.api.list.primitive.ImmutableCharList;
import org.eclipse.collections.api.tuple.primitive.CharCharPair;
import org.eclipse.collections.api.tuple.primitive.CharObjectPair;

public interface MutableCharList
extends MutableCharCollection,
CharList {
    public void addAtIndex(int var1, char var2);

    public boolean addAllAtIndex(int var1, char ... var2);

    public boolean addAllAtIndex(int var1, CharIterable var2);

    public char removeAtIndex(int var1);

    public char set(int var1, char var2);

    default public void swap(int index1, int index2) {
        char value = this.get(index1);
        this.set(index1, this.get(index2));
        this.set(index2, value);
    }

    @Override
    public MutableCharList select(CharPredicate var1);

    @Override
    public MutableCharList reject(CharPredicate var1);

    @Override
    public MutableCharList with(char var1);

    @Override
    public MutableCharList without(char var1);

    @Override
    public MutableCharList withAll(CharIterable var1);

    @Override
    public MutableCharList withoutAll(CharIterable var1);

    @Override
    default public MutableCharList tap(CharProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public <V> MutableList<V> collect(CharToObjectFunction<? extends V> var1);

    default public <V> MutableList<V> collectWithIndex(CharIntToObjectFunction<? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((char each2) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.value(each2, n);
        });
    }

    public MutableCharList reverseThis();

    @Override
    public MutableCharList toReversed();

    @Override
    public MutableCharList distinct();

    public MutableCharList sortThis();

    default public MutableCharList sortThis(CharComparator comparator) {
        throw new UnsupportedOperationException("sortThis(CharComparator comparator) is not supported on " + this.getClass());
    }

    default public <T> MutableCharList sortThisBy(CharToObjectFunction<T> function) {
        return this.sortThisBy(function, Comparator.naturalOrder());
    }

    default public <T> MutableCharList sortThisBy(CharToObjectFunction<T> function, Comparator<? super T> comparator) {
        return this.sortThis((i1, i2) -> comparator.compare((Object)function.valueOf(i1), (Object)function.valueOf(i2)));
    }

    default public MutableCharList shuffleThis() {
        return this.shuffleThis(new Random());
    }

    default public MutableCharList shuffleThis(Random rnd) {
        for (int j = this.size() - 1; j > 0; --j) {
            int k = rnd.nextInt(j + 1);
            char selected = this.get(j);
            this.set(j, this.get(k));
            this.set(k, selected);
        }
        return this;
    }

    @Override
    public MutableCharList asUnmodifiable();

    @Override
    public MutableCharList asSynchronized();

    @Override
    public ImmutableCharList toImmutable();

    @Override
    public MutableCharList subList(int var1, int var2);

    default public MutableList<CharCharPair> zipChar(CharIterable iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    default public <T> MutableList<CharObjectPair<T>> zip(Iterable<T> list) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    @Override
    default public MutableCharList newEmpty() {
        throw new UnsupportedOperationException("Implement in concrete classes.");
    }
}

