/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.bag.primitive.LongBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongIntPair;
import org.eclipse.collections.impl.Counter;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.primitive.SynchronizedLongBag;
import org.eclipse.collections.impl.bag.mutable.primitive.UnmodifiableLongBag;
import org.eclipse.collections.impl.block.factory.primitive.IntToIntFunctions;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.LongBags;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.map.mutable.primitive.LongIntHashMap;
import org.eclipse.collections.impl.primitive.AbstractLongIterable;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class LongHashBag
extends AbstractLongIterable
implements MutableLongBag,
Externalizable {
    private static final long serialVersionUID = 1L;
    private LongIntHashMap items;
    private int size;

    public LongHashBag() {
        this.items = new LongIntHashMap();
    }

    public LongHashBag(int size2) {
        this.items = new LongIntHashMap(size2);
    }

    public LongHashBag(LongIterable iterable) {
        this();
        this.addAll(iterable);
    }

    public LongHashBag(long ... elements) {
        this();
        this.addAll(elements);
    }

    public LongHashBag(LongHashBag bag) {
        this.items = new LongIntHashMap(bag.sizeDistinct());
        this.addAll(bag);
    }

    public static LongHashBag newBag(int size2) {
        return new LongHashBag(size2);
    }

    public static LongHashBag newBagWith(long ... source) {
        return new LongHashBag(source);
    }

    public static LongHashBag newBag(LongIterable source) {
        if (source instanceof LongHashBag) {
            return new LongHashBag((LongHashBag)source);
        }
        return new LongHashBag(source);
    }

    public static LongHashBag newBag(LongBag source) {
        return new LongHashBag(source);
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.items.notEmpty();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int sizeDistinct() {
        return this.items.size();
    }

    @Override
    public void clear() {
        this.items.clear();
        this.size = 0;
    }

    @Override
    public LongHashBag with(long element) {
        this.add(element);
        return this;
    }

    public LongHashBag with(long element1, long element2) {
        this.add(element1);
        this.add(element2);
        return this;
    }

    public LongHashBag with(long element1, long element2, long element3) {
        this.add(element1);
        this.add(element2);
        this.add(element3);
        return this;
    }

    @Override
    public LongHashBag withAll(LongIterable iterable) {
        this.addAll(iterable);
        return this;
    }

    @Override
    public LongHashBag without(long element) {
        this.remove(element);
        return this;
    }

    @Override
    public LongHashBag withoutAll(LongIterable iterable) {
        this.removeAll(iterable);
        return this;
    }

    @Override
    public boolean contains(long value) {
        return this.items.containsKey(value);
    }

    @Override
    public int occurrencesOf(long item) {
        return this.items.get(item);
    }

    @Override
    public void forEachWithOccurrences(LongIntProcedure procedure) {
        this.items.forEachKeyValue(procedure);
    }

    @Override
    public LongHashBag selectByOccurrences(IntPredicate predicate) {
        LongHashBag result = new LongHashBag();
        this.forEachWithOccurrences((each2, occurrences) -> {
            if (predicate.accept(occurrences)) {
                result.addOccurrences(each2, occurrences);
            }
        });
        return result;
    }

    @Override
    public MutableLongSet selectUnique() {
        MutableLongSet result = LongSets.mutable.empty();
        this.forEachWithOccurrences((each2, occurrences) -> {
            if (occurrences == 1) {
                result.add(each2);
            }
        });
        return result;
    }

    @Override
    public MutableList<LongIntPair> topOccurrences(int count2) {
        return this.occurrencesSortingBy(count2, item -> -item.getTwo(), Lists.mutable.empty());
    }

    @Override
    public MutableList<LongIntPair> bottomOccurrences(int count2) {
        return this.occurrencesSortingBy(count2, LongIntPair::getTwo, Lists.mutable.empty());
    }

    protected MutableList<LongIntPair> occurrencesSortingBy(int n, IntFunction<LongIntPair> function, MutableList<LongIntPair> returnWhenEmpty) {
        int keySize;
        if (n < 0) {
            throw new IllegalArgumentException("Cannot use a value of n < 0");
        }
        if (n == 0) {
            return returnWhenEmpty;
        }
        MutableList<LongIntPair> sorted2 = this.toListWithOccurrences().sortThisByInt(function);
        MutableList<LongIntPair> results = sorted2.subList(0, keySize).toList();
        for (keySize = Math.min(n, this.sizeDistinct()); keySize < sorted2.size() && ((LongIntPair)results.getLast()).getTwo() == ((LongIntPair)sorted2.get(keySize)).getTwo(); ++keySize) {
            results.add(sorted2.get(keySize));
        }
        return results;
    }

    protected MutableList<LongIntPair> toListWithOccurrences() {
        FastList<LongIntPair> result = FastList.newList(this.sizeDistinct());
        this.forEachWithOccurrences((each2, count2) -> result.add(PrimitiveTuples.pair(each2, count2)));
        return result;
    }

    @Override
    public boolean add(long item) {
        this.items.updateValue(item, 0, IntToIntFunctions.increment());
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(long item) {
        int newValue = this.items.updateValue(item, 0, IntToIntFunctions.decrement());
        if (newValue <= 0) {
            this.items.removeKey(item);
            if (newValue == 0) {
                --this.size;
            }
            return newValue == 0;
        }
        --this.size;
        return true;
    }

    @Override
    public boolean removeIf(LongPredicate predicate) {
        boolean changed = false;
        MutableLongIterator iterator2 = this.items.keySet().longIterator();
        while (iterator2.hasNext()) {
            long key = iterator2.next();
            if (!predicate.accept(key)) continue;
            this.size -= this.items.get(key);
            iterator2.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean addAll(long ... source) {
        if (source.length == 0) {
            return false;
        }
        for (long each2 : source) {
            this.add(each2);
        }
        return true;
    }

    @Override
    public boolean addAll(LongIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        if (source instanceof LongBag) {
            LongBag otherBag = (LongBag)source;
            otherBag.forEachWithOccurrences(this::addOccurrences);
        } else {
            LongIterator iterator2 = source.longIterator();
            while (iterator2.hasNext()) {
                long each2 = iterator2.next();
                this.add(each2);
            }
        }
        return true;
    }

    @Override
    public boolean removeAll(long ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (long each2 : source) {
            int occurrences = this.items.removeKeyIfAbsent(each2, 0);
            this.size -= occurrences;
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean removeAll(LongIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof LongBag) {
            LongBag otherBag = (LongBag)source;
            otherBag.forEachWithOccurrences((each2, occurrences) -> {
                int oldOccurrences = this.items.removeKeyIfAbsent(each2, 0);
                this.size -= oldOccurrences;
            });
        } else {
            LongIterator iterator2 = source.longIterator();
            while (iterator2.hasNext()) {
                long each3 = iterator2.next();
                int occurrences2 = this.items.removeKeyIfAbsent(each3, 0);
                this.size -= occurrences2;
            }
        }
        return this.size() != oldSize;
    }

    @Override
    public boolean retainAll(LongIterable source) {
        int oldSize = this.size();
        LongSet sourceSet = source instanceof LongSet ? (LongSet)source : source.toSet();
        LongHashBag retained = this.select(sourceSet::contains);
        if (retained.size() != oldSize) {
            this.items = retained.items;
            this.size = retained.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(long ... source) {
        return this.retainAll(LongHashSet.newSetWith(source));
    }

    @Override
    public void addOccurrences(long item, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot add a negative number of occurrences");
        }
        if (occurrences > 0) {
            this.items.updateValue(item, 0, intParameter -> intParameter + occurrences);
            this.size += occurrences;
        }
    }

    @Override
    public boolean removeOccurrences(long item, int occurrences) {
        if (occurrences < 0) {
            throw new IllegalArgumentException("Cannot remove a negative number of occurrences");
        }
        if (occurrences == 0) {
            return false;
        }
        int newValue = this.items.updateValue(item, 0, intParameter -> intParameter - occurrences);
        if (newValue <= 0) {
            this.size -= occurrences - newValue;
            this.items.removeKey(item);
            return newValue + occurrences != 0;
        }
        this.size -= occurrences;
        return true;
    }

    @Override
    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(LongProcedure procedure) {
        this.items.forEachKeyValue((key, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                procedure.value(key);
            }
        });
    }

    @Override
    public LongHashBag select(LongPredicate predicate) {
        LongHashBag result = new LongHashBag();
        this.forEachWithOccurrences((each2, occurrences) -> {
            if (predicate.accept(each2)) {
                result.addOccurrences(each2, occurrences);
            }
        });
        return result;
    }

    @Override
    public LongHashBag reject(LongPredicate predicate) {
        LongHashBag result = new LongHashBag();
        this.forEachWithOccurrences((each2, occurrences) -> {
            if (!predicate.accept(each2)) {
                result.addOccurrences(each2, occurrences);
            }
        });
        return result;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        Object[] result = new Object[]{injectedValue};
        this.forEachWithOccurrences((each2, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                result[0] = function.valueOf(result[0], each2);
            }
        });
        return (T)result[0];
    }

    @Override
    public RichIterable<LongIterable> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        MutableList<LongIterable> result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size2) {
                result.add(LongBags.mutable.withAll(this));
            } else {
                MutableLongIterator iterator2 = this.longIterator();
                while (iterator2.hasNext()) {
                    MutableLongBag batch = LongBags.mutable.empty();
                    for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
                        batch.add(iterator2.next());
                    }
                    result.add(batch);
                }
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object otherBag) {
        if (otherBag == this) {
            return true;
        }
        if (!(otherBag instanceof LongBag)) {
            return false;
        }
        LongBag bag = (LongBag)otherBag;
        if (this.sizeDistinct() != bag.sizeDistinct()) {
            return false;
        }
        return this.items.keysView().allSatisfy(key -> this.occurrencesOf(key) == bag.occurrencesOf(key));
    }

    @Override
    public int hashCode() {
        Counter result = new Counter();
        this.forEachWithOccurrences((eachItem, occurrences) -> result.add((int)(eachItem ^ eachItem >>> 32) ^ occurrences));
        return result.getCount();
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        boolean[] firstItem = new boolean[]{true};
        try {
            appendable.append(start);
            this.items.forEachKeyValue((each2, occurrences) -> {
                try {
                    for (int i = 0; i < occurrences; ++i) {
                        if (!firstItem[0]) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(each2));
                        firstItem[0] = false;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int count(LongPredicate predicate) {
        Counter result = new Counter();
        this.forEachWithOccurrences((each2, occurrences) -> {
            if (predicate.accept(each2)) {
                result.add(occurrences);
            }
        });
        return result.getCount();
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        return this.items.keysView().anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        return this.items.keysView().allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(LongPredicate predicate) {
        return this.items.keysView().noneSatisfy(predicate);
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.items.keysView().detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> MutableBag<V> collect(LongToObjectFunction<? extends V> function) {
        HashBag result = HashBag.newBag(this.items.size());
        this.forEachWithOccurrences((each2, occurrences) -> result.addOccurrences(function.valueOf(each2), occurrences));
        return result;
    }

    @Override
    public long max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().max();
    }

    @Override
    public long min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.items.keysView().min();
    }

    @Override
    public long sum() {
        long[] result = new long[]{0L};
        this.forEachWithOccurrences((each2, occurrences) -> {
            result[0] = result[0] + each2 * (long)occurrences;
        });
        return result[0];
    }

    @Override
    public long[] toArray() {
        long[] array = new long[this.size()];
        int[] index = new int[]{0};
        this.forEachWithOccurrences((each2, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                array[index[0]] = each2;
                index[0] = index[0] + 1;
            }
        });
        return array;
    }

    @Override
    public long[] toArray(long[] array) {
        if (array.length < this.size()) {
            array = new long[this.size()];
        }
        int[] index = new int[]{0};
        long[] finalBypass = array;
        this.forEachWithOccurrences((each2, occurrences) -> {
            for (int i = 0; i < occurrences; ++i) {
                finalBypass[index[0]] = each2;
                index[0] = index[0] + 1;
            }
        });
        return array;
    }

    @Override
    public MutableLongBag asUnmodifiable() {
        return new UnmodifiableLongBag(this);
    }

    @Override
    public MutableLongBag asSynchronized() {
        return new SynchronizedLongBag(this);
    }

    @Override
    public ImmutableLongBag toImmutable() {
        return LongBags.immutable.withAll(this);
    }

    @Override
    public LongHashBag newEmpty() {
        return new LongHashBag();
    }

    @Override
    public MutableLongIterator longIterator() {
        return new InternalIterator();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.items.size());
        try {
            this.items.forEachKeyValue((each2, occurrences) -> {
                try {
                    out.writeLong(each2);
                    out.writeInt(occurrences);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size2 = in.readInt();
        this.items = new LongIntHashMap(size2);
        for (int i = 0; i < size2; ++i) {
            this.addOccurrences(in.readLong(), in.readInt());
        }
    }

    private class InternalIterator
    implements MutableLongIterator {
        private MutableLongIterator longIterator;
        private long currentItem;
        private int occurrences;
        private boolean canRemove;

        private InternalIterator() {
            this.longIterator = LongHashBag.this.items.keySet().longIterator();
        }

        @Override
        public boolean hasNext() {
            return this.occurrences > 0 || this.longIterator.hasNext();
        }

        @Override
        public long next() {
            if (this.occurrences == 0) {
                this.currentItem = this.longIterator.next();
                this.occurrences = LongHashBag.this.occurrencesOf(this.currentItem);
            }
            --this.occurrences;
            this.canRemove = true;
            return this.currentItem;
        }

        @Override
        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            if (this.occurrences == 0) {
                this.longIterator.remove();
                LongHashBag.this.size--;
            } else {
                LongHashBag.this.remove(this.currentItem);
            }
            this.canRemove = false;
        }
    }
}

