/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel.list;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterable;
import org.eclipse.collections.impl.lazy.parallel.OrderedBatch;
import org.eclipse.collections.impl.lazy.parallel.list.AbstractParallelListIterable;
import org.eclipse.collections.impl.lazy.parallel.list.ListBatch;
import org.eclipse.collections.impl.utility.Iterate;

@Beta
public class ParallelFlatCollectListIterable<T, V>
extends AbstractParallelListIterable<V, ListBatch<V>> {
    private final AbstractParallelIterable<T, ? extends OrderedBatch<T>> parallelIterable;
    private final Function<? super T, ? extends Iterable<V>> function;

    public ParallelFlatCollectListIterable(AbstractParallelIterable<T, ? extends OrderedBatch<T>> parallelIterable, Function<? super T, ? extends Iterable<V>> function) {
        this.parallelIterable = parallelIterable;
        this.function = function;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.parallelIterable.getExecutorService();
    }

    @Override
    public int getBatchSize() {
        return this.parallelIterable.getBatchSize();
    }

    @Override
    public LazyIterable<ListBatch<V>> split() {
        return this.parallelIterable.split().collect((T batch) -> batch.flatCollect(this.function));
    }

    @Override
    public void forEach(Procedure<? super V> procedure) {
        this.parallelIterable.forEach((? super T each2) -> Iterate.forEach(this.function.valueOf(each2), procedure));
    }

    @Override
    public V detect(Predicate<? super V> predicate) {
        AtomicReference result = new AtomicReference();
        this.parallelIterable.anySatisfy((? super T each2) -> Iterate.anySatisfy(this.function.valueOf(each2), (? super T each1) -> {
            if (predicate.accept((Object)each1)) {
                result.compareAndSet(null, each1);
                return true;
            }
            return false;
        }));
        return result.get();
    }

    @Override
    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.parallelIterable.anySatisfy((? super T each2) -> Iterate.anySatisfy(this.function.valueOf(each2), predicate));
    }

    @Override
    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.parallelIterable.allSatisfy((? super T each2) -> Iterate.allSatisfy(this.function.valueOf(each2), predicate));
    }
}

