/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel.set.sorted;

import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.list.ParallelListIterable;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.multimap.sortedset.SortedSetMultimap;
import org.eclipse.collections.api.set.sorted.ParallelSortedSetIterable;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterable;
import org.eclipse.collections.impl.lazy.parallel.list.ParallelCollectListIterable;
import org.eclipse.collections.impl.lazy.parallel.list.ParallelFlatCollectListIterable;
import org.eclipse.collections.impl.lazy.parallel.set.sorted.ParallelSelectSortedSetIterable;
import org.eclipse.collections.impl.lazy.parallel.set.sorted.SortedSetBatch;
import org.eclipse.collections.impl.multimap.set.sorted.SynchronizedPutTreeSortedSetMultimap;

@Beta
public abstract class AbstractParallelSortedSetIterable<T, B extends SortedSetBatch<T>>
extends AbstractParallelIterable<T, B>
implements ParallelSortedSetIterable<T> {
    @Override
    protected boolean isOrdered() {
        return true;
    }

    @Override
    public ParallelSortedSetIterable<T> asUnique() {
        return this;
    }

    @Override
    public ParallelSortedSetIterable<T> select(Predicate<? super T> predicate) {
        return new ParallelSelectSortedSetIterable<T>(this, predicate);
    }

    @Override
    public <P> ParallelSortedSetIterable<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.select((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public <S> ParallelSortedSetIterable<S> selectInstancesOf(Class<S> clazz) {
        return this.select(Predicates.instanceOf(clazz));
    }

    @Override
    public ParallelSortedSetIterable<T> reject(Predicate<? super T> predicate) {
        return this.select(Predicates.not(predicate));
    }

    @Override
    public <P> ParallelSortedSetIterable<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.reject((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public <V> ParallelListIterable<V> collect(Function<? super T, ? extends V> function) {
        return new ParallelCollectListIterable<T, V>(this, function);
    }

    @Override
    public <P, V> ParallelListIterable<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collect((Function)Functions.bind(function, parameter));
    }

    @Override
    public <V> ParallelListIterable<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.select((Predicate)predicate).collect((Function)function);
    }

    @Override
    public <V> ParallelListIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return new ParallelFlatCollectListIterable(this, function);
    }

    @Override
    public <V> SortedSetMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        SynchronizedPutTreeSortedSetMultimap result = SynchronizedPutTreeSortedSetMultimap.newMultimap();
        this.forEach(each2 -> {
            Object key = function.valueOf(each2);
            result.put(key, each2);
        });
        return result;
    }

    @Override
    public <V> SortedSetMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        SynchronizedPutTreeSortedSetMultimap result = SynchronizedPutTreeSortedSetMultimap.newMultimap();
        this.forEach(each2 -> {
            Iterable keys2 = (Iterable)function.valueOf(each2);
            for (Object key : keys2) {
                result.put(key, each2);
            }
        });
        return result;
    }

    @Override
    public <V> MapIterable<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.toList().groupByUniqueKey((Function)function);
    }

    @Override
    public Object[] toArray() {
        return this.toList().toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.toList().toArray((T[])array);
    }
}

