/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectIntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.ImmutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectIntMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.eclipse.collections.api.map.primitive.ObjectIntMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.ObjectIntPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.IntBags;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.map.immutable.primitive.AbstractImmutableObjectIntMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import org.eclipse.collections.impl.set.mutable.UnmodifiableMutableSet;

final class ImmutableObjectIntHashMap<K>
extends AbstractImmutableObjectIntMap<K>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableObjectIntMap<K> delegate;

    ImmutableObjectIntHashMap(ObjectIntMap<? extends K> delegate) {
        this.delegate = new ObjectIntHashMap<K>(delegate);
    }

    @Override
    public IntIterator intIterator() {
        return new UnmodifiableIntIterator(this.delegate.intIterator());
    }

    @Override
    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(IntProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(IntPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableIntCollection select(IntPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableIntCollection reject(IntPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public RichIterable<IntIterable> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            IntIterator iterator2 = this.intIterator();
            while (iterator2.hasNext()) {
                MutableIntBag batch = IntBags.mutable.empty();
                for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
                    batch.add(iterator2.next());
                }
                result.add(batch.toImmutable());
            }
        }
        return result.toImmutable();
    }

    @Override
    public <V> ImmutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        RichIterable collection = this.delegate.collect((IntToObjectFunction)function);
        return collection.toImmutable();
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public int max() {
        return this.delegate.max();
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public int min() {
        return this.delegate.min();
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public int[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableIntList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public int[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public int[] toArray(int[] target) {
        return this.delegate.toArray(target);
    }

    @Override
    public boolean contains(int value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(int ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(IntIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableIntList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableIntSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableIntBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyIntIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableObjectIntMap<K> newWithKeyValue(K key, int value) {
        ObjectIntHashMap<K> map2 = ObjectIntHashMap.newMap();
        map2.putAll(this);
        map2.put(key, value);
        return map2.toImmutable();
    }

    @Override
    public ImmutableObjectIntMap<K> newWithoutKey(K key) {
        ObjectIntHashMap<K> map2 = ObjectIntHashMap.newMap();
        map2.putAll(this);
        map2.removeKey(key);
        return map2.toImmutable();
    }

    @Override
    public ImmutableObjectIntMap<K> newWithoutAllKeys(Iterable<? extends K> keys2) {
        ObjectIntHashMap<K> map2 = ObjectIntHashMap.newMap();
        map2.putAll(this);
        Iterator<K> iterator2 = keys2.iterator();
        while (iterator2.hasNext()) {
            map2.removeKey(iterator2.next());
        }
        return map2.toImmutable();
    }

    @Override
    public int get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public int getOrThrow(Object key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public int getIfAbsent(Object key, int ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(int value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(IntProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(Procedure<? super K> procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(ObjectIntProcedure<? super K> objectIntProcedure) {
        this.delegate.forEachKeyValue(objectIntProcedure);
    }

    @Override
    public ImmutableObjectIntMap<K> select(ObjectIntPredicate<? super K> objectIntPredicate) {
        return this.delegate.select(objectIntPredicate).toImmutable();
    }

    @Override
    public ImmutableObjectIntMap<K> reject(ObjectIntPredicate<? super K> objectIntPredicate) {
        return this.delegate.reject(objectIntPredicate).toImmutable();
    }

    @Override
    public ImmutableObjectIntMap<K> toImmutable() {
        return this;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public Set<K> keySet() {
        return UnmodifiableMutableSet.of(this.delegate.keySet());
    }

    @Override
    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of(this.delegate.values());
    }

    @Override
    public LazyIterable<K> keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<ObjectIntPair<K>> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableIntObjectMap<K> flipUniqueValues() {
        MutableIntObjectMap result = IntObjectMaps.mutable.empty();
        this.forEachKeyValue((key, value) -> {
            Object oldKey = result.put(value, key);
            if (oldKey != null) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + oldKey + " and key: " + key);
            }
        });
        return result.toImmutable();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    private Object writeReplace() {
        return new AbstractImmutableObjectIntMap.ImmutableObjectIntMapSerializationProxy(this);
    }
}

