/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortFloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortFloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.map.primitive.ImmutableFloatShortMap;
import org.eclipse.collections.api.map.primitive.ImmutableShortFloatMap;
import org.eclipse.collections.api.map.primitive.ShortFloatMap;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.ShortFloatPair;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.FloatBags;
import org.eclipse.collections.impl.factory.primitive.FloatShortMaps;
import org.eclipse.collections.impl.factory.primitive.ShortFloatMaps;
import org.eclipse.collections.impl.factory.primitive.ShortLists;
import org.eclipse.collections.impl.iterator.UnmodifiableFloatIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.ShortFloatHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableShortSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableShortFloatSingletonMap
implements ImmutableShortFloatMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_VALUE = 0.0f;
    private final short key1;
    private final float value1;

    ImmutableShortFloatSingletonMap(short key1, float value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    @Override
    public float get(short key) {
        return this.getIfAbsent(key, 0.0f);
    }

    @Override
    public float getIfAbsent(short key, float ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    @Override
    public float getOrThrow(short key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(short key) {
        return this.key1 == key;
    }

    @Override
    public boolean containsValue(float value) {
        return Float.compare(this.value1, value) == 0;
    }

    @Override
    public void forEachValue(FloatProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public void forEachKey(ShortProcedure procedure) {
        procedure.value(this.key1);
    }

    @Override
    public void forEachKeyValue(ShortFloatProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    @Override
    public LazyShortIterable keysView() {
        return ShortLists.immutable.of(this.key1).asLazy();
    }

    @Override
    public RichIterable<ShortFloatPair> keyValuesView() {
        return Lists.immutable.of(PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    @Override
    public ImmutableFloatShortMap flipUniqueValues() {
        return FloatShortMaps.immutable.with(this.value1, this.key1);
    }

    @Override
    public ImmutableShortFloatMap select(ShortFloatPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? ShortFloatHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new ShortFloatHashMap().toImmutable();
    }

    @Override
    public ImmutableShortFloatMap reject(ShortFloatPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new ShortFloatHashMap().toImmutable() : ShortFloatHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return function.valueOf(injectedValue, this.value1);
    }

    @Override
    public RichIterable<FloatIterable> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        return Lists.mutable.with(FloatBags.immutable.with(this.value1));
    }

    @Override
    public ImmutableShortFloatMap toImmutable() {
        return this;
    }

    @Override
    public FloatIterator floatIterator() {
        return new UnmodifiableFloatIterator(ShortFloatHashMap.newWithKeysValues(this.key1, this.value1).floatIterator());
    }

    @Override
    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(FloatProcedure procedure) {
        procedure.value(this.value1);
    }

    @Override
    public int count(FloatPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    @Override
    public double sum() {
        return this.value1;
    }

    @Override
    public float min() {
        return this.value1;
    }

    @Override
    public float max() {
        return this.value1;
    }

    @Override
    public float maxIfEmpty(float defaultValue) {
        return this.value1;
    }

    @Override
    public float minIfEmpty(float defaultValue) {
        return this.value1;
    }

    @Override
    public double average() {
        return this.value1;
    }

    @Override
    public double median() {
        return this.value1;
    }

    @Override
    public float[] toSortedArray() {
        return new float[]{this.value1};
    }

    @Override
    public MutableFloatList toSortedList() {
        return FloatArrayList.newListWith(this.value1);
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        return predicate.accept(this.value1);
    }

    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    @Override
    public ImmutableFloatBag select(FloatPredicate predicate) {
        return predicate.accept(this.value1) ? FloatHashBag.newBagWith(this.value1).toImmutable() : FloatBags.immutable.empty();
    }

    @Override
    public ImmutableFloatBag reject(FloatPredicate predicate) {
        return predicate.accept(this.value1) ? FloatBags.immutable.empty() : FloatHashBag.newBagWith(this.value1).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(FloatToObjectFunction<? extends V> function) {
        return Bags.immutable.of(function.valueOf(this.value1));
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    @Override
    public float[] toArray() {
        return new float[]{this.value1};
    }

    @Override
    public float[] toArray(float[] target) {
        if (target.length < 1) {
            target = new float[]{this.value1};
        } else {
            target[0] = this.value1;
        }
        return target;
    }

    @Override
    public boolean contains(float value) {
        return Float.compare(this.value1, value) == 0;
    }

    @Override
    public boolean containsAll(float ... source) {
        for (float value : source) {
            if (Float.compare(this.value1, value) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        FloatIterator iterator2 = source.floatIterator();
        while (iterator2.hasNext()) {
            if (Float.compare(this.value1, iterator2.next()) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public MutableFloatList toList() {
        return FloatArrayList.newListWith(this.value1);
    }

    @Override
    public MutableFloatSet toSet() {
        return FloatHashSet.newSetWith(this.value1);
    }

    @Override
    public MutableFloatBag toBag() {
        return FloatHashBag.newBagWith(this.value1);
    }

    @Override
    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter(this);
    }

    @Override
    public ImmutableShortFloatMap newWithKeyValue(short key, float value) {
        return ShortFloatMaps.immutable.withAll(ShortFloatHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    @Override
    public ImmutableShortFloatMap newWithoutKey(short key) {
        return this.key1 == key ? ShortFloatMaps.immutable.with() : this;
    }

    @Override
    public ImmutableShortFloatMap newWithoutAllKeys(ShortIterable keys2) {
        return keys2.contains(this.key1) ? ShortFloatMaps.immutable.with() : this;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean notEmpty() {
        return true;
    }

    @Override
    public MutableShortSet keySet() {
        return UnmodifiableShortSet.of(ShortHashSet.newSetWith(this.key1));
    }

    @Override
    public MutableFloatCollection values() {
        return UnmodifiableFloatCollection.of(FloatArrayList.newListWith(this.value1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShortFloatMap)) {
            return false;
        }
        ShortFloatMap map2 = (ShortFloatMap)obj;
        if (map2.size() != 1) {
            return false;
        }
        return map2.containsKey(this.key1) && Float.compare(this.value1, map2.getOrThrow(this.key1)) == 0;
    }

    @Override
    public int hashCode() {
        return this.key1 ^ Float.floatToIntBits(this.value1);
    }

    @Override
    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    @Override
    public String makeString() {
        return this.makeString(", ");
    }

    @Override
    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    @Override
    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    @Override
    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

