/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.set.immutable.primitive.AbstractImmutableShortSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableShortSetSerializationProxy;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;

class ImmutableShortShortMapKeySet
extends AbstractImmutableShortSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final short EMPTY_KEY = 0;
    private static final short REMOVED_KEY = 1;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 2;
    private static final int INITIAL_LINEAR_PROBE = 16;
    private final short[] keysValues;
    private final int occupiedWithData;
    private final boolean containsZeroKey;
    private final boolean containsOneKey;

    ImmutableShortShortMapKeySet(short[] keysValues, int occupiedWithData, boolean containsZeroKey, boolean containsOneKey) {
        this.keysValues = keysValues;
        this.occupiedWithData = occupiedWithData;
        this.containsZeroKey = containsZeroKey;
        this.containsOneKey = containsOneKey;
    }

    private static boolean isEmptyKey(short key) {
        return key == 0;
    }

    private static boolean isRemovedKey(short key) {
        return key == 1;
    }

    private static boolean isNonSentinel(short key) {
        return !ImmutableShortShortMapKeySet.isEmptyKey(key) && !ImmutableShortShortMapKeySet.isRemovedKey(key);
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.containsZeroKey) {
            result += 0;
        }
        if (this.containsOneKey) {
            ++result;
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableShortShortMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                result += this.keysValues[i];
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.occupiedWithData + (this.containsOneKey ? 1 : 0) + (this.containsZeroKey ? 1 : 0);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            int count2 = 0;
            if (this.containsZeroKey) {
                appendable.append(String.valueOf(0));
                ++count2;
            }
            if (this.containsOneKey) {
                if (count2 > 0) {
                    appendable.append(separator);
                }
                ++count2;
                appendable.append(String.valueOf(1));
            }
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableShortShortMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                if (count2 > 0) {
                    appendable.append(separator);
                }
                ++count2;
                appendable.append(String.valueOf(this.keysValues[i]));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ShortIterator shortIterator() {
        return new InternalShortIterator();
    }

    @Override
    public short[] toArray() {
        short[] array = new short[this.size()];
        int index = 0;
        if (this.containsZeroKey) {
            array[index] = 0;
            ++index;
        }
        if (this.containsOneKey) {
            array[index] = 1;
            ++index;
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableShortShortMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                array[index] = this.keysValues[i];
                ++index;
            }
        }
        return array;
    }

    @Override
    public short[] toArray(short[] array) {
        if (array.length < this.size()) {
            array = new short[this.size()];
        }
        int index = 0;
        if (this.containsZeroKey) {
            array[index] = 0;
            ++index;
        }
        if (this.containsOneKey) {
            array[index] = 1;
            ++index;
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableShortShortMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                array[index] = this.keysValues[i];
                ++index;
            }
        }
        return array;
    }

    @Override
    public boolean contains(short value) {
        if (value == 0) {
            return this.containsZeroKey;
        }
        if (value == 1) {
            return this.containsOneKey;
        }
        return this.keysValues[this.probe(value)] == value;
    }

    @Override
    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ShortProcedure procedure) {
        if (this.containsZeroKey) {
            procedure.value((short)0);
        }
        if (this.containsOneKey) {
            procedure.value((short)1);
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableShortShortMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                procedure.value(this.keysValues[i]);
            }
        }
    }

    @Override
    public ImmutableShortSet select(ShortPredicate predicate) {
        ShortHashSet result = new ShortHashSet();
        if (this.containsZeroKey && predicate.accept((short)0)) {
            result.add((short)0);
        }
        if (this.containsOneKey && predicate.accept((short)1)) {
            result.add((short)1);
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableShortShortMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            result.add(this.keysValues[i]);
        }
        return result.toImmutable();
    }

    @Override
    public ImmutableShortSet reject(ShortPredicate predicate) {
        ShortHashSet result = new ShortHashSet();
        if (this.containsZeroKey && !predicate.accept((short)0)) {
            result.add((short)0);
        }
        if (this.containsOneKey && !predicate.accept((short)1)) {
            result.add((short)1);
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableShortShortMapKeySet.isNonSentinel(this.keysValues[i]) || predicate.accept(this.keysValues[i])) continue;
            result.add(this.keysValues[i]);
        }
        return result.toImmutable();
    }

    @Override
    public <V> ImmutableSet<V> collect(ShortToObjectFunction<? extends V> function) {
        UnifiedSet target = UnifiedSet.newSet(this.size());
        if (this.containsZeroKey) {
            target.add(function.valueOf((short)0));
        }
        if (this.containsOneKey) {
            target.add(function.valueOf((short)1));
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableShortShortMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                target.add(function.valueOf(this.keysValues[i]));
            }
        }
        return target.toImmutable();
    }

    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        if (this.containsZeroKey && predicate.accept((short)0)) {
            return 0;
        }
        if (this.containsOneKey && predicate.accept((short)1)) {
            return 1;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableShortShortMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            return this.keysValues[i];
        }
        return ifNone;
    }

    @Override
    public int count(ShortPredicate predicate) {
        int count2 = 0;
        if (this.containsZeroKey && predicate.accept((short)0)) {
            ++count2;
        }
        if (this.containsOneKey && predicate.accept((short)1)) {
            ++count2;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableShortShortMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        if (this.containsZeroKey && predicate.accept((short)0)) {
            return true;
        }
        if (this.containsOneKey && predicate.accept((short)1)) {
            return true;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableShortShortMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        if (this.containsZeroKey && !predicate.accept((short)0)) {
            return false;
        }
        if (this.containsOneKey && !predicate.accept((short)1)) {
            return false;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableShortShortMapKeySet.isNonSentinel(this.keysValues[i]) || predicate.accept(this.keysValues[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(ShortPredicate predicate) {
        if (this.containsZeroKey && predicate.accept((short)0)) {
            return false;
        }
        if (this.containsOneKey && predicate.accept((short)1)) {
            return false;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableShortShortMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public long sum() {
        long nextSum;
        long adjustedValue;
        long result = 0L;
        long compensation = 0L;
        if (this.containsZeroKey) {
            adjustedValue = 0L - compensation;
            nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        if (this.containsOneKey) {
            adjustedValue = 1L - compensation;
            nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableShortShortMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                long adjustedValue2 = (long)this.keysValues[i] - compensation;
                long nextSum2 = result + adjustedValue2;
                compensation = nextSum2 - result - adjustedValue2;
                result = nextSum2;
            }
        }
        return result;
    }

    @Override
    public short max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        short max2 = 0;
        boolean isMaxSet = false;
        if (this.containsZeroKey) {
            max2 = 0;
            isMaxSet = true;
        }
        if (this.containsOneKey && (!isMaxSet || max2 < 1)) {
            max2 = 1;
            isMaxSet = true;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableShortShortMapKeySet.isNonSentinel(this.keysValues[i]) || isMaxSet && max2 >= this.keysValues[i]) continue;
            max2 = this.keysValues[i];
            isMaxSet = true;
        }
        return max2;
    }

    @Override
    public short min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        short min2 = 0;
        boolean isMinSet = false;
        if (this.containsZeroKey) {
            min2 = 0;
            isMinSet = true;
        }
        if (this.containsOneKey && (!isMinSet || 1 < min2)) {
            min2 = 1;
            isMinSet = true;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableShortShortMapKeySet.isNonSentinel(this.keysValues[i]) || isMinSet && this.keysValues[i] >= min2) continue;
            min2 = this.keysValues[i];
            isMinSet = true;
        }
        return min2;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        if (this.containsZeroKey) {
            result = function.valueOf(result, (short)0);
        }
        if (this.containsOneKey) {
            result = function.valueOf(result, (short)1);
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableShortShortMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                result = function.valueOf(result, this.keysValues[i]);
            }
        }
        return result;
    }

    private Object writeReplace() {
        return new ImmutableShortSetSerializationProxy(this);
    }

    int probe(short element) {
        int index = this.mask(element) << 1;
        short keyAtIndex = this.keysValues[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        for (int i = 2; i < 16; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            keyAtIndex = this.keysValues[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(short element, int removedIndex) {
        int index = this.spreadTwoAndMask(element) << 1;
        for (int i = 0; i < 16; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            short keyAtIndex = this.keysValues[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(short element, int removedIndex) {
        int nextIndex = SpreadFunctions.shortSpreadOne(element) << 1;
        int spreadTwo = Integer.reverse(SpreadFunctions.shortSpreadTwo(element)) | 1;
        short keyAtIndex;
        while ((keyAtIndex = this.keysValues[nextIndex = this.mask((nextIndex >> 1) + spreadTwo) << 1]) != element) {
            if (keyAtIndex == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(short element) {
        int code = SpreadFunctions.shortSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(short element) {
        int code = SpreadFunctions.shortSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & (this.keysValues.length >> 1) - 1;
    }

    private class InternalShortIterator
    implements ShortIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalShortIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ImmutableShortShortMapKeySet.this.size();
        }

        @Override
        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ImmutableShortShortMapKeySet.this.containsZeroKey) {
                    return 0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ImmutableShortShortMapKeySet.this.containsOneKey) {
                    return 1;
                }
            }
            short[] keysValues = ImmutableShortShortMapKeySet.this.keysValues;
            while (!ImmutableShortShortMapKeySet.isNonSentinel(keysValues[this.position])) {
                this.position += 2;
            }
            short result = ImmutableShortShortMapKeySet.this.keysValues[this.position];
            this.position += 2;
            return result;
        }
    }
}

