/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.DoubleList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.DoubleStack;
import org.eclipse.collections.api.stack.primitive.ImmutableDoubleStack;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.DoubleStacks;
import org.eclipse.collections.impl.iterator.ImmutableEmptyDoubleIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;

final class ImmutableDoubleEmptyStack
implements ImmutableDoubleStack,
Serializable {
    static final ImmutableDoubleStack INSTANCE = new ImmutableDoubleEmptyStack();
    private static final long serialVersionUID = 1L;

    ImmutableDoubleEmptyStack() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public DoubleIterator doubleIterator() {
        return ImmutableEmptyDoubleIterator.INSTANCE;
    }

    @Override
    public void forEach(DoubleProcedure procedure) {
    }

    @Override
    public void each(DoubleProcedure procedure) {
    }

    @Override
    public int count(DoublePredicate predicate) {
        return 0;
    }

    @Override
    public boolean anySatisfy(DoublePredicate predicate) {
        return false;
    }

    @Override
    public boolean allSatisfy(DoublePredicate predicate) {
        return true;
    }

    @Override
    public boolean noneSatisfy(DoublePredicate predicate) {
        return true;
    }

    @Override
    public double peek() {
        throw new EmptyStackException();
    }

    @Override
    public DoubleList peek(int count2) {
        this.checkNegativeCount(count2);
        if (count2 == 0) {
            return new DoubleArrayList(0);
        }
        throw new EmptyStackException();
    }

    @Override
    public double peekAt(int index) {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    @Override
    public ImmutableDoubleStack select(DoublePredicate predicate) {
        return this;
    }

    @Override
    public ImmutableDoubleStack reject(DoublePredicate predicate) {
        return this;
    }

    @Override
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return ifNone;
    }

    @Override
    public <V> ImmutableStack<V> collect(DoubleToObjectFunction<? extends V> function) {
        return Stacks.immutable.of();
    }

    @Override
    public double sum() {
        return 0.0;
    }

    @Override
    public double max() {
        throw new NoSuchElementException();
    }

    @Override
    public double maxIfEmpty(double defaultValue) {
        return defaultValue;
    }

    @Override
    public double min() {
        throw new NoSuchElementException();
    }

    @Override
    public double minIfEmpty(double defaultValue) {
        return defaultValue;
    }

    @Override
    public double average() {
        throw new ArithmeticException();
    }

    @Override
    public double median() {
        throw new ArithmeticException();
    }

    @Override
    public double[] toSortedArray() {
        return new double[0];
    }

    @Override
    public MutableDoubleList toSortedList() {
        return new DoubleArrayList();
    }

    @Override
    public double[] toArray() {
        return new double[0];
    }

    @Override
    public double[] toArray(double[] target) {
        return target;
    }

    @Override
    public boolean contains(double value) {
        return false;
    }

    @Override
    public boolean containsAll(double ... source) {
        return source.length == 0;
    }

    @Override
    public boolean containsAll(DoubleIterable source) {
        return source.isEmpty();
    }

    @Override
    public MutableDoubleList toList() {
        return new DoubleArrayList();
    }

    @Override
    public MutableDoubleSet toSet() {
        return new DoubleHashSet();
    }

    @Override
    public MutableDoubleBag toBag() {
        return new DoubleHashBag();
    }

    @Override
    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter(this);
    }

    @Override
    public ImmutableDoubleStack toImmutable() {
        return this;
    }

    @Override
    public ImmutableDoubleStack push(double element) {
        return DoubleStacks.immutable.with(element);
    }

    @Override
    public ImmutableDoubleStack pop() {
        throw new EmptyStackException();
    }

    @Override
    public ImmutableDoubleStack pop(int count2) {
        this.checkNegativeCount(count2);
        if (count2 == 0) {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count2);
        }
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    @Override
    public RichIterable<DoubleIterable> chunk(int size2) {
        return Lists.immutable.empty();
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof DoubleStack)) {
            return false;
        }
        DoubleStack stack = (DoubleStack)otherStack;
        return stack.isEmpty();
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double getFirst() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getFirst() not implemented yet");
    }

    @Override
    public int indexOf(double value) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".indexOf() not implemented yet");
    }

    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectDoubleIntToObjectFunction<? super T, ? extends T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".injectIntoWithIndex() not implemented yet");
    }

    @Override
    public void forEachWithIndex(DoubleIntProcedure procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }
}

