/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableIntStack;
import org.eclipse.collections.api.stack.primitive.IntStack;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.IntStacks;
import org.eclipse.collections.impl.iterator.ImmutableEmptyIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;

final class ImmutableIntEmptyStack
implements ImmutableIntStack,
Serializable {
    static final ImmutableIntStack INSTANCE = new ImmutableIntEmptyStack();
    private static final long serialVersionUID = 1L;

    ImmutableIntEmptyStack() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public IntIterator intIterator() {
        return ImmutableEmptyIntIterator.INSTANCE;
    }

    @Override
    public void forEach(IntProcedure procedure) {
    }

    @Override
    public void each(IntProcedure procedure) {
    }

    @Override
    public int count(IntPredicate predicate) {
        return 0;
    }

    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        return false;
    }

    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        return true;
    }

    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        return true;
    }

    @Override
    public int peek() {
        throw new EmptyStackException();
    }

    @Override
    public IntList peek(int count2) {
        this.checkNegativeCount(count2);
        if (count2 == 0) {
            return new IntArrayList(0);
        }
        throw new EmptyStackException();
    }

    @Override
    public int peekAt(int index) {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    @Override
    public ImmutableIntStack select(IntPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableIntStack reject(IntPredicate predicate) {
        return this;
    }

    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return ifNone;
    }

    @Override
    public <V> ImmutableStack<V> collect(IntToObjectFunction<? extends V> function) {
        return Stacks.immutable.of();
    }

    @Override
    public long sum() {
        return 0L;
    }

    @Override
    public int max() {
        throw new NoSuchElementException();
    }

    @Override
    public int maxIfEmpty(int defaultValue) {
        return defaultValue;
    }

    @Override
    public int min() {
        throw new NoSuchElementException();
    }

    @Override
    public int minIfEmpty(int defaultValue) {
        return defaultValue;
    }

    @Override
    public double average() {
        throw new ArithmeticException();
    }

    @Override
    public double median() {
        throw new ArithmeticException();
    }

    @Override
    public int[] toSortedArray() {
        return new int[0];
    }

    @Override
    public MutableIntList toSortedList() {
        return new IntArrayList();
    }

    @Override
    public int[] toArray() {
        return new int[0];
    }

    @Override
    public int[] toArray(int[] target) {
        return target;
    }

    @Override
    public boolean contains(int value) {
        return false;
    }

    @Override
    public boolean containsAll(int ... source) {
        return source.length == 0;
    }

    @Override
    public boolean containsAll(IntIterable source) {
        return source.isEmpty();
    }

    @Override
    public MutableIntList toList() {
        return new IntArrayList();
    }

    @Override
    public MutableIntSet toSet() {
        return new IntHashSet();
    }

    @Override
    public MutableIntBag toBag() {
        return new IntHashBag();
    }

    @Override
    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter(this);
    }

    @Override
    public ImmutableIntStack toImmutable() {
        return this;
    }

    @Override
    public ImmutableIntStack push(int element) {
        return IntStacks.immutable.with(element);
    }

    @Override
    public ImmutableIntStack pop() {
        throw new EmptyStackException();
    }

    @Override
    public ImmutableIntStack pop(int count2) {
        this.checkNegativeCount(count2);
        if (count2 == 0) {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count2);
        }
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    @Override
    public RichIterable<IntIterable> chunk(int size2) {
        return Lists.immutable.empty();
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof IntStack)) {
            return false;
        }
        IntStack stack = (IntStack)otherStack;
        return stack.isEmpty();
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getFirst() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getFirst() not implemented yet");
    }

    @Override
    public int indexOf(int value) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".indexOf() not implemented yet");
    }

    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectIntIntToObjectFunction<? super T, ? extends T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".injectIntoWithIndex() not implemented yet");
    }

    @Override
    public void forEachWithIndex(IntIntProcedure procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }
}

