/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableIntStack;
import org.eclipse.collections.api.stack.primitive.MutableIntStack;
import org.eclipse.collections.impl.factory.primitive.IntStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.stack.mutable.primitive.UnmodifiableIntStack;

public class SynchronizedIntStack
implements MutableIntStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    private final MutableIntStack stack;

    public SynchronizedIntStack(MutableIntStack stack) {
        this(stack, null);
    }

    public SynchronizedIntStack(MutableIntStack stack, Object newLock) {
        this.stack = stack;
        this.lock = newLock == null ? this : newLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(int item) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.push(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pop() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntList pop(int count2) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.pop(count2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int peek() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IntList peek(int count2) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.peek(count2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int peekAt(int index) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.peekAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.stack.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(int value) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(int ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(IntIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.containsAll(source);
        }
    }

    @Override
    public IntIterator intIterator() {
        return new UnmodifiableIntIterator(this.stack.intIterator());
    }

    @Override
    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void each(IntProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean anySatisfy(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allSatisfy(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean noneSatisfy(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int detectIfNone(IntPredicate predicate, int ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntStack select(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntStack reject(IntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableStack<V> collect(IntToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.collect((IntToObjectFunction)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sum() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int max() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int min() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int minIfEmpty(int defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.minIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int maxIfEmpty(int defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.maxIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double average() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.average();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double median() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.median();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntList toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] toSortedArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toSortedArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] toArray(int[] target) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toArray(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object otherStack) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.equals(otherStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyIntIterable asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return new LazyIntIterableAdapter(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntStack asUnmodifiable() {
        Object object = this.lock;
        synchronized (object) {
            return new UnmodifiableIntStack(this);
        }
    }

    @Override
    public MutableIntStack asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableIntStack toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return IntStacks.immutable.withAllReversed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableIntStack newEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.newEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichIterable<IntIterable> chunk(int size2) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.chunk(size2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFirst() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(int value) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.indexOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectIntIntToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.injectIntoWithIndex(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachWithIndex(IntIntProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.forEachWithIndex(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableStack<V> collectWithIndex(IntIntToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.collectWithIndex((IntIntToObjectFunction)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V, R extends Collection<V>> R collectWithIndex(IntIntToObjectFunction<? extends V> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.collectWithIndex(function, target);
        }
    }
}

