/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.PriorityBlockingQueue;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.impl.utility.internal.ReflectionHelper;

public class DefaultSpeciesNewStrategy {
    public static final DefaultSpeciesNewStrategy INSTANCE = new DefaultSpeciesNewStrategy();
    private static final Class<?>[] SIZE_CONSTRUCTOR_TYPES = new Class[]{Integer.TYPE};

    public <T> Collection<T> speciesNew(Collection<?> collection) {
        if (collection instanceof MutableCollection) {
            return ((MutableCollection)collection).newEmpty();
        }
        if (collection instanceof Proxy) {
            return DefaultSpeciesNewStrategy.createNewInstanceForCollectionType(collection);
        }
        if (ReflectionHelper.hasDefaultConstructor(collection.getClass())) {
            return (Collection)ReflectionHelper.newInstance(collection.getClass());
        }
        return DefaultSpeciesNewStrategy.createNewInstanceForCollectionType(collection);
    }

    public <T> Collection<T> speciesNew(Collection<?> collection, int size2) {
        if (size2 < 0) {
            throw new IllegalArgumentException("size may not be < 0 but was " + size2);
        }
        if (collection instanceof Proxy || collection instanceof PriorityQueue || collection instanceof PriorityBlockingQueue || collection instanceof SortedSet) {
            return DefaultSpeciesNewStrategy.createNewInstanceForCollectionType(collection);
        }
        Constructor<?> constructor = ReflectionHelper.getConstructor(collection.getClass(), SIZE_CONSTRUCTOR_TYPES);
        if (constructor != null) {
            return (Collection)ReflectionHelper.newInstance(constructor, size2);
        }
        return this.speciesNew(collection);
    }

    private static <T> Collection<T> createNewInstanceForCollectionType(Collection<?> collection) {
        if (collection instanceof SortedSet || collection instanceof PriorityQueue || collection instanceof PriorityBlockingQueue) {
            return Lists.mutable.empty();
        }
        if (collection instanceof Set) {
            return Sets.mutable.empty();
        }
        return Lists.mutable.empty();
    }
}

