/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rsta.ui;

import java.awt.Dimension;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class MaxWidthComboBox<E>
extends JComboBox<E> {
    private static final long serialVersionUID = 1L;
    private int maxWidth;

    public MaxWidthComboBox(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public MaxWidthComboBox(ComboBoxModel<E> model, int maxWidth) {
        super(model);
        this.maxWidth = maxWidth;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension size2 = super.getMaximumSize();
        size2.width = Math.min(size2.width, this.maxWidth);
        return size2;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size2 = super.getMinimumSize();
        size2.width = Math.min(size2.width, this.maxWidth);
        return size2;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size2 = super.getPreferredSize();
        size2.width = Math.min(size2.width, this.maxWidth);
        return size2;
    }
}

