/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.eclipse.collections.api.map.primitive.MutableLongLongMap;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.BTreeMap;
import org.mapdb.BTreeMapJava;
import org.mapdb.ConcurrencyAware;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.HTreeMap;
import org.mapdb.IndexTreeList;
import org.mapdb.IndexTreeListJava;
import org.mapdb.IndexTreeLongLongMap;
import org.mapdb.MapModificationListener;
import org.mapdb.Pump;
import org.mapdb.QueueLong;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.StoreTx;
import org.mapdb.Utils;
import org.mapdb.elsa.ElsaClassCallback;
import org.mapdb.elsa.ElsaClassInfoResolver;
import org.mapdb.elsa.ElsaSerializerBase;
import org.mapdb.elsa.ElsaSerializerPojo;
import org.mapdb.elsa.ElsaStack;
import org.mapdb.serializer.GroupSerializer;
import org.mapdb.serializer.GroupSerializerObjectArray;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0096\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012*\u0002.3\b\u0016\u0018\u0000 \u0096\u00012\u00020\u00012\u00020\u0002: \u0090\u0001\u0091\u0001\u0092\u0001\u0093\u0001\u0094\u0001\u0095\u0001\u0096\u0001\u0097\u0001\u0098\u0001\u0099\u0001\u009a\u0001\u009b\u0001\u009c\u0001\u009d\u0001\u009e\u0001\u009f\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u0018J\u0016\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u00182\u0006\u0010F\u001a\u00020\u0006J\u000e\u0010G\u001a\u00020H2\u0006\u0010E\u001a\u00020\u0018J\u0016\u0010G\u001a\u00020H2\u0006\u0010E\u001a\u00020\u00182\u0006\u0010F\u001a\u00020\u000bJ\u000e\u0010I\u001a\u00020J2\u0006\u0010E\u001a\u00020\u0018J\u0016\u0010I\u001a\u00020J2\u0006\u0010E\u001a\u00020\u00182\u0006\u0010F\u001a\u00020KJ\u000e\u0010L\u001a\u00020M2\u0006\u0010E\u001a\u00020\u0018J\u0018\u0010L\u001a\u00020M2\u0006\u0010E\u001a\u00020\u00182\b\u0010F\u001a\u0004\u0018\u00010\u0018J\u0016\u0010N\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170O2\u0006\u0010E\u001a\u00020\u0018J(\u0010N\u001a\b\u0012\u0004\u0012\u0002HP0O\"\u0004\b\u0000\u0010P2\u0006\u0010E\u001a\u00020\u00182\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002HP0\u000eJ7\u0010N\u001a\b\u0012\u0004\u0012\u0002HP0O\"\u0004\b\u0000\u0010P2\u0006\u0010E\u001a\u00020\u00182\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002HP0\u000e2\b\u0010F\u001a\u0004\u0018\u0001HP\u00a2\u0006\u0002\u0010RJ\u0010\u0010S\u001a\u00020T2\u0006\u0010E\u001a\u00020\u0018H\u0004J\b\u0010U\u001a\u00020TH\u0004J\b\u0010V\u001a\u00020TH\u0016J\b\u0010W\u001a\u00020TH\u0016J\u0006\u0010X\u001a\u00020TJ\u0012\u0010Y\u001a\u00020T2\n\u0010Z\u001a\u0006\u0012\u0002\b\u00030@J\u0014\u0010[\u001a\u00020T2\n\u0010Z\u001a\u0006\u0012\u0002\b\u00030@H\u0002J\u000e\u0010\\\u001a\u00020\u00062\u0006\u0010E\u001a\u00020\u0018J\u0019\u0010]\u001a\u0002HP\"\u0004\b\u0000\u0010P2\u0006\u0010E\u001a\u00020\u0018\u00a2\u0006\u0002\u0010^J\u0014\u0010_\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00170`J\f\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00180bJ\u0010\u0010c\u001a\u0004\u0018\u00010\u00182\u0006\u0010d\u001a\u00020\u0017J\u0006\u0010e\u001a\u00020\u0004J\u0016\u0010f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030g2\u0006\u0010E\u001a\u00020\u0018JB\u0010f\u001a\u000e\u0012\u0004\u0012\u0002Hh\u0012\u0004\u0012\u0002Hi0g\"\u0004\b\u0000\u0010h\"\u0004\b\u0001\u0010i2\u0006\u0010E\u001a\u00020\u00182\f\u0010j\u001a\b\u0012\u0004\u0012\u0002Hh0\u000e2\f\u0010k\u001a\b\u0012\u0004\u0012\u0002Hi0\u000eJ\u0012\u0010l\u001a\u0006\u0012\u0002\b\u00030m2\u0006\u0010E\u001a\u00020\u0018J(\u0010l\u001a\b\u0012\u0004\u0012\u0002HP0m\"\u0004\b\u0000\u0010P2\u0006\u0010E\u001a\u00020\u00182\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002HP0\u000eJ\u0016\u0010n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170o2\u0006\u0010E\u001a\u00020\u0018J(\u0010n\u001a\b\u0012\u0004\u0012\u0002HP0o\"\u0004\b\u0000\u0010P2\u0006\u0010E\u001a\u00020\u00182\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002HP0\u000eJ\u0010\u0010p\u001a\u00020q2\u0006\u0010E\u001a\u00020\u0018H\u0002J\u0006\u0010r\u001a\u00020\u0006J\u0013\u0010s\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a2\u0006\u0002\u0010tJ\u0012\u0010u\u001a\u0004\u0018\u00010\u00182\u0006\u0010E\u001a\u00020\u0018H\u0004J/\u0010v\u001a\u0004\u0018\u0001HP\"\u0004\b\u0000\u0010P2\u0012\u0010w\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180x2\u0006\u0010y\u001a\u00020\u0018\u00a2\u0006\u0002\u0010zJ\u0012\u0010{\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180xJ\u0014\u0010|\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180xH\u0004J\u001a\u0010}\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180`2\u0006\u0010E\u001a\u00020\u0018J*\u0010~\u001a\u00020T2\u0012\u0010w\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180x2\u0006\u0010y\u001a\u00020\u00182\u0006\u0010\u007f\u001a\u00020\u0017J\u001b\u0010\u0080\u0001\u001a\u00020T2\u0012\u0010w\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180xJ\u001d\u0010\u0081\u0001\u001a\u00020T2\u0012\u0010w\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180xH\u0004J\r\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020\u00180bJ\"\u0010\u0083\u0001\u001a\u001b\u0012\u0004\u0012\u00020\u0018\u0012\u0011\u0012\u000f\u0012\u0004\u0012\u00020\u0018\u0012\u0005\u0012\u00030\u0084\u00010`0`H\u0002J\u001d\u0010\u0085\u0001\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00170@0\u000fH\u0002\u00a2\u0006\u0003\u0010\u0086\u0001J\u0015\u0010\u0087\u0001\u001a\b\u0012\u0004\u0012\u00020\u00170\u000fH\u0002\u00a2\u0006\u0003\u0010\u0088\u0001J\u0007\u0010\u0089\u0001\u001a\u00020TJ\u0018\u0010\u008a\u0001\u001a\u000b\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u008b\u00012\u0006\u0010E\u001a\u00020\u0018JF\u0010\u008a\u0001\u001a\u000f\u0012\u0004\u0012\u0002Hh\u0012\u0004\u0012\u0002Hi0\u008b\u0001\"\u0004\b\u0000\u0010h\"\u0004\b\u0001\u0010i2\u0006\u0010E\u001a\u00020\u00182\r\u0010j\u001a\t\u0012\u0004\u0012\u0002Hh0\u008c\u00012\r\u0010k\u001a\t\u0012\u0004\u0012\u0002Hi0\u008c\u0001J\u0014\u0010\u008d\u0001\u001a\u0007\u0012\u0002\b\u00030\u008e\u00012\u0006\u0010E\u001a\u00020\u0018J+\u0010\u008d\u0001\u001a\t\u0012\u0004\u0012\u0002HP0\u008e\u0001\"\u0004\b\u0000\u0010P2\u0006\u0010E\u001a\u00020\u00182\r\u0010Q\u001a\t\u0012\u0004\u0012\u0002HP0\u008c\u0001J\t\u0010\u008f\u0001\u001a\u00020TH\u0002R \u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00170\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010(R\u0016\u0010)\u001a\u0004\u0018\u00010*X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0010\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010/R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00104R(\u00105\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001706X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0010\u0010=\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010(RB\u0010?\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 A*\b\u0012\u0002\b\u0003\u0018\u00010@0@ A*\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 A*\b\u0012\u0002\b\u0003\u0018\u00010@0@\u0018\u00010B0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a0\u0001"}, d2={"Lorg/mapdb/DB;", "Ljava/io/Closeable;", "Lorg/mapdb/ConcurrencyAware;", "store", "Lorg/mapdb/Store;", "storeOpened", "", "isThreadSafe", "classLoader", "Ljava/lang/ClassLoader;", "shutdownHook", "", "(Lorg/mapdb/Store;ZZLjava/lang/ClassLoader;I)V", "classInfoSerializer", "Lorg/mapdb/Serializer;", "", "Lorg/mapdb/elsa/ElsaSerializerPojo$ClassInfo;", "getClassInfoSerializer", "()Lorg/mapdb/Serializer;", "getClassLoader", "()Ljava/lang/ClassLoader;", "classSingletonCat", "Ljava/util/IdentityHashMap;", "", "", "classSingletonRev", "Ljava/util/HashMap;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "defaultSerializer", "Lorg/mapdb/serializer/GroupSerializerObjectArray;", "getDefaultSerializer", "()Lorg/mapdb/serializer/GroupSerializerObjectArray;", "elsaSerializer", "Lorg/mapdb/elsa/ElsaSerializerPojo;", "executors", "", "Ljava/util/concurrent/ExecutorService;", "getExecutors", "()Ljava/util/Set;", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "nameDeser", "org/mapdb/DB$nameDeser$1", "Lorg/mapdb/DB$nameDeser$1;", "nameRegex", "Lkotlin/text/Regex;", "nameSer", "org/mapdb/DB$nameSer$1", "Lorg/mapdb/DB$nameSer$1;", "namesInstanciated", "Lcom/google/common/cache/Cache;", "getNamesInstanciated", "()Lcom/google/common/cache/Cache;", "setNamesInstanciated", "(Lcom/google/common/cache/Cache;)V", "getShutdownHook", "()I", "shutdownReference", "getStoreOpened", "unknownClasses", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "", "atomicBoolean", "Lorg/mapdb/DB$AtomicBooleanMaker;", "name", "value", "atomicInteger", "Lorg/mapdb/DB$AtomicIntegerMaker;", "atomicLong", "Lorg/mapdb/DB$AtomicLongMaker;", "", "atomicString", "Lorg/mapdb/DB$AtomicStringMaker;", "atomicVar", "Lorg/mapdb/DB$AtomicVarMaker;", "E", "serializer", "(Ljava/lang/String;Lorg/mapdb/Serializer;Ljava/lang/Object;)Lorg/mapdb/DB$AtomicVarMaker;", "checkName", "", "checkNotClosed", "checkThreadSafe", "close", "commit", "defaultSerializerRegisterClass", "clazz", "defaultSerializerRegisterClass_noLock", "exists", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "getAll", "", "getAllNames", "", "getNameForObject", "e", "getStore", "hashMap", "Lorg/mapdb/DB$HashMapMaker;", "K", "V", "keySerializer", "valueSerializer", "hashSet", "Lorg/mapdb/DB$HashSetMaker;", "indexTreeList", "Lorg/mapdb/DB$IndexTreeListMaker;", "indexTreeLongLongMap", "Lorg/mapdb/DB$IndexTreeLongLongMapMaker;", "isClosed", "loadClassInfos", "()[Lorg/mapdb/elsa/ElsaSerializerPojo$ClassInfo;", "nameCatalogGet", "nameCatalogGetClass", "nameCatalog", "Ljava/util/SortedMap;", "key", "(Ljava/util/SortedMap;Ljava/lang/String;)Ljava/lang/Object;", "nameCatalogLoad", "nameCatalogLoadLocked", "nameCatalogParamsFor", "nameCatalogPutClass", "obj", "nameCatalogSave", "nameCatalogSaveLocked", "nameCatalogVerifyGetMessages", "nameCatalogVerifyTree", "Lorg/mapdb/DB$CatVal;", "namedClasses", "()[Ljava/lang/Class;", "pojoSingletons", "()[Ljava/lang/Object;", "rollback", "treeMap", "Lorg/mapdb/DB$TreeMapMaker;", "Lorg/mapdb/serializer/GroupSerializer;", "treeSet", "Lorg/mapdb/DB$TreeSetMaker;", "unknownClassesSave", "AtomicBooleanMaker", "AtomicIntegerMaker", "AtomicLongMaker", "AtomicStringMaker", "AtomicVarMaker", "CatVal", "Companion", "HashMapMaker", "HashSetMaker", "IndexTreeListMaker", "IndexTreeLongLongMapMaker", "Keys", "Maker", "TreeMapMaker", "TreeMapSink", "TreeSetMaker", "mapdb"})
public class DB
implements Closeable,
ConcurrencyAware {
    @Nullable
    private final ReentrantReadWriteLock lock;
    private final AtomicBoolean closed;
    @NotNull
    private Cache<String, Object> namesInstanciated;
    private final IdentityHashMap<Object, String> classSingletonCat;
    private final HashMap<String, Object> classSingletonRev;
    private final Set<Class<?>> unknownClasses;
    private final nameSer.1 nameSer;
    private final nameDeser.1 nameDeser;
    private final ElsaSerializerPojo elsaSerializer;
    @NotNull
    private final GroupSerializerObjectArray<Object> defaultSerializer;
    @NotNull
    private final Serializer<ElsaSerializerPojo.ClassInfo[]> classInfoSerializer;
    private final Object shutdownReference;
    @NotNull
    private final Set<ExecutorService> executors;
    private final Regex nameRegex;
    private final Store store;
    private final boolean storeOpened;
    private final boolean isThreadSafe;
    @NotNull
    private final ClassLoader classLoader;
    private final int shutdownHook;
    @NotNull
    private static final Serializer<SortedMap<String, String>> NAME_CATALOG_SERIALIZER;
    private static final int NAMED_SERIALIZATION_HEADER = 1;
    private static final Map<Object, Object> shutdownHooks;
    private static AtomicBoolean shutdownHookInstalled;
    public static final Companion Companion;

    @NotNull
    public final Store getStore() {
        this.checkNotClosed();
        return this.store;
    }

    @Nullable
    protected final ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    protected final void checkNotClosed() {
        if (this.closed.get()) {
            throw (Throwable)new IllegalAccessError("DB was closed");
        }
    }

    @NotNull
    protected final Cache<String, Object> getNamesInstanciated() {
        return this.namesInstanciated;
    }

    protected final void setNamesInstanciated(@NotNull Cache<String, Object> cache) {
        Intrinsics.checkParameterIsNotNull(cache, "<set-?>");
        this.namesInstanciated = cache;
    }

    private final Class<? extends Object>[] namedClasses() {
        return new Class[]{BTreeMap.class, HTreeMap.class, HTreeMap.KeySet.class, BTreeMapJava.KeySet.class, Atomic.Integer.class, Atomic.Long.class, Atomic.String.class, Atomic.Boolean.class, Atomic.Var.class, IndexTreeList.class};
    }

    @NotNull
    public final GroupSerializerObjectArray<Object> getDefaultSerializer() {
        return this.defaultSerializer;
    }

    @NotNull
    protected final Serializer<ElsaSerializerPojo.ClassInfo[]> getClassInfoSerializer() {
        return this.classInfoSerializer;
    }

    private final Object[] pojoSingletons() {
        Object[] objectArray = new Object[44];
        objectArray[0] = this;
        objectArray[1] = this.defaultSerializer;
        GroupSerializer<Character> groupSerializer = Serializer.CHAR;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer, "Serializer.CHAR");
        objectArray[2] = groupSerializer;
        GroupSerializer<String> groupSerializer2 = Serializer.STRING_ORIGHASH;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer2, "Serializer.STRING_ORIGHASH");
        objectArray[3] = groupSerializer2;
        GroupSerializer<String> groupSerializer3 = Serializer.STRING;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer3, "Serializer.STRING");
        objectArray[4] = groupSerializer3;
        GroupSerializer<String> groupSerializer4 = Serializer.STRING_DELTA;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer4, "Serializer.STRING_DELTA");
        objectArray[5] = groupSerializer4;
        GroupSerializer<String> groupSerializer5 = Serializer.STRING_DELTA2;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer5, "Serializer.STRING_DELTA2");
        objectArray[6] = groupSerializer5;
        GroupSerializer<String> groupSerializer6 = Serializer.STRING_INTERN;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer6, "Serializer.STRING_INTERN");
        objectArray[7] = groupSerializer6;
        GroupSerializer<String> groupSerializer7 = Serializer.STRING_ASCII;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer7, "Serializer.STRING_ASCII");
        objectArray[8] = groupSerializer7;
        Serializer<String> serializer = Serializer.STRING_NOSIZE;
        Intrinsics.checkExpressionValueIsNotNull(serializer, "Serializer.STRING_NOSIZE");
        objectArray[9] = serializer;
        GroupSerializer<Long> groupSerializer8 = Serializer.LONG;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer8, "Serializer.LONG");
        objectArray[10] = groupSerializer8;
        GroupSerializer<Long> groupSerializer9 = Serializer.LONG_PACKED;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer9, "Serializer.LONG_PACKED");
        objectArray[11] = groupSerializer9;
        GroupSerializer<Long> groupSerializer10 = Serializer.LONG_DELTA;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer10, "Serializer.LONG_DELTA");
        objectArray[12] = groupSerializer10;
        GroupSerializer<Integer> groupSerializer11 = Serializer.INTEGER;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer11, "Serializer.INTEGER");
        objectArray[13] = groupSerializer11;
        GroupSerializer<Integer> groupSerializer12 = Serializer.INTEGER_PACKED;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer12, "Serializer.INTEGER_PACKED");
        objectArray[14] = groupSerializer12;
        GroupSerializer<Integer> groupSerializer13 = Serializer.INTEGER_DELTA;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer13, "Serializer.INTEGER_DELTA");
        objectArray[15] = groupSerializer13;
        GroupSerializer<Boolean> groupSerializer14 = Serializer.BOOLEAN;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer14, "Serializer.BOOLEAN");
        objectArray[16] = groupSerializer14;
        GroupSerializer<Long> groupSerializer15 = Serializer.RECID;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer15, "Serializer.RECID");
        objectArray[17] = groupSerializer15;
        GroupSerializer<long[]> groupSerializer16 = Serializer.RECID_ARRAY;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer16, "Serializer.RECID_ARRAY");
        objectArray[18] = groupSerializer16;
        GroupSerializer<Object> groupSerializer17 = Serializer.ILLEGAL_ACCESS;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer17, "Serializer.ILLEGAL_ACCESS");
        objectArray[19] = groupSerializer17;
        GroupSerializer<byte[]> groupSerializer18 = Serializer.BYTE_ARRAY;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer18, "Serializer.BYTE_ARRAY");
        objectArray[20] = groupSerializer18;
        GroupSerializer<byte[]> groupSerializer19 = Serializer.BYTE_ARRAY_DELTA;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer19, "Serializer.BYTE_ARRAY_DELTA");
        objectArray[21] = groupSerializer19;
        GroupSerializer<byte[]> groupSerializer20 = Serializer.BYTE_ARRAY_DELTA2;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer20, "Serializer.BYTE_ARRAY_DELTA2");
        objectArray[22] = groupSerializer20;
        Serializer<byte[]> serializer2 = Serializer.BYTE_ARRAY_NOSIZE;
        Intrinsics.checkExpressionValueIsNotNull(serializer2, "Serializer.BYTE_ARRAY_NOSIZE");
        objectArray[23] = serializer2;
        GroupSerializer<char[]> groupSerializer21 = Serializer.CHAR_ARRAY;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer21, "Serializer.CHAR_ARRAY");
        objectArray[24] = groupSerializer21;
        GroupSerializer<int[]> groupSerializer22 = Serializer.INT_ARRAY;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer22, "Serializer.INT_ARRAY");
        objectArray[25] = groupSerializer22;
        GroupSerializer<long[]> groupSerializer23 = Serializer.LONG_ARRAY;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer23, "Serializer.LONG_ARRAY");
        objectArray[26] = groupSerializer23;
        GroupSerializer<double[]> groupSerializer24 = Serializer.DOUBLE_ARRAY;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer24, "Serializer.DOUBLE_ARRAY");
        objectArray[27] = groupSerializer24;
        GroupSerializer groupSerializer25 = Serializer.JAVA;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer25, "Serializer.JAVA");
        objectArray[28] = groupSerializer25;
        GroupSerializer groupSerializer26 = Serializer.ELSA;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer26, "Serializer.ELSA");
        objectArray[29] = groupSerializer26;
        GroupSerializer<UUID> groupSerializer27 = Serializer.UUID;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer27, "Serializer.UUID");
        objectArray[30] = groupSerializer27;
        GroupSerializer<Byte> groupSerializer28 = Serializer.BYTE;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer28, "Serializer.BYTE");
        objectArray[31] = groupSerializer28;
        GroupSerializer<Float> groupSerializer29 = Serializer.FLOAT;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer29, "Serializer.FLOAT");
        objectArray[32] = groupSerializer29;
        GroupSerializer<Double> groupSerializer30 = Serializer.DOUBLE;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer30, "Serializer.DOUBLE");
        objectArray[33] = groupSerializer30;
        GroupSerializer<Short> groupSerializer31 = Serializer.SHORT;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer31, "Serializer.SHORT");
        objectArray[34] = groupSerializer31;
        GroupSerializer<short[]> groupSerializer32 = Serializer.SHORT_ARRAY;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer32, "Serializer.SHORT_ARRAY");
        objectArray[35] = groupSerializer32;
        GroupSerializer<float[]> groupSerializer33 = Serializer.FLOAT_ARRAY;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer33, "Serializer.FLOAT_ARRAY");
        objectArray[36] = groupSerializer33;
        GroupSerializer<BigInteger> groupSerializer34 = Serializer.BIG_INTEGER;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer34, "Serializer.BIG_INTEGER");
        objectArray[37] = groupSerializer34;
        GroupSerializer<BigDecimal> groupSerializer35 = Serializer.BIG_DECIMAL;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer35, "Serializer.BIG_DECIMAL");
        objectArray[38] = groupSerializer35;
        GroupSerializer<Class<?>> groupSerializer36 = Serializer.CLASS;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer36, "Serializer.CLASS");
        objectArray[39] = groupSerializer36;
        GroupSerializer<Date> groupSerializer37 = Serializer.DATE;
        Intrinsics.checkExpressionValueIsNotNull(groupSerializer37, "Serializer.DATE");
        objectArray[40] = groupSerializer37;
        List list = Collections.EMPTY_LIST;
        Intrinsics.checkExpressionValueIsNotNull(list, "Collections.EMPTY_LIST");
        objectArray[41] = list;
        Set set = Collections.EMPTY_SET;
        Intrinsics.checkExpressionValueIsNotNull(set, "Collections.EMPTY_SET");
        objectArray[42] = set;
        Map map2 = Collections.EMPTY_MAP;
        Intrinsics.checkExpressionValueIsNotNull(map2, "Collections.EMPTY_MAP");
        objectArray[43] = map2;
        return objectArray;
    }

    private final ElsaSerializerPojo.ClassInfo[] loadClassInfos() {
        ElsaSerializerPojo.ClassInfo[] classInfoArray = this.store.get(2L, this.classInfoSerializer);
        if (classInfoArray == null) {
            Intrinsics.throwNpe();
        }
        return classInfoArray;
    }

    @NotNull
    protected final Set<ExecutorService> getExecutors() {
        return this.executors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SortedMap<String, String> nameCatalogLoad() {
        SortedMap<String, String> sortedMap;
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            this.checkNotClosed();
            sortedMap = this.nameCatalogLoadLocked();
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
        return sortedMap;
    }

    @NotNull
    protected final SortedMap<String, String> nameCatalogLoadLocked() {
        Utils.INSTANCE.assertReadLock(this.lock);
        SortedMap<String, String> sortedMap = this.store.get(1L, NAME_CATALOG_SERIALIZER);
        if (sortedMap == null) {
            throw (Throwable)new DBException.WrongConfiguration("Could not open store, it has no Named Catalog");
        }
        return sortedMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void nameCatalogSave(@NotNull SortedMap<String, String> nameCatalog) {
        Intrinsics.checkParameterIsNotNull(nameCatalog, "nameCatalog");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            this.checkNotClosed();
            this.nameCatalogSaveLocked(nameCatalog);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    protected final void nameCatalogSaveLocked(@NotNull SortedMap<String, String> nameCatalog) {
        Intrinsics.checkParameterIsNotNull(nameCatalog, "nameCatalog");
        Utils.INSTANCE.assertWriteLock(this.lock);
        this.store.update(1L, nameCatalog, NAME_CATALOG_SERIALIZER);
    }

    protected final void checkName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        if (StringsKt.contains$default((CharSequence)name, '#', false, 2, null)) {
            throw (Throwable)new DBException.WrongConfiguration("Name contains illegal character, '#' is not allowed.");
        }
        Regex regex = this.nameRegex;
        CharSequence charSequence = name;
        if (!regex.matches(charSequence)) {
            throw (Throwable)new DBException.WrongConfiguration("Name contains illegal character");
        }
    }

    @Nullable
    protected final String nameCatalogGet(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return (String)this.nameCatalogLoadLocked().get(name);
    }

    public final void nameCatalogPutClass(@NotNull SortedMap<String, String> nameCatalog, @NotNull String key, @NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull(nameCatalog, "nameCatalog");
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(obj, "obj");
        String value = this.classSingletonCat.get(obj);
        if (value == null) {
            // empty if block
        }
        if (value != null) {
            nameCatalog.put(key, value);
        }
    }

    @Nullable
    public final <E> E nameCatalogGetClass(@NotNull SortedMap<String, String> nameCatalog, @NotNull String key) {
        Intrinsics.checkParameterIsNotNull(nameCatalog, "nameCatalog");
        Intrinsics.checkParameterIsNotNull(key, "key");
        String string = (String)nameCatalog.get(key);
        if (string == null) {
            return null;
        }
        String clazz = string;
        Object singleton = this.classSingletonRev.get(clazz);
        if (singleton != null) {
            return (E)singleton;
        }
        throw (Throwable)new DBException.WrongConfiguration("Could not load object: " + clazz);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> nameCatalogParamsFor(@NotNull String name) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(name, "name");
        TreeMap ret2 = new TreeMap();
        Map map2 = this.nameCatalogLoad();
        TreeMap treeMap2 = ret2;
        void var4_5 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        void var6_7 = $receiver$iv$iv;
        Iterator iterator2 = var6_7.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            Object k = it.getKey();
            Intrinsics.checkExpressionValueIsNotNull(k, "it.key");
            if (!StringsKt.startsWith$default((String)k, name + "#", false, 2, null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map map3 = destination$iv$iv;
        treeMap2.putAll(map3);
        Map<String, String> map4 = Collections.unmodifiableMap(ret2);
        Intrinsics.checkExpressionValueIsNotNull(map4, "Collections.unmodifiableMap(ret)");
        return map4;
    }

    private final void unknownClassesSave() {
        Utils.INSTANCE.assertWriteLock(this.lock);
        Set<Class<?>> set = this.unknownClasses;
        Intrinsics.checkExpressionValueIsNotNull(set, "unknownClasses");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            Class it;
            Class clazz = it = (Class)element$iv;
            Intrinsics.checkExpressionValueIsNotNull(clazz, "it");
            this.defaultSerializerRegisterClass_noLock(clazz);
        }
        this.unknownClasses.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            this.checkNotClosed();
            this.unknownClassesSave();
            this.store.commit();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rollback() {
        if (!(this.store instanceof StoreTx)) {
            throw (Throwable)new UnsupportedOperationException("Store does not support rollback");
        }
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            this.checkNotClosed();
            this.unknownClasses.clear();
            ((StoreTx)this.store).rollback();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    public final boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (this.shutdownReference != null) {
            shutdownHooks.remove(this.shutdownReference);
        }
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            ExecutorService it;
            this.unknownClassesSave();
            Iterable $receiver$iv = this.executors;
            for (Object element$iv : $receiver$iv) {
                it = (ExecutorService)element$iv;
                it.shutdown();
            }
            $receiver$iv = this.executors;
            for (Object element$iv : $receiver$iv) {
                it = (ExecutorService)element$iv;
                while (!it.awaitTermination(1L, TimeUnit.DAYS)) {
                }
            }
            this.executors.clear();
            this.store.close();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final <E> E get(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        var2_2 = Utils.INSTANCE;
        lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            block29: {
                block18: {
                    block21: {
                        block23: {
                            block20: {
                                block25: {
                                    block27: {
                                        block22: {
                                            block19: {
                                                block24: {
                                                    block26: {
                                                        block28: {
                                                            this.checkNotClosed();
                                                            v0 = var5_5 = (type = this.nameCatalogGet(name + Keys.INSTANCE.getType()));
                                                            if (v0 == null) break block18;
                                                            switch (v0.hashCode()) {
                                                                case 23865181: {
                                                                    if (!var5_5.equals("AtomicBoolean")) ** break;
                                                                    break block19;
                                                                }
                                                                case 2132139879: {
                                                                    if (!var5_5.equals("AtomicLong")) ** break;
                                                                    break block20;
                                                                }
                                                                case 285670804: {
                                                                    if (!var5_5.equals("IndexTreeLongLongMap")) ** break;
                                                                    break block21;
                                                                }
                                                                case -1932803762: {
                                                                    if (!var5_5.equals("HashMap")) ** break;
                                                                    break;
                                                                }
                                                                case 1917205619: {
                                                                    if (!var5_5.equals("AtomicInteger")) ** break;
                                                                    break block22;
                                                                }
                                                                case -1299487698: {
                                                                    if (!var5_5.equals("IndexTreeList")) ** break;
                                                                    break block23;
                                                                }
                                                                case 600988612: {
                                                                    if (!var5_5.equals("TreeSet")) ** break;
                                                                    break block24;
                                                                }
                                                                case 492169788: {
                                                                    if (!var5_5.equals("AtomicString")) ** break;
                                                                    break block25;
                                                                }
                                                                case 600982718: {
                                                                    if (!var5_5.equals("TreeMap")) ** break;
                                                                    break block26;
                                                                }
                                                                case 1731355868: {
                                                                    if (!var5_5.equals("AtomicVar")) ** break;
                                                                    break block27;
                                                                }
                                                                case -1932797868: {
                                                                    if (!var5_5.equals("HashSet")) ** break;
                                                                    break block28;
                                                                }
                                                            }
                                                            v1 = this.hashMap(name).open();
                                                            break block29;
                                                        }
                                                        v1 = this.hashSet(name).open();
                                                        break block29;
                                                    }
                                                    v1 = this.treeMap(name).open();
                                                    break block29;
                                                }
                                                v1 = this.treeSet(name).open();
                                                break block29;
                                            }
                                            v1 = this.atomicBoolean(name).open();
                                            break block29;
                                        }
                                        v1 = this.atomicInteger(name).open();
                                        break block29;
                                    }
                                    v1 = this.atomicVar(name).open();
                                    break block29;
                                }
                                v1 = this.atomicString(name).open();
                                break block29;
                            }
                            v1 = this.atomicLong(name).open();
                            break block29;
                        }
                        v1 = this.indexTreeList(name).open();
                        break block29;
                    }
                    v1 = this.indexTreeLongLongMap(name).open();
                    break block29;
                }
                v1 = null;
                break block29;
                v1 = new DBException.WrongConfiguration("Collection has unknown type: " + type);
            }
            var9_6 = v1;
            return (E)var9_6;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    @Nullable
    public final String getNameForObject(@NotNull Object e) {
        Intrinsics.checkParameterIsNotNull(e, "e");
        ConcurrentMap<String, Object> concurrentMap = this.namesInstanciated.asMap();
        Intrinsics.checkExpressionValueIsNotNull(concurrentMap, "namesInstanciated.asMap()");
        Map $receiver$iv = concurrentMap;
        LinkedHashMap result$iv = new LinkedHashMap();
        Map map2 = $receiver$iv;
        for (Map.Entry entry$iv : map2.entrySet()) {
            Object it = entry$iv.getValue();
            if (!(it == e)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return (String)CollectionsKt.firstOrNull(((Map)result$iv).keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean exists(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            this.checkNotClosed();
            boolean bl = this.nameCatalogGet(name + Keys.INSTANCE.getType()) != null;
            return bl;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Iterable<String> getAllNames() {
        void var3_3;
        String it;
        Iterable $receiver$iv$iv;
        Set<String> set = this.nameCatalogLoad().keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, "nameCatalogLoad().keys");
        Iterable $receiver$iv = set;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String string = it = (String)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull(string, "it");
            if (!StringsKt.endsWith$default(string, Keys.INSTANCE.getType(), false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it;
            Intrinsics.checkExpressionValueIsNotNull(string, "it");
            String string2 = (String)StringsKt.split$default((CharSequence)string, new String[]{"#"}, false, 0, 6, null).get(0);
            collection.add(string2);
        }
        return (List)var3_3;
    }

    @NotNull
    public final Map<String, Object> getAll() {
        TreeMap ret2 = new TreeMap();
        Iterable<String> $receiver$iv = this.getAllNames();
        Iterator<String> iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            String element$iv;
            String it = element$iv = iterator2.next();
            ret2.put(it, this.get(it));
        }
        return ret2;
    }

    @NotNull
    public final HashMapMaker<?, ?> hashMap(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return new HashMapMaker(this, name, false, null, 12, null);
    }

    @NotNull
    public final <K, V> HashMapMaker<K, V> hashMap(@NotNull String name, @NotNull Serializer<K> keySerializer, @NotNull Serializer<V> valueSerializer) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(keySerializer, "keySerializer");
        Intrinsics.checkParameterIsNotNull(valueSerializer, "valueSerializer");
        return new HashMapMaker(this, name, false, null, 12, null).keySerializer(keySerializer).valueSerializer(valueSerializer);
    }

    @NotNull
    public final TreeMapMaker<?, ?> treeMap(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return new TreeMapMaker(this, name, false, 4, null);
    }

    @NotNull
    public final <K, V> TreeMapMaker<K, V> treeMap(@NotNull String name, @NotNull GroupSerializer<K> keySerializer, @NotNull GroupSerializer<V> valueSerializer) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(keySerializer, "keySerializer");
        Intrinsics.checkParameterIsNotNull(valueSerializer, "valueSerializer");
        return new TreeMapMaker(this, name, false, 4, null).keySerializer(keySerializer).valueSerializer(valueSerializer);
    }

    @NotNull
    public final TreeSetMaker<?> treeSet(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return new TreeSetMaker(this, name);
    }

    @NotNull
    public final <E> TreeSetMaker<E> treeSet(@NotNull String name, @NotNull GroupSerializer<E> serializer) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        return new TreeSetMaker(this, name).serializer(serializer);
    }

    @NotNull
    public final HashSetMaker<?> hashSet(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return new HashSetMaker(this, name, null, 4, null);
    }

    @NotNull
    public final <E> HashSetMaker<E> hashSet(@NotNull String name, @NotNull Serializer<E> serializer) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        return new HashSetMaker(this, name, null, 4, null).serializer(serializer);
    }

    @NotNull
    public final AtomicIntegerMaker atomicInteger(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return new AtomicIntegerMaker(this, name, 0, 4, null);
    }

    @NotNull
    public final AtomicIntegerMaker atomicInteger(@NotNull String name, int value) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return new AtomicIntegerMaker(this, name, value);
    }

    @NotNull
    public final AtomicLongMaker atomicLong(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return new AtomicLongMaker(this, name, 0L, 4, null);
    }

    @NotNull
    public final AtomicLongMaker atomicLong(@NotNull String name, long value) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return new AtomicLongMaker(this, name, value);
    }

    @NotNull
    public final AtomicBooleanMaker atomicBoolean(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return new AtomicBooleanMaker(this, name, false, 4, null);
    }

    @NotNull
    public final AtomicBooleanMaker atomicBoolean(@NotNull String name, boolean value) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return new AtomicBooleanMaker(this, name, value);
    }

    @NotNull
    public final AtomicStringMaker atomicString(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return new AtomicStringMaker(this, name, null, 4, null);
    }

    @NotNull
    public final AtomicStringMaker atomicString(@NotNull String name, @Nullable String value) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return new AtomicStringMaker(this, name, value);
    }

    @NotNull
    public final AtomicVarMaker<Object> atomicVar(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return this.atomicVar(name, (Serializer)this.defaultSerializer);
    }

    @NotNull
    public final <E> AtomicVarMaker<E> atomicVar(@NotNull String name, @NotNull Serializer<E> serializer) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        return new AtomicVarMaker(this, name, serializer, null, 8, null);
    }

    @NotNull
    public final <E> AtomicVarMaker<E> atomicVar(@NotNull String name, @NotNull Serializer<E> serializer, @Nullable E value) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        return new AtomicVarMaker<E>(this, name, serializer, value);
    }

    private final IndexTreeLongLongMapMaker indexTreeLongLongMap(String name) {
        return new IndexTreeLongLongMapMaker(this, name);
    }

    @NotNull
    public final <E> IndexTreeListMaker<E> indexTreeList(@NotNull String name, @NotNull Serializer<E> serializer) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        return new IndexTreeListMaker<E>(this, name, serializer);
    }

    @NotNull
    public final IndexTreeListMaker<Object> indexTreeList(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return this.indexTreeList(name, (Serializer)this.defaultSerializer);
    }

    @Override
    public void checkThreadSafe() {
        ConcurrencyAware.DefaultImpls.checkThreadSafe(this);
        if (!this.store.isThreadSafe()) {
            throw (Throwable)((Object)new AssertionError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void defaultSerializerRegisterClass(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            this.checkNotClosed();
            this.defaultSerializerRegisterClass_noLock(clazz);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    private final void defaultSerializerRegisterClass_noLock(Class<?> clazz) {
        ElsaSerializerPojo.ClassInfo classInfo;
        String className;
        ElsaSerializerPojo.ClassInfo[] infos;
        block2: {
            ElsaSerializerPojo.ClassInfo[] classInfoArray;
            Utils.INSTANCE.assertWriteLock(this.lock);
            infos = this.loadClassInfos();
            className = clazz.getName();
            ElsaSerializerPojo.ClassInfo[] classInfoArray2 = classInfoArray = infos;
            int n = classInfoArray2.length;
            for (int i = 0; i < n; ++i) {
                ElsaSerializerPojo.ClassInfo classInfo2;
                ElsaSerializerPojo.ClassInfo it = classInfo2 = classInfoArray2[i];
                if (!Intrinsics.areEqual(it.name, className)) continue;
                classInfo = classInfo2;
                break block2;
            }
            classInfo = null;
        }
        if (classInfo != null) {
            return;
        }
        ElsaSerializerPojo.ClassInfo[] classInfoArray = Arrays.copyOf(infos, infos.length + 1);
        Intrinsics.checkExpressionValueIsNotNull(classInfoArray, "Arrays.copyOf(infos, infos.size + 1)");
        infos = classInfoArray;
        int n = infos.length - 1;
        ElsaSerializerPojo.ClassInfo classInfo3 = this.elsaSerializer.makeClassInfo(className);
        Intrinsics.checkExpressionValueIsNotNull(classInfo3, "elsaSerializer.makeClassInfo(className)");
        infos[n] = classInfo3;
        this.store.update(2L, infos, this.classInfoSerializer);
    }

    private final Map<String, Map<String, CatVal>> nameCatalogVerifyTree() {
        Function1 all2 = nameCatalogVerifyTree.all.1.INSTANCE;
        Function1 recid2 = nameCatalogVerifyTree.recid.1.INSTANCE;
        Function1 recidOptional2 = nameCatalogVerifyTree.recidOptional.1.INSTANCE;
        Function1 function1 = nameCatalogVerifyTree.long.1.INSTANCE;
        Function1 function12 = nameCatalogVerifyTree.int.1.INSTANCE;
        Function1 recidArray = all2;
        Function1 serializer = all2;
        Function1 function13 = nameCatalogVerifyTree.boolean.1.INSTANCE;
        return MapsKt.mapOf(new Pair("HashMap", MapsKt.mapOf(new Pair<String, CatVal>(Keys.INSTANCE.getKeySerializer(), new CatVal(serializer, false)), new Pair<String, CatVal>(Keys.INSTANCE.getValueSerializer(), new CatVal(serializer, false)), new Pair<String, CatVal>(Keys.INSTANCE.getRootRecids(), new CatVal(recidArray, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getValueInline(), new CatVal(function13, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getHashSeed(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getConcShift(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getLevels(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getDirShift(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getRemoveCollapsesIndexTree(), new CatVal(function13, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getCounterRecids(), new CatVal(recidArray, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireCreateQueue(), new CatVal(all2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireUpdateQueue(), new CatVal(all2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireGetQueue(), new CatVal(all2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireCreateTTL(), new CatVal(function1, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireUpdateTTL(), new CatVal(function1, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireGetTTL(), new CatVal(function1, false, 2, null)))), new Pair("HashSet", MapsKt.mapOf(new Pair<String, CatVal>(Keys.INSTANCE.getSerializer(), new CatVal(serializer, false)), new Pair<String, CatVal>(Keys.INSTANCE.getRootRecids(), new CatVal(recidArray, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getHashSeed(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getConcShift(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getDirShift(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getLevels(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getRemoveCollapsesIndexTree(), new CatVal(function13, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getCounterRecids(), new CatVal(recidArray, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireCreateQueue(), new CatVal(all2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireGetQueue(), new CatVal(all2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireCreateTTL(), new CatVal(function1, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getExpireGetTTL(), new CatVal(function1, false, 2, null)))), new Pair("TreeMap", MapsKt.mapOf(new Pair<String, CatVal>(Keys.INSTANCE.getKeySerializer(), new CatVal(serializer, false)), new Pair<String, CatVal>(Keys.INSTANCE.getValueSerializer(), new CatVal(serializer, false)), new Pair<String, CatVal>(Keys.INSTANCE.getRootRecidRecid(), new CatVal(recid2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getCounterRecid(), new CatVal(recidOptional2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getMaxNodeSize(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getValueInline(), new CatVal(function13, false, 2, null)))), new Pair("TreeSet", MapsKt.mapOf(new Pair<String, CatVal>(Keys.INSTANCE.getSerializer(), new CatVal(serializer, false)), new Pair<String, CatVal>(Keys.INSTANCE.getRootRecidRecid(), new CatVal(recid2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getCounterRecid(), new CatVal(recidOptional2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getMaxNodeSize(), new CatVal(function12, false, 2, null)))), new Pair<String, Map<String, CatVal>>("AtomicBoolean", MapsKt.mapOf(new Pair<String, CatVal>(Keys.INSTANCE.getRecid(), new CatVal(recid2, false, 2, null)))), new Pair<String, Map<String, CatVal>>("AtomicInteger", MapsKt.mapOf(new Pair<String, CatVal>(Keys.INSTANCE.getRecid(), new CatVal(recid2, false, 2, null)))), new Pair("AtomicVar", MapsKt.mapOf(new Pair<String, CatVal>(Keys.INSTANCE.getRecid(), new CatVal(recid2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getSerializer(), new CatVal(serializer, false)))), new Pair<String, Map<String, CatVal>>("AtomicString", MapsKt.mapOf(new Pair<String, CatVal>(Keys.INSTANCE.getRecid(), new CatVal(recid2, false, 2, null)))), new Pair<String, Map<String, CatVal>>("AtomicLong", MapsKt.mapOf(new Pair<String, CatVal>(Keys.INSTANCE.getRecid(), new CatVal(recid2, false, 2, null)))), new Pair("IndexTreeList", MapsKt.mapOf(new Pair<String, CatVal>(Keys.INSTANCE.getSerializer(), new CatVal(serializer, false)), new Pair<String, CatVal>(Keys.INSTANCE.getDirShift(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getLevels(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getRemoveCollapsesIndexTree(), new CatVal(function13, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getCounterRecid(), new CatVal(recid2, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getRootRecid(), new CatVal(recid2, false, 2, null)))), new Pair("IndexTreeLongLongMap", MapsKt.mapOf(new Pair<String, CatVal>(Keys.INSTANCE.getDirShift(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getLevels(), new CatVal(function12, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getRemoveCollapsesIndexTree(), new CatVal(function13, false, 2, null)), new Pair<String, CatVal>(Keys.INSTANCE.getRootRecid(), new CatVal(recid2, false, 2, null)))));
    }

    @NotNull
    public final Iterable<String> nameCatalogVerifyGetMessages() {
        Object object;
        Object object2;
        String it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        ArrayList ret2 = new ArrayList();
        Map<String, Map<String, CatVal>> ver = this.nameCatalogVerifyTree();
        SortedMap<String, String> catalog = this.nameCatalogLoad();
        Set<String> set = catalog.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, "catalog.keys");
        Iterable iterable = $receiver$iv = (Iterable)set;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String string = it = (String)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull(string, "it");
            if (!StringsKt.endsWith$default(string, Keys.INSTANCE.getType(), false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string;
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull(it, "it");
            int $i$f$filterTo = 0;
            int $i$f$filter = StringsKt.lastIndexOf$default((CharSequence)it, '#', 0, false, 6, null);
            String string2 = object2;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull(string2.substring($i$f$filterTo, $i$f$filter), "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            collection.add(string);
        }
        Set<String> names = CollectionsKt.toSet((List)destination$iv$iv);
        HashSet known = new HashSet();
        for (String name : names) {
            Object item$iv$iv;
            object = known;
            item$iv$iv = name + Keys.INSTANCE.getType();
            object.add(item$iv$iv);
            String type = (String)catalog.get(name + Keys.INSTANCE.getType());
            Object object3 = ver;
            Map<String, CatVal> reqParams = object3.get(type);
            if (reqParams == null) {
                object3 = ret2;
                object2 = name + Keys.INSTANCE.getType() + ": unknown type '" + type + '\'';
                object3.add(object2);
                continue;
            }
            Map<String, CatVal> $i$f$filterTo = reqParams;
            object2 = $i$f$filterTo.entrySet().iterator();
            while (object2.hasNext()) {
                Object object4;
                Object $i$a$2$map = object3 = (Map.Entry)object2.next();
                String param = (String)$i$a$2$map.getKey();
                $i$a$2$map = object3;
                CatVal catVal = (CatVal)$i$a$2$map.getValue();
                $i$a$2$map = known;
                Object $i$f$mapTo = name + param;
                $i$a$2$map.add($i$f$mapTo);
                String value = (String)catalog.get(name + param);
                if (value == null) {
                    if (!catVal.getRequired()) continue;
                    $i$f$mapTo = ret2;
                    object4 = name + param + ": required parameter not found";
                    $i$f$mapTo.add(object4);
                    continue;
                }
                String msg = catVal.getMsg().invoke(value);
                if (msg == null) continue;
                object4 = ret2;
                String string = name + param + ": " + msg;
                object4.add(string);
            }
        }
        for (String param : catalog.keySet()) {
            if (known.contains(param)) continue;
            object = ret2;
            String string = param + ": unknown parameter";
            object.add(string);
        }
        return ret2;
    }

    protected final boolean getStoreOpened() {
        return this.storeOpened;
    }

    @Override
    public boolean isThreadSafe() {
        return this.isThreadSafe;
    }

    @NotNull
    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public final int getShutdownHook() {
        return this.shutdownHook;
    }

    /*
     * WARNING - void declaration
     */
    public DB(@NotNull Store store, boolean storeOpened, boolean isThreadSafe, @NotNull ClassLoader classLoader, int shutdownHook) {
        Object object;
        List<String> msgs;
        Object object2;
        Class<? extends Object> it;
        Object object3;
        Class<? extends Object>[] $receiver$iv$iv;
        Class<? extends Object>[] $receiver$iv;
        ElsaSerializerPojo elsaSerializerPojo;
        Intrinsics.checkParameterIsNotNull(store, "store");
        Intrinsics.checkParameterIsNotNull(classLoader, "classLoader");
        this.store = store;
        this.storeOpened = storeOpened;
        this.isThreadSafe = isThreadSafe;
        this.classLoader = classLoader;
        this.shutdownHook = shutdownHook;
        this.lock = this.isThreadSafe() ? new ReentrantReadWriteLock() : null;
        this.closed = new AtomicBoolean(false);
        Cache cache = CacheBuilder.newBuilder().concurrencyLevel(1).weakValues().build();
        Intrinsics.checkExpressionValueIsNotNull(cache, "CacheBuilder.newBuilder(\u2026l(1).weakValues().build()");
        this.namesInstanciated = cache;
        this.classSingletonCat = new IdentityHashMap();
        this.classSingletonRev = new HashMap();
        this.unknownClasses = Collections.synchronizedSet(new HashSet());
        this.nameSer = new ElsaSerializerBase.Ser<Object>(this){
            final /* synthetic */ DB this$0;

            public void serialize(@NotNull DataOutput out, @NotNull Object value, @Nullable ElsaStack objectStack) {
                Intrinsics.checkParameterIsNotNull(out, "out");
                Intrinsics.checkParameterIsNotNull(value, "value");
                String string = this.this$0.getNameForObject(value);
                if (string == null) {
                    throw (Throwable)new DBException.SerializationError("Could not serialize named object, it was not instantiated by this db");
                }
                String name = string;
                out.writeUTF(name);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.nameDeser = new ElsaSerializerBase.Deser<Object>(this){
            final /* synthetic */ DB this$0;

            @Nullable
            public Object deserialize(@NotNull DataInput input, @NotNull ElsaStack objectStack) {
                String name;
                Intrinsics.checkParameterIsNotNull(input, "input");
                Intrinsics.checkParameterIsNotNull(objectStack, "objectStack");
                String string = name = input.readUTF();
                Intrinsics.checkExpressionValueIsNotNull(string, "name");
                return this.this$0.get(string);
            }
            {
                this.this$0 = $outer;
            }
        };
        Class<? extends Object>[] classArray = this.namedClasses();
        Object[] objectArray = this.pojoSingletons();
        int n = 0;
        ElsaSerializerPojo elsaSerializerPojo2 = elsaSerializerPojo;
        Serializable serializable = elsaSerializerPojo;
        DB dB = this;
        void var7_14 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        for (Class<? extends Object> item$iv$iv : $receiver$iv$iv) {
            void var12_25 = item$iv$iv;
            object3 = destination$iv$iv;
            object2 = new Pair<void, nameSer.1>((void)it, this.nameSer);
            object3.add(object2);
        }
        object3 = (List)destination$iv$iv;
        $receiver$iv = this.namedClasses();
        object3 = MapsKt.toMap((Iterable)object3);
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList($receiver$iv.length);
        int n2 = $receiver$iv$iv.length;
        for (int i = 0; i < n2; ++i) {
            Class<? extends Object> item$iv$iv;
            it = item$iv$iv = $receiver$iv$iv[i];
            object2 = destination$iv$iv;
            Pair<Class<? extends Object>, Integer> pair = new Pair<Class<? extends Object>, Integer>(it, NAMED_SERIALIZATION_HEADER);
            object2.add(pair);
        }
        object2 = (List)destination$iv$iv;
        elsaSerializerPojo2(n, objectArray, (Map<Class, ElsaSerializerBase.Ser>)object3, MapsKt.toMap((Iterable)object2), MapsKt.mapOf(new Pair<Integer, nameDeser.1>(NAMED_SERIALIZATION_HEADER, this.nameDeser)), new ElsaClassCallback(this){
            final /* synthetic */ DB this$0;

            public final void classMissing(Class<Object> it) {
                DB.access$getUnknownClasses$p(this.this$0).add(it);
            }
            {
                this.this$0 = dB;
            }
        }, new ElsaClassInfoResolver(this){
            final /* synthetic */ DB this$0;

            /*
             * WARNING - void declaration
             */
            public int classToId(@NotNull String className) {
                ElsaSerializerPojo.ClassInfo[] classInfos;
                Intrinsics.checkParameterIsNotNull(className, "className");
                ElsaSerializerPojo.ClassInfo[] $receiver$iv = classInfos = DB.access$loadClassInfos(this.this$0);
                int index$iv = 0;
                for (ElsaSerializerPojo.ClassInfo item$iv : $receiver$iv) {
                    void classInfo;
                    int n = index$iv++;
                    ElsaSerializerPojo.ClassInfo classInfo2 = item$iv;
                    int i = n;
                    if (!Intrinsics.areEqual(classInfo.name, className)) continue;
                    return i;
                }
                return -1;
            }

            @Nullable
            public ElsaSerializerPojo.ClassInfo getClassInfo(int classId) {
                return DB.access$loadClassInfos(this.this$0)[classId];
            }
            {
                this.this$0 = $outer;
            }
        });
        dB.elsaSerializer = serializable;
        this.defaultSerializer = new GroupSerializerObjectArray<Object>(this){
            final /* synthetic */ DB this$0;

            @Nullable
            public Object deserialize(@NotNull DataInput2 input, int available) {
                Intrinsics.checkParameterIsNotNull(input, "input");
                return DB.access$getElsaSerializer$p(this.this$0).deserialize(input);
            }

            public void serialize(@NotNull DataOutput2 out, @NotNull Object value) {
                Intrinsics.checkParameterIsNotNull(out, "out");
                Intrinsics.checkParameterIsNotNull(value, "value");
                DB.access$getElsaSerializer$p(this.this$0).serialize(out, value);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.classInfoSerializer = new Serializer<ElsaSerializerPojo.ClassInfo[]>(this){
            final /* synthetic */ DB this$0;

            public void serialize(@NotNull DataOutput2 out, @NotNull ElsaSerializerPojo.ClassInfo[] ci) {
                Intrinsics.checkParameterIsNotNull(out, "out");
                Intrinsics.checkParameterIsNotNull(ci, "ci");
                out.packInt(ci.length);
                for (ElsaSerializerPojo.ClassInfo c : ci) {
                    DB.access$getElsaSerializer$p(this.this$0).classInfoSerialize(out, c);
                }
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public ElsaSerializerPojo.ClassInfo[] deserialize(@NotNull DataInput2 input, int available) {
                Intrinsics.checkParameterIsNotNull(input, "input");
                int size$iv = input.unpackInt();
                ElsaSerializerPojo.ClassInfo[] result$iv = new ElsaSerializerPojo.ClassInfo[size$iv];
                int n = 0;
                int n2 = result$iv.length;
                while (n < n2) {
                    ElsaSerializerPojo.ClassInfo classInfo;
                    void i$iv;
                    void var7_7 = i$iv;
                    void var11_9 = i$iv++;
                    ElsaSerializerPojo.ClassInfo[] classInfoArray = result$iv;
                    classInfoArray[var11_9] = classInfo = DB.access$getElsaSerializer$p(this.this$0).classInfoDeserialize(input);
                }
                return result$iv;
            }
            {
                this.this$0 = $outer;
            }
        };
        if (!this.storeOpened) {
            if (this.store.isReadOnly()) {
                throw (Throwable)new DBException.WrongConfiguration("Can not create new store in read-only mode");
            }
            long nameCatalogRecid = this.store.put(new TreeMap(), NAME_CATALOG_SERIALIZER);
            if (1L != nameCatalogRecid) {
                throw (Throwable)new DBException.WrongConfiguration("Store does not support Reserved Recids: " + this.store.getClass());
            }
            long classCatalogRecid = this.store.put(new ElsaSerializerPojo.ClassInfo[0], this.classInfoSerializer);
            if (2L != classCatalogRecid) {
                throw (Throwable)new DBException.WrongConfiguration("Store does not support Reserved Recids: " + this.store.getClass());
            }
            long l = 3L;
            long it2 = 8L;
            while (l <= it2) {
                void recid2;
                GroupSerializer<Long> groupSerializer = Serializer.LONG_PACKED;
                Intrinsics.checkExpressionValueIsNotNull(groupSerializer, "Serializer.LONG_PACKED");
                long recid22 = this.store.put(null, (Serializer)groupSerializer);
                if (recid2 != recid22) {
                    throw (Throwable)new DBException.WrongConfiguration("Store does not support Reserved Recids: " + this.store.getClass());
                }
                ++recid2;
            }
            this.store.commit();
        }
        if (!(msgs = CollectionsKt.toList(this.nameCatalogVerifyGetMessages())).isEmpty()) {
            throw (Throwable)new DBException.NewMapDBFormat("Name Catalog has some new unsupported features: " + msgs.toString());
        }
        Field[] fieldArray = Serializer.class.getDeclaredFields();
        Intrinsics.checkExpressionValueIsNotNull(fieldArray, "Serializer::class.java.declaredFields");
        Field[] $receiver$iv2 = fieldArray;
        int n3 = $receiver$iv2.length;
        for (int i = 0; i < n3; ++i) {
            Field element$iv;
            Field f = element$iv = $receiver$iv2[i];
            StringBuilder stringBuilder = new StringBuilder().append(Serializer.class.getCanonicalName()).append("#");
            Field field = f;
            Intrinsics.checkExpressionValueIsNotNull(field, "f");
            String name = stringBuilder.append(field.getName()).toString();
            Object obj = f.get(null);
            this.classSingletonCat.put(obj, name);
            this.classSingletonRev.put(name, obj);
        }
        String defSerName = "org.mapdb.DB#defaultSerializer";
        this.classSingletonCat.put(this.defaultSerializer, defSerName);
        this.classSingletonRev.put(defSerName, this.defaultSerializer);
        switch (this.shutdownHook) {
            case 0: {
                object = null;
                break;
            }
            case 1: {
                object = this;
                break;
            }
            case 2: {
                object = new WeakReference<DB>(this);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException();
            }
        }
        this.shutdownReference = object;
        if (this.shutdownReference != null) {
            Companion.addShutdownHook(this.shutdownReference);
        }
        Set set = Collections.synchronizedSet(new LinkedHashSet());
        Intrinsics.checkExpressionValueIsNotNull(set, "Collections.synchronizedSet(LinkedHashSet())");
        this.executors = set;
        String string = "[A-Z0-9._-]";
        dB = this;
        serializable = new Regex(string);
        dB.nameRegex = serializable;
    }

    public /* synthetic */ DB(Store store, boolean bl, boolean bl2, ClassLoader classLoader, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl2 = true;
        }
        if ((n2 & 8) != 0) {
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull(thread2, "Thread.currentThread()");
            ClassLoader classLoader2 = thread2.getContextClassLoader();
            Intrinsics.checkExpressionValueIsNotNull(classLoader2, "Thread.currentThread().contextClassLoader");
            classLoader = classLoader2;
        }
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        this(store, bl, bl2, classLoader, n);
    }

    static {
        Companion = new Companion(null);
        NAME_CATALOG_SERIALIZER = new Serializer<SortedMap<String, String>>(){

            /*
             * WARNING - void declaration
             */
            @Nullable
            public SortedMap<String, String> deserialize(@NotNull DataInput2 input, int available) {
                Intrinsics.checkParameterIsNotNull(input, "input");
                int size2 = input.unpackInt();
                TreeMap<String, String> ret2 = new TreeMap<String, String>();
                int n = 0;
                int n2 = size2;
                while (n < n2) {
                    void i;
                    ret2.put(input.readUTF(), input.readUTF());
                    ++i;
                }
                return ret2;
            }

            public void serialize(@NotNull DataOutput2 out, @NotNull SortedMap<String, String> value) {
                Map $receiver$iv;
                Intrinsics.checkParameterIsNotNull(out, "out");
                Intrinsics.checkParameterIsNotNull(value, "value");
                out.packInt(value.size());
                Map map2 = $receiver$iv = (Map)value;
                Iterator<Map.Entry<K, V>> iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> e = element$iv = iterator2.next();
                    out.writeUTF((String)e.getKey());
                    out.writeUTF((String)e.getValue());
                }
            }
        };
        NAMED_SERIALIZATION_HEADER = 1;
        shutdownHooks = Collections.synchronizedMap(new IdentityHashMap());
        shutdownHookInstalled = new AtomicBoolean(false);
    }

    public static final /* synthetic */ Set access$getUnknownClasses$p(DB $this) {
        return $this.unknownClasses;
    }

    @NotNull
    public static final /* synthetic */ ElsaSerializerPojo.ClassInfo[] access$loadClassInfos(DB $this) {
        return $this.loadClassInfos();
    }

    @NotNull
    public static final /* synthetic */ ElsaSerializerPojo access$getElsaSerializer$p(DB $this) {
        return $this.elsaSerializer;
    }

    public static final /* synthetic */ void access$setShutdownHookInstalled$cp(@NotNull AtomicBoolean atomicBoolean) {
        shutdownHookInstalled = atomicBoolean;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b3\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0014\u0010\u001b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0014\u0010\u001d\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0014\u0010\u001f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0014\u0010!\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0014\u0010#\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u0014\u0010%\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u0014\u0010'\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0006R\u0014\u0010)\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0006R\u0014\u0010+\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0006R\u0014\u0010-\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0006R\u0014\u0010/\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0006R\u0014\u00101\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0006R\u0014\u00103\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0006R\u0014\u00105\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0006\u00a8\u00067"}, d2={"Lorg/mapdb/DB$Keys;", "", "()V", "concShift", "", "getConcShift", "()Ljava/lang/String;", "counterRecid", "getCounterRecid", "counterRecids", "getCounterRecids", "dirShift", "getDirShift", "expireCreateQueue", "getExpireCreateQueue", "expireCreateTTL", "getExpireCreateTTL", "expireGetQueue", "getExpireGetQueue", "expireGetTTL", "getExpireGetTTL", "expireUpdateQueue", "getExpireUpdateQueue", "expireUpdateTTL", "getExpireUpdateTTL", "hashSeed", "getHashSeed", "keySerializer", "getKeySerializer", "levels", "getLevels", "maxNodeSize", "getMaxNodeSize", "recid", "getRecid", "removeCollapsesIndexTree", "getRemoveCollapsesIndexTree", "rootRecid", "getRootRecid", "rootRecidRecid", "getRootRecidRecid", "rootRecids", "getRootRecids", "segmentRecids", "getSegmentRecids", "serializer", "getSerializer", "size", "getSize", "type", "getType", "valueInline", "getValueInline", "valueSerializer", "getValueSerializer", "mapdb"})
    public static final class Keys {
        @NotNull
        private static final String type = "#type";
        @NotNull
        private static final String keySerializer = "#keySerializer";
        @NotNull
        private static final String valueSerializer = "#valueSerializer";
        @NotNull
        private static final String serializer = "#serializer";
        @NotNull
        private static final String valueInline = "#valueInline";
        @NotNull
        private static final String counterRecids = "#counterRecids";
        @NotNull
        private static final String hashSeed = "#hashSeed";
        @NotNull
        private static final String segmentRecids = "#segmentRecids";
        @NotNull
        private static final String expireCreateTTL = "#expireCreateTTL";
        @NotNull
        private static final String expireUpdateTTL = "#expireUpdateTTL";
        @NotNull
        private static final String expireGetTTL = "#expireGetTTL";
        @NotNull
        private static final String expireCreateQueue = "#expireCreateQueue";
        @NotNull
        private static final String expireUpdateQueue = "#expireUpdateQueue";
        @NotNull
        private static final String expireGetQueue = "#expireGetQueue";
        @NotNull
        private static final String rootRecids = "#rootRecids";
        @NotNull
        private static final String rootRecid = "#rootRecid";
        @NotNull
        private static final String concShift = "#concShift";
        @NotNull
        private static final String dirShift = "#dirShift";
        @NotNull
        private static final String levels = "#levels";
        @NotNull
        private static final String removeCollapsesIndexTree = "#removeCollapsesIndexTree";
        @NotNull
        private static final String rootRecidRecid = "#rootRecidRecid";
        @NotNull
        private static final String counterRecid = "#counterRecid";
        @NotNull
        private static final String maxNodeSize = "#maxNodeSize";
        @NotNull
        private static final String size = "#size";
        @NotNull
        private static final String recid = "#recid";
        public static final Keys INSTANCE;

        @NotNull
        public final String getType() {
            return type;
        }

        @NotNull
        public final String getKeySerializer() {
            return keySerializer;
        }

        @NotNull
        public final String getValueSerializer() {
            return valueSerializer;
        }

        @NotNull
        public final String getSerializer() {
            return serializer;
        }

        @NotNull
        public final String getValueInline() {
            return valueInline;
        }

        @NotNull
        public final String getCounterRecids() {
            return counterRecids;
        }

        @NotNull
        public final String getHashSeed() {
            return hashSeed;
        }

        @NotNull
        public final String getSegmentRecids() {
            return segmentRecids;
        }

        @NotNull
        public final String getExpireCreateTTL() {
            return expireCreateTTL;
        }

        @NotNull
        public final String getExpireUpdateTTL() {
            return expireUpdateTTL;
        }

        @NotNull
        public final String getExpireGetTTL() {
            return expireGetTTL;
        }

        @NotNull
        public final String getExpireCreateQueue() {
            return expireCreateQueue;
        }

        @NotNull
        public final String getExpireUpdateQueue() {
            return expireUpdateQueue;
        }

        @NotNull
        public final String getExpireGetQueue() {
            return expireGetQueue;
        }

        @NotNull
        public final String getRootRecids() {
            return rootRecids;
        }

        @NotNull
        public final String getRootRecid() {
            return rootRecid;
        }

        @NotNull
        public final String getConcShift() {
            return concShift;
        }

        @NotNull
        public final String getDirShift() {
            return dirShift;
        }

        @NotNull
        public final String getLevels() {
            return levels;
        }

        @NotNull
        public final String getRemoveCollapsesIndexTree() {
            return removeCollapsesIndexTree;
        }

        @NotNull
        public final String getRootRecidRecid() {
            return rootRecidRecid;
        }

        @NotNull
        public final String getCounterRecid() {
            return counterRecid;
        }

        @NotNull
        public final String getMaxNodeSize() {
            return maxNodeSize;
        }

        @NotNull
        public final String getSize() {
            return size;
        }

        @NotNull
        public final String getRecid() {
            return recid;
        }

        private Keys() {
        }

        static {
            Keys keys2;
            INSTANCE = keys2 = new Keys();
            type = type;
            keySerializer = keySerializer;
            valueSerializer = valueSerializer;
            serializer = serializer;
            valueInline = valueInline;
            counterRecids = counterRecids;
            hashSeed = hashSeed;
            segmentRecids = segmentRecids;
            expireCreateTTL = expireCreateTTL;
            expireUpdateTTL = expireUpdateTTL;
            expireGetTTL = expireGetTTL;
            expireCreateQueue = expireCreateQueue;
            expireUpdateQueue = expireUpdateQueue;
            expireGetQueue = expireGetQueue;
            rootRecids = rootRecids;
            rootRecid = rootRecid;
            concShift = concShift;
            dirShift = dirShift;
            levels = levels;
            removeCollapsesIndexTree = removeCollapsesIndexTree;
            rootRecidRecid = rootRecidRecid;
            counterRecid = counterRecid;
            maxNodeSize = maxNodeSize;
            size = size;
            recid = recid;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u0003BD\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012#\b\u0002\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u0007\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\f\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u0014\u0010;\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J(\u0010<\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0>H\u0014J\u0014\u0010?\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u001a\u0010@\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010A\u001a\u00020\u0019J\"\u0010@\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010A\u001a\u00020\u00192\u0006\u0010B\u001a\u00020CJ\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u001a\u0010D\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010A\u001a\u00020\u0019J\"\u0010D\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010A\u001a\u00020\u00192\u0006\u0010B\u001a\u00020CJ\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u001a\u0010E\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010A\u001a\u00020\u0019J\"\u0010E\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010A\u001a\u00020\u00192\u0006\u0010B\u001a\u00020CJ\u001a\u0010F\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010G\u001a\u00020\u0016J\u001c\u0010H\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\u0010I\u001a\u0004\u0018\u00010\u001bJ\u001a\u0010J\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010K\u001a\u00020\u0019J\u001a\u0010L\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010M\u001a\u00020\u0019J(\u0010N\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0014\u0010O\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00010 J\u001a\u0010P\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010Q\u001a\u00020\u0019J\u001a\u0010R\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010R\u001a\u00020\rJ&\u0010S\u001a\u000e\u0012\u0004\u0012\u0002HT\u0012\u0004\u0012\u00028\u00010\u0000\"\u0004\b\u0002\u0010T2\f\u0010S\u001a\b\u0012\u0004\u0012\u0002HT0&J*\u0010U\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010V\u001a\u00020\r2\u0006\u0010W\u001a\u00020\r2\u0006\u0010X\u001a\u00020\rJ&\u0010Y\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0012\u0010Z\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010*J\u0014\u0010[\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J(\u0010\\\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0>H\u0014J\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u0012\u0010^\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J5\u0010_\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002!\u0010_\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u000e\u0012\b\b\u0007\u0012\u0004\b\b(0\u0012\u0004\u0012\u00028\u00010\fJ&\u0010`\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002HT0\u0000\"\u0004\b\u0002\u0010T2\f\u0010`\u001a\b\u0012\u0004\u0012\u0002HT0&J\b\u0010a\u001a\u00020bH\u0014R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010$R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010*0)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R/\u0010\u000b\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u0007\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u000e\u0010.\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R-\u0010/\u001a!\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u000e\u0012\b\b\u0007\u0012\u0004\b\b(0\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00028\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u00020\bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00107\u00a8\u0006c"}, d2={"Lorg/mapdb/DB$HashMapMaker;", "K", "V", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/HTreeMap;", "db", "Lorg/mapdb/DB;", "name", "", "hasValues", "", "_storeFactory", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "segment", "Lorg/mapdb/Store;", "(Lorg/mapdb/DB;Ljava/lang/String;ZLkotlin/jvm/functions/Function1;)V", "_concShift", "_counterEnable", "_dirShift", "_expireCompactThreshold", "", "Ljava/lang/Double;", "_expireCreateTTL", "", "_expireExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "_expireExecutorPeriod", "_expireGetTTL", "_expireMaxSize", "_expireOverflow", "", "_expireStoreSize", "_expireUpdateTTL", "_hashSeed", "Ljava/lang/Integer;", "_keySerializer", "Lorg/mapdb/Serializer;", "_levels", "_modListeners", "", "Lorg/mapdb/MapModificationListener;", "_removeCollapsesIndexTree", "get_storeFactory", "()Lkotlin/jvm/functions/Function1;", "_valueInline", "_valueLoader", "key", "_valueSerializer", "getDb", "()Lorg/mapdb/DB;", "getHasValues", "()Z", "getName", "()Ljava/lang/String;", "type", "getType", "counterEnable", "create", "create2", "catalog", "Ljava/util/SortedMap;", "createOrOpen", "expireAfterCreate", "ttl", "unit", "Ljava/util/concurrent/TimeUnit;", "expireAfterGet", "expireAfterUpdate", "expireCompactThreshold", "freeFraction", "expireExecutor", "executor", "expireExecutorPeriod", "period", "expireMaxSize", "maxSize", "expireOverflow", "overflowMap", "expireStoreSize", "storeSize", "hashSeed", "keySerializer", "A", "layout", "concurrency", "dirSize", "levels", "modificationListener", "listener", "open", "open2", "removeCollapsesIndexTreeDisable", "valueInline", "valueLoader", "valueSerializer", "verify", "", "mapdb"})
    public static final class HashMapMaker<K, V>
    extends Maker<HTreeMap<K, V>> {
        @NotNull
        private final String type = "HashMap";
        private Serializer<K> _keySerializer;
        private Serializer<V> _valueSerializer;
        private boolean _valueInline;
        private int _concShift;
        private int _dirShift;
        private int _levels;
        private Integer _hashSeed;
        private long _expireCreateTTL;
        private long _expireUpdateTTL;
        private long _expireGetTTL;
        private ScheduledExecutorService _expireExecutor;
        private long _expireExecutorPeriod;
        private long _expireMaxSize;
        private long _expireStoreSize;
        private Double _expireCompactThreshold;
        private boolean _counterEnable;
        private Function1<? super K, ? extends V> _valueLoader;
        private List<MapModificationListener<K, V>> _modListeners;
        private Map<K, V> _expireOverflow;
        private boolean _removeCollapsesIndexTree;
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        private final boolean hasValues;
        @NotNull
        private final Function1<Integer, Store> _storeFactory;

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @NotNull
        public final <A> HashMapMaker<A, V> keySerializer(@NotNull Serializer<A> keySerializer) {
            Intrinsics.checkParameterIsNotNull(keySerializer, "keySerializer");
            this._keySerializer = keySerializer;
            HashMapMaker hashMapMaker = this;
            if (hashMapMaker == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.mapdb.DB.HashMapMaker<A, V>");
            }
            return hashMapMaker;
        }

        @NotNull
        public final <A> HashMapMaker<K, A> valueSerializer(@NotNull Serializer<A> valueSerializer) {
            Intrinsics.checkParameterIsNotNull(valueSerializer, "valueSerializer");
            this._valueSerializer = valueSerializer;
            HashMapMaker hashMapMaker = this;
            if (hashMapMaker == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.mapdb.DB.HashMapMaker<K, A>");
            }
            return hashMapMaker;
        }

        @NotNull
        public final HashMapMaker<K, V> valueInline() {
            this._valueInline = true;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> removeCollapsesIndexTreeDisable() {
            this._removeCollapsesIndexTree = false;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> hashSeed(int hashSeed) {
            this._hashSeed = hashSeed;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> layout(int concurrency, int dirSize, int levels) {
            layout.1 toShift$ = layout.1.INSTANCE;
            this._concShift = toShift$.invoke(concurrency);
            this._dirShift = toShift$.invoke(dirSize);
            this._levels = levels;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterCreate() {
            return this.expireAfterCreate(-1L);
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterCreate(long ttl) {
            this._expireCreateTTL = ttl;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterCreate(long ttl, @NotNull TimeUnit unit) {
            Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
            return this.expireAfterCreate(unit.toMillis(ttl));
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterUpdate() {
            return this.expireAfterUpdate(-1L);
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterUpdate(long ttl) {
            this._expireUpdateTTL = ttl;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterUpdate(long ttl, @NotNull TimeUnit unit) {
            Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
            return this.expireAfterUpdate(unit.toMillis(ttl));
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterGet() {
            return this.expireAfterGet(-1L);
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterGet(long ttl) {
            this._expireGetTTL = ttl;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> expireAfterGet(long ttl, @NotNull TimeUnit unit) {
            Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
            return this.expireAfterGet(unit.toMillis(ttl));
        }

        @NotNull
        public final HashMapMaker<K, V> expireExecutor(@Nullable ScheduledExecutorService executor) {
            this._expireExecutor = executor;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> expireExecutorPeriod(long period) {
            this._expireExecutorPeriod = period;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> expireCompactThreshold(double freeFraction) {
            this._expireCompactThreshold = freeFraction;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> expireMaxSize(long maxSize) {
            this._expireMaxSize = maxSize;
            return this.counterEnable();
        }

        @NotNull
        public final HashMapMaker<K, V> expireStoreSize(long storeSize) {
            this._expireStoreSize = storeSize;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> expireOverflow(@NotNull Map<K, V> overflowMap) {
            Intrinsics.checkParameterIsNotNull(overflowMap, "overflowMap");
            this._expireOverflow = overflowMap;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> valueLoader(@NotNull Function1<? super K, ? extends V> valueLoader) {
            Intrinsics.checkParameterIsNotNull(valueLoader, "valueLoader");
            this._valueLoader = valueLoader;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> counterEnable() {
            this._counterEnable = true;
            return this;
        }

        @NotNull
        public final HashMapMaker<K, V> modificationListener(@NotNull MapModificationListener<K, V> listener2) {
            block1: {
                Intrinsics.checkParameterIsNotNull(listener2, "listener");
                if (this._modListeners == null) {
                    this._modListeners = new ArrayList();
                }
                List<MapModificationListener<K, V>> list = this._modListeners;
                if (list == null) break block1;
                list.add(listener2);
            }
            return this;
        }

        @Override
        protected void verify() {
            if (this._expireOverflow != null && this._valueLoader != null) {
                throw (Throwable)new DBException.WrongConfiguration("ExpireOverflow and ValueLoader can not be used at the same time");
            }
            Map<K, V> expireOverflow = this._expireOverflow;
            if (expireOverflow != null) {
                this._valueLoader = new Function1<K, V>(expireOverflow){
                    final /* synthetic */ Map $expireOverflow;

                    @Nullable
                    public final V invoke(K key) {
                        return this.$expireOverflow.get(key);
                    }
                    {
                        this.$expireOverflow = map2;
                        super(1);
                    }
                };
                MapModificationListener listener2 = new MapModificationListener<K, V>(this, expireOverflow){
                    final /* synthetic */ HashMapMaker this$0;
                    final /* synthetic */ Map $expireOverflow;

                    public final void modify(K key, @Nullable V oldVal, @Nullable V newVal, boolean triggered) {
                        if (!triggered && newVal == null && oldVal != null) {
                            V oldVal2 = this.$expireOverflow.remove(key);
                            if (oldVal2 != null && HashMapMaker.access$get_valueSerializer$p(this.this$0).equals(oldVal, oldVal2)) {
                                Utils.INSTANCE.getLOG().warning(verify.listener.1.INSTANCE);
                            }
                        } else if (triggered && newVal == null) {
                            this.$expireOverflow.put(key, oldVal);
                        }
                    }
                    {
                        this.this$0 = hashMapMaker;
                        this.$expireOverflow = map2;
                    }
                };
                this._modListeners.add(listener2);
            }
            if (this._expireExecutor != null) {
                Set<ExecutorService> set = this.getDb().getExecutors();
                ScheduledExecutorService scheduledExecutorService = this._expireExecutor;
                if (scheduledExecutorService == null) {
                    Intrinsics.throwNpe();
                }
                set.add(scheduledExecutorService);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected HTreeMap<K, V> create2(@NotNull SortedMap<String, String> catalog) {
            MapModificationListener[] mapModificationListenerArray;
            HTreeMap<? super K, ? extends V> hTreeMap;
            int it;
            QueueLong[] queueLongArray;
            QueueLong[] expireUpdateQueues;
            int it22;
            QueueLong[] queueLongArray2;
            QueueLong[] expireCreateQueues;
            int it3;
            int n;
            QueueLong[] queueLongArray3;
            Object object;
            String i$iv3;
            Object cr;
            Object object2;
            void var24_23;
            Object result$iv;
            int i$iv2;
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            int segmentCount = 1 << this._concShift;
            Integer n2 = this._hashSeed;
            int hashSeed = n2 != null ? n2.intValue() : new SecureRandom().nextInt();
            Function1<Integer, Store> init$iv = this._storeFactory;
            Store[] result$iv2 = new Store[segmentCount];
            int n3 = 0;
            int n4 = result$iv2.length;
            while (n3 < n4) {
                result$iv2[i$iv2] = init$iv.invoke(i$iv2);
                ++i$iv2;
            }
            Store[] stores = result$iv2;
            long[] rootRecids = new long[segmentCount];
            String rootRecidsStr = "";
            i$iv2 = 0;
            n4 = segmentCount;
            while (i$iv2 < n4) {
                long rootRecid;
                void i;
                Store store = stores[i];
                long[] lArray = IndexTreeListJava.dirEmpty();
                Serializer<long[]> serializer = IndexTreeListJava.dirSer;
                Intrinsics.checkExpressionValueIsNotNull(serializer, "IndexTreeListJava.dirSer");
                rootRecids[i] = rootRecid = store.put(lArray, serializer);
                rootRecidsStr = rootRecidsStr + (i == false ? "" : ",") + rootRecid;
                ++i;
            }
            this.getDb().nameCatalogPutClass(catalog, this.getName() + (this.hasValues ? Keys.INSTANCE.getKeySerializer() : Keys.INSTANCE.getSerializer()), this._keySerializer);
            if (this.hasValues) {
                this.getDb().nameCatalogPutClass(catalog, this.getName() + Keys.INSTANCE.getValueSerializer(), this._valueSerializer);
            }
            if (this.hasValues) {
                Map i = catalog;
                String string = this.getName() + Keys.INSTANCE.getValueInline();
                String rootRecid = String.valueOf(this._valueInline);
                i.put(string, rootRecid);
            }
            Map i = catalog;
            String string = this.getName() + Keys.INSTANCE.getRootRecids();
            String rootRecid = rootRecidsStr;
            i.put(string, rootRecid);
            i = catalog;
            string = this.getName() + Keys.INSTANCE.getHashSeed();
            rootRecid = String.valueOf(hashSeed);
            i.put(string, rootRecid);
            i = catalog;
            string = this.getName() + Keys.INSTANCE.getConcShift();
            rootRecid = String.valueOf(this._concShift);
            i.put(string, rootRecid);
            i = catalog;
            string = this.getName() + Keys.INSTANCE.getDirShift();
            rootRecid = String.valueOf(this._dirShift);
            i.put(string, rootRecid);
            i = catalog;
            string = this.getName() + Keys.INSTANCE.getLevels();
            rootRecid = String.valueOf(this._levels);
            i.put(string, rootRecid);
            i = catalog;
            string = this.getName() + Keys.INSTANCE.getRemoveCollapsesIndexTree();
            rootRecid = String.valueOf(this._removeCollapsesIndexTree);
            i.put(string, rootRecid);
            if (this._counterEnable) {
                result$iv = new long[segmentCount];
                int n5 = 0;
                int n6 = ((long[])result$iv).length;
                while (n5 < n6) {
                    long l;
                    void segment;
                    void i$iv3;
                    void var12_20 = i$iv3;
                    var24_23 = i$iv3++;
                    object2 = result$iv;
                    Store store = stores[segment];
                    Long l2 = 0L;
                    GroupSerializer<Long> groupSerializer = Serializer.LONG_PACKED;
                    Intrinsics.checkExpressionValueIsNotNull(groupSerializer, "Serializer.LONG_PACKED");
                    object2[var24_23] = l = store.put(l2, (Serializer)groupSerializer);
                }
                cr = result$iv;
                result$iv = catalog;
                i$iv3 = this.getName() + Keys.INSTANCE.getCounterRecids();
                Object object3 = cr;
                String string2 = LongArrayList.newListWith(Arrays.copyOf((long[])object3, ((Object)object3).length)).makeString("", ",", "");
                result$iv.put(i$iv3, string2);
                object = cr;
            } else {
                cr = catalog;
                result$iv = this.getName() + Keys.INSTANCE.getCounterRecids();
                i$iv3 = "";
                cr.put(result$iv, i$iv3);
                object = null;
            }
            Object counterRecids = object;
            cr = catalog;
            result$iv = this.getName() + Keys.INSTANCE.getExpireCreateTTL();
            i$iv3 = String.valueOf(this._expireCreateTTL);
            cr.put(result$iv, i$iv3);
            if (this.hasValues) {
                cr = catalog;
                result$iv = this.getName() + Keys.INSTANCE.getExpireUpdateTTL();
                i$iv3 = String.valueOf(this._expireUpdateTTL);
                cr.put(result$iv, i$iv3);
            }
            cr = catalog;
            result$iv = this.getName() + Keys.INSTANCE.getExpireGetTTL();
            i$iv3 = String.valueOf(this._expireGetTTL);
            cr.put(result$iv, i$iv3);
            LongArrayList createQ = new LongArrayList();
            LongArrayList updateQ = new LongArrayList();
            LongArrayList getQ = new LongArrayList();
            Function2<Integer, LongArrayList, QueueLong> emptyLongQueue$ = new Function2<Integer, LongArrayList, QueueLong>(stores){
                final /* synthetic */ Store[] $stores;

                @NotNull
                public final QueueLong invoke(int segment, @NotNull LongArrayList qq) {
                    Intrinsics.checkParameterIsNotNull(qq, "qq");
                    Store store = this.$stores[segment];
                    long q = store.put(null, QueueLong.Node.SERIALIZER.INSTANCE);
                    Long l = q;
                    GroupSerializer<Long> groupSerializer = Serializer.RECID;
                    Intrinsics.checkExpressionValueIsNotNull(groupSerializer, "Serializer.RECID");
                    long tailRecid = store.put(l, (Serializer)groupSerializer);
                    Long l2 = q;
                    GroupSerializer<Long> groupSerializer2 = Serializer.RECID;
                    Intrinsics.checkExpressionValueIsNotNull(groupSerializer2, "Serializer.RECID");
                    long headRecid = store.put(l2, (Serializer)groupSerializer2);
                    Long l3 = 0L;
                    GroupSerializer<Long> groupSerializer3 = Serializer.RECID;
                    Intrinsics.checkExpressionValueIsNotNull(groupSerializer3, "Serializer.RECID");
                    long headPrevRecid = store.put(l3, (Serializer)groupSerializer3);
                    qq.add(tailRecid);
                    qq.add(headRecid);
                    qq.add(headPrevRecid);
                    return new QueueLong(store, tailRecid, headRecid, headPrevRecid);
                }
                {
                    this.$stores = storeArray;
                    super(2);
                }
            };
            if (this._expireCreateTTL == 0L) {
                queueLongArray3 = null;
            } else {
                QueueLong[] result$iv3 = new QueueLong[segmentCount];
                int $i$f$LongArray = 0;
                n = result$iv3.length;
                while ($i$f$LongArray < n) {
                    void i$iv4;
                    void var16_38 = i$iv4;
                    var24_23 = i$iv4++;
                    object2 = result$iv3;
                    QueueLong queueLong = emptyLongQueue$.invoke(it3, createQ);
                    object2[var24_23] = (long)queueLong;
                }
                queueLongArray3 = expireCreateQueues = result$iv3;
            }
            if (this._expireUpdateTTL == 0L) {
                queueLongArray2 = null;
            } else {
                QueueLong[] result$iv4 = new QueueLong[segmentCount];
                n = 0;
                it3 = result$iv4.length;
                while (n < it3) {
                    void i$iv5;
                    void $i$a$1$<init> = i$iv5;
                    var24_23 = i$iv5++;
                    object2 = result$iv4;
                    QueueLong queueLong = emptyLongQueue$.invoke(it22, updateQ);
                    object2[var24_23] = (long)queueLong;
                }
                queueLongArray2 = expireUpdateQueues = result$iv4;
            }
            if (this._expireGetTTL == 0L) {
                queueLongArray = null;
            } else {
                QueueLong[] result$iv5 = new QueueLong[segmentCount];
                it3 = 0;
                it22 = result$iv5.length;
                while (it3 < it22) {
                    void i$iv6;
                    void $i$a$1$<init> = i$iv6;
                    var24_23 = i$iv6++;
                    object2 = result$iv5;
                    QueueLong queueLong = emptyLongQueue$.invoke(it, getQ);
                    object2[var24_23] = (long)queueLong;
                }
                queueLongArray = result$iv5;
            }
            QueueLong[] expireGetQueues = queueLongArray;
            Map result$iv5 = catalog;
            String i$iv6 = this.getName() + Keys.INSTANCE.getExpireCreateQueue();
            String it22 = createQ.makeString("", ",", "");
            result$iv5.put(i$iv6, it22);
            if (this.hasValues) {
                result$iv5 = catalog;
                i$iv6 = this.getName() + Keys.INSTANCE.getExpireUpdateQueue();
                it22 = updateQ.makeString("", ",", "");
                result$iv5.put(i$iv6, it22);
            }
            result$iv5 = catalog;
            i$iv6 = this.getName() + Keys.INSTANCE.getExpireGetQueue();
            it22 = getQ.makeString("", ",", "");
            result$iv5.put(i$iv6, it22);
            int size$iv2 = 1 << this._concShift;
            MutableLongLongMap[] result$iv6 = new MutableLongLongMap[size$iv2];
            it = 0;
            int n7 = result$iv6.length;
            while (it < n7) {
                void segment;
                void i$iv7;
                void $i$f$Array = i$iv7;
                var24_23 = i$iv7++;
                object2 = result$iv6;
                IndexTreeLongLongMap indexTreeLongLongMap = new IndexTreeLongLongMap(stores[segment], rootRecids[segment], this._dirShift, this._levels, this._removeCollapsesIndexTree);
                object2[var24_23] = (long)indexTreeLongLongMap;
            }
            MutableLongLongMap[] indexTrees = result$iv6;
            HTreeMap<? super K, ? extends V> hTreeMap2 = hTreeMap;
            Object object4 = hTreeMap;
            Serializer<K> serializer = this._keySerializer;
            Serializer<V> serializer2 = this._valueSerializer;
            boolean bl = this._valueInline;
            int n8 = this._concShift;
            int n9 = this._dirShift;
            int n10 = this._levels;
            Store[] storeArray = stores;
            MutableLongLongMap[] mutableLongLongMapArray = indexTrees;
            int n11 = hashSeed;
            Object object5 = counterRecids;
            long l = this._expireCreateTTL;
            long l3 = this._expireUpdateTTL;
            long l4 = this._expireGetTTL;
            long l5 = this._expireMaxSize;
            long l6 = this._expireStoreSize;
            QueueLong[] queueLongArray4 = expireCreateQueues;
            QueueLong[] queueLongArray5 = expireUpdateQueues;
            QueueLong[] queueLongArray6 = expireGetQueues;
            ScheduledExecutorService scheduledExecutorService = this._expireExecutor;
            long l7 = this._expireExecutorPeriod;
            Double d = this._expireCompactThreshold;
            boolean bl2 = this.getDb().isThreadSafe();
            Function1<K, V> function1 = this._valueLoader;
            if (this._modListeners.isEmpty()) {
                mapModificationListenerArray = null;
            } else {
                void $receiver$iv;
                Collection size$iv2 = this._modListeners;
                Function1<K, V> function12 = function1;
                boolean bl3 = bl2;
                Double d2 = d;
                long l8 = l7;
                ScheduledExecutorService scheduledExecutorService2 = scheduledExecutorService;
                QueueLong[] queueLongArray7 = queueLongArray6;
                QueueLong[] queueLongArray8 = queueLongArray5;
                QueueLong[] queueLongArray9 = queueLongArray4;
                long l9 = l6;
                long l10 = l5;
                long l11 = l4;
                long l12 = l3;
                long l13 = l;
                Object object6 = object5;
                int n12 = n11;
                MutableLongLongMap[] mutableLongLongMapArray2 = mutableLongLongMapArray;
                Store[] storeArray2 = storeArray;
                int n13 = n10;
                int n14 = n9;
                int n15 = n8;
                boolean bl4 = bl;
                Serializer<V> serializer3 = serializer2;
                Serializer<K> serializer4 = serializer;
                HTreeMap<? super K, ? extends V> hTreeMap3 = hTreeMap2;
                object2 = object4;
                void v39 = $receiver$iv;
                if (v39 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                void thisCollection$iv = v39;
                MapModificationListener[] mapModificationListenerArray2 = thisCollection$iv.toArray(new MapModificationListener[0]);
                if (mapModificationListenerArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                MapModificationListener[] mapModificationListenerArray3 = mapModificationListenerArray2;
                object4 = object2;
                hTreeMap2 = hTreeMap3;
                serializer = serializer4;
                serializer2 = serializer3;
                bl = bl4;
                n8 = n15;
                n9 = n14;
                n10 = n13;
                storeArray = storeArray2;
                mutableLongLongMapArray = mutableLongLongMapArray2;
                n11 = n12;
                object5 = object6;
                l = l13;
                l3 = l12;
                l4 = l11;
                l5 = l10;
                l6 = l9;
                queueLongArray4 = queueLongArray9;
                queueLongArray5 = queueLongArray8;
                queueLongArray6 = queueLongArray7;
                scheduledExecutorService = scheduledExecutorService2;
                l7 = l8;
                d = d2;
                bl2 = bl3;
                function1 = function12;
                mapModificationListenerArray = mapModificationListenerArray3;
            }
            hTreeMap2(serializer, serializer2, bl, n8, n9, n10, storeArray, mutableLongLongMapArray, n11, (long[])object5, l, l3, l4, l5, l6, queueLongArray4, queueLongArray5, queueLongArray6, scheduledExecutorService, l7, d, bl2, function1, mapModificationListenerArray, this.getDb(), this.hasValues);
            return object4;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected HTreeMap<K, V> open2(@NotNull SortedMap<String, String> catalog) {
            MapModificationListener[] mapModificationListenerArray;
            HTreeMap<? super K, ? extends V> hTreeMap;
            Object object;
            long l;
            long l2;
            Object $receiver$iv;
            long[] lArray;
            String counterRecidsStr;
            void $receiver$iv$iv;
            Iterable $receiver$iv2;
            int n;
            Serializer<V> serializer;
            int n2;
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getConcShift());
            if (v == null) {
                Intrinsics.throwNpe();
            }
            String string = (String)v;
            Object object2 = this;
            object2._concShift = n2 = Integer.parseInt(string);
            int segmentCount = 1 << this._concShift;
            Object init$iv = this._storeFactory;
            Object result$iv = new Store[segmentCount];
            int n3 = 0;
            int n4 = ((Store[])result$iv).length;
            while (n3 < n4) {
                void i$iv;
                result$iv[i$iv] = init$iv.invoke((int)i$iv);
                ++i$iv;
            }
            Store[] stores = result$iv;
            Serializer<K> serializer2 = (Serializer<K>)this.getDb().nameCatalogGetClass(catalog, this.getName() + (this.hasValues ? Keys.INSTANCE.getKeySerializer() : Keys.INSTANCE.getSerializer()));
            if (serializer2 == null) {
                serializer2 = this._keySerializer = this._keySerializer;
            }
            if (!this.hasValues) {
                GroupSerializer<Boolean> groupSerializer = BTreeMap.Companion.getNO_VAL_SERIALIZER$mapdb();
                if (groupSerializer == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.mapdb.Serializer<V>");
                }
                serializer = (Serializer<V>)groupSerializer;
            } else {
                serializer = (Serializer<V>)this.getDb().nameCatalogGetClass(catalog, this.getName() + Keys.INSTANCE.getValueSerializer());
                if (serializer == null) {
                    serializer = this._valueSerializer;
                }
            }
            this._valueSerializer = serializer;
            HashMapMaker hashMapMaker = this;
            if (this.hasValues) {
                Object v2 = catalog.get(this.getName() + Keys.INSTANCE.getValueInline());
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                init$iv = (String)v2;
                object2 = hashMapMaker;
                n2 = Boolean.parseBoolean((String)init$iv) ? 1 : 0;
                hashMapMaker = object2;
                n = n2;
            } else {
                n = 1;
            }
            hashMapMaker._valueInline = n;
            Object v3 = catalog.get(this.getName() + Keys.INSTANCE.getHashSeed());
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            result$iv = (String)v3;
            int hashSeed = Integer.parseInt((String)result$iv);
            Object v4 = catalog.get(this.getName() + Keys.INSTANCE.getRootRecids());
            if (v4 == null) {
                Intrinsics.throwNpe();
            }
            Iterable iterable = $receiver$iv2 = (Iterable)StringsKt.split$default((CharSequence)v4, new String[]{","}, false, 0, 6, null);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                Iterator it;
                String string2 = (String)item$iv$iv;
                object2 = destination$iv$iv;
                void var12_23 = it;
                Long l3 = Long.parseLong((String)var12_23);
                object2.add(l3);
            }
            long[] rootRecids = CollectionsKt.toLongArray((List)destination$iv$iv);
            Object v5 = catalog.get(this.getName() + Keys.INSTANCE.getCounterRecids());
            if (v5 == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.areEqual("", counterRecidsStr = (String)v5)) {
                lArray = null;
            } else {
                void $receiver$iv$iv2;
                Object object3 = $receiver$iv = (Iterable)StringsKt.split$default((CharSequence)counterRecidsStr, new String[]{","}, false, 0, 6, null);
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    void it;
                    String $i$a$1$map = (String)item$iv$iv;
                    object2 = destination$iv$iv2;
                    void $i$f$mapTo = it;
                    Long l4 = Long.parseLong((String)$i$f$mapTo);
                    object2.add(l4);
                }
                lArray = CollectionsKt.toLongArray((List)destination$iv$iv2);
            }
            long[] counterRecids = lArray;
            Object v6 = catalog.get(this.getName() + Keys.INSTANCE.getDirShift());
            if (v6 == null) {
                Intrinsics.throwNpe();
            }
            $receiver$iv = (String)v6;
            object2 = this;
            object2._dirShift = n2 = Integer.parseInt((String)$receiver$iv);
            Object v7 = catalog.get(this.getName() + Keys.INSTANCE.getLevels());
            if (v7 == null) {
                Intrinsics.throwNpe();
            }
            $receiver$iv = (String)v7;
            object2 = this;
            object2._levels = n2 = Integer.parseInt((String)$receiver$iv);
            Object v8 = catalog.get(this.getName() + Keys.INSTANCE.getRemoveCollapsesIndexTree());
            if (v8 == null) {
                Intrinsics.throwNpe();
            }
            $receiver$iv = (String)v8;
            object2 = this;
            n2 = Boolean.parseBoolean((String)$receiver$iv) ? 1 : 0;
            object2._removeCollapsesIndexTree = n2;
            Object v9 = catalog.get(this.getName() + Keys.INSTANCE.getExpireCreateTTL());
            if (v9 == null) {
                Intrinsics.throwNpe();
            }
            $receiver$iv = (String)v9;
            object2 = this;
            object2._expireCreateTTL = l2 = Long.parseLong((String)$receiver$iv);
            Object object4 = this;
            if (this.hasValues) {
                Object v10 = catalog.get(this.getName() + Keys.INSTANCE.getExpireUpdateTTL());
                if (v10 == null) {
                    Intrinsics.throwNpe();
                }
                $receiver$iv = (String)v10;
                object2 = object4;
                l2 = Long.parseLong((String)$receiver$iv);
                object4 = object2;
                l = l2;
            } else {
                l = 0L;
            }
            ((HashMapMaker)object4)._expireUpdateTTL = l;
            Object v11 = catalog.get(this.getName() + Keys.INSTANCE.getExpireGetTTL());
            if (v11 == null) {
                Intrinsics.throwNpe();
            }
            $receiver$iv = (String)v11;
            object2 = this;
            object2._expireGetTTL = l2 = Long.parseLong((String)$receiver$iv);
            Function2<Long, String, QueueLong[]> queues$ = new Function2<Long, String, QueueLong[]>(catalog, segmentCount, stores){
                final /* synthetic */ SortedMap $catalog;
                final /* synthetic */ int $segmentCount;
                final /* synthetic */ Store[] $stores;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final QueueLong[] invoke(long ttl, @NotNull String queuesName) {
                    QueueLong[] queueLongArray;
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Intrinsics.checkParameterIsNotNull(queuesName, "queuesName");
                    if (ttl == 0L) {
                        return null;
                    }
                    V v = this.$catalog.get(queuesName);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    Iterable iterable = $receiver$iv = (Iterable)StringsKt.split$default((CharSequence)v, new String[]{","}, false, 0, 6, null);
                    QueueLong[] destination$iv$iv22 = (QueueLong[])new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        queueLongArray = destination$iv$iv22;
                        void var11_15 = it;
                        Long l = Long.parseLong((String)var11_15);
                        queueLongArray.add(l);
                    }
                    long[] rr = CollectionsKt.toLongArray((List)destination$iv$iv22);
                    if (rr.length != this.$segmentCount * 3) {
                        throw (Throwable)new DBException.WrongConfiguration("wrong segment count");
                    }
                    int size$iv = this.$segmentCount;
                    QueueLong[] result$iv = new QueueLong[size$iv];
                    int destination$iv$iv22 = 0;
                    int n = result$iv.length;
                    while (destination$iv$iv22 < n) {
                        void segment;
                        QueueLong queueLong;
                        void i$iv;
                        void item$iv$iv = i$iv;
                        void var16_11 = i$iv++;
                        queueLongArray = result$iv;
                        queueLongArray[var16_11] = queueLong = new QueueLong(this.$stores[segment], rr[segment * 3 + false], rr[segment * 3 + true], rr[segment * 3 + 2]);
                    }
                    return result$iv;
                }
                {
                    this.$catalog = sortedMap;
                    this.$segmentCount = n;
                    this.$stores = storeArray;
                    super(2);
                }
            };
            QueueLong[] expireCreateQueues = queues$.invoke(this._expireCreateTTL, this.getName() + Keys.INSTANCE.getExpireCreateQueue());
            QueueLong[] expireUpdateQueues = queues$.invoke(this._expireUpdateTTL, this.getName() + Keys.INSTANCE.getExpireUpdateQueue());
            QueueLong[] expireGetQueues = queues$.invoke(this._expireGetTTL, this.getName() + Keys.INSTANCE.getExpireGetQueue());
            int size$iv2 = 1 << this._concShift;
            MutableLongLongMap[] result$iv2 = new MutableLongLongMap[size$iv2];
            int $i$a$1$map = 0;
            int n5 = result$iv2.length;
            while ($i$a$1$map < n5) {
                void segment;
                void i$iv;
                void $i$f$map = i$iv;
                void var21_9 = i$iv++;
                object2 = result$iv2;
                object = new IndexTreeLongLongMap(stores[segment], rootRecids[segment], this._dirShift, this._levels, this._removeCollapsesIndexTree);
                object2[var21_9] = object;
            }
            MutableLongLongMap[] indexTrees = result$iv2;
            HTreeMap<? super K, ? extends V> hTreeMap2 = hTreeMap;
            Object object5 = hTreeMap;
            Object object6 = this._keySerializer;
            Serializer<V> serializer3 = this._valueSerializer;
            boolean bl = this._valueInline;
            int n6 = this._concShift;
            int n7 = this._dirShift;
            int n8 = this._levels;
            Store[] storeArray = stores;
            MutableLongLongMap[] mutableLongLongMapArray = indexTrees;
            int n9 = hashSeed;
            long[] lArray2 = counterRecids;
            long l5 = this._expireCreateTTL;
            long l6 = this._expireUpdateTTL;
            long l7 = this._expireGetTTL;
            long l8 = this._expireMaxSize;
            long l9 = this._expireStoreSize;
            QueueLong[] queueLongArray = expireCreateQueues;
            QueueLong[] queueLongArray2 = expireUpdateQueues;
            QueueLong[] queueLongArray3 = expireGetQueues;
            ScheduledExecutorService scheduledExecutorService = this._expireExecutor;
            long l10 = this._expireExecutorPeriod;
            Double d = this._expireCompactThreshold;
            boolean bl2 = this.getDb().isThreadSafe();
            Function1<K, V> function1 = this._valueLoader;
            if (this._modListeners.isEmpty()) {
                mapModificationListenerArray = null;
            } else {
                void $receiver$iv3;
                Collection size$iv2 = this._modListeners;
                Function1<K, V> function12 = function1;
                boolean bl3 = bl2;
                Double d2 = d;
                long l11 = l10;
                ScheduledExecutorService scheduledExecutorService2 = scheduledExecutorService;
                QueueLong[] queueLongArray4 = queueLongArray3;
                QueueLong[] queueLongArray5 = queueLongArray2;
                QueueLong[] queueLongArray6 = queueLongArray;
                long l12 = l9;
                long l13 = l8;
                long l14 = l7;
                long l15 = l6;
                long l16 = l5;
                long[] lArray3 = lArray2;
                int n10 = n9;
                MutableLongLongMap[] mutableLongLongMapArray2 = mutableLongLongMapArray;
                Store[] storeArray2 = storeArray;
                int n11 = n8;
                int n12 = n7;
                int n13 = n6;
                boolean bl4 = bl;
                Serializer<V> serializer4 = serializer3;
                object = object6;
                HTreeMap<? super K, ? extends V> hTreeMap3 = hTreeMap2;
                object2 = object5;
                void v46 = $receiver$iv3;
                if (v46 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                void thisCollection$iv = v46;
                MapModificationListener[] mapModificationListenerArray2 = thisCollection$iv.toArray(new MapModificationListener[0]);
                if (mapModificationListenerArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                MapModificationListener[] mapModificationListenerArray3 = mapModificationListenerArray2;
                object5 = object2;
                hTreeMap2 = hTreeMap3;
                object6 = object;
                serializer3 = serializer4;
                bl = bl4;
                n6 = n13;
                n7 = n12;
                n8 = n11;
                storeArray = storeArray2;
                mutableLongLongMapArray = mutableLongLongMapArray2;
                n9 = n10;
                lArray2 = lArray3;
                l5 = l16;
                l6 = l15;
                l7 = l14;
                l8 = l13;
                l9 = l12;
                queueLongArray = queueLongArray6;
                queueLongArray2 = queueLongArray5;
                queueLongArray3 = queueLongArray4;
                scheduledExecutorService = scheduledExecutorService2;
                l10 = l11;
                d = d2;
                bl2 = bl3;
                function1 = function12;
                mapModificationListenerArray = mapModificationListenerArray3;
            }
            hTreeMap2((Serializer<? super K>)object6, (Serializer<? extends V>)serializer3, bl, n6, n7, n8, storeArray, mutableLongLongMapArray, n9, lArray2, l5, l6, l7, l8, l9, queueLongArray, queueLongArray2, queueLongArray3, scheduledExecutorService, l10, d, bl2, (Function1<? super K, ? extends V>)function1, mapModificationListenerArray, this.getDb(), this.hasValues);
            return object5;
        }

        @Override
        @NotNull
        public HTreeMap<K, V> create() {
            return (HTreeMap)super.create();
        }

        @Override
        @NotNull
        public HTreeMap<K, V> createOrOpen() {
            return (HTreeMap)super.createOrOpen();
        }

        @Override
        @NotNull
        public HTreeMap<K, V> open() {
            return (HTreeMap)super.open();
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        protected final boolean getHasValues() {
            return this.hasValues;
        }

        @NotNull
        protected final Function1<Integer, Store> get_storeFactory() {
            return this._storeFactory;
        }

        public HashMapMaker(@NotNull DB db, @NotNull String name, boolean hasValues, @NotNull Function1<? super Integer, ? extends Store> _storeFactory) {
            Intrinsics.checkParameterIsNotNull(db, "db");
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(_storeFactory, "_storeFactory");
            this.db = db;
            this.name = name;
            this.hasValues = hasValues;
            this._storeFactory = _storeFactory;
            this.type = "HashMap";
            GroupSerializerObjectArray<Object> groupSerializerObjectArray = this.getDb().getDefaultSerializer();
            if (groupSerializerObjectArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.mapdb.Serializer<K>");
            }
            this._keySerializer = groupSerializerObjectArray;
            GroupSerializerObjectArray<Object> groupSerializerObjectArray2 = this.getDb().getDefaultSerializer();
            if (groupSerializerObjectArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.mapdb.Serializer<V>");
            }
            this._valueSerializer = groupSerializerObjectArray2;
            this._concShift = 3;
            this._dirShift = 7;
            this._levels = 4;
            this._expireExecutorPeriod = 10000L;
            this._modListeners = new ArrayList();
            this._removeCollapsesIndexTree = true;
        }

        public /* synthetic */ HashMapMaker(final DB dB, String string, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                function1 = new Function1<Integer, Store>(){

                    @Override
                    @NotNull
                    public final Store invoke(int i) {
                        return dB.store;
                    }
                };
            }
            this(dB, string, bl, function1);
        }

        @NotNull
        public static final /* synthetic */ Serializer access$get_valueSerializer$p(HashMapMaker $this) {
            return $this._valueSerializer;
        }

        public static final /* synthetic */ void access$set_valueSerializer$p(HashMapMaker $this, @NotNull Serializer serializer) {
            $this._valueSerializer = serializer;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00050\u0003B\u0005\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\f\u001a\u00020\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/mapdb/DB$TreeMapSink;", "K", "V", "Lorg/mapdb/Pump$Sink;", "Lkotlin/Pair;", "Lorg/mapdb/BTreeMap;", "()V", "put", "", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "putAll", "map", "Ljava/util/SortedMap;", "mapdb"})
    public static abstract class TreeMapSink<K, V>
    extends Pump.Sink<Pair<? extends K, ? extends V>, BTreeMap<K, V>> {
        public final void put(K key, V value) {
            this.put(new Pair<K, V>(key, value));
        }

        public final void putAll(@NotNull SortedMap<K, V> map2) {
            Map $receiver$iv;
            Intrinsics.checkParameterIsNotNull(map2, "map");
            Map map3 = $receiver$iv = (Map)map2;
            Iterator iterator2 = map3.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry e = element$iv = iterator2.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00040\u0003B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J(\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0*H\u0014J,\u0010+\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0018\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010.0-J\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000100J\u0014\u00101\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J&\u00102\u001a\u000e\u0012\u0004\u0012\u0002H3\u0012\u0004\u0012\u00028\u00010\u0000\"\u0004\b\u0002\u001032\f\u00102\u001a\b\u0012\u0004\u0012\u0002H30\u0011J\u001a\u00104\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u00105\u001a\u00020\u0013J&\u00106\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0016J\u0014\u00108\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J(\u00109\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00042\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0*H\u0014J&\u0010:\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H30\u0000\"\u0004\b\u0002\u001032\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H30\u0011J\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0014\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0016\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0018\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u0019\u001a\u001f\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u001b\u0012\b\b\u0007\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#\u00a8\u0006<"}, d2={"Lorg/mapdb/DB$TreeMapMaker;", "K", "V", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/BTreeMap;", "db", "Lorg/mapdb/DB;", "name", "", "hasValues", "", "(Lorg/mapdb/DB;Ljava/lang/String;Z)V", "_counterEnable", "_counterRecid", "", "Ljava/lang/Long;", "_keySerializer", "Lorg/mapdb/serializer/GroupSerializer;", "_maxNodeSize", "", "_modListeners", "", "Lorg/mapdb/MapModificationListener;", "_rootRecidRecid", "_valueInline", "_valueLoader", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "key", "_valueSerializer", "getDb", "()Lorg/mapdb/DB;", "getHasValues", "()Z", "getName", "()Ljava/lang/String;", "type", "getType", "counterEnable", "create", "create2", "catalog", "Ljava/util/SortedMap;", "createFrom", "iterator", "", "Lkotlin/Pair;", "createFromSink", "Lorg/mapdb/DB$TreeMapSink;", "createOrOpen", "keySerializer", "A", "maxNodeSize", "size", "modificationListener", "listener", "open", "open2", "valueSerializer", "valuesOutsideNodesEnable", "mapdb"})
    public static final class TreeMapMaker<K, V>
    extends Maker<BTreeMap<K, V>> {
        @NotNull
        private final String type = "TreeMap";
        private GroupSerializer<K> _keySerializer;
        private GroupSerializer<V> _valueSerializer;
        private int _maxNodeSize;
        private boolean _counterEnable;
        private Function1<? super K, ? extends V> _valueLoader;
        private List<MapModificationListener<K, V>> _modListeners;
        private Long _rootRecidRecid;
        private Long _counterRecid;
        private boolean _valueInline;
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        private final boolean hasValues;

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @NotNull
        public final <A> TreeMapMaker<A, V> keySerializer(@NotNull GroupSerializer<A> keySerializer) {
            Intrinsics.checkParameterIsNotNull(keySerializer, "keySerializer");
            this._keySerializer = keySerializer;
            TreeMapMaker treeMapMaker = this;
            if (treeMapMaker == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.mapdb.DB.TreeMapMaker<A, V>");
            }
            return treeMapMaker;
        }

        @NotNull
        public final <A> TreeMapMaker<K, A> valueSerializer(@NotNull GroupSerializer<A> valueSerializer) {
            Intrinsics.checkParameterIsNotNull(valueSerializer, "valueSerializer");
            if (!this.hasValues) {
                throw (Throwable)new DBException.WrongConfiguration("Set, no vals");
            }
            this._valueSerializer = valueSerializer;
            TreeMapMaker treeMapMaker = this;
            if (treeMapMaker == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.mapdb.DB.TreeMapMaker<K, A>");
            }
            return treeMapMaker;
        }

        @NotNull
        public final TreeMapMaker<K, V> maxNodeSize(int size2) {
            this._maxNodeSize = size2;
            return this;
        }

        @NotNull
        public final TreeMapMaker<K, V> counterEnable() {
            this._counterEnable = true;
            return this;
        }

        @NotNull
        public final TreeMapMaker<K, V> valuesOutsideNodesEnable() {
            this._valueInline = false;
            return this;
        }

        @NotNull
        public final TreeMapMaker<K, V> modificationListener(@NotNull MapModificationListener<K, V> listener2) {
            block1: {
                Intrinsics.checkParameterIsNotNull(listener2, "listener");
                if (this._modListeners == null) {
                    this._modListeners = new ArrayList();
                }
                List<MapModificationListener<K, V>> list = this._modListeners;
                if (list == null) break block1;
                list.add(listener2);
            }
            return this;
        }

        @NotNull
        public final BTreeMap<K, V> createFrom(@NotNull Iterator<? extends Pair<? extends K, ? extends V>> iterator2) {
            Intrinsics.checkParameterIsNotNull(iterator2, "iterator");
            TreeMapSink<K, V> consumer = this.createFromSink();
            while (iterator2.hasNext()) {
                consumer.put(iterator2.next());
            }
            return (BTreeMap)consumer.create();
        }

        @NotNull
        public final TreeMapSink<K, V> createFromSink() {
            boolean bl = this._valueInline;
            boolean bl2 = false;
            int n = this._maxNodeSize * 3 / 4;
            int n2 = this._maxNodeSize * 3 / 4;
            Pump.Sink consumer = Pump.treeMap$default(Pump.INSTANCE, this.getDb().store, this._keySerializer, this._valueSerializer, null, n, n2, bl2, bl, 72, null);
            return new TreeMapSink<K, V>(this, consumer){
                final /* synthetic */ TreeMapMaker this$0;
                final /* synthetic */ Pump.Sink $consumer;

                public void put(@NotNull Pair<? extends K, ? extends V> e) {
                    Intrinsics.checkParameterIsNotNull(e, "e");
                    this.$consumer.put(e);
                }

                @NotNull
                public BTreeMap<K, V> create() {
                    Long l;
                    this.$consumer.create();
                    Long l2 = this.$consumer.getRootRecidRecid$mapdb();
                    if (l2 == null) {
                        throw (Throwable)((Object)new AssertionError());
                    }
                    TreeMapMaker.access$set_rootRecidRecid$p(this.this$0, (long)l2);
                    if (TreeMapMaker.access$get_counterEnable$p(this.this$0)) {
                        Store store = DB.access$getStore$p(this.this$0.getDb());
                        Long l3 = this.$consumer.getCounter$mapdb();
                        GroupSerializer<Long> groupSerializer = Serializer.LONG;
                        Intrinsics.checkExpressionValueIsNotNull(groupSerializer, "Serializer.LONG");
                        l = store.put(l3, (Serializer)groupSerializer);
                    } else {
                        l = 0L;
                    }
                    TreeMapMaker.access$set_counterRecid$p(this.this$0, l);
                    return (BTreeMap)this.this$0.make2(true);
                }
                {
                    this.this$0 = $outer;
                    this.$consumer = $captured_local_variable$1;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected BTreeMap<K, V> create2(@NotNull SortedMap<String, String> catalog) {
            MapModificationListener[] mapModificationListenerArray;
            BTreeMap<K, V> bTreeMap;
            long l;
            Object object;
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            this.getDb().nameCatalogPutClass(catalog, this.getName() + (this.hasValues ? Keys.INSTANCE.getKeySerializer() : Keys.INSTANCE.getSerializer()), this._keySerializer);
            if (this.hasValues) {
                this.getDb().nameCatalogPutClass(catalog, this.getName() + Keys.INSTANCE.getValueSerializer(), this._valueSerializer);
                Map map2 = catalog;
                String string = this.getName() + Keys.INSTANCE.getValueInline();
                object = String.valueOf(this._valueInline);
                map2.put(string, object);
            }
            Long l2 = this._rootRecidRecid;
            long rootRecidRecid2 = l2 != null ? l2.longValue() : BTreeMap.Companion.putEmptyRoot$mapdb(this.getDb().store, this._keySerializer, this._valueSerializer);
            object = catalog;
            String string = this.getName() + Keys.INSTANCE.getRootRecidRecid();
            Object object2 = String.valueOf(rootRecidRecid2);
            object.put(string, object2);
            if (this._counterEnable) {
                Long l3 = this._counterRecid;
                if (l3 != null) {
                    l = l3;
                } else {
                    Store store = this.getDb().store;
                    Long l4 = 0L;
                    GroupSerializer<Long> groupSerializer = Serializer.LONG;
                    Intrinsics.checkExpressionValueIsNotNull(groupSerializer, "Serializer.LONG");
                    l = store.put(l4, (Serializer)groupSerializer);
                }
            } else {
                l = 0L;
            }
            long counterRecid2 = l;
            object2 = catalog;
            String string2 = this.getName() + Keys.INSTANCE.getCounterRecid();
            String string3 = String.valueOf(counterRecid2);
            object2.put(string2, string3);
            object2 = catalog;
            string2 = this.getName() + Keys.INSTANCE.getMaxNodeSize();
            string3 = String.valueOf(this._maxNodeSize);
            object2.put(string2, string3);
            BTreeMap<K, V> bTreeMap2 = bTreeMap;
            BTreeMap<K, V> bTreeMap3 = bTreeMap;
            GroupSerializer<K> groupSerializer = this._keySerializer;
            GroupSerializer<V> groupSerializer2 = this._valueSerializer;
            long l5 = rootRecidRecid2;
            Store store = this.getDb().store;
            int n = this._maxNodeSize;
            Comparator comparator = this._keySerializer;
            boolean bl = this.getDb().isThreadSafe();
            long l6 = counterRecid2;
            boolean bl2 = this.hasValues;
            boolean bl3 = this._valueInline;
            if (this._modListeners == null) {
                mapModificationListenerArray = null;
            } else {
                void $receiver$iv;
                List<MapModificationListener<K, V>> list = this._modListeners;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                object2 = list;
                boolean bl4 = bl3;
                boolean bl5 = bl2;
                long l7 = l6;
                boolean bl6 = bl;
                Comparator comparator2 = comparator;
                int n2 = n;
                Store store2 = store;
                long l8 = l5;
                GroupSerializer<V> groupSerializer3 = groupSerializer2;
                GroupSerializer<K> groupSerializer4 = groupSerializer;
                BTreeMap<K, V> bTreeMap4 = bTreeMap2;
                BTreeMap<K, V> bTreeMap5 = bTreeMap3;
                void v21 = $receiver$iv;
                if (v21 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                void thisCollection$iv = v21;
                MapModificationListener[] mapModificationListenerArray2 = thisCollection$iv.toArray(new MapModificationListener[0]);
                if (mapModificationListenerArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                MapModificationListener[] mapModificationListenerArray3 = mapModificationListenerArray2;
                bTreeMap3 = bTreeMap5;
                bTreeMap2 = bTreeMap4;
                groupSerializer = groupSerializer4;
                groupSerializer2 = groupSerializer3;
                l5 = l8;
                store = store2;
                n = n2;
                comparator = comparator2;
                bl = bl6;
                l6 = l7;
                bl2 = bl5;
                bl3 = bl4;
                mapModificationListenerArray = mapModificationListenerArray3;
            }
            object2 = mapModificationListenerArray;
            boolean bl7 = bl3;
            boolean bl8 = bl2;
            long l9 = l6;
            boolean bl9 = bl;
            Comparator comparator3 = comparator;
            int n3 = n;
            bTreeMap2(groupSerializer, groupSerializer2, l5, store, bl7, n3, comparator3, bl9, l9, bl8, (MapModificationListener<K, V>[])object2);
            return bTreeMap3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected BTreeMap<K, V> open2(@NotNull SortedMap<String, String> catalog) {
            MapModificationListener[] mapModificationListenerArray;
            BTreeMap<K, V> bTreeMap;
            String string;
            int n;
            GroupSerializer<V> groupSerializer;
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getRootRecidRecid());
            if (v == null) {
                Intrinsics.throwNpe();
            }
            String string2 = (String)v;
            long rootRecidRecid2 = Long.parseLong(string2);
            GroupSerializer<K> groupSerializer2 = (GroupSerializer<K>)this.getDb().nameCatalogGetClass(catalog, this.getName() + (this.hasValues ? Keys.INSTANCE.getKeySerializer() : Keys.INSTANCE.getSerializer()));
            if (groupSerializer2 == null) {
                groupSerializer2 = this._keySerializer = this._keySerializer;
            }
            if (!this.hasValues) {
                groupSerializer = BTreeMap.Companion.getNO_VAL_SERIALIZER$mapdb();
                if (groupSerializer == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.mapdb.serializer.GroupSerializer<V>");
                }
            } else {
                groupSerializer = (GroupSerializer<V>)this.getDb().nameCatalogGetClass(catalog, this.getName() + Keys.INSTANCE.getValueSerializer());
                if (groupSerializer == null) {
                    groupSerializer = this._valueSerializer;
                }
            }
            this._valueSerializer = groupSerializer;
            Object v2 = catalog.get(this.getName() + Keys.INSTANCE.getCounterRecid());
            if (v2 == null) {
                Intrinsics.throwNpe();
            }
            Object object = (String)v2;
            long counterRecid2 = Long.parseLong((String)object);
            Object v3 = catalog.get(this.getName() + Keys.INSTANCE.getMaxNodeSize());
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            object = (String)v3;
            Object object2 = this;
            ((TreeMapMaker)object2)._maxNodeSize = n = Integer.parseInt((String)object);
            if (Intrinsics.areEqual(this._valueSerializer, BTreeMap.Companion.getNO_VAL_SERIALIZER$mapdb()) ^ true && catalog.get(this.getName() + Keys.INSTANCE.getValueInline()) == null && !this.getDb().store.isReadOnly()) {
                object = catalog;
                String string3 = this.getName() + Keys.INSTANCE.getValueInline();
                String string4 = "true";
                object.put(string3, string4);
                this.getDb().nameCatalogSaveLocked(catalog);
            }
            if ((string = (String)catalog.get(this.getName() + Keys.INSTANCE.getValueInline())) == null) {
                string = "true";
            }
            object = string;
            object2 = this;
            n = Boolean.parseBoolean((String)object) ? 1 : 0;
            ((TreeMapMaker)object2)._valueInline = n;
            BTreeMap<K, V> bTreeMap2 = bTreeMap;
            Object object3 = bTreeMap;
            GroupSerializer<K> groupSerializer3 = this._keySerializer;
            GroupSerializer<V> groupSerializer4 = this._valueSerializer;
            long l = rootRecidRecid2;
            Store store = this.getDb().store;
            int n2 = this._maxNodeSize;
            Comparator comparator = this._keySerializer;
            boolean bl = this.getDb().isThreadSafe();
            long l2 = counterRecid2;
            boolean bl2 = this.hasValues;
            boolean bl3 = this._valueInline;
            if (this._modListeners == null) {
                mapModificationListenerArray = null;
            } else {
                void $receiver$iv;
                List<MapModificationListener<K, V>> list = this._modListeners;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                object = list;
                boolean bl4 = bl3;
                boolean bl5 = bl2;
                long l3 = l2;
                boolean bl6 = bl;
                Comparator comparator2 = comparator;
                int n3 = n2;
                Store store2 = store;
                long l4 = l;
                GroupSerializer<V> groupSerializer5 = groupSerializer4;
                GroupSerializer<K> groupSerializer6 = groupSerializer3;
                BTreeMap<K, V> bTreeMap3 = bTreeMap2;
                object2 = object3;
                void v21 = $receiver$iv;
                if (v21 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                void thisCollection$iv = v21;
                MapModificationListener[] mapModificationListenerArray2 = thisCollection$iv.toArray(new MapModificationListener[0]);
                if (mapModificationListenerArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                MapModificationListener[] mapModificationListenerArray3 = mapModificationListenerArray2;
                object3 = object2;
                bTreeMap2 = bTreeMap3;
                groupSerializer3 = groupSerializer6;
                groupSerializer4 = groupSerializer5;
                l = l4;
                store = store2;
                n2 = n3;
                comparator = comparator2;
                bl = bl6;
                l2 = l3;
                bl2 = bl5;
                bl3 = bl4;
                mapModificationListenerArray = mapModificationListenerArray3;
            }
            object = mapModificationListenerArray;
            boolean bl7 = bl3;
            boolean bl8 = bl2;
            long l5 = l2;
            boolean bl9 = bl;
            Comparator comparator3 = comparator;
            int n4 = n2;
            bTreeMap2(groupSerializer3, groupSerializer4, l, store, bl7, n4, comparator3, bl9, l5, bl8, (MapModificationListener<K, V>[])object);
            return object3;
        }

        @Override
        @NotNull
        public BTreeMap<K, V> create() {
            return (BTreeMap)super.create();
        }

        @Override
        @NotNull
        public BTreeMap<K, V> createOrOpen() {
            return (BTreeMap)super.createOrOpen();
        }

        @Override
        @NotNull
        public BTreeMap<K, V> open() {
            return (BTreeMap)super.open();
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        protected final boolean getHasValues() {
            return this.hasValues;
        }

        public TreeMapMaker(@NotNull DB db, @NotNull String name, boolean hasValues) {
            Intrinsics.checkParameterIsNotNull(db, "db");
            Intrinsics.checkParameterIsNotNull(name, "name");
            this.db = db;
            this.name = name;
            this.hasValues = hasValues;
            this.type = "TreeMap";
            GroupSerializerObjectArray<Object> groupSerializerObjectArray = this.getDb().getDefaultSerializer();
            if (groupSerializerObjectArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.mapdb.serializer.GroupSerializer<K>");
            }
            this._keySerializer = groupSerializerObjectArray;
            GroupSerializer groupSerializer = this.hasValues ? (GroupSerializer)this.getDb().getDefaultSerializer() : BTreeMap.Companion.getNO_VAL_SERIALIZER$mapdb();
            if (groupSerializer == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.mapdb.serializer.GroupSerializer<V>");
            }
            this._valueSerializer = groupSerializer;
            this._maxNodeSize = 32;
            this._valueInline = true;
        }

        public /* synthetic */ TreeMapMaker(DB dB, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(dB, string, bl);
        }

        @Nullable
        public static final /* synthetic */ Long access$get_rootRecidRecid$p(TreeMapMaker $this) {
            return $this._rootRecidRecid;
        }

        public static final /* synthetic */ void access$set_rootRecidRecid$p(TreeMapMaker $this, @Nullable Long l) {
            $this._rootRecidRecid = l;
        }

        @Nullable
        public static final /* synthetic */ Long access$get_counterRecid$p(TreeMapMaker $this) {
            return $this._counterRecid;
        }

        public static final /* synthetic */ void access$set_counterRecid$p(TreeMapMaker $this, @Nullable Long l) {
            $this._counterRecid = l;
        }

        public static final /* synthetic */ boolean access$get_counterEnable$p(TreeMapMaker $this) {
            return $this._counterEnable;
        }

        public static final /* synthetic */ void access$set_counterEnable$p(TreeMapMaker $this, boolean bl) {
            $this._counterEnable = bl;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017H\u0014J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017H\u0014J \u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0000\"\u0004\b\u0001\u0010\u001d2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001eJ\b\u0010\u001f\u001a\u00020 H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006!"}, d2={"Lorg/mapdb/DB$TreeSetMaker;", "E", "Lorg/mapdb/DB$Maker;", "Ljava/util/NavigableSet;", "db", "Lorg/mapdb/DB;", "name", "", "(Lorg/mapdb/DB;Ljava/lang/String;)V", "getDb", "()Lorg/mapdb/DB;", "maker", "Lorg/mapdb/DB$TreeMapMaker;", "", "getMaker", "()Lorg/mapdb/DB$TreeMapMaker;", "getName", "()Ljava/lang/String;", "type", "getType", "counterEnable", "create2", "catalog", "Ljava/util/SortedMap;", "maxNodeSize", "size", "", "open2", "serializer", "A", "Lorg/mapdb/serializer/GroupSerializer;", "verify", "", "mapdb"})
    public static final class TreeSetMaker<E>
    extends Maker<NavigableSet<E>> {
        @NotNull
        private final TreeMapMaker<E, Object> maker;
        @NotNull
        private final String type = "TreeSet";
        @NotNull
        private final DB db;
        @NotNull
        private final String name;

        @NotNull
        protected final TreeMapMaker<E, Object> getMaker() {
            return this.maker;
        }

        @NotNull
        public final <A> TreeSetMaker<A> serializer(@NotNull GroupSerializer<A> serializer) {
            Intrinsics.checkParameterIsNotNull(serializer, "serializer");
            this.maker.keySerializer(serializer);
            TreeSetMaker treeSetMaker = this;
            if (treeSetMaker == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.mapdb.DB.TreeSetMaker<A>");
            }
            return treeSetMaker;
        }

        @NotNull
        public final TreeSetMaker<E> maxNodeSize(int size2) {
            this.maker.maxNodeSize(size2);
            return this;
        }

        @NotNull
        public final TreeSetMaker<E> counterEnable() {
            this.maker.counterEnable();
            return this;
        }

        @Override
        protected void verify() {
            this.maker.%%%verify$mapdb();
        }

        @Override
        @NotNull
        protected NavigableSet<E> open2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            NavigableSet navigableSet = (NavigableSet)((BTreeMap)this.maker.%%%open2$mapdb(catalog)).keySet();
            if (navigableSet == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.NavigableSet<E>");
            }
            return navigableSet;
        }

        @Override
        @NotNull
        protected NavigableSet<E> create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            NavigableSet navigableSet = (NavigableSet)((BTreeMap)this.maker.%%%create2$mapdb(catalog)).keySet();
            if (navigableSet == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.NavigableSet<E>");
            }
            return navigableSet;
        }

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        public TreeSetMaker(@NotNull DB db, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull(db, "db");
            Intrinsics.checkParameterIsNotNull(name, "name");
            this.db = db;
            this.name = name;
            this.maker = new TreeMapMaker(this.getDb(), this.getName(), false);
            this.type = "TreeSet";
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B:\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012#\b\u0002\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\u0006\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\t\u00a2\u0006\u0002\u0010\u000eJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001fH\u0014J\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010!\u001a\u00020\"J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010!\u001a\u00020\"J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\u0010*\u001a\u0004\u0018\u00010+J\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010-\u001a\u00020\"J\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010/\u001a\u00020\"J\u0014\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00101\u001a\u00020\"J\u0014\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00102\u001a\u00020\nJ$\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\nJ\"\u00107\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001fH\u0014J\f\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J \u00109\u001a\b\u0012\u0004\u0012\u0002H:0\u0000\"\u0004\b\u0001\u0010:2\f\u00109\u001a\b\u0012\u0004\u0012\u0002H:0;J\b\u0010<\u001a\u00020=H\u0014R/\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\u0006\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006>"}, d2={"Lorg/mapdb/DB$HashSetMaker;", "E", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/HTreeMap$KeySet;", "db", "Lorg/mapdb/DB;", "name", "", "_storeFactory", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "segment", "Lorg/mapdb/Store;", "(Lorg/mapdb/DB;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "get_storeFactory", "()Lkotlin/jvm/functions/Function1;", "getDb", "()Lorg/mapdb/DB;", "maker", "Lorg/mapdb/DB$HashMapMaker;", "", "getMaker", "()Lorg/mapdb/DB$HashMapMaker;", "getName", "()Ljava/lang/String;", "type", "getType", "counterEnable", "create2", "catalog", "Ljava/util/SortedMap;", "expireAfterCreate", "ttl", "", "unit", "Ljava/util/concurrent/TimeUnit;", "expireAfterGet", "expireCompactThreshold", "freeFraction", "", "expireExecutor", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "expireExecutorPeriod", "period", "expireMaxSize", "maxSize", "expireStoreSize", "storeSize", "hashSeed", "layout", "concurrency", "dirSize", "levels", "open2", "removeCollapsesIndexTreeDisable", "serializer", "A", "Lorg/mapdb/Serializer;", "verify", "", "mapdb"})
    public static final class HashSetMaker<E>
    extends Maker<HTreeMap.KeySet<E>> {
        @NotNull
        private final HashMapMaker<E, Object> maker;
        @NotNull
        private final String type = "HashSet";
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        @NotNull
        private final Function1<Integer, Store> _storeFactory;

        @NotNull
        protected final HashMapMaker<E, Object> getMaker() {
            return this.maker;
        }

        @NotNull
        public final <A> HashSetMaker<A> serializer(@NotNull Serializer<A> serializer) {
            Intrinsics.checkParameterIsNotNull(serializer, "serializer");
            this.maker.keySerializer(serializer);
            HashSetMaker hashSetMaker = this;
            if (hashSetMaker == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.mapdb.DB.HashSetMaker<A>");
            }
            return hashSetMaker;
        }

        @NotNull
        public final HashSetMaker<E> counterEnable() {
            this.maker.counterEnable();
            return this;
        }

        @NotNull
        public final HashSetMaker<E> removeCollapsesIndexTreeDisable() {
            this.maker.removeCollapsesIndexTreeDisable();
            return this;
        }

        @NotNull
        public final HashSetMaker<E> hashSeed(int hashSeed) {
            this.maker.hashSeed(hashSeed);
            return this;
        }

        @NotNull
        public final HashSetMaker<E> layout(int concurrency, int dirSize, int levels) {
            this.maker.layout(concurrency, dirSize, levels);
            return this;
        }

        @NotNull
        public final HashSetMaker<E> expireAfterCreate() {
            return this.expireAfterCreate(-1L);
        }

        @NotNull
        public final HashSetMaker<E> expireAfterCreate(long ttl) {
            this.maker.expireAfterCreate(ttl);
            return this;
        }

        @NotNull
        public final HashSetMaker<E> expireAfterCreate(long ttl, @NotNull TimeUnit unit) {
            Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
            return this.expireAfterCreate(unit.toMillis(ttl));
        }

        @NotNull
        public final HashSetMaker<E> expireAfterGet() {
            return this.expireAfterGet(-1L);
        }

        @NotNull
        public final HashSetMaker<E> expireAfterGet(long ttl) {
            this.maker.expireAfterGet(ttl);
            return this;
        }

        @NotNull
        public final HashSetMaker<E> expireAfterGet(long ttl, @NotNull TimeUnit unit) {
            Intrinsics.checkParameterIsNotNull((Object)unit, "unit");
            return this.expireAfterGet(unit.toMillis(ttl));
        }

        @NotNull
        public final HashSetMaker<E> expireExecutor(@Nullable ScheduledExecutorService executor) {
            this.maker.expireExecutor(executor);
            return this;
        }

        @NotNull
        public final HashSetMaker<E> expireExecutorPeriod(long period) {
            this.maker.expireExecutorPeriod(period);
            return this;
        }

        @NotNull
        public final HashSetMaker<E> expireCompactThreshold(double freeFraction) {
            this.maker.expireCompactThreshold(freeFraction);
            return this;
        }

        @NotNull
        public final HashSetMaker<E> expireMaxSize(long maxSize) {
            this.maker.expireMaxSize(maxSize);
            return this;
        }

        @NotNull
        public final HashSetMaker<E> expireStoreSize(long storeSize) {
            this.maker.expireStoreSize(storeSize);
            return this;
        }

        @Override
        protected void verify() {
            this.maker.%%%verify$mapdb();
        }

        @Override
        @NotNull
        protected HTreeMap.KeySet<E> open2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            Set set = ((HTreeMap)this.maker.%%%open2$mapdb(catalog)).keySet();
            if (set == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.mapdb.HTreeMap.KeySet<E>");
            }
            return (HTreeMap.KeySet)set;
        }

        @Override
        @NotNull
        protected HTreeMap.KeySet<E> create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            Set set = ((HTreeMap)this.maker.%%%create2$mapdb(catalog)).keySet();
            if (set == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.mapdb.HTreeMap.KeySet<E>");
            }
            return (HTreeMap.KeySet)set;
        }

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        @NotNull
        protected final Function1<Integer, Store> get_storeFactory() {
            return this._storeFactory;
        }

        public HashSetMaker(@NotNull DB db, @NotNull String name, @NotNull Function1<? super Integer, ? extends Store> _storeFactory) {
            Intrinsics.checkParameterIsNotNull(db, "db");
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(_storeFactory, "_storeFactory");
            this.db = db;
            this.name = name;
            this._storeFactory = _storeFactory;
            this.maker = new HashMapMaker(this.getDb(), this.getName(), false, this._storeFactory);
            this.maker.valueSerializer(BTreeMap.Companion.getNO_VAL_SERIALIZER$mapdb()).valueInline();
            this.type = "HashSet";
        }

        public /* synthetic */ HashSetMaker(final DB dB, String string, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                function1 = new Function1<Integer, Store>(){

                    @Override
                    @NotNull
                    public final Store invoke(int i) {
                        return dB.store;
                    }
                };
            }
            this(dB, string, function1);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J#\u0010\u000e\u001a\u00028\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0010H\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J#\u0010\u0013\u001a\u00028\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0010H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0012J\r\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\r\u0010\u0018\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J!\u0010\u001a\u001a\u00028\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0010H$\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\r\u0010\u001c\u001a\u00028\u0000H\u0017\u00a2\u0006\u0002\u0010\u0019J\u0017\u0010\u001d\u001a\u00028\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u001eH\u0004\u00a2\u0006\u0002\u0010\u001fJ\r\u0010 \u001a\u00028\u0000H\u0017\u00a2\u0006\u0002\u0010\u0019J\r\u0010!\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J!\u0010\"\u001a\u00028\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0010H$\u00a2\u0006\u0002\u0010\u0012J\b\u0010#\u001a\u00020\u0016H\u0014R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006$"}, d2={"Lorg/mapdb/DB$Maker;", "E", "", "()V", "db", "Lorg/mapdb/DB;", "getDb", "()Lorg/mapdb/DB;", "name", "", "getName", "()Ljava/lang/String;", "type", "getType", "%%%create2", "catalog", "Ljava/util/SortedMap;", "%%%create2$mapdb", "(Ljava/util/SortedMap;)Ljava/lang/Object;", "%%%open2", "%%%open2$mapdb", "%%%verify", "", "%%%verify$mapdb", "create", "()Ljava/lang/Object;", "create2", "createOrOpen", "make", "make2", "", "(Ljava/lang/Boolean;)Ljava/lang/Object;", "makeOrGet", "open", "open2", "verify", "mapdb"})
    public static abstract class Maker<E> {
        public E create() {
            return this.make2(true);
        }

        @Deprecated(message="use createOrOpen() method", replaceWith=@ReplaceWith(imports={}, expression="createOrOpen()"))
        public E make() {
            return this.make2(null);
        }

        @Deprecated(message="use createOrOpen() method", replaceWith=@ReplaceWith(imports={}, expression="createOrOpen()"))
        public E makeOrGet() {
            return this.make2(null);
        }

        public E createOrOpen() {
            return this.make2(null);
        }

        public E open() {
            return this.make2(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final E make2(@Nullable Boolean create) {
            Utils utils = Utils.INSTANCE;
            ReadWriteLock lock$iv = this.getDb().getLock();
            if (lock$iv != null) {
                lock$iv.writeLock().lock();
            }
            try {
                this.getDb().checkNotClosed();
                this.verify();
                SortedMap<String, String> catalog = this.getDb().nameCatalogLoad();
                String typeFromDb = (String)catalog.get(this.getName() + Keys.INSTANCE.getType());
                if (create != null) {
                    if (typeFromDb != null && create.booleanValue()) {
                        throw (Throwable)new DBException.WrongConfiguration("Named record already exists: " + this.getName());
                    }
                    if (!create.booleanValue() && typeFromDb == null) {
                        throw (Throwable)new DBException.WrongConfiguration("Named record does not exist: " + this.getName());
                    }
                }
                if (typeFromDb != null && Intrinsics.areEqual(this.getType(), typeFromDb) ^ true) {
                    throw (Throwable)new DBException.WrongConfiguration("Wrong type for named record '" + this.getName() + "'. Expected '" + this.getType() + "', but catalog has '" + typeFromDb + '\'');
                }
                Object ref = this.getDb().getNamesInstanciated().getIfPresent(this.getName());
                if (ref != null) {
                    Object object = ref;
                    return (E)object;
                }
                if (typeFromDb != null) {
                    E ret2 = this.open2(catalog);
                    this.getDb().getNamesInstanciated().put(this.getName(), ret2);
                    E e = ret2;
                    return e;
                }
                if (this.getDb().store.isReadOnly()) {
                    throw (Throwable)new UnsupportedOperationException("Read-only");
                }
                catalog.put(this.getName() + Keys.INSTANCE.getType(), this.getType());
                E ret3 = this.create2(catalog);
                this.getDb().nameCatalogSaveLocked(catalog);
                this.getDb().getNamesInstanciated().put(this.getName(), ret3);
                E e = ret3;
                return e;
            }
            finally {
                if (lock$iv != null) {
                    lock$iv.writeLock().unlock();
                }
            }
        }

        protected void verify() {
        }

        protected abstract E create2(@NotNull SortedMap<String, String> var1);

        protected abstract E open2(@NotNull SortedMap<String, String> var1);

        public final void %%%verify$mapdb() {
            this.verify();
        }

        public final E %%%create2$mapdb(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            return this.create2(catalog);
        }

        public final E %%%open2$mapdb(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            return this.open2(catalog);
        }

        @NotNull
        protected abstract DB getDb();

        @NotNull
        protected abstract String getName();

        @NotNull
        protected abstract String getType();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0012\u001a\u00020\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0014H\u0014J\u001c\u0010\u0015\u001a\u00020\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0014H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/mapdb/DB$AtomicIntegerMaker;", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/Atomic$Integer;", "db", "Lorg/mapdb/DB;", "name", "", "value", "", "(Lorg/mapdb/DB;Ljava/lang/String;I)V", "getDb", "()Lorg/mapdb/DB;", "getName", "()Ljava/lang/String;", "type", "getType", "getValue", "()I", "create2", "catalog", "Ljava/util/SortedMap;", "open2", "mapdb"})
    public static final class AtomicIntegerMaker
    extends Maker<Atomic.Integer> {
        @NotNull
        private final String type = "AtomicInteger";
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        private final int value;

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @Override
        @NotNull
        protected Atomic.Integer create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            Store store = this.getDb().store;
            Integer n = this.value;
            GroupSerializer<Integer> groupSerializer = Serializer.INTEGER;
            Intrinsics.checkExpressionValueIsNotNull(groupSerializer, "Serializer.INTEGER");
            long recid2 = store.put(n, (Serializer)groupSerializer);
            Map map2 = catalog;
            String string = this.getName() + Keys.INSTANCE.getRecid();
            String string2 = String.valueOf(recid2);
            map2.put(string, string2);
            return new Atomic.Integer(this.getDb().store, recid2);
        }

        @Override
        @NotNull
        protected Atomic.Integer open2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getRecid());
            if (v == null) {
                Intrinsics.throwNpe();
            }
            String string = (String)v;
            long recid2 = Long.parseLong(string);
            return new Atomic.Integer(this.getDb().store, recid2);
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        protected final int getValue() {
            return this.value;
        }

        public AtomicIntegerMaker(@NotNull DB db, @NotNull String name, int value) {
            Intrinsics.checkParameterIsNotNull(db, "db");
            Intrinsics.checkParameterIsNotNull(name, "name");
            this.db = db;
            this.name = name;
            this.value = value;
            this.type = "AtomicInteger";
        }

        public /* synthetic */ AtomicIntegerMaker(DB dB, String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            this(dB, string, n);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0012\u001a\u00020\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0014H\u0014J\u001c\u0010\u0015\u001a\u00020\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0014H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/mapdb/DB$AtomicLongMaker;", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/Atomic$Long;", "db", "Lorg/mapdb/DB;", "name", "", "value", "", "(Lorg/mapdb/DB;Ljava/lang/String;J)V", "getDb", "()Lorg/mapdb/DB;", "getName", "()Ljava/lang/String;", "type", "getType", "getValue", "()J", "create2", "catalog", "Ljava/util/SortedMap;", "open2", "mapdb"})
    public static final class AtomicLongMaker
    extends Maker<Atomic.Long> {
        @NotNull
        private final String type = "AtomicLong";
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        private final long value;

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @Override
        @NotNull
        protected Atomic.Long create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            Store store = this.getDb().store;
            Long l = this.value;
            GroupSerializer<Long> groupSerializer = Serializer.LONG;
            Intrinsics.checkExpressionValueIsNotNull(groupSerializer, "Serializer.LONG");
            long recid2 = store.put(l, (Serializer)groupSerializer);
            Map map2 = catalog;
            String string = this.getName() + Keys.INSTANCE.getRecid();
            String string2 = String.valueOf(recid2);
            map2.put(string, string2);
            return new Atomic.Long(this.getDb().store, recid2);
        }

        @Override
        @NotNull
        protected Atomic.Long open2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getRecid());
            if (v == null) {
                Intrinsics.throwNpe();
            }
            String string = (String)v;
            long recid2 = Long.parseLong(string);
            return new Atomic.Long(this.getDb().store, recid2);
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        protected final long getValue() {
            return this.value;
        }

        public AtomicLongMaker(@NotNull DB db, @NotNull String name, long value) {
            Intrinsics.checkParameterIsNotNull(db, "db");
            Intrinsics.checkParameterIsNotNull(name, "name");
            this.db = db;
            this.name = name;
            this.value = value;
            this.type = "AtomicLong";
        }

        public /* synthetic */ AtomicLongMaker(DB dB, String string, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                l = 0L;
            }
            this(dB, string, l);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0012\u001a\u00020\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0014H\u0014J\u001c\u0010\u0015\u001a\u00020\u00022\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0014H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/mapdb/DB$AtomicBooleanMaker;", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/Atomic$Boolean;", "db", "Lorg/mapdb/DB;", "name", "", "value", "", "(Lorg/mapdb/DB;Ljava/lang/String;Z)V", "getDb", "()Lorg/mapdb/DB;", "getName", "()Ljava/lang/String;", "type", "getType", "getValue", "()Z", "create2", "catalog", "Ljava/util/SortedMap;", "open2", "mapdb"})
    public static final class AtomicBooleanMaker
    extends Maker<Atomic.Boolean> {
        @NotNull
        private final String type = "AtomicBoolean";
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        private final boolean value;

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @Override
        @NotNull
        protected Atomic.Boolean create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            Store store = this.getDb().store;
            Boolean bl = this.value;
            GroupSerializer<Boolean> groupSerializer = Serializer.BOOLEAN;
            Intrinsics.checkExpressionValueIsNotNull(groupSerializer, "Serializer.BOOLEAN");
            long recid2 = store.put(bl, (Serializer)groupSerializer);
            Map map2 = catalog;
            String string = this.getName() + Keys.INSTANCE.getRecid();
            String string2 = String.valueOf(recid2);
            map2.put(string, string2);
            return new Atomic.Boolean(this.getDb().store, recid2);
        }

        @Override
        @NotNull
        protected Atomic.Boolean open2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getRecid());
            if (v == null) {
                Intrinsics.throwNpe();
            }
            String string = (String)v;
            long recid2 = Long.parseLong(string);
            return new Atomic.Boolean(this.getDb().store, recid2);
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        protected final boolean getValue() {
            return this.value;
        }

        public AtomicBooleanMaker(@NotNull DB db, @NotNull String name, boolean value) {
            Intrinsics.checkParameterIsNotNull(db, "db");
            Intrinsics.checkParameterIsNotNull(name, "name");
            this.db = db;
            this.name = name;
            this.value = value;
            this.type = "AtomicBoolean";
        }

        public /* synthetic */ AtomicBooleanMaker(DB dB, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(dB, string, bl);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0010\u001a\u00020\u00022\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0012H\u0014J\u001c\u0010\u0013\u001a\u00020\u00022\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0012H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/mapdb/DB$AtomicStringMaker;", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/Atomic$String;", "db", "Lorg/mapdb/DB;", "name", "", "value", "(Lorg/mapdb/DB;Ljava/lang/String;Ljava/lang/String;)V", "getDb", "()Lorg/mapdb/DB;", "getName", "()Ljava/lang/String;", "type", "getType", "getValue", "create2", "catalog", "Ljava/util/SortedMap;", "open2", "mapdb"})
    public static final class AtomicStringMaker
    extends Maker<Atomic.String> {
        @NotNull
        private final String type = "AtomicString";
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        @Nullable
        private final String value;

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @Override
        @NotNull
        protected Atomic.String create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            Store store = this.getDb().store;
            Serializer<String> serializer = Serializer.STRING_NOSIZE;
            Intrinsics.checkExpressionValueIsNotNull(serializer, "Serializer.STRING_NOSIZE");
            long recid2 = store.put(this.value, serializer);
            Map map2 = catalog;
            String string = this.getName() + Keys.INSTANCE.getRecid();
            String string2 = String.valueOf(recid2);
            map2.put(string, string2);
            return new Atomic.String(this.getDb().store, recid2);
        }

        @Override
        @NotNull
        protected Atomic.String open2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getRecid());
            if (v == null) {
                Intrinsics.throwNpe();
            }
            String string = (String)v;
            long recid2 = Long.parseLong(string);
            return new Atomic.String(this.getDb().store, recid2);
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        @Nullable
        protected final String getValue() {
            return this.value;
        }

        public AtomicStringMaker(@NotNull DB db, @NotNull String name, @Nullable String value) {
            Intrinsics.checkParameterIsNotNull(db, "db");
            Intrinsics.checkParameterIsNotNull(name, "name");
            this.db = db;
            this.name = name;
            this.value = value;
            this.type = "AtomicString";
        }

        public /* synthetic */ AtomicStringMaker(DB dB, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(dB, string, string2);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000bJ\"\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0019H\u0014J\"\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0019H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0018\u0010\n\u001a\u0004\u0018\u00018\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lorg/mapdb/DB$AtomicVarMaker;", "E", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/Atomic$Var;", "db", "Lorg/mapdb/DB;", "name", "", "serializer", "Lorg/mapdb/Serializer;", "value", "(Lorg/mapdb/DB;Ljava/lang/String;Lorg/mapdb/Serializer;Ljava/lang/Object;)V", "getDb", "()Lorg/mapdb/DB;", "getName", "()Ljava/lang/String;", "getSerializer", "()Lorg/mapdb/Serializer;", "type", "getType", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "create2", "catalog", "Ljava/util/SortedMap;", "open2", "mapdb"})
    public static final class AtomicVarMaker<E>
    extends Maker<Atomic.Var<E>> {
        @NotNull
        private final String type = "AtomicVar";
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        @NotNull
        private final Serializer<E> serializer;
        @Nullable
        private final E value;

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @Override
        @NotNull
        protected Atomic.Var<E> create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            long recid2 = this.getDb().store.put(this.value, this.serializer);
            Map map2 = catalog;
            String string = this.getName() + Keys.INSTANCE.getRecid();
            String string2 = String.valueOf(recid2);
            map2.put(string, string2);
            this.getDb().nameCatalogPutClass(catalog, this.getName() + Keys.INSTANCE.getSerializer(), this.serializer);
            return new Atomic.Var<E>(this.getDb().store, recid2, this.serializer);
        }

        @Override
        @NotNull
        protected Atomic.Var<E> open2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getRecid());
            if (v == null) {
                Intrinsics.throwNpe();
            }
            String string = (String)v;
            long recid2 = Long.parseLong(string);
            Serializer<E> serializer = (Serializer<E>)this.getDb().nameCatalogGetClass(catalog, this.getName() + Keys.INSTANCE.getSerializer());
            if (serializer == null) {
                serializer = this.serializer;
            }
            Serializer<E> serializer2 = serializer;
            return new Atomic.Var<E>(this.getDb().store, recid2, serializer2);
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        @NotNull
        protected final Serializer<E> getSerializer() {
            return this.serializer;
        }

        @Nullable
        protected final E getValue() {
            return this.value;
        }

        public AtomicVarMaker(@NotNull DB db, @NotNull String name, @NotNull Serializer<E> serializer, @Nullable E value) {
            Intrinsics.checkParameterIsNotNull(db, "db");
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(serializer, "serializer");
            this.db = db;
            this.name = name;
            this.serializer = serializer;
            this.value = value;
            this.type = "AtomicVar";
        }

        public /* synthetic */ AtomicVarMaker(DB dB, String string, Serializer serializer, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                GroupSerializerObjectArray<Object> groupSerializerObjectArray = dB.getDefaultSerializer();
                if (groupSerializerObjectArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.mapdb.Serializer<E>");
                }
                serializer = groupSerializerObjectArray;
            }
            if ((n & 8) != 0) {
                object = null;
            }
            this(dB, string, serializer, object);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0013\u001a\u00020\u00022\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0015H\u0014J\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tJ\u001c\u0010\u0019\u001a\u00020\u00022\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0015H\u0014J\u0006\u0010\u001a\u001a\u00020\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/mapdb/DB$IndexTreeLongLongMapMaker;", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/IndexTreeLongLongMap;", "db", "Lorg/mapdb/DB;", "name", "", "(Lorg/mapdb/DB;Ljava/lang/String;)V", "_dirShift", "", "_levels", "_removeCollapsesIndexTree", "", "getDb", "()Lorg/mapdb/DB;", "getName", "()Ljava/lang/String;", "type", "getType", "create2", "catalog", "Ljava/util/SortedMap;", "layout", "dirSize", "levels", "open2", "removeCollapsesIndexTreeDisable", "mapdb"})
    public static final class IndexTreeLongLongMapMaker
    extends Maker<IndexTreeLongLongMap> {
        private int _dirShift;
        private int _levels;
        private boolean _removeCollapsesIndexTree;
        @NotNull
        private final String type = "IndexTreeLongLongMap";
        @NotNull
        private final DB db;
        @NotNull
        private final String name;

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @NotNull
        public final IndexTreeLongLongMapMaker layout(int dirSize, int levels) {
            layout.1 toShift$ = layout.1.INSTANCE;
            this._dirShift = toShift$.invoke(dirSize);
            this._levels = levels;
            return this;
        }

        @NotNull
        public final IndexTreeLongLongMapMaker removeCollapsesIndexTreeDisable() {
            this._removeCollapsesIndexTree = false;
            return this;
        }

        @Override
        @NotNull
        protected IndexTreeLongLongMap create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            Map map2 = catalog;
            String string = this.getName() + Keys.INSTANCE.getDirShift();
            Object object = String.valueOf(this._dirShift);
            map2.put(string, object);
            map2 = catalog;
            string = this.getName() + Keys.INSTANCE.getLevels();
            object = String.valueOf(this._levels);
            map2.put(string, object);
            map2 = catalog;
            string = this.getName() + Keys.INSTANCE.getRemoveCollapsesIndexTree();
            object = String.valueOf(this._removeCollapsesIndexTree);
            map2.put(string, object);
            Store store = this.getDb().store;
            long[] lArray = IndexTreeListJava.dirEmpty();
            Serializer<long[]> serializer = IndexTreeListJava.dirSer;
            Intrinsics.checkExpressionValueIsNotNull(serializer, "IndexTreeListJava.dirSer");
            long rootRecid = store.put(lArray, serializer);
            object = catalog;
            String string2 = this.getName() + Keys.INSTANCE.getRootRecid();
            String string3 = String.valueOf(rootRecid);
            object.put(string2, string3);
            return new IndexTreeLongLongMap(this.getDb().store, rootRecid, this._dirShift, this._levels, this._removeCollapsesIndexTree);
        }

        @Override
        @NotNull
        protected IndexTreeLongLongMap open2(@NotNull SortedMap<String, String> catalog) {
            boolean bl;
            IndexTreeLongLongMap indexTreeLongLongMap;
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            Store store = this.getDb().store;
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getDirShift());
            if (v == null) {
                Intrinsics.throwNpe();
            }
            String string = (String)v;
            Store store2 = store;
            IndexTreeLongLongMap indexTreeLongLongMap2 = indexTreeLongLongMap;
            IndexTreeLongLongMap indexTreeLongLongMap3 = indexTreeLongLongMap;
            int n = Integer.parseInt(string);
            Object v2 = catalog.get(this.getName() + Keys.INSTANCE.getLevels());
            if (v2 == null) {
                Intrinsics.throwNpe();
            }
            string = (String)v2;
            int n2 = Integer.parseInt(string);
            Object v3 = catalog.get(this.getName() + Keys.INSTANCE.getRootRecid());
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            string = (String)v3;
            long l = Long.parseLong(string);
            Object v4 = catalog.get(this.getName() + Keys.INSTANCE.getRemoveCollapsesIndexTree());
            if (v4 == null) {
                Intrinsics.throwNpe();
            }
            string = (String)v4;
            boolean bl2 = bl = Boolean.parseBoolean(string);
            long l2 = l;
            int n3 = n2;
            int n4 = n;
            indexTreeLongLongMap2(store2, l2, n4, n3, bl2);
            return indexTreeLongLongMap3;
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        public IndexTreeLongLongMapMaker(@NotNull DB db, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull(db, "db");
            Intrinsics.checkParameterIsNotNull(name, "name");
            this.db = db;
            this.name = name;
            this._dirShift = 7;
            this._levels = 4;
            this._removeCollapsesIndexTree = true;
            this.type = "IndexTreeLongLongMap";
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001aH\u0014J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fJ\"\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001aH\u0014J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006 "}, d2={"Lorg/mapdb/DB$IndexTreeListMaker;", "E", "Lorg/mapdb/DB$Maker;", "Lorg/mapdb/IndexTreeList;", "db", "Lorg/mapdb/DB;", "name", "", "serializer", "Lorg/mapdb/Serializer;", "(Lorg/mapdb/DB;Ljava/lang/String;Lorg/mapdb/Serializer;)V", "_dirShift", "", "_levels", "_removeCollapsesIndexTree", "", "getDb", "()Lorg/mapdb/DB;", "getName", "()Ljava/lang/String;", "getSerializer", "()Lorg/mapdb/Serializer;", "type", "getType", "create2", "catalog", "Ljava/util/SortedMap;", "layout", "dirSize", "levels", "open2", "removeCollapsesIndexTreeDisable", "mapdb"})
    public static final class IndexTreeListMaker<E>
    extends Maker<IndexTreeList<E>> {
        private int _dirShift;
        private int _levels;
        private boolean _removeCollapsesIndexTree;
        @NotNull
        private final String type = "IndexTreeList";
        @NotNull
        private final DB db;
        @NotNull
        private final String name;
        @NotNull
        private final Serializer<E> serializer;

        @Override
        @NotNull
        protected String getType() {
            return this.type;
        }

        @NotNull
        public final IndexTreeListMaker<E> layout(int dirSize, int levels) {
            layout.1 toShift$ = layout.1.INSTANCE;
            this._dirShift = toShift$.invoke(dirSize);
            this._levels = levels;
            return this;
        }

        @NotNull
        public final IndexTreeListMaker<E> removeCollapsesIndexTreeDisable() {
            this._removeCollapsesIndexTree = false;
            return this;
        }

        @Override
        @NotNull
        protected IndexTreeList<E> create2(@NotNull SortedMap<String, String> catalog) {
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            Map map2 = catalog;
            String string = this.getName() + Keys.INSTANCE.getDirShift();
            Object object = String.valueOf(this._dirShift);
            map2.put(string, object);
            map2 = catalog;
            string = this.getName() + Keys.INSTANCE.getLevels();
            object = String.valueOf(this._levels);
            map2.put(string, object);
            map2 = catalog;
            string = this.getName() + Keys.INSTANCE.getRemoveCollapsesIndexTree();
            object = String.valueOf(this._removeCollapsesIndexTree);
            map2.put(string, object);
            this.getDb().nameCatalogPutClass(catalog, this.getName() + Keys.INSTANCE.getSerializer(), this.serializer);
            Store store = this.getDb().store;
            Long l = 0L;
            GroupSerializer<Long> groupSerializer = Serializer.LONG_PACKED;
            Intrinsics.checkExpressionValueIsNotNull(groupSerializer, "Serializer.LONG_PACKED");
            long counterRecid = store.put(l, (Serializer)groupSerializer);
            object = catalog;
            String string2 = this.getName() + Keys.INSTANCE.getCounterRecid();
            Object object2 = String.valueOf(counterRecid);
            object.put(string2, object2);
            Store store2 = this.getDb().store;
            long[] lArray = IndexTreeListJava.dirEmpty();
            Serializer<long[]> serializer = IndexTreeListJava.dirSer;
            Intrinsics.checkExpressionValueIsNotNull(serializer, "IndexTreeListJava.dirSer");
            long rootRecid = store2.put(lArray, serializer);
            object2 = catalog;
            String string3 = this.getName() + Keys.INSTANCE.getRootRecid();
            String string4 = String.valueOf(rootRecid);
            object2.put(string3, string4);
            IndexTreeLongLongMap map3 = new IndexTreeLongLongMap(this.getDb().store, rootRecid, this._dirShift, this._levels, this._removeCollapsesIndexTree);
            long l2 = counterRecid;
            boolean bl = this.getDb().isThreadSafe();
            Serializer<E> serializer2 = this.serializer;
            MutableLongLongMap mutableLongLongMap = map3;
            return new IndexTreeList<E>(this.getDb().store, serializer2, mutableLongLongMap, l2, bl);
        }

        @Override
        @NotNull
        protected IndexTreeList<E> open2(@NotNull SortedMap<String, String> catalog) {
            long l;
            IndexTreeList indexTreeList;
            boolean bl;
            IndexTreeLongLongMap indexTreeLongLongMap;
            Intrinsics.checkParameterIsNotNull(catalog, "catalog");
            Store store = this.getDb().store;
            Object v = catalog.get(this.getName() + Keys.INSTANCE.getDirShift());
            if (v == null) {
                Intrinsics.throwNpe();
            }
            String string = (String)v;
            Store store2 = store;
            IndexTreeList<E> indexTreeList2 = indexTreeLongLongMap;
            Object object = indexTreeLongLongMap;
            int n = Integer.parseInt(string);
            Object v2 = catalog.get(this.getName() + Keys.INSTANCE.getLevels());
            if (v2 == null) {
                Intrinsics.throwNpe();
            }
            string = (String)v2;
            int n2 = Integer.parseInt(string);
            Object v3 = catalog.get(this.getName() + Keys.INSTANCE.getRootRecid());
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            string = (String)v3;
            long l2 = Long.parseLong(string);
            Object v4 = catalog.get(this.getName() + Keys.INSTANCE.getRemoveCollapsesIndexTree());
            if (v4 == null) {
                Intrinsics.throwNpe();
            }
            string = (String)v4;
            boolean bl2 = bl = Boolean.parseBoolean(string);
            long l3 = l2;
            int n3 = n2;
            int n4 = n;
            ((IndexTreeLongLongMap)((Object)indexTreeList2))(store2, l3, n4, n3, bl2);
            IndexTreeLongLongMap map2 = object;
            Store store3 = this.getDb().store;
            MutableLongLongMap mutableLongLongMap = map2;
            Serializer<E> serializer = (Serializer<E>)this.getDb().nameCatalogGetClass(catalog, this.getName() + Keys.INSTANCE.getSerializer());
            if (serializer == null) {
                serializer = this.serializer;
            }
            boolean bl3 = this.getDb().isThreadSafe();
            Object v5 = catalog.get(this.getName() + Keys.INSTANCE.getCounterRecid());
            if (v5 == null) {
                Intrinsics.throwNpe();
            }
            String string2 = (String)v5;
            boolean bl4 = bl3;
            Serializer<E> serializer2 = serializer;
            MutableLongLongMap mutableLongLongMap2 = mutableLongLongMap;
            store2 = store3;
            indexTreeList2 = indexTreeList;
            object = indexTreeList;
            long l4 = l = Long.parseLong(string2);
            boolean bl5 = bl4;
            Serializer<E> serializer3 = serializer2;
            MutableLongLongMap mutableLongLongMap3 = mutableLongLongMap2;
            indexTreeList2(store2, serializer3, mutableLongLongMap3, l4, bl5);
            return object;
        }

        @Override
        @NotNull
        protected DB getDb() {
            return this.db;
        }

        @Override
        @NotNull
        protected String getName() {
            return this.name;
        }

        @NotNull
        protected final Serializer<E> getSerializer() {
            return this.serializer;
        }

        public IndexTreeListMaker(@NotNull DB db, @NotNull String name, @NotNull Serializer<E> serializer) {
            Intrinsics.checkParameterIsNotNull(db, "db");
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(serializer, "serializer");
            this.db = db;
            this.name = name;
            this.serializer = serializer;
            this._dirShift = 7;
            this._levels = 4;
            this._removeCollapsesIndexTree = true;
            this.type = "IndexTreeList";
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\b\u0018\u00002\u00020\u0001B%\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/mapdb/DB$CatVal;", "", "msg", "Lkotlin/Function1;", "", "required", "", "(Lkotlin/jvm/functions/Function1;Z)V", "getMsg", "()Lkotlin/jvm/functions/Function1;", "getRequired", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "mapdb"})
    protected static final class CatVal {
        @NotNull
        private final Function1<String, String> msg;
        private final boolean required;

        @NotNull
        public final Function1<String, String> getMsg() {
            return this.msg;
        }

        public final boolean getRequired() {
            return this.required;
        }

        public CatVal(@NotNull Function1<? super String, String> msg, boolean required) {
            Intrinsics.checkParameterIsNotNull(msg, "msg");
            this.msg = msg;
            this.required = required;
        }

        public /* synthetic */ CatVal(Function1 function1, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(function1, bl);
        }

        @NotNull
        public final Function1<String, String> component1() {
            return this.msg;
        }

        public final boolean component2() {
            return this.required;
        }

        @NotNull
        public final CatVal copy(@NotNull Function1<? super String, String> msg, boolean required) {
            Intrinsics.checkParameterIsNotNull(msg, "msg");
            return new CatVal(msg, required);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CatVal copy$default(CatVal catVal, Function1 function1, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = catVal.msg;
            }
            if ((n & 2) != 0) {
                bl = catVal.required;
            }
            return catVal.copy(function1, bl);
        }

        public String toString() {
            return "CatVal(msg=" + this.msg + ", required=" + this.required + ")";
        }

        public int hashCode() {
            Function1<String, String> function1 = this.msg;
            int n = (function1 != null ? function1.hashCode() : 0) * 31;
            int n2 = this.required ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CatVal)) break block3;
                    CatVal catVal = (CatVal)object;
                    if (!Intrinsics.areEqual(this.msg, catVal.msg) || !(this.required == catVal.required)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R&\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000RN\u0010\u000f\u001aB\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00010\u0001\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00010\u0001 \u0011* \u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00010\u0001\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/mapdb/DB$Companion;", "", "()V", "NAMED_SERIALIZATION_HEADER", "", "getNAMED_SERIALIZATION_HEADER", "()I", "NAME_CATALOG_SERIALIZER", "Lorg/mapdb/Serializer;", "Ljava/util/SortedMap;", "", "getNAME_CATALOG_SERIALIZER", "()Lorg/mapdb/Serializer;", "shutdownHookInstalled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "shutdownHooks", "", "kotlin.jvm.PlatformType", "", "addShutdownHook", "", "ref", "mapdb"})
    public static final class Companion {
        @NotNull
        protected final Serializer<SortedMap<String, String>> getNAME_CATALOG_SERIALIZER() {
            return NAME_CATALOG_SERIALIZER;
        }

        protected final int getNAMED_SERIALIZATION_HEADER() {
            return NAMED_SERIALIZATION_HEADER;
        }

        protected final void addShutdownHook(@NotNull Object ref) {
            Intrinsics.checkParameterIsNotNull(ref, "ref");
            if (shutdownHookInstalled.compareAndSet(false, true)) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        Collection $receiver$iv;
                        Collection collection = $receiver$iv = (Collection)DB.access$getShutdownHooks$cp().keySet();
                        if (collection == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                        }
                        Collection thisCollection$iv = collection;
                        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                        if (objectArray == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        for (Object o : objectArray) {
                            try {
                                Object a = o;
                                if (a instanceof Reference) {
                                    a = ((Reference)a).get();
                                }
                                if (!(a instanceof DB)) continue;
                                ((DB)a).close();
                            }
                            catch (Throwable e) {
                                Utils.INSTANCE.getLOG().log(Level.SEVERE, "DB.close() thrown exception in shutdown hook.", e);
                            }
                        }
                    }
                });
            }
            shutdownHooks.put(ref, ref);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

