/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongProgression;
import kotlin.ranges.RangesKt;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.StoreWAL;
import org.mapdb.Utils;
import org.mapdb.volume.Volume;
import org.mapdb.volume.VolumeFactory;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001BG\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010N\u001a\u00020\u001e2\u0006\u0010O\u001a\u00020\t2\u0006\u0010P\u001a\u00020\u0007H\u0004J\b\u0010Q\u001a\u00020\u001eH$J\b\u0010R\u001a\u00020\u001eH$J\b\u0010S\u001a\u00020\u001eH\u0004J\b\u0010T\u001a\u00020UH\u0004J\u0006\u0010V\u001a\u00020\u001eJ\u0006\u0010W\u001a\u00020\tJ3\u0010X\u001a\u0004\u0018\u0001HY\"\u0004\b\u0000\u0010Y2\f\u0010Z\u001a\b\u0012\u0004\u0012\u0002HY0[2\u0006\u0010\\\u001a\u00020]2\u0006\u0010O\u001a\u00020\u001eH\u0004\u00a2\u0006\u0002\u0010^J\b\u0010_\u001a\u00020UH\u0004J\b\u0010`\u001a\u00020\u001eH\u0004J\u0010\u0010a\u001a\u00020U2\u0006\u0010b\u001a\u00020\u001eH$J\u0010\u0010c\u001a\u00020\u001e2\u0006\u0010d\u001a\u00020\u001eH$J0\u0010e\u001a\u00020\u001e2\u0006\u0010O\u001a\u00020\u001e2\u0006\u0010f\u001a\u00020\u001e2\u0006\u0010g\u001a\u00020\t2\u0006\u0010h\u001a\u00020\t2\u0006\u0010i\u001a\u00020\tH\u0004J\u0010\u0010j\u001a\u00020\u00072\u0006\u0010k\u001a\u00020\u001eH\u0004J\u0010\u0010l\u001a\u00020\u00072\u0006\u0010k\u001a\u00020\u001eH\u0004J\u0010\u0010m\u001a\u00020\u00072\u0006\u0010k\u001a\u00020\u001eH\u0004J\u0010\u0010n\u001a\u00020U2\u0006\u00102\u001a\u000203H\u0004J\u0010\u0010o\u001a\u00020\u001e2\u0006\u0010O\u001a\u00020\u001eH\u0004J \u0010p\u001a\u00020U2\u0006\u0010q\u001a\u00020\u001e2\u0006\u0010r\u001a\u00020\u001e2\u0006\u0010P\u001a\u00020\u0007H$J\u0018\u0010s\u001a\u00020\u001e2\u0006\u0010q\u001a\u00020\u001e2\u0006\u0010P\u001a\u00020\u0007H$J\u0010\u0010t\u001a\u00020\u001e2\u0006\u0010u\u001a\u00020\u001eH\u0004J\u0010\u0010v\u001a\u00020\t2\u0006\u0010d\u001a\u00020\u001eH\u0004J \u0010w\u001a\u00020U2\u0006\u0010O\u001a\u00020\u001e2\u0006\u0010f\u001a\u00020\u001e2\u0006\u0010P\u001a\u00020\u0007H\u0004J\u0010\u0010x\u001a\u00020U2\u0006\u0010d\u001a\u00020\u001eH\u0004J-\u0010y\u001a\u0004\u0018\u00010z\"\u0004\b\u0000\u0010Y2\b\u0010{\u001a\u0004\u0018\u0001HY2\f\u0010Z\u001a\b\u0012\u0004\u0012\u0002HY0[H\u0004\u00a2\u0006\u0002\u0010|J\u0018\u0010}\u001a\u00020U2\u0006\u0010d\u001a\u00020\u001e2\u0006\u0010r\u001a\u00020\u001eH$J\u0006\u0010~\u001a\u00020\tR\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR$\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e8D@DX\u0084\u000e\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0010R\u001a\u0010'\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0010\"\u0004\b)\u0010*R$\u0010+\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010!\"\u0004\b-\u0010#R\u0012\u0010.\u001a\u00020/X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u001c\u00102\u001a\n 4*\u0004\u0018\u00010303X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010R\u001e\u00108\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001809X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010<\u001a\u0004\b:\u0010;R$\u0010=\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e8D@DX\u0084\u000e\u00a2\u0006\f\u001a\u0004\b>\u0010!\"\u0004\b?\u0010#R\u0014\u0010@\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u001cR\u0014\u0010B\u001a\u00020\u001eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010!R\u0016\u0010D\u001a\u0004\u0018\u00010EX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0012\u0010H\u001a\u00020/X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u00101R\u0014\u0010J\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010M\u00a8\u0006\u007f"}, d2={"Lorg/mapdb/StoreDirectAbstract;", "Lorg/mapdb/Store;", "file", "", "volumeFactory", "Lorg/mapdb/volume/VolumeFactory;", "isThreadSafe", "", "concShift", "", "fileDeleteAfterClose", "checksum", "checksumHeader", "checksumHeaderBypass", "(Ljava/lang/String;Lorg/mapdb/volume/VolumeFactory;ZIZZZZ)V", "getChecksum", "()Z", "getChecksumHeader", "getChecksumHeaderBypass", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getClosed", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "compactionLock", "Ljava/util/concurrent/locks/ReadWriteLock;", "getCompactionLock", "()Ljava/util/concurrent/locks/ReadWriteLock;", "getConcShift", "()I", "v", "", "dataTail", "getDataTail", "()J", "setDataTail", "(J)V", "getFile", "()Ljava/lang/String;", "getFileDeleteAfterClose", "fileSyncDisable", "getFileSyncDisable$mapdb", "setFileSyncDisable$mapdb", "(Z)V", "fileTail", "getFileTail$mapdb", "setFileTail$mapdb", "headVol", "Lorg/mapdb/volume/Volume;", "getHeadVol", "()Lorg/mapdb/volume/Volume;", "indexPages", "Lorg/eclipse/collections/api/list/primitive/MutableLongList;", "kotlin.jvm.PlatformType", "getIndexPages", "()Lorg/eclipse/collections/api/list/primitive/MutableLongList;", "isClosed", "locks", "", "getLocks", "()[Ljava/util/concurrent/locks/ReadWriteLock;", "[Ljava/util/concurrent/locks/ReadWriteLock;", "maxRecid", "getMaxRecid", "setMaxRecid", "segmentCount", "getSegmentCount", "segmentMask", "getSegmentMask", "structuralLock", "Ljava/util/concurrent/locks/Lock;", "getStructuralLock", "()Ljava/util/concurrent/locks/Lock;", "volume", "getVolume", "volumeExistsAtStart", "getVolumeExistsAtStart", "getVolumeFactory", "()Lorg/mapdb/volume/VolumeFactory;", "allocateData", "size", "recursive", "allocateNewIndexPage", "allocateNewPage", "allocateRecid", "assertNotClosed", "", "calculateChecksum", "calculateHeaderChecksum", "deserialize", "R", "serializer", "Lorg/mapdb/Serializer;", "di", "Lorg/mapdb/DataInput2;", "(Lorg/mapdb/Serializer;Lorg/mapdb/DataInput2;J)Ljava/lang/Object;", "fileHeaderCheck", "fileHeaderCompose", "freeSizeIncrement", "increment", "getIndexVal", "recid", "indexValCompose", "offset", "linked", "unused", "archive", "indexValFlagArchive", "indexValue", "indexValFlagLinked", "indexValFlagUnused", "loadIndexPages", "longStackMasterLinkOffset", "longStackPut", "masterLinkOffset", "value", "longStackTake", "recidToOffset", "recid2", "recidToSegment", "releaseData", "releaseRecid", "serialize", "Lorg/mapdb/DataOutput2;", "record", "(Ljava/lang/Object;Lorg/mapdb/Serializer;)Lorg/mapdb/DataOutput2;", "setIndexVal", "storeHeaderCompose", "mapdb"})
public abstract class StoreDirectAbstract
implements Store {
    private final int segmentCount;
    private final long segmentMask;
    @NotNull
    private final ReadWriteLock[] locks;
    @Nullable
    private final Lock structuralLock;
    @Nullable
    private final ReadWriteLock compactionLock;
    private boolean fileSyncDisable;
    private final boolean volumeExistsAtStart;
    private final MutableLongList indexPages;
    @NotNull
    private final AtomicBoolean closed;
    @Nullable
    private final String file;
    @NotNull
    private final VolumeFactory volumeFactory;
    private final boolean isThreadSafe;
    private final int concShift;
    private final boolean fileDeleteAfterClose;
    private final boolean checksum;
    private final boolean checksumHeader;
    private final boolean checksumHeaderBypass;

    @NotNull
    protected abstract Volume getVolume();

    @NotNull
    protected abstract Volume getHeadVol();

    protected final int getSegmentCount() {
        return this.segmentCount;
    }

    protected final long getSegmentMask() {
        return this.segmentMask;
    }

    @NotNull
    protected final ReadWriteLock[] getLocks() {
        return this.locks;
    }

    @Nullable
    protected final Lock getStructuralLock() {
        return this.structuralLock;
    }

    @Nullable
    protected final ReadWriteLock getCompactionLock() {
        return this.compactionLock;
    }

    public final boolean getFileSyncDisable$mapdb() {
        return this.fileSyncDisable;
    }

    public final void setFileSyncDisable$mapdb(boolean bl) {
        this.fileSyncDisable = bl;
    }

    protected final boolean getVolumeExistsAtStart() {
        return this.volumeExistsAtStart;
    }

    protected final MutableLongList getIndexPages() {
        return this.indexPages;
    }

    protected final long recidToOffset(long recid2) {
        long recid3 = recid2 - 1L;
        if (recid3 < 126962L) {
            return 32880L + recid3 * (long)8;
        }
        long pageNum = (recid3 -= 126962L) / 131070L;
        return this.indexPages.get((int)pageNum) + (long)16 + recid3 % 131070L * (long)8;
    }

    @NotNull
    protected final AtomicBoolean getClosed() {
        return this.closed;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    protected final void assertNotClosed() {
        if (this.closed.get()) {
            throw (Throwable)new IllegalAccessError("Store was closed");
        }
    }

    protected final long getDataTail() {
        return DataIO.parity4Get(this.getHeadVol().getLong(24L));
    }

    protected final void setDataTail(long v) {
        if (v % (long)16 != 0L) {
            throw (Throwable)new DBException.DataCorruption("unaligned data tail");
        }
        Utils.INSTANCE.assertLocked(this.structuralLock);
        this.getHeadVol().putLong(24L, DataIO.parity4Set(v));
    }

    protected final long getMaxRecid() {
        return DataIO.parity3Get(this.getHeadVol().getLong(32L)) >>> 3;
    }

    protected final void setMaxRecid(long v) {
        Utils.INSTANCE.assertLocked(this.structuralLock);
        this.getHeadVol().putLong(32L, DataIO.parity3Set(v << 3));
    }

    public final long getFileTail$mapdb() {
        return DataIO.parity16Get(this.getHeadVol().getLong(40L));
    }

    public final void setFileTail$mapdb(long v) {
        Utils.INSTANCE.assertLocked(this.structuralLock);
        this.getHeadVol().putLong(40L, DataIO.parity16Set(v));
    }

    protected final void fileHeaderCheck() {
        int featBits;
        long header = this.getHeadVol().getLong(0L);
        if (header >>> 56 != 74L) {
            throw (Throwable)new DBException.WrongFormat("Wrong file header, not MapDB file");
        }
        if ((header >>> 48 & 0xFFL) != 3L) {
            throw (Throwable)new DBException.WrongFormat("Wrong file header, not StoreDirect file");
        }
        if ((header >>> 32 & 0xFFFFL) != 0L) {
            throw (Throwable)new DBException.NewMapDBFormat("Store was created with newer version of MapDB, some new features are not supported");
        }
        if (this.getHeadVol().getInt(20L) != this.calculateHeaderChecksum()) {
            String msg = "Header checksum broken. Store was not closed correctly and might be corrupted. Use `DBMaker.checksumHeaderBypass()` to recover your data. Use clean shutdown or enable transactions to protect the store in the future.";
            if (this.checksumHeaderBypass) {
                Utils.INSTANCE.getLOG().warning(new Supplier<String>(msg){
                    final /* synthetic */ String $msg;

                    @NotNull
                    public final String get() {
                        return this.$msg;
                    }
                    {
                        this.$msg = string;
                    }
                });
            } else {
                throw (Throwable)new DBException.DataCorruption(msg);
            }
        }
        if (((int)header >>> 0 & 1) != 0) {
            throw (Throwable)new DBException.WrongConfiguration("Store is encrypted, but no encryption method was provided");
        }
        int checksumFeature = (int)header >>> 1 & 3;
        if (checksumFeature == 0 && this.checksum) {
            throw (Throwable)new DBException.WrongConfiguration("Store was created without checksum, but checksum is enabled in configuration");
        }
        if (checksumFeature == 1 && !this.checksum) {
            throw (Throwable)new DBException.WrongConfiguration("Store was created without checksum, but checksum is not enabled in configuration");
        }
        if (checksumFeature > 1) {
            throw (Throwable)new DBException.NewMapDBFormat("This version of MapDB does not support new checksum type used in store");
        }
        if (checksumFeature != 0 && this instanceof StoreWAL) {
            throw (Throwable)new DBException.WrongConfiguration("StoreWAL does not support checksum");
        }
        long checksumFromHeader = this.getHeadVol().getLong(8L);
        if (this.checksum) {
            if (this.calculateChecksum() != checksumFromHeader) {
                throw (Throwable)new DBException.DataCorruption("Wrong checksum in header");
            }
        } else if (1L != checksumFromHeader) {
            throw (Throwable)new DBException.DataCorruption("Checksum is disabled, expected 1, got something else");
        }
        if ((featBits = this.getHeadVol().getInt(4L)) >>> 3 != 0) {
            throw (Throwable)new DBException.NewMapDBFormat("Header indicates feature not supported in older version of MapDB");
        }
        int storeFeatBits = this.getHeadVol().getInt(16L);
        if (storeFeatBits >>> 1 != 0) {
            throw (Throwable)new DBException.NewMapDBFormat("Store header indicates feature not supported in older version of MapDB");
        }
        if ((storeFeatBits & 1) == 0 && this.checksumHeader) {
            throw (Throwable)new DBException.WrongConfiguration("Store header checksum, disabled in store, but enabled in configuration");
        }
        if ((storeFeatBits & 1) == 1 && !this.checksumHeader) {
            throw (Throwable)new DBException.WrongConfiguration("Store header checksum enabled in store, but disabled in configuration");
        }
    }

    protected final long fileHeaderCompose() {
        long checksumFlag = this.checksum ? 1L << 1 : 0L;
        return 5333106383736799232L + checksumFlag;
    }

    public final int storeHeaderCompose() {
        return 0 + (this.checksumHeader ? 1 : 0);
    }

    protected abstract long getIndexVal(long var1);

    protected abstract void setIndexVal(long var1, long var3);

    protected final void loadIndexPages(@NotNull MutableLongList indexPages) {
        long nextPage;
        Intrinsics.checkParameterIsNotNull(indexPages, "indexPages");
        long indexPagePointerOffset = 32864L;
        while ((nextPage = DataIO.parity16Get(this.getVolume().getLong(indexPagePointerOffset))) != 0L) {
            if (nextPage % 0x100000L != 0L) {
                throw (Throwable)new DBException.DataCorruption("wrong page pointer");
            }
            indexPages.add(nextPage);
            indexPagePointerOffset = nextPage + (long)8;
        }
    }

    protected final long indexValCompose(long size2, long offset, int linked, int unused, int archive) {
        if (size2 < 0L || size2 > (long)65535) {
            throw (Throwable)((Object)new AssertionError());
        }
        if (offset % (long)16 != 0L) {
            throw (Throwable)new DBException.DataCorruption("unaligned offset");
        }
        if ((offset & 0xFFFFFFFFFFF0L) != offset) {
            throw (Throwable)new DBException.DataCorruption("unaligned offset");
        }
        int n = linked;
        if (!(0 <= n && 1 >= n)) {
            throw (Throwable)((Object)new AssertionError());
        }
        n = archive;
        if (!(0 <= n && 1 >= n)) {
            throw (Throwable)((Object)new AssertionError());
        }
        n = unused;
        if (!(0 <= n && 1 >= n)) {
            throw (Throwable)((Object)new AssertionError());
        }
        return (size2 << 48) + offset + (long)linked * 8L + (long)unused * 4L + (long)archive * 2L;
    }

    protected final boolean indexValFlagLinked(long indexValue) {
        return (indexValue & 8L) != 0L;
    }

    protected final boolean indexValFlagUnused(long indexValue) {
        return (indexValue & 4L) != 0L;
    }

    protected final boolean indexValFlagArchive(long indexValue) {
        return (indexValue & 2L) != 0L;
    }

    protected final int recidToSegment(long recid2) {
        return (int)(recid2 & this.segmentMask);
    }

    @Nullable
    protected final <R> R deserialize(@NotNull Serializer<R> serializer, @NotNull DataInput2 di, long size2) {
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        Intrinsics.checkParameterIsNotNull(di, "di");
        try {
            R ret2 = serializer.deserialize(di, (int)size2);
            return ret2;
        }
        catch (IOException e) {
            throw (Throwable)new DBException.SerializationError(e);
        }
    }

    @Nullable
    protected final <R> DataOutput2 serialize(@Nullable R record, @NotNull Serializer<R> serializer) {
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        if (record == null) {
            return null;
        }
        try {
            DataOutput2 out = new DataOutput2();
            serializer.serialize(out, record);
            return out;
        }
        catch (IOException e) {
            throw (Throwable)new DBException.SerializationError(e);
        }
    }

    protected final long allocateRecid() {
        Utils.INSTANCE.assertLocked(this.structuralLock);
        long reusedRecid = this.longStackTake(64L, false);
        if (reusedRecid != 0L) {
            return DataIO.parity1Get(reusedRecid) >>> 1;
        }
        long maxRecid2 = this.getMaxRecid();
        long maxRecidOffset = this.recidToOffset(maxRecid2);
        if (maxRecidOffset % 0x100000L == 1048568L) {
            this.allocateNewIndexPage();
        }
        long ret2 = maxRecid2 + 1L;
        this.setMaxRecid(ret2);
        return ret2;
    }

    protected abstract long allocateNewIndexPage();

    protected final long allocateData(int size2, boolean recursive) {
        long reusedDataOffset;
        Utils.INSTANCE.assertLocked(this.structuralLock);
        if ((long)size2 > 65520L) {
            throw (Throwable)((Object)new AssertionError());
        }
        if (size2 <= 0) {
            throw (Throwable)((Object)new AssertionError());
        }
        if (size2 % 16 != 0) {
            throw (Throwable)((Object)new AssertionError());
        }
        long l = reusedDataOffset = recursive ? 0L : this.longStackTake(this.longStackMasterLinkOffset(size2), recursive);
        if (reusedDataOffset != 0L) {
            long reusedDataOffset2 = DataIO.parity1Get(reusedDataOffset) << 3;
            if (reusedDataOffset2 % (long)16 != 0L) {
                throw (Throwable)new DBException.DataCorruption("wrong offset");
            }
            this.freeSizeIncrement(-((long)size2));
            return reusedDataOffset2;
        }
        long dataTail2 = this.getDataTail();
        if (dataTail2 == 0L) {
            long page = this.allocateNewPage();
            this.setDataTail(page + (long)size2);
            if (page % (long)16 != 0L) {
                throw (Throwable)new DBException.DataCorruption("wrong offset");
            }
            return page;
        }
        if (dataTail2 % 0x100000L + (long)size2 <= 0x100000L) {
            this.setDataTail((dataTail2 + (long)size2) % 0x100000L == 0L ? 0L : dataTail2 + (long)size2);
            if (dataTail2 % (long)16 != 0L) {
                throw (Throwable)new DBException.DataCorruption("wrong offset");
            }
            return dataTail2;
        }
        this.setDataTail(0L);
        long remSize = 0x100000L - dataTail2 % 0x100000L;
        if (remSize != 0L) {
            this.releaseData(remSize, dataTail2, recursive);
        }
        return this.allocateData(size2, recursive);
    }

    protected final void releaseData(long size2, long offset, boolean recursive) {
        Utils.INSTANCE.assertLocked(this.structuralLock);
        if (size2 % (long)16 != 0L) {
            throw (Throwable)((Object)new AssertionError());
        }
        if (size2 > 65520L) {
            throw (Throwable)((Object)new AssertionError());
        }
        this.freeSizeIncrement(size2);
        long offset2 = DataIO.parity1Set(offset >>> 3);
        this.longStackPut(this.longStackMasterLinkOffset(size2), offset2, recursive);
    }

    protected final void releaseRecid(long recid2) {
        this.longStackPut(64L, DataIO.parity1Set(recid2 << 1), false);
    }

    protected abstract void freeSizeIncrement(long var1);

    protected abstract void longStackPut(long var1, long var3, boolean var5);

    protected abstract long longStackTake(long var1, boolean var3);

    protected final long longStackMasterLinkOffset(long size2) {
        if (size2 % (long)16 != 0L) {
            throw (Throwable)((Object)new AssertionError());
        }
        if (size2 > 65520L) {
            throw (Throwable)((Object)new AssertionError());
        }
        return size2 / (long)2 + 64L;
    }

    protected abstract long allocateNewPage();

    public final long calculateChecksum() {
        long checksum = this.getVolume().getLong(0L) + this.getVolume().hash(16L, this.getFileTail$mapdb() - (long)16, 0L);
        if (checksum == 0L || checksum == 1L) {
            checksum = 2L;
        }
        return checksum;
    }

    /*
     * WARNING - void declaration
     */
    public final int calculateHeaderChecksum() {
        if (!this.checksumHeader) {
            return 0;
        }
        int c = 1142099053;
        LongProgression longProgression = RangesKt.step(RangesKt.until(24, 32864L), 4L);
        long l = longProgression.getFirst();
        long l2 = longProgression.getLast();
        long l3 = longProgression.getStep();
        long l4 = l;
        long l5 = l2;
        if (l3 > 0L ? l4 <= l5 : l4 >= l5) {
            while (true) {
                void offset;
                c += this.getHeadVol().getInt((long)offset);
                if (offset == l2) break;
                l = offset + l3;
            }
        }
        return c;
    }

    @Nullable
    public final String getFile() {
        return this.file;
    }

    @NotNull
    public final VolumeFactory getVolumeFactory() {
        return this.volumeFactory;
    }

    @Override
    public boolean isThreadSafe() {
        return this.isThreadSafe;
    }

    public final int getConcShift() {
        return this.concShift;
    }

    public final boolean getFileDeleteAfterClose() {
        return this.fileDeleteAfterClose;
    }

    public final boolean getChecksum() {
        return this.checksum;
    }

    public final boolean getChecksumHeader() {
        return this.checksumHeader;
    }

    public final boolean getChecksumHeaderBypass() {
        return this.checksumHeaderBypass;
    }

    /*
     * WARNING - void declaration
     */
    public StoreDirectAbstract(@Nullable String file, @NotNull VolumeFactory volumeFactory, boolean isThreadSafe, int concShift, boolean fileDeleteAfterClose, boolean checksum, boolean checksumHeader, boolean checksumHeaderBypass) {
        ReadWriteLock[] readWriteLockArray;
        void size$iv;
        Intrinsics.checkParameterIsNotNull(volumeFactory, "volumeFactory");
        this.file = file;
        this.volumeFactory = volumeFactory;
        this.isThreadSafe = isThreadSafe;
        this.concShift = concShift;
        this.fileDeleteAfterClose = fileDeleteAfterClose;
        this.checksum = checksum;
        this.checksumHeader = checksumHeader;
        this.checksumHeaderBypass = checksumHeaderBypass;
        this.segmentCount = 1 << this.concShift;
        this.segmentMask = (1L << this.concShift) - 1L;
        int n = this.segmentCount;
        StoreDirectAbstract storeDirectAbstract = this;
        ReadWriteLock[] result$iv = new ReadWriteLock[size$iv];
        int n2 = 0;
        int n3 = result$iv.length;
        while (n2 < n3) {
            ReadWriteLock readWriteLock;
            void i$iv;
            void var13_14 = i$iv;
            void var18_16 = i$iv++;
            readWriteLockArray = result$iv;
            readWriteLockArray[var18_16] = readWriteLock = Utils.INSTANCE.newReadWriteLock(this.isThreadSafe());
        }
        readWriteLockArray = result$iv;
        storeDirectAbstract.locks = readWriteLockArray;
        this.structuralLock = Utils.INSTANCE.newLock(this.isThreadSafe());
        this.compactionLock = Utils.INSTANCE.newReadWriteLock(this.isThreadSafe());
        this.volumeExistsAtStart = this.volumeFactory.exists(this.file);
        this.indexPages = this.isThreadSafe() ? new LongArrayList().asSynchronized() : (MutableLongList)new LongArrayList();
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public void checkThreadSafe() {
        Store.DefaultImpls.checkThreadSafe(this);
    }
}

