/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Arrays;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;

public class SerializerByteArrayNoSize
implements Serializer<byte[]> {
    @Override
    public void serialize(DataOutput2 out, byte[] value) throws IOException {
        out.write(value);
    }

    @Override
    public byte[] deserialize(DataInput2 in, int available) throws IOException {
        byte[] ret2 = new byte[available];
        in.readFully(ret2);
        return ret2;
    }

    @Override
    public boolean isTrusted() {
        return true;
    }

    @Override
    public boolean equals(byte[] a1, byte[] a2) {
        return Arrays.equals(a1, a2);
    }

    @Override
    public int hashCode(byte[] bytes, int seed) {
        return BYTE_ARRAY.hashCode(bytes, seed);
    }

    @Override
    public boolean needsAvailableSizeHint() {
        return true;
    }

    @Override
    public int compare(byte[] o1, byte[] o2) {
        if (o1 == o2) {
            return 0;
        }
        int len = Math.min(o1.length, o2.length);
        for (int i = 0; i < len; ++i) {
            int b1 = o1[i] & 0xFF;
            int b2 = o2[i] & 0xFF;
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return o1.length - o2.length;
    }
}

