/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sesim.Asset;
import sesim.AutoTraderInterface;
import sesim.Market;
import sesim.Order;
import sesim.Position;

public class Account {
    private final Market defaultMarket;
    private final Asset currency = null;
    private Market.AccountListener listener = null;
    long cash;
    long initial_shares;
    long initial_money;
    long initial_equity;
    protected AutoTraderInterface owner;
    final ConcurrentHashMap<Long, Order> orders;
    private final HashMap<Asset, Position> positions;
    private HashMap<Asset, Position> snap_positions = new HashMap();
    private long snap_cash;
    boolean isLiquided = false;

    void makeSnapShot() {
        this.snap_positions = new HashMap();
        for (Asset a : this.positions.keySet()) {
            Position p = new Position(this.positions.get(a));
            this.snap_positions.put(a, p);
        }
        this.snap_cash = this.cash;
    }

    Account(Market se, float money, float shares) {
        this.defaultMarket = se;
        this.orders = new ConcurrentHashMap();
        this.positions = new HashMap();
        this.initial_money = this.cash = (long)(money * se.money_df);
        this.initial_shares = (long)(shares * se.shares_df);
        this.initial_equity = this.getEquity_Long();
    }

    public Map<Asset, Position> getPositions() {
        return Collections.unmodifiableMap(this.positions);
    }

    void cancelAllOrders() {
        for (Order o : this.orders.values()) {
            o.getMarket().cancelOrder(this, o.id);
        }
    }

    public long getMarginUsed_Long() {
        long totalMargin = 0L;
        for (Position pos : this.positions.values()) {
            totalMargin += pos.getMargin_Long();
        }
        return totalMargin;
    }

    public float getMarginUsed() {
        return (float)this.getMarginUsed_Long() / this.defaultMarket.money_df;
    }

    public float getShares() {
        return (float)this.getPosition((Asset)this.defaultMarket).shares / this.defaultMarket.shares_df;
    }

    public float getInitialShares() {
        return (float)this.initial_shares / this.defaultMarket.shares_df;
    }

    public long getShares_Long() {
        return this.getPosition((Asset)this.defaultMarket).shares;
    }

    public float getMoney() {
        return (float)this.cash / this.defaultMarket.money_df;
    }

    public float getInitialMoney() {
        return (float)this.initial_money / this.defaultMarket.money_df;
    }

    public long getMoney_Long() {
        return this.cash;
    }

    public AutoTraderInterface getOwner() {
        return this.owner;
    }

    public Map<Long, Order> getOrders() {
        return Collections.unmodifiableMap(this.orders);
    }

    public void setListener(Market.AccountListener al) {
        this.listener = al;
    }

    public void update(Order o) {
        if (this.listener == null) {
            return;
        }
        this.listener.accountUpdated(this, o);
    }

    public int getNumberOfOpenOrders() {
        return this.orders.size();
    }

    public long getCashInOpenOrders_Long(long exclude) {
        Iterator<Map.Entry<Long, Order>> it = this.getOrders().entrySet().iterator();
        long orderCash = 0L;
        while (it.hasNext()) {
            Map.Entry<Long, Order> e = it.next();
            Order o = e.getValue();
            if (!o.isBuy() || !o.hasLimit() || o.id == exclude) continue;
            orderCash = (long)((float)orderCash + (o.getInitialVolume() - (float)o.getExecuted_Long()) * (float)o.getLimit_Long());
        }
        return orderCash;
    }

    public long getCashInOpenOrders_Long() {
        return this.getCashInOpenOrders_Long(-1L);
    }

    public float getCashInOpenOrders() {
        return (float)this.getCashInOpenOrders_Long() / this.defaultMarket.money_df;
    }

    public long getSharesInOpenOrders_Long(long exclude) {
        Iterator<Map.Entry<Long, Order>> it = this.getOrders().entrySet().iterator();
        long volume2 = 0L;
        while (it.hasNext()) {
            Map.Entry<Long, Order> e = it.next();
            Order o = e.getValue();
            if (!o.isSell() || o.id == exclude) continue;
            volume2 = (long)((float)volume2 + (o.getInitialVolume() - o.getExecuted()));
        }
        return volume2;
    }

    public long getSharesInOpenOrders_Long() {
        return this.getSharesInOpenOrders_Long(-1L);
    }

    public float getSharesInOpenOrders() {
        return (float)this.getSharesInOpenOrders_Long() / this.defaultMarket.shares_df;
    }

    public float getSharesAvailable() {
        return this.getShares() - this.getSharesInOpenOrders();
    }

    public long getCashAvailabale_Long() {
        return this.cash;
    }

    public float getCashAvailable() {
        return this.getMoney() - this.getCashInOpenOrders();
    }

    public Order getOrderByID(long oid) {
        return this.orders.get(oid);
    }

    public boolean isOrderCovered_Long(Position p, long volume2, long price, int leverage) {
        long cashNeeded = p.getRequiredCashForOrder_Long(volume2, price, leverage);
        return (float)cashNeeded <= this.getFreeMargin();
    }

    public boolean isOrderCovered_Long(Market se, long volume2, long price, int leverage) {
        return this.isOrderCovered_Long(this.getPosition(se), volume2, price, leverage);
    }

    public boolean isOrderCovered(Market se, float volume2, float price, int leverage) {
        return this.isOrderCovered_Long(this.getPosition(se), (long)(volume2 * se.shares_df), (long)(price * se.money_df), leverage);
    }

    public float getRequiredCashForOrder(Market se, float volume2, float price, int leverage) {
        return (float)this.getPosition(se).getRequiredCashForOrder_Long((long)(volume2 * se.shares_df), (long)(price * se.money_df), leverage) / se.money_df;
    }

    public Market getDefaultMarket() {
        return this.defaultMarket;
    }

    public float getPerformance(float lastPrice) {
        float total = this.getEquity();
        float iniTotal = this.getSnapShotEquity();
        return total / (iniTotal / 100.0f) - 100.0f;
    }

    public final long getEquity_Long() {
        long equity = this.cash;
        for (Position pos : this.positions.values()) {
            equity += pos.getEquityValue_Long();
        }
        return equity;
    }

    float getCash() {
        return (float)this.cash / this.defaultMarket.money_df;
    }

    public float getEquity() {
        return (float)this.getEquity_Long() / this.defaultMarket.money_df;
    }

    public final long getSnapshotEquity_Long() {
        long equity = this.snap_cash;
        for (Position pos : this.snap_positions.values()) {
            equity += pos.getEquityValue_Long();
        }
        return equity;
    }

    public float getSnapShotEquity() {
        return (float)this.getSnapshotEquity_Long() / this.defaultMarket.money_df;
    }

    public long getFreeMargin_Long() {
        return this.getEquity_Long() - this.getMarginUsed_Long();
    }

    public float getFreeMargin() {
        return (float)this.getFreeMargin_Long() / this.defaultMarket.money_df;
    }

    Position createPosition() {
        return null;
    }

    public final Position getPosition(Asset asset) {
        Position p = this.positions.get(asset);
        if (p != null) {
            return p;
        }
        p = new Position(asset, this);
        this.positions.put(asset, p);
        return p;
    }

    public boolean isLiquidated() {
        return this.isLiquided;
    }

    void calculateLiquidationStops(long lastPrice) {
        if (this.isLiquided) {
            return;
        }
        long currentEquity = this.getEquity_Long();
        long totalUsedMargin = this.getMarginUsed_Long();
        long criticalEquity = 1000L;
        long lMax_additional = currentEquity - criticalEquity;
        if (lMax_additional <= 0L) {
            return;
        }
        double totalAbsoluteVolumeSum = 0.0;
        for (Position p : this.positions.values()) {
            totalAbsoluteVolumeSum += (double)((float)lastPrice / p.asset.getMarket().money_df * (float)Math.abs(p.getShares_Long()));
        }
        for (Position p : this.positions.values()) {
            double positionVolume = p.asset.getMarket().getLastPrice() * (float)Math.abs(p.getShares_Long());
            double weight = positionVolume / totalAbsoluteVolumeSum;
            long toleratedLoss_i_long = (long)((double)lMax_additional * weight);
            long shares = Math.abs(p.getShares_Long());
            if (shares == 0L) continue;
            double lossPerShare_double = (double)toleratedLoss_i_long / (double)shares / 100.0;
            double currentPrice = (float)lastPrice / p.asset.getMarket().money_df;
            double stopPrice = p.isShort() ? currentPrice + lossPerShare_double : currentPrice - lossPerShare_double;
            p.setStopPrice((long)(stopPrice * (double)this.defaultMarket.money_df));
        }
    }
}

