/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.io.FileNotFoundException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONObject;
import sesim.Account;
import sesim.Asset;
import sesim.OHLCData;
import sesim.Order;
import sesim.OrderBookEntry;
import sesim.Position;
import sesim.Quote;
import sesim.Scheduler;
import sesim.Sim;
import sesim.TradingLogReader;
import sesim.TradingLogWriter;

public class Market
implements Asset {
    public float money_df = 100.0f;
    private int money_decimals = 2;
    DecimalFormat money_formatter = this.getFormatter(2);
    public float shares_df = 1.0f;
    private int shares_decimals = 0;
    private DecimalFormat shares_formatter = this.getFormatter(0);
    int minOHLCBarDuration = 1000;
    HashMap<Integer, OHLCData> ohlcByTimeFrameLength = new HashMap();
    TradingLogReader tradingLogReader = null;
    SortedSet bidBook;
    SortedSet askBook;
    SortedSet marketBidBook;
    SortedSet marketAskBook;
    SortedSet stopBuyBook;
    SortedSet stopSellBook;
    SortedSet liquidationsShort;
    SortedSet liquidationsLong;
    SortedSet priceEventsAbove;
    SortedSet priceEventsBelow;
    private String tradingLogFileName = null;
    Sim sim;
    final Executor executor = new Executor();
    public final String CFG_MONEY_DECIMALS = "money_decimals";
    public final String CFG_SHARES_DECIMALS = "shares_decimals";
    public final String CFG_AUTO_INITIAL_PRICE = "auto_initial_price";
    public final String CFG_INITIAL_PRICE = "initial_price";
    private final Set<BookListener> askBookListeners = ConcurrentHashMap.newKeySet();
    private final Set<BookListener> bidBookListeners = ConcurrentHashMap.newKeySet();
    private final Set<BookListener> ulAskBookListeners = ConcurrentHashMap.newKeySet();
    private final Set<BookListener> ulBidBookListeners = ConcurrentHashMap.newKeySet();
    private final Set<BookListener> stopBuyBookListeners = ConcurrentHashMap.newKeySet();
    private final Set<BookListener> stopSellBookListeners = ConcurrentHashMap.newKeySet();
    private final List<QuoteReceiver> quoteReceiverList = new CopyOnWriteArrayList<QuoteReceiver>();
    Quote lastQuote;
    private long fairValue = 0L;
    String symbol = "RBTN";
    long numTrades = 0L;
    long numOrders = 0L;
    long priceLow = 0L;
    long priceHigh = 0L;
    long t_lastPrice = 0L;
    TradingLogWriter tradingLog;
    boolean logging = false;

    public void setMoneyDecimals(int n) {
        this.money_df = (float)Math.pow(10.0, n);
        this.money_decimals = n;
        this.money_formatter = this.getFormatter(n);
    }

    @Override
    public float getDf() {
        return this.shares_df;
    }

    public int getMoneyDecimals() {
        return this.money_decimals;
    }

    public int getSharesDecimals() {
        return this.shares_decimals;
    }

    public void setSharesDecimals(int n) {
        this.shares_df = (float)Math.pow(10.0, n);
        this.shares_decimals = n;
        this.shares_formatter = this.getFormatter(n);
    }

    public float roundToDecimals(double val, double f) {
        return (float)(Math.floor(val * f) / f);
    }

    public float roundShares(double shares) {
        return this.roundToDecimals(shares, this.shares_df);
    }

    public float roundMoney(double money) {
        return this.roundToDecimals(money, this.money_df);
    }

    public DecimalFormat getFormatter(int n) {
        String s = "#0.";
        if (n == 0) {
            s = "#";
        } else {
            for (int i = 0; i < n; ++i) {
                s = s + "0";
            }
        }
        return new DecimalFormat(s);
    }

    public DecimalFormat getMoneyFormatter() {
        return this.money_formatter;
    }

    public DecimalFormat getSharesFormatter() {
        return this.shares_formatter;
    }

    @Override
    public Market getMarket() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OHLCData getOHLCdata(Integer timeFrameLength) {
        OHLCData data = this.ohlcByTimeFrameLength.get(timeFrameLength);
        if (data == null) {
            Executor executor = this.executor;
            synchronized (executor) {
                OHLCData o = new OHLCData(this, timeFrameLength, this.ohlcByTimeFrameLength.get(this.minOHLCBarDuration));
                this.ohlcByTimeFrameLength.put(timeFrameLength, o);
                return o;
            }
        }
        return data;
    }

    public void setTradingLog(boolean v) throws FileNotFoundException {
        if (v) {
            if (this.tradingLogFileName == null) {
                throw new FileNotFoundException();
            }
            if (this.tradingLog == null) {
                this.tradingLog = new TradingLogWriter(this.tradingLogFileName);
            }
        }
        this.logging = v;
    }

    public TradingLogReader getTradingLog() throws FileNotFoundException {
        if (this.tradingLogFileName == null) {
            return null;
        }
        if (this.tradingLogReader == null) {
            this.tradingLogReader = new TradingLogReader(this.tradingLogFileName);
        }
        return this.tradingLogReader;
    }

    void updateOHLCData(Quote q) {
        for (OHLCData data : this.ohlcByTimeFrameLength.values()) {
            data.realTimeAdd(q.time, q.price, q.volume);
        }
    }

    public void setTradingLogFile(String fileName) {
        this.tradingLogFileName = fileName;
    }

    final void initExchange() {
        if (this.tradingLog != null) {
            this.tradingLog.close();
            this.tradingLog = null;
            this.tradingLogReader = null;
        }
        this.resetStatistics();
        this.quoteReceiverList.clear();
        this.askBookListeners.clear();
        this.bidBookListeners.clear();
        this.ohlcByTimeFrameLength = new HashMap();
        this.ohlcByTimeFrameLength.put(this.minOHLCBarDuration, new OHLCData(this, this.minOHLCBarDuration));
        this.bidBook = new ConcurrentSkipListSet<Order>(new OrderComparator(2));
        this.askBook = new ConcurrentSkipListSet<Order>(new OrderComparator(3));
        this.marketBidBook = new ConcurrentSkipListSet<Order>(new OrderComparator(0));
        this.marketAskBook = new ConcurrentSkipListSet<Order>(new OrderComparator(1));
        this.stopSellBook = new ConcurrentSkipListSet<Order>(new StopComparator(true));
        this.stopBuyBook = new ConcurrentSkipListSet<Order>(new StopComparator(false));
        this.liquidationsLong = new TreeSet<Position>(new LiquidationComparator(true));
        this.liquidationsShort = new TreeSet<Position>(new LiquidationComparator(true));
        this.priceEventsAbove = new TreeSet();
        this.priceEventsBelow = new TreeSet();
    }

    public void sheduleOnPriceAbove(PriceEvent e) {
        this.priceEventsAbove.add(e);
    }

    public void cancelScheduleOnPriceAbove(PriceEvent e) {
        this.priceEventsAbove.remove(e);
    }

    public void sheduleOnPriceBelow(PriceEvent e) {
        this.priceEventsBelow.add(e);
    }

    public void cancelScheduleOnPriceBelow(PriceEvent e) {
        this.priceEventsBelow.remove(e);
    }

    public Market(Sim sim) {
        this.sim = sim;
        this.initExchange();
    }

    void resetStatistics() {
        this.numTrades = 0L;
        this.numOrders = 0L;
        this.priceLow = 0L;
        this.priceHigh = 0L;
    }

    public Statistics getStatistics() {
        return new Statistics();
    }

    public void reset() {
        this.initExchange();
    }

    void setFairValue(float v) {
        this.fairValue = (long)(v * this.money_df);
    }

    public void initLastQuote() {
        Quote q = new Quote(this);
        q.price = this.fairValue;
        q.volume = 0L;
        q.ask = q.price;
        q.bid = q.price;
        q.ask_volume = 0L;
        q.bid_volume = 0L;
        q.time = this.sim.scheduler.getCurrentTimeMillis();
        this.lastQuote = q;
        this.updateOHLCData(q);
        this.updateQuoteReceivers(q);
    }

    public float getLastPrice() {
        Quote q = this.getLastQuoete();
        if (q == null) {
            return 0.0f;
        }
        return (float)q.price / this.money_df;
    }

    public long getLastPrice_Long() {
        return this.getLastQuoete().price;
    }

    public void putConfig(JSONObject cfg) {
        this.setMoneyDecimals(cfg.optInt("money_decimals", 2));
        this.setSharesDecimals(cfg.optInt("shares_decimals", 0));
    }

    private Long getBestPrice_Long() {
        SortedSet bid = this.bidBook;
        SortedSet ask = this.askBook;
        Quote lq = this.getLastQuoete();
        Order b = null;
        Order a = null;
        if (!bid.isEmpty()) {
            b = (Order)bid.first();
        }
        if (!ask.isEmpty()) {
            a = (Order)ask.first();
        }
        if (lq == null && b == null && a == null) {
            return null;
        }
        if (a != null && b != null) {
            Quote q = new Quote(this);
            long rc = (((Order)bid.first()).limit + ((Order)ask.first()).limit) / 2L;
            return rc;
        }
        if (a != null) {
            Quote q = new Quote(this);
            if (lq == null) {
                return a.limit;
            }
            if (lq.price > a.limit) {
                return a.limit;
            }
            return lq.price;
        }
        if (b != null) {
            Quote q = new Quote(this);
            if (lq == null) {
                return b.limit;
            }
            if (lq.price < b.limit) {
                return b.limit;
            }
            return lq.price;
        }
        if (lq == null) {
            return null;
        }
        return lq.price;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Quote getBestPrice_0() {
        Executor executor = this.executor;
        synchronized (executor) {
            SortedSet bid = this.bidBook;
            SortedSet ask = this.askBook;
            Quote lq = this.getLastQuoete();
            Order b = null;
            Order a = null;
            if (!bid.isEmpty()) {
                b = (Order)bid.first();
            }
            if (!ask.isEmpty()) {
                a = (Order)ask.first();
            }
            if (lq == null && b == null && a == null) {
                return null;
            }
            if (a != null && b != null) {
                Quote q = new Quote(this);
                if (lq == null) {
                    q.price = (((Order)bid.first()).limit + ((Order)ask.first()).limit) / 2L;
                    return q;
                }
                if (lq.price < b.limit) {
                    q.price = b.limit;
                    return q;
                }
                if (lq.price > a.limit) {
                    q.price = a.limit;
                    return q;
                }
                return lq;
            }
            if (a != null) {
                Quote q = new Quote(this);
                if (lq == null) {
                    q.price = a.limit;
                    return q;
                }
                if (lq.price > a.limit) {
                    q.price = a.limit;
                    return q;
                }
                return lq;
            }
            if (b != null) {
                Quote q = new Quote(this);
                if (lq == null) {
                    q.price = b.limit;
                    return q;
                }
                if (lq.price < b.limit) {
                    q.price = b.limit;
                    return q;
                }
                return lq;
            }
            return lq;
        }
    }

    private Set<BookListener> selectBookReceiver(byte t) {
        switch (t) {
            case 3: {
                return this.askBookListeners;
            }
            case 2: {
                return this.bidBookListeners;
            }
            case 1: {
                return this.ulAskBookListeners;
            }
            case 0: {
                return this.ulBidBookListeners;
            }
            case 4: {
                return this.stopBuyBookListeners;
            }
            case 5: {
                return this.stopSellBookListeners;
            }
        }
        return null;
    }

    public void addBookListener(byte type, BookListener bl) {
        Set<BookListener> booklisteners = this.selectBookReceiver(type);
        if (booklisteners == null) {
            return;
        }
        booklisteners.add(bl);
    }

    public void removeBookListener(BookListener bl) {
        this.askBookListeners.remove(bl);
        this.bidBookListeners.remove(bl);
        this.ulAskBookListeners.remove(bl);
        this.ulBidBookListeners.remove(bl);
        this.stopBuyBookListeners.remove(bl);
        this.stopSellBookListeners.remove(bl);
    }

    void updateBookReceivers(byte t) {
        Set<BookListener> booklisteners = this.selectBookReceiver(t);
        Iterator<BookListener> i = booklisteners.iterator();
        while (i.hasNext()) {
            i.next().UpdateOrderBook();
        }
    }

    public void addQuoteReceiver(QuoteReceiver qr) {
        this.quoteReceiverList.add(qr);
    }

    private void updateQuoteReceivers(Quote q) {
        Iterator<QuoteReceiver> i = this.quoteReceiverList.iterator();
        while (i.hasNext()) {
            i.next().UpdateQuote(q);
        }
    }

    public ArrayList<Order> getRawOrderBook(byte type, int depth) {
        SortedSet<Order> book = this.getBook(type);
        if (book == null) {
            return null;
        }
        ArrayList<Order> ret2 = new ArrayList<Order>();
        Iterator it = book.iterator();
        for (int i = 0; i < depth && it.hasNext(); ++i) {
            Order o = new Order((Order)it.next());
            if (o.volume <= 0L) continue;
            ret2.add(o);
        }
        return ret2;
    }

    SortedSet<Order> getBook(byte type) {
        switch (type & 7) {
            case 2: {
                return this.bidBook;
            }
            case 3: {
                return this.askBook;
            }
            case 0: {
                return this.marketBidBook;
            }
            case 1: {
                return this.marketAskBook;
            }
            case 5: {
                return this.stopSellBook;
            }
            case 4: {
                return this.stopBuyBook;
            }
        }
        return null;
    }

    public TreeMap<Long, OrderBookEntry> getCompressedOrderBook(byte type, int depth) {
        TreeMap<Long, OrderBookEntry> map2 = new TreeMap<Long, OrderBookEntry>();
        SortedSet<Order> book = this.getBook(type);
        if (book == null) {
            return null;
        }
        Iterator it = book.iterator();
        int i = 0;
        while (it.hasNext()) {
            Order o = new Order((Order)it.next());
            if (o.volume > 0L) {
                OrderBookEntry oe = map2.get(o.limit);
                if (oe == null) {
                    map2.put(o.limit, new CompOrderBookEntry(o));
                } else {
                    oe.addVolume(o.volume);
                    map2.put(o.limit, oe);
                }
                if (map2.size() >= depth) break;
            }
            ++i;
        }
        return map2;
    }

    public Quote getLastQuoete() {
        return this.lastQuote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelOrder(Account a, long order_id) {
        Order o;
        if (a == null) {
            return false;
        }
        boolean ret2 = false;
        Executor executor = this.executor;
        synchronized (executor) {
            o = a.orders.get(order_id);
            if (o != null) {
                if (o.isBuy()) {
                    if (o.hasLimit()) {
                        this.bidBook.remove(o);
                    } else {
                        this.marketBidBook.remove(o);
                    }
                    if (o.hasStop()) {
                        this.stopBuyBook.remove(o);
                    }
                } else {
                    if (o.hasLimit()) {
                        this.askBook.remove(o);
                    } else {
                        this.marketAskBook.remove(o);
                    }
                    if (o.hasStop()) {
                        this.stopSellBook.remove(o);
                    }
                }
                a.orders.remove(o.id);
                o.status = (byte)8;
                a.update(o);
                ret2 = true;
            }
        }
        if (ret2) {
            this.updateBookReceivers(o.type);
        }
        return ret2;
    }

    private void removeOrderIfExecuted(Order o) {
        if (o.volume != 0L && o.status != 4) {
            o.status = (byte)3;
            o.account.update(o);
            return;
        }
        o.account.orders.remove(o.id);
        if (o.isSell()) {
            if (o.hasLimit()) {
                this.askBook.remove(o);
            } else {
                this.marketAskBook.remove(o);
            }
        } else if (o.hasLimit()) {
            this.bidBook.remove(o);
        } else {
            this.marketBidBook.remove(o);
        }
        if (this.logging) {
            this.tradingLog.add(new TradingLogWriter.TradingLogRecord(this.sim.scheduler.getCurrentTimeMillis(), TradingLogWriter.TradingLogRecord.Action.CLOSE_ORDER, o));
        }
        o.status = (byte)4;
        o.account.update(o);
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    void checkSLOrders(long price) {
        Order s;
        SortedSet ss = this.stopSellBook;
        SortedSet sb = this.stopBuyBook;
        while (!ss.isEmpty()) {
            s = (Order)ss.first();
            if (price > s.stop) break;
            ss.remove(s);
            if (s.hasLimit()) {
                this.askBook.add(s);
                continue;
            }
            this.marketAskBook.add(s);
        }
        while (!sb.isEmpty()) {
            s = (Order)sb.first();
            if (price < s.stop) break;
            sb.remove(s);
            if (s.hasLimit()) {
                this.bidBook.add(s);
                continue;
            }
            this.marketBidBook.add(s);
        }
    }

    void setLiquidationStop(Position p) {
        if (p.isShort()) {
            this.liquidationsShort.add(p);
        } else {
            this.liquidationsLong.add(p);
        }
    }

    void removeLiquidationStop(Position p) {
        this.liquidationsShort.remove(p);
        this.liquidationsLong.remove(p);
    }

    private void finishTrade(Order buyer, Order seller, long price, long volume2) {
        buyer.position.addShares(volume2, price, buyer.leverage);
        seller.position.addShares(-volume2, price, seller.leverage);
        ++this.numTrades;
        buyer.volume -= volume2;
        seller.volume -= volume2;
        buyer.cost += price * volume2;
        seller.cost += price * volume2;
        this.removeOrderIfExecuted(seller);
        this.removeOrderIfExecuted(buyer);
        if (this.logging) {
            TradingLogWriter.TradingLogRecord e = new TradingLogWriter.TradingLogRecord(this.sim.scheduler.getCurrentTimeMillis(), TradingLogWriter.TradingLogRecord.Action.SELL, seller);
            e.trasaction_volume = (float)volume2 / this.shares_df;
            e.transaction_price = (float)price / this.money_df;
            this.tradingLog.add(e);
            e = new TradingLogWriter.TradingLogRecord(this.sim.scheduler.getCurrentTimeMillis(), TradingLogWriter.TradingLogRecord.Action.BUY, buyer);
            e.trasaction_volume = (float)volume2 / this.shares_df;
            e.transaction_price = (float)price / this.money_df;
            this.tradingLog.add(e);
        }
    }

    void addQuoteToHistory(Quote q) {
        if (this.priceLow == 0L) {
            this.priceLow = q.price;
        } else if (q.price < this.priceLow) {
            this.priceLow = q.price;
        }
        if (q.price > this.priceHigh) {
            this.priceHigh = q.price;
        }
        this.lastQuote = q;
        this.updateOHLCData(q);
        this.updateQuoteReceivers(q);
    }

    private void executeOrders() {
        SortedSet bid = this.bidBook;
        SortedSet ask = this.askBook;
        SortedSet ul_buy = this.marketBidBook;
        SortedSet ul_sell = this.marketAskBook;
        long volume_total = 0L;
        long money_total = 0L;
        while (true) {
            long volume2;
            long volume3;
            long price;
            Order buyer;
            Order seller;
            if (!ul_sell.isEmpty() && !ul_buy.isEmpty()) {
                long svol;
                seller = (Order)ul_sell.first();
                buyer = (Order)ul_buy.first();
                price = this.getBestPrice_Long();
                long bvol = svol = (volume3 = buyer.volume >= seller.volume ? seller.volume : buyer.volume);
                long bp = buyer.position.getRequiredCashForOrder_Long(volume3, price, buyer.leverage);
                long cashAvail = buyer.account.getCashAvailabale_Long();
                if (cashAvail < bp) {
                    bvol = cashAvail / price;
                    buyer.status = (byte)4;
                }
                bp = seller.position.getRequiredCashForOrder_Long(-volume3, price, buyer.leverage);
                cashAvail = buyer.account.getCashAvailabale_Long();
                if (cashAvail < bp) {
                    svol = cashAvail / price;
                    buyer.status = (byte)4;
                }
                volume3 = bvol >= svol ? svol : bvol;
                this.finishTrade(buyer, seller, price, volume3);
                volume_total += volume3;
                money_total += price * volume3;
                this.checkSLOrders(price);
                continue;
            }
            while (!ul_buy.isEmpty() && !ask.isEmpty()) {
                seller = (Order)ask.first();
                buyer = (Order)ul_buy.first();
                price = seller.limit;
                long bvol = buyer.position.getTradableShares_Long(buyer.volume, price, buyer.leverage);
                if (bvol <= 0L) {
                    buyer.status = (byte)4;
                    this.removeOrderIfExecuted(buyer);
                    continue;
                }
                volume2 = bvol >= seller.volume ? seller.volume : bvol;
                this.finishTrade(buyer, seller, price, volume2);
                volume_total += volume2;
                money_total += price * volume2;
                this.checkSLOrders(price);
            }
            while (!ul_sell.isEmpty() && !bid.isEmpty()) {
                Order buyer2 = (Order)bid.first();
                Order seller2 = (Order)ul_sell.first();
                price = buyer2.limit;
                long svol = seller2.position.getTradableShares_Long(-seller2.volume, price, seller2.leverage);
                if (svol == 0L) {
                    seller2.status = (byte)4;
                    this.removeOrderIfExecuted(seller2);
                    continue;
                }
                volume2 = svol >= buyer2.volume ? buyer2.volume : svol;
                this.finishTrade(buyer2, seller2, price, volume2);
                volume_total += volume2;
                money_total += price * volume2;
                this.checkSLOrders(price);
            }
            if (bid.isEmpty() || ask.isEmpty()) break;
            Order b = (Order)bid.first();
            Order a = (Order)ask.first();
            if (b.limit < a.limit) break;
            price = b.id < a.id ? b.limit : a.limit;
            volume3 = b.volume >= a.volume ? a.volume : b.volume;
            this.finishTrade(b, a, price, volume3);
            volume_total += volume3;
            money_total += price * volume3;
            this.checkSLOrders(price);
        }
        if (volume_total == 0L) {
            return;
        }
        Quote q = new Quote(this);
        q.price = money_total / volume_total;
        q.volume = volume_total;
        q.time = this.sim.scheduler.getCurrentTimeMillis();
        this.addQuoteToHistory(q);
        this.checkLiquidationStops(q.price);
        this.checkPriceEvents(q.price);
        this.updateQuoteReceivers(q);
    }

    void checkPriceEvents(long price) {
        PriceEvent e;
        SortedSet up = this.priceEventsAbove;
        SortedSet down = this.priceEventsBelow;
        while (!this.priceEventsAbove.isEmpty()) {
            e = (PriceEvent)up.first();
            if (price <= e.price) break;
            up.remove(e);
            this.sim.scheduler.addEvent(this.sim.getCurrentTimeMillis(), e);
        }
        while (!this.priceEventsBelow.isEmpty()) {
            e = (PriceEvent)down.last();
            if (price >= e.price) break;
            down.remove(e);
            this.sim.scheduler.addEvent(this.sim.getCurrentTimeMillis(), e);
        }
    }

    void checkLiquidationStops(long price) {
        Position p;
        long stopPrice;
        SortedSet longStops = this.liquidationsLong;
        SortedSet shortStops = this.liquidationsShort;
        while (!longStops.isEmpty() && price < (stopPrice = (p = (Position)longStops.last()).getStopPrice_Long())) {
            boolean result = longStops.remove(p);
            p.account.isLiquided = true;
            p.account.cancelAllOrders();
            this.createOrderNoExec_Long(p.account, (byte)1, Math.abs(p.shares), 0L, 0L, 1);
        }
        while (!shortStops.isEmpty() && price > (stopPrice = (p = (Position)shortStops.first()).getStopPrice_Long())) {
            shortStops.remove(p);
            p.account.isLiquided = true;
            p.account.cancelAllOrders();
            this.createOrderNoExec_Long(p.account, (byte)0, Math.abs(p.shares), 0L, 0L, 1);
        }
    }

    private void addOrderToBook(Order o) {
        if (o.isSell()) {
            if (o.hasStop()) {
                this.stopSellBook.add(o);
            } else if (o.hasLimit()) {
                this.askBook.add(o);
            } else {
                this.marketAskBook.add(o);
            }
            return;
        }
        if (o.hasStop()) {
            this.stopBuyBook.add(o);
        } else if (o.hasLimit()) {
            this.bidBook.add(o);
        } else {
            this.marketBidBook.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Order createOrder_Long(Account a, byte type, long volume2, long limit, long stop, int leverage) {
        if (volume2 <= 0L) {
            return null;
        }
        if ((type & 2) != 0 && limit <= 0L) {
            return null;
        }
        Order o = new Order(this, a, type, volume2, limit, stop, leverage);
        Executor executor = this.executor;
        synchronized (executor) {
            ++this.numOrders;
            this.addOrderToBook(o);
            a.orders.put(o.id, o);
            a.update(o);
            this.executeOrders();
            this.updateBookReceivers((byte)3);
            this.updateBookReceivers((byte)2);
            this.updateBookReceivers((byte)1);
            this.updateBookReceivers((byte)0);
            this.updateBookReceivers((byte)5);
            this.updateBookReceivers((byte)4);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Order createOrderNoExec_Long(Account a, byte type, long volume2, long limit, long stop, int leverage) {
        if (volume2 <= 0L) {
            return null;
        }
        if ((type & 2) != 0 && limit <= 0L) {
            return null;
        }
        Order o = new Order(this, a, type, volume2, limit, stop, leverage);
        Executor executor = this.executor;
        synchronized (executor) {
            ++this.numOrders;
            this.addOrderToBook(o);
            a.orders.put(o.id, o);
            a.update(o);
        }
        return o;
    }

    public Order createOrder(Account a, byte type, float volume2, float limit, float stop) {
        return this.createOrder_Long(a, type, (long)(volume2 * this.shares_df), (long)(limit * this.money_df), (long)(stop * this.money_df), 1);
    }

    public Order createOrder(Account a, byte type, float volume2, float limit, float stop, int leverage) {
        return this.createOrder_Long(a, type, (long)(volume2 * this.shares_df), (long)(limit * this.money_df), (long)(stop * this.money_df), leverage);
    }

    public Order createLeveragedOrder(Account a, byte type, long money) {
        if (!Order.isSell(type)) {
            return null;
        }
        long leverage = 10L;
        long lastPrice = this.getBestPrice_Long();
        long numberOfShares = money * leverage / lastPrice;
        long sellMoney = numberOfShares * lastPrice;
        long buyBackMoney = a.getCashAvailabale_Long() - money + sellMoney;
        long sellPrice = lastPrice;
        long buyBackPrice = buyBackMoney / numberOfShares;
        System.out.printf("numShares: %d, buyMoney: %d, buyBackMoney: %d, buyPrice: %d, buyBackPrice: %d\n", numberOfShares, sellMoney, buyBackMoney, sellPrice, buyBackPrice);
        return null;
    }

    class Executor
    extends Thread {
        Executor() {
        }

        @Override
        public void run() {
        }
    }

    class OrderComparator
    implements Comparator<Order> {
        byte type;

        OrderComparator(byte type) {
            this.type = type;
        }

        @Override
        public int compare(Order left, Order right) {
            long d;
            switch (this.type) {
                case 0: 
                case 2: 
                case 4: {
                    d = right.limit - left.limit;
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    d = left.limit - right.limit;
                    break;
                }
                default: {
                    d = 0L;
                }
            }
            if (d != 0L) {
                return d > 0L ? 1 : -1;
            }
            if (left.id < right.id) {
                return -1;
            }
            if (left.id > right.id) {
                return 1;
            }
            return 0;
        }
    }

    class StopComparator
    implements Comparator<Order> {
        boolean reverse;

        StopComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(Order left, Order right) {
            long d = this.reverse ? right.stop - left.stop : left.stop - right.stop;
            if (d != 0L) {
                return d > 0L ? 1 : -1;
            }
            d = right.initial_volume - left.initial_volume;
            if (d != 0L) {
                return d > 0L ? 1 : -1;
            }
            if (left.id < right.id) {
                return -1;
            }
            if (left.id > right.id) {
                return 1;
            }
            return 0;
        }
    }

    class LiquidationComparator
    implements Comparator<Position> {
        boolean isLong;

        LiquidationComparator(boolean type) {
            this.isLong = type;
        }

        @Override
        public int compare(Position a, Position b) {
            int priceCmp;
            int n = priceCmp = this.isLong ? Long.compare(a.getStopPrice_Long(), b.getStopPrice_Long()) : Long.compare(b.getStopPrice_Long(), a.getStopPrice_Long());
            if (priceCmp != 0) {
                return priceCmp;
            }
            return Long.compare(a.id, b.id);
        }
    }

    public class Statistics {
        public long trades = 0L;
        public long orders = 0L;
        public float high = 0.0f;
        public float low = 0.0f;
        public long lastTradeTime = 0L;

        Statistics() {
            if (Market.this.lastQuote == null) {
                return;
            }
            this.trades = Market.this.numTrades;
            this.orders = Market.this.numOrders;
            this.lastTradeTime = Market.this.lastQuote.time;
            OHLCData d = Market.this.getOHLCdata(Market.this.minOHLCBarDuration);
            this.high = (float)Market.this.priceHigh / Market.this.money_df;
            this.low = (float)Market.this.priceLow / Market.this.money_df;
        }
    }

    public static interface BookListener {
        public void UpdateOrderBook();
    }

    public static interface QuoteReceiver {
        public void UpdateQuote(Quote var1);
    }

    public static class CompOrderBookEntry
    implements OrderBookEntry {
        long limit;
        long volume;
        Market se;
        long stop;

        public CompOrderBookEntry(Market se) {
            this.se = se;
        }

        public CompOrderBookEntry(Order oe) {
            this.se = oe.market;
            this.volume = oe.volume;
            this.limit = oe.limit;
        }

        public CompOrderBookEntry(OrderBookEntry oe) {
            this.se = oe.getMarket();
            this.volume = oe.getVolume_Long();
            this.limit = oe.getLimit_Long();
        }

        @Override
        public float getVolume() {
            return (float)this.volume / this.se.shares_df;
        }

        @Override
        public float getLimit() {
            return (float)this.limit / this.se.money_df;
        }

        @Override
        public String getOwnerName() {
            return "";
        }

        @Override
        public void addVolume(long v) {
            this.volume += v;
        }

        @Override
        public float getStop() {
            return -1.0f;
        }

        @Override
        public long getVolume_Long() {
            return this.volume;
        }

        @Override
        public long getLimit_Long() {
            return this.limit;
        }

        @Override
        public long getStop_Long() {
            return this.stop;
        }

        @Override
        public Market getMarket() {
            return this.se;
        }
    }

    public static class PriceEvent
    extends Scheduler.Event
    implements Comparable {
        long price;
        private static final AtomicLong ID_GEN = new AtomicLong(0L);
        private final long id = ID_GEN.incrementAndGet();

        public int compareTo(Object o) {
            PriceEvent pe = (PriceEvent)o;
            int cmp = Long.compare(this.price, pe.price);
            if (cmp != 0) {
                return cmp;
            }
            return Long.compare(this.id, pe.id);
        }

        public PriceEvent() {
        }

        public PriceEvent(Market se, double price) {
            this();
            this.price = (long)(price * (double)se.money_df);
        }

        public PriceEvent(long price) {
            this();
            this.price = price;
        }
    }

    public static interface OrderListener {
        public void orderUpdated(Order var1);
    }

    public static interface AccountListener {
        public void accountUpdated(Account var1, Order var2);
    }
}

