/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.math.BigInteger;

public class MathBenchmark {
    public static void main(String[] args) {
        long r = MathBenchmark.getRandomPrice_Long(10000L, -200L, 200L, 1L, 0L);
        System.out.printf("R0: %d\n", r);
        r = MathBenchmark.getRandomPrice_Long(9800L, -200L, 204L, 1L, 1L);
        System.out.printf("R0: %d\n", r);
    }

    public static void ex() {
        int N = 1000000000;
        long start = System.currentTimeMillis();
        long longResult = 1L;
        for (int i = 1; i <= 1000000000; ++i) {
            longResult += (long)i;
        }
        long end = System.currentTimeMillis();
        System.out.println("long: " + (end - start) + " ms");
        start = System.currentTimeMillis();
        double doubleResult = 1.0;
        for (int i = 1; i <= 1000000000; ++i) {
            doubleResult += (double)i;
        }
        end = System.currentTimeMillis();
        System.out.println("double: " + (end - start) + " ms");
        start = System.currentTimeMillis();
        BigInteger bigResult = BigInteger.ONE;
        for (int i = 1; i <= 1000000000; ++i) {
            bigResult = bigResult.add(BigInteger.valueOf(i));
        }
        end = System.currentTimeMillis();
        System.out.println("BigInteger: " + (end - start) + " ms");
    }

    public static long getRandomPriceDelta_Long(long lastPrice, long minDeviation, long maxDeviation, long minAbsoluteDeviation, long rnd) {
        long maxDelta;
        long product = lastPrice * minDeviation;
        long minDelta = product >= 0L ? (product + 0L) / 10000L : (product - 0L) / 10000L;
        product = lastPrice * maxDeviation;
        long l = maxDelta = product >= 0L ? (product + 0L) / 10000L : (product - 0L) / 10000L;
        if (Math.abs(minDelta) < minAbsoluteDeviation && minDeviation != 0L) {
            long l2 = minDelta = minDeviation < 0L ? -minAbsoluteDeviation : minAbsoluteDeviation;
        }
        if (Math.abs(maxDelta) < minAbsoluteDeviation && maxDeviation != 0L) {
            long l3 = maxDelta = maxDeviation < 0L ? -minAbsoluteDeviation : minAbsoluteDeviation;
        }
        if (minDelta + lastPrice < 0L) {
            minDelta = -lastPrice;
        }
        long range = maxDelta - minDelta + 1L;
        long delta = rnd * (range - 1L) + minDelta;
        return delta;
    }

    public static long getRandomPrice_Long(long lastPrice, long minDeviation, long maxDeviation, long minAbsDeviation, long rnd) {
        long delta = MathBenchmark.getRandomPriceDelta_Long(lastPrice, minDeviation, maxDeviation, minAbsDeviation, rnd);
        long newPrice = lastPrice + delta;
        if (newPrice < 1L) {
            newPrice = 1L;
        }
        return newPrice;
    }
}

