/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.util.ArrayList;
import sesim.Market;
import sesim.MinMax;
import sesim.OHLCDataItem;

public class OHLCData {
    private long max = 0L;
    private long min = 0L;
    private int barDuration = 60000;
    Market se;
    public ArrayList<OHLCDataItem> data = new ArrayList();
    private long last_price = 0L;

    public OHLCData(Market se, int timeFrameLength) {
        this.se = se;
        this.barDuration = timeFrameLength;
    }

    public OHLCData(Market se, int barDuration, OHLCData base) {
        this(se, barDuration);
        for (OHLCDataItem i : base.data) {
            this.realTimeAdd(i.time, i.open, i.volume);
            this.realTimeAdd(i.time, i.high, 0L);
            this.realTimeAdd(i.time, i.low, 0L);
            this.realTimeAdd(i.time, i.close, 0L);
        }
    }

    public float getMax() {
        return (float)this.max / this.se.money_df;
    }

    public float getMin() {
        return (float)this.min / this.se.money_df;
    }

    public int size() {
        return this.data.size();
    }

    public int getFrameSize() {
        return this.barDuration;
    }

    public MinMax getMinMax(int first, int last) {
        if (first >= this.data.size()) {
            OHLCDataItem di = this.data.get(this.data.size() - 1);
            return new MinMax(this.se.money_df, di.low, di.high);
        }
        OHLCDataItem di = this.data.get(first);
        MinMax minmax = new MinMax(this.se.money_df, di.low, di.high);
        for (int i = first + 1; i < last && i < this.data.size(); ++i) {
            di = this.data.get(i);
            if (di.low < minmax.min) {
                minmax.min = di.low;
            }
            if (di.high <= minmax.max) continue;
            minmax.max = di.high;
        }
        return minmax;
    }

    public MinMax getVolMinMax(int first, int last) {
        if (first >= this.data.size()) {
            OHLCDataItem di = this.data.get(this.data.size() - 1);
            return new MinMax(this.se.shares_df, di.volume, di.volume);
        }
        OHLCDataItem di = this.data.get(first);
        MinMax minmax = new MinMax(this.se.shares_df, di.volume, di.volume);
        for (int i = first + 1; i < last && i < this.data.size(); ++i) {
            di = this.data.get(i);
            if (di.volume < minmax.min) {
                minmax.min = di.volume;
            }
            if (di.volume <= minmax.max) continue;
            minmax.max = di.volume;
        }
        return minmax;
    }

    public OHLCDataItem get(int n) {
        return this.data.get(n);
    }

    private void updateMinMax(long price) {
        if (price > this.max) {
            this.max = price;
        }
        if (price < this.min) {
            this.min = price;
        }
    }

    boolean realTimeAdd(long time, long price, long volume2) {
        if (this.data.isEmpty() && time < (long)this.barDuration) {
            this.data.add(new OHLCDataItem(this.se, 0L, price, volume2));
            this.last_price = price;
            return true;
        }
        long nFrame = (long)this.data.size() * (long)this.barDuration;
        if (time < nFrame) {
            this.last_price = price;
            this.updateMinMax(price);
            OHLCDataItem d = this.data.get(this.data.size() - 1);
            return d.update(price, volume2);
        }
        while (time > nFrame + (long)this.barDuration) {
            this.data.add(new OHLCDataItem(this.se, nFrame, this.last_price, 0L));
            nFrame += (long)this.barDuration;
        }
        this.data.add(new OHLCDataItem(this.se, nFrame, price, volume2));
        this.last_price = price;
        return true;
    }
}

