/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.util.concurrent.atomic.AtomicLong;
import sesim.Account;
import sesim.Asset;
import sesim.Order;

public class Position {
    private static final AtomicLong ID_GEN = new AtomicLong(0L);
    final Asset asset;
    final Account account;
    long shares;
    long entryPrice;
    long margin;
    private long stopPrice;
    long id;
    long netCashFlow = 0L;
    long totalEntryCost = 0L;
    public boolean mops = true;
    Order liquidationOrder = null;

    public Position(Asset asset, Account account) {
        this.asset = asset;
        this.id = ID_GEN.incrementAndGet();
        this.shares = 0L;
        this.entryPrice = 0L;
        this.margin = 0L;
        this.account = account;
    }

    public Position(Position p) {
        this.asset = p.asset;
        this.id = p.id;
        this.account = p.account;
        this.margin = p.margin;
        this.netCashFlow = p.netCashFlow;
        this.shares = p.shares;
    }

    public String getName() {
        return this.asset.getSymbol();
    }

    public long getShares_Long() {
        return this.shares;
    }

    public float getShares() {
        return (float)this.shares / this.asset.getDf();
    }

    public float getLeverage() {
        float leverage = this.getMargin() == 0.0f ? 1.0f : this.getTotalEntryCost() / this.getMargin();
        return leverage;
    }

    public float getMargin() {
        return (float)this.getMargin_Long() / this.asset.getMarket().money_df;
    }

    public long getMargin_Long() {
        return Math.abs(this.margin);
    }

    public float getEntryPrice() {
        return this.getTotalEntryCost() / (float)this.shares;
    }

    public long getExposure() {
        return Math.abs(this.shares * this.entryPrice);
    }

    public long getPnL_Long(long currentPrice) {
        return currentPrice * this.shares - this.netCashFlow;
    }

    public long getPnL_Long() {
        return this.asset.getMarket().getLastPrice_Long() * this.shares + this.netCashFlow;
    }

    public float getPnL() {
        return (float)(this.asset.getMarket().getLastPrice_Long() * this.shares + this.netCashFlow) / this.asset.getMarket().money_df;
    }

    public float getPnLPercent() {
        float base;
        if (this.getMargin() != 0.0f) {
            base = this.getMargin();
        } else {
            base = -this.netCashFlow;
            if (base == 0.0f) {
                return 0.0f;
            }
        }
        return this.getPnL() / base * 100.0f;
    }

    public long getMarketValue_Long() {
        return this.totalEntryCost - this.asset.getMarket().getLastPrice_Long() * this.shares - this.netCashFlow;
    }

    public float getMarketValue() {
        return (float)this.getMarketValue_Long() / this.asset.getMarket().money_df;
    }

    public long getEquityValue_Long(long price) {
        return this.netCashFlow + this.shares * price;
    }

    public long getEquityValue_Long() {
        return this.getEquityValue_Long(this.asset.getMarket().getLastPrice_Long());
    }

    public float getEquityValue() {
        return (float)this.getEquityValue_Long() / this.asset.getMarket().money_df;
    }

    public float getTotalEntryCost() {
        return (float)this.totalEntryCost / this.asset.getMarket().money_df;
    }

    public float getShadowCash() {
        return (float)this.netCashFlow / this.asset.getMarket().money_df;
    }

    public float getNetBrokerLoan() {
        return (float)this.netCashFlow / this.asset.getMarket().money_df;
    }

    boolean isShort() {
        return this.shares < 0L;
    }

    void addShares(long volume2, long price, int leverage) {
        if (Long.signum(this.shares) == Long.signum(volume2) || this.shares == 0L) {
            long val = volume2 * price;
            this.netCashFlow -= val;
            this.totalEntryCost += val;
            long marginRequired = Math.abs(val / (long)leverage);
            this.shares += volume2;
            this.margin += marginRequired;
        } else {
            long nextShares = this.shares + volume2;
            if (Long.signum(this.shares) != Long.signum(nextShares)) {
                long marginRequired;
                this.netCashFlow += this.shares * price;
                this.account.cash += this.netCashFlow;
                this.shares = nextShares;
                long val = this.shares * price;
                this.netCashFlow = -val;
                this.totalEntryCost = val;
                this.margin = marginRequired = Math.abs(val) / (long)leverage;
            } else {
                long val = volume2 * price;
                this.netCashFlow -= val;
                this.totalEntryCost += val;
                long reductionFactor = Math.abs(volume2) * 10000L / Math.abs(this.shares);
                long marginReduction = this.margin * reductionFactor / 10000L;
                this.shares = nextShares;
                this.margin -= marginReduction;
            }
        }
        if (this.shares == 0L || this.shares > 0L && this.netCashFlow + this.margin >= 0L) {
            this.account.cash += this.netCashFlow;
            this.margin = 0L;
            this.netCashFlow = 0L;
            if (this.shares == 0L) {
                this.totalEntryCost = 0L;
            }
        }
        if (this.margin != 0L) {
            this.account.calculateLiquidationStops(price);
        } else {
            this.asset.getMarket().removeLiquidationStop(this);
        }
    }

    public float getStopPrice() {
        return (float)this.stopPrice / this.asset.getMarket().money_df;
    }

    public long getStopPrice_Long() {
        return this.stopPrice;
    }

    void setStopPrice(long newStopPrice) {
        this.asset.getMarket().removeLiquidationStop(this);
        this.stopPrice = newStopPrice;
        this.asset.getMarket().setLiquidationStop(this);
    }

    public long getRequiredCashForOrder_Long(long volume2, long price, long leverage) {
        if (Long.signum(this.shares) == Long.signum(volume2) || this.shares == 0L) {
            long val = volume2 * price;
            long marginRequired = Math.abs(val / leverage);
            return marginRequired;
        }
        long nextShares = this.shares + volume2;
        if (Long.signum(this.shares) != Long.signum(nextShares) && nextShares != 0L) {
            long val = nextShares * price;
            long marginRequired = Math.abs(val) / leverage;
            return marginRequired;
        }
        return 0L;
    }

    public long getTradableShares_Long(long volume2, long price, long leverage) {
        if (Long.signum(this.shares) == Long.signum(volume2) || this.shares == 0L) {
            long val = volume2 * price;
            long marginRequired = Math.abs(val / leverage);
            long freeMargin = this.account.getFreeMargin_Long();
            if (freeMargin < 0L) {
                freeMargin = 0L;
            }
            if (freeMargin < marginRequired) {
                return freeMargin * leverage / price;
            }
        } else {
            long val;
            long marginRequired;
            long c;
            long nextShares = this.shares + volume2;
            if (Long.signum(this.shares) != Long.signum(nextShares) && nextShares != 0L && (c = this.netCashFlow - -this.shares * price + this.margin + this.account.cash) < (marginRequired = Math.abs(val = nextShares * price) / leverage)) {
                return Math.abs(this.shares) + c * leverage / price;
            }
        }
        return Math.abs(volume2);
    }

    void updateLiquidationOrder(int l) {
        if (this.margin == 0L) {
            if (this.liquidationOrder == null) {
                return;
            }
            this.asset.getMarket().cancelOrder(this.account, this.liquidationOrder.id);
            this.liquidationOrder = null;
            return;
        }
        int leverage = (int)(this.totalEntryCost / this.margin);
        if (this.liquidationOrder != null) {
            this.asset.getMarket().cancelOrder(this.account, this.liquidationOrder.id);
        }
    }
}

