/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.locks.LockSupport;

public class Scheduler
extends Thread {
    private boolean pause = false;
    private double acceleration = 1.0;
    private boolean terminate = false;
    private final TreeMap<Long, LinkedHashSet<Event>> eventQueue = new TreeMap();
    private double currentTimeMillis = 0.0;
    private long last_nanos = System.nanoTime();
    private double current_nanos = 0.0;
    private boolean maxAcceleartion = false;
    long startTime;
    ExecutorService executor = ForkJoinPool.commonPool();
    long pauseTime;

    public void setAcceleration(double val) {
        this.acceleration = val;
        LockSupport.unpark(this);
    }

    public double getAcceleration() {
        return this.acceleration;
    }

    public void setMaxAcceleration(boolean val) {
        this.maxAcceleartion = val;
    }

    public boolean getMaxAcceleration() {
        return this.maxAcceleartion;
    }

    public void terminate() {
        this.terminate = true;
        this.pause = false;
        LockSupport.unpark(this);
    }

    @Override
    public void start() {
        if (this.isAlive()) {
            return;
        }
        this.initScheduler();
        super.start();
        this.startTime = System.currentTimeMillis();
    }

    private long calculateCurrentTimeMillis() {
        if (this.pause) {
            return (long)this.currentTimeMillis;
        }
        long cur = System.nanoTime();
        long diff = cur - this.last_nanos;
        this.last_nanos = cur;
        this.current_nanos += (double)diff * this.acceleration;
        this.currentTimeMillis = this.current_nanos / 1000000.0;
        return (long)this.currentTimeMillis;
    }

    public long getCurrentTimeMillis() {
        return (long)this.currentTimeMillis;
    }

    public static String formatTimeMillis(long t) {
        Date date = new Date(t);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        long seconds = t / 1000L % 60L;
        long minutes = t / 1000L / 60L % 60L;
        long hours = t / 1000L / 3600L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    public void addEvent(long t, Event e) {
        LinkedHashSet<Event> s = this.eventQueue.get(t);
        if (s == null) {
            s = new LinkedHashSet();
            this.eventQueue.put(t, s);
        }
        s.add(e);
        LockSupport.unpark(this);
    }

    public boolean delEvent(long t, Event e) {
        LinkedHashSet<Event> s = this.eventQueue.get(t);
        if (s == null) {
            return false;
        }
        boolean rc = s.remove(e);
        if (rc) {
            LockSupport.unpark(this);
        }
        return rc;
    }

    public void pause() {
        this.setPause(!this.pause);
    }

    public void setPause(boolean val) {
        this.pause = val;
        LockSupport.unpark(this);
        if (this.pause) {
            this.pauseTime = System.currentTimeMillis();
        } else {
            this.startTime += System.currentTimeMillis() + this.pauseTime;
        }
    }

    public long getCurrentTime() {
        if (this.pause) {
            return this.pauseTime - this.startTime;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    public boolean getPause() {
        return this.pause;
    }

    Event pollFirst(LinkedHashSet<Event> s) {
        Iterator it = s.iterator();
        if (!it.hasNext()) {
            return null;
        }
        Event e = (Event)it.next();
        it.remove();
        return e;
    }

    private long runEvents() {
        Event e;
        long ct;
        if (this.pause) {
            return -1L;
        }
        if (this.eventQueue.isEmpty()) {
            return -1L;
        }
        LinkedHashSet<Event> s = this.eventQueue.firstEntry().getValue();
        long t = this.eventQueue.firstKey();
        if (t > (ct = this.maxAcceleartion ? t : this.calculateCurrentTimeMillis())) {
            return (long)(((double)t - (double)this.getCurrentTimeMillis()) / this.acceleration);
        }
        if (t <= ct) {
            this.currentTimeMillis = t;
            this.current_nanos = this.currentTimeMillis * 1000000.0;
        }
        while ((e = this.pollFirst(s)) != null) {
            e.eventProcessor.processEvent(t, e);
        }
        this.eventQueue.remove(t);
        return 0L;
    }

    void initScheduler() {
        this.currentTimeMillis = 0.0;
        this.last_nanos = System.nanoTime();
        this.addEvent(1000L, new Event(new EmptyCtr()));
        this.terminate = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.terminate) {
            long wMillis;
            Scheduler scheduler = this;
            synchronized (scheduler) {
                wMillis = this.runEvents();
            }
            if (wMillis != -1L && !this.pause) {
                LockSupport.parkNanos(wMillis * 1000L * 1000L);
                continue;
            }
            LockSupport.park();
        }
        this.eventQueue.clear();
    }

    public static class Event {
        protected EventProcessor eventProcessor;

        public Event(EventProcessor p) {
            this.eventProcessor = p;
        }

        public Event() {
            this.eventProcessor = null;
        }
    }

    public static interface EventProcessor {
        public void processEvent(long var1, Event var3);
    }

    class EmptyCtr
    implements EventProcessor {
        EmptyCtr() {
        }

        @Override
        public void processEvent(long t, Event e) {
            Scheduler.this.addEvent(1000L + Scheduler.this.getCurrentTimeMillis(), e);
        }

        public long getID() {
            return 999999999999999999L;
        }
    }
}

