/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.SplittableRandom;
import org.json.JSONArray;
import org.json.JSONObject;
import sesim.Asset;
import sesim.AutoTraderBase;
import sesim.AutoTraderInterface;
import sesim.AutoTraderLoader;
import sesim.Logger;
import sesim.Market;
import sesim.Order;
import sesim.Scheduler;

public class Sim {
    public static final String DEFAULT_RANDOM_CFG = "{seed: 0,use_seed: false}";
    private Market se;
    HashMap<String, Asset> assets = new HashMap();
    public AutoTraderLoader tloader;
    Scheduler scheduler = new Scheduler();
    public ArrayList<AutoTraderInterface> traders = null;
    public static String DEFAULT_EXCHANGE_CFG = "{  money_decimals: 2,  shares_decimals: 0}";
    public static SplittableRandom random = new SplittableRandom(12L);

    public static int randNextInt() {
        return random.nextInt();
    }

    public static int randNextInt(int bounds) {
        return random.nextInt(bounds);
    }

    public static double randNextDouble() {
        return random.nextDouble();
    }

    public Market getExchange() {
        return this.se;
    }

    public Asset getAsset(String symbol) {
        Asset a = this.assets.get(symbol);
        if (a == null) {
            a = new TempAsset(symbol, this.se);
            this.assets.put(symbol, a);
        }
        return a;
    }

    public void setAcceleration(double a) {
        this.scheduler.setAcceleration(a);
    }

    public void setPause(boolean p) {
        this.scheduler.setPause(p);
    }

    public boolean getPause() {
        return this.scheduler.getPause();
    }

    public long getCurrentTimeMillis() {
        return this.scheduler.getCurrentTimeMillis();
    }

    public void startScheduler() {
        this.scheduler.start();
    }

    public void stop() {
        Logger.info("Sim stopped", new Object[0]);
        this.scheduler.terminate();
    }

    public void addEvent(long t, Scheduler.Event e) {
        this.scheduler.addEvent(t, e);
    }

    public boolean delEvent(long t, Scheduler.Event e) {
        return this.scheduler.delEvent(t, e);
    }

    public Sim() {
        this.se = new Market(this);
        this.initAutoTraderLoader();
        this.reset();
    }

    public final void reset() {
        if (this.traders != null) {
            for (AutoTraderInterface t : this.traders) {
                t.stop();
            }
        }
        this.traders = new ArrayList();
        this.scheduler = new Scheduler();
        this.se.reset();
    }

    private AutoTraderInterface createTraderNew(Market se, long id, String name, float money, float shares, String strat, JSONObject cfg) {
        String base = cfg.getString("base");
        AutoTraderInterface ac = this.tloader.getStrategyBase(base);
        if (ac == null) {
            return null;
        }
        ac.setConfig(cfg);
        ac.init(this, id, name, money, shares, strat, cfg);
        return ac;
    }

    void resetAutoTraders() {
        ArrayList<String> names = this.tloader.getDefaultStrategyNames();
        for (String name : names) {
            AutoTraderInterface ac = this.tloader.getStrategyBase(name);
            ac.reset();
        }
    }

    private void initAutoTraderLoader() {
        ArrayList<String> pathlist = new ArrayList<String>();
        String dp = new File(Sim.class.getProtectionDomain().getCodeSource().getLocation().getPath()).toString();
        pathlist.add(dp);
        this.tloader = new AutoTraderLoader(pathlist);
    }

    public static final JSONObject getStrategies(JSONObject cfg) {
        return cfg.getJSONObject("strategies");
    }

    public static final void putStrategies(JSONObject sobj, JSONObject strategies) {
        sobj.put("strategies", strategies);
    }

    public static final JSONArray getTraders(JSONObject cfg) {
        JSONArray traders = cfg.getJSONArray("traders");
        return traders;
    }

    public static final void putTraders(JSONObject cfg, JSONArray traders) {
        cfg.put("traders", traders);
    }

    public static JSONObject getStrategy(JSONObject cfg, String name) {
        return Sim.getStrategies(cfg).optJSONObject(name);
    }

    public static JSONObject getExchangeCfg(JSONObject cfg) {
        JSONObject exchange = cfg.optJSONObject("exchange");
        if (exchange == null) {
            exchange = new JSONObject(DEFAULT_EXCHANGE_CFG);
        }
        return exchange;
    }

    public static JSONObject getRandomCfg(JSONObject cfg) {
        JSONObject rand = cfg.optJSONObject("random");
        if (rand != null) {
            return rand;
        }
        return new JSONObject(DEFAULT_RANDOM_CFG);
    }

    public static final void putExchangeCfg(JSONObject sobj, JSONObject exchange) {
        sobj.put("exchange", exchange);
    }

    public static boolean useRandomSeed(JSONObject cfg) {
        JSONObject rand = Sim.getRandomCfg(cfg);
        return rand.optBoolean("use_seed", false);
    }

    public static long getRandomSeed(JSONObject cfg) {
        JSONObject rand = Sim.getRandomCfg(cfg);
        return rand.optLong("seed", 0L);
    }

    public static double calculateInitialPrice(JSONArray tlist) {
        double cash = 0.0;
        double shares = 0.0;
        for (int i = 0; i < tlist.length(); ++i) {
            JSONObject trader = tlist.getJSONObject(i);
            if (!trader.optBoolean("Enabled", false) || trader.optBoolean("ExcludeInitial", false)) continue;
            long count2 = trader.optLong("Count", 0L);
            cash += trader.optDouble("Cash", 0.0) * (double)count2;
            shares += trader.optDouble("Shares", 0.0) * (double)count2;
        }
        return shares == 0.0 ? 100.0 : cash / shares;
    }

    public void startTraders(JSONObject cfg) {
        int i;
        Order.resetIdGenerator();
        Logger.info("Sim started", new Object[0]);
        this.se.putConfig(Sim.getExchangeCfg(cfg));
        long randomSeed = Sim.getRandomSeed(cfg);
        boolean useSeed = Sim.useRandomSeed(cfg);
        this.resetAutoTraders();
        if (useSeed) {
            random = new SplittableRandom(randomSeed);
        } else {
            random = new SplittableRandom();
            randomSeed = random.nextLong(Long.MAX_VALUE);
            random = new SplittableRandom(randomSeed);
        }
        Logger.info("Random seed is %d", randomSeed);
        JSONArray tlist = Sim.getTraders(cfg);
        boolean autoInitialPrice = Sim.getExchangeCfg(cfg).optBoolean(this.se.CFG_AUTO_INITIAL_PRICE, true);
        double initialPrice = autoInitialPrice ? Sim.calculateInitialPrice(tlist) : (double)((float)Sim.getExchangeCfg(cfg).optDouble(this.se.CFG_INITIAL_PRICE, 100.0));
        Logger.info("Initial prices is: %f", initialPrice);
        this.se.setFairValue((float)initialPrice);
        this.se.initLastQuote();
        Float moneyTotal = Float.valueOf(0.0f);
        Float sharesTotal = Float.valueOf(0.0f);
        long id = 0L;
        block0: for (i = 0; i < tlist.length(); ++i) {
            JSONObject t = tlist.getJSONObject(i);
            String strategy_name = t.optString("Strategy", null);
            if (strategy_name == null) continue;
            JSONObject strategyCfg = Sim.getStrategy(cfg, strategy_name);
            Integer count2 = t.getInt("Count");
            Float shares = Float.valueOf((float)t.optDouble("Shares", 0.0));
            Float money = Float.valueOf((float)t.optDouble("Cash", 0.0));
            Boolean enabled = t.optBoolean("Enabled", false);
            if (!enabled.booleanValue()) continue;
            if (strategyCfg == null) {
                Logger.error("Strategy '%s' does't exists, will not start '%s'", strategy_name, t.getString("Name"));
                continue;
            }
            Object global = null;
            for (int i1 = 0; i1 < count2; ++i1) {
                JSONArray color;
                String base = strategyCfg.getString("base");
                AutoTraderInterface trader = this.tloader.getStrategyBase(base);
                if (trader == null) continue;
                global = trader.initGlobal(this, global, strategyCfg);
                trader.setConfig(strategyCfg);
                trader.init(this, id, t.getString("Name") + "-" + i1, money.floatValue() + (float)(initialPrice * (double)shares.floatValue()), 0.0f, strategy_name, strategyCfg);
                trader.getAccount().getPosition(this.se).addShares((long)(shares.floatValue() * this.se.shares_df), (long)(initialPrice * (double)this.se.money_df), 1);
                trader.getAccount().makeSnapShot();
                if (trader == null) {
                    base = strategyCfg.getString("base");
                    Logger.error("Could not load base '%s', not starting %s", base, t.getString("Name"));
                    continue block0;
                }
                ((AutoTraderBase)trader).setStrategyName(strategy_name);
                this.traders.add(trader);
                Boolean exclude = t.optBoolean("ExcludeInitial", false);
                if (!exclude.booleanValue()) {
                    moneyTotal = Float.valueOf(moneyTotal.floatValue() + money.floatValue());
                    sharesTotal = Float.valueOf(sharesTotal.floatValue() + shares.floatValue());
                }
                if ((color = t.optJSONArray("Color")) == null || color.length() != 3) continue;
                int[] c = new int[]{color.getInt(0), color.getInt(1), color.getInt(2)};
                ((AutoTraderBase)trader).color = c;
            }
        }
        for (i = 0; i < this.traders.size(); ++i) {
            this.traders.get(i).start();
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    static class TempAsset
    implements Asset {
        private final String symbol;
        private final Market se;

        TempAsset(String sym, Market se) {
            this.symbol = sym;
            this.se = se;
        }

        @Override
        public String getSymbol() {
            return this.symbol;
        }

        @Override
        public Market getMarket() {
            return this.se;
        }

        @Override
        public float getDf() {
            return this.se.getDf();
        }
    }

    public static final class CfgKeys {
        public static final String SESIMVERSION = "version";
        public static final String STRATEGIES = "strategies";
        public static final String TRADERS = "traders";
        public static final String EXCHANGE = "exchange";
        public static final String RANDOM = "random";
    }
}

