/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import sesim.TradingLogWriter;

public class TradingLogReader {
    private final FileChannel readChannel;
    private final RandomAccessFile raf;

    public TradingLogReader(String fileName) throws FileNotFoundException {
        this.raf = new RandomAccessFile(fileName, "r");
        this.readChannel = this.raf.getChannel();
    }

    public long size() throws IOException {
        if (this.readChannel == null || !this.readChannel.isOpen()) {
            return 0L;
        }
        long fileSize = this.readChannel.size();
        return fileSize / 72L;
    }

    public TradingLogWriter.TradingLogRecord get(long n) {
        if (n < 0L || this.readChannel == null || !this.readChannel.isOpen()) {
            return null;
        }
        try {
            long position = (n - 1L) * 72L;
            if (position + 72L > this.readChannel.size()) {
                System.out.printf("Datensatz %d existiert noch nicht oder ist unvollst\u00e4ndig (Dateigr\u00f6\u00dfe: %d).%n", n, this.readChannel.size());
                return null;
            }
            this.readChannel.position(position);
            ByteBuffer recordBuffer = ByteBuffer.allocate(72);
            int bytesRead = this.readChannel.read(recordBuffer);
            if (bytesRead != 72) {
                System.out.println("Fehler: Nur ein unvollst\u00e4ndiger Datensatz gelesen.");
                return null;
            }
            recordBuffer.flip();
            return TradingLogWriter.TradingLogRecord.read(recordBuffer);
        }
        catch (IOException e) {
            Logger.getLogger(TradingLogWriter.class.getName()).log(Level.SEVERE, "Fehler beim Lesen des Datensatzes " + n, e);
            return null;
        }
    }
}

