/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import sesim.Order;

public class TradingLogWriter
extends Thread {
    private Queue<ByteBuffer> queue = new ConcurrentLinkedQueue<ByteBuffer>();
    private BufferedOutputStream outStream;
    private boolean terminate = false;
    private ByteBuffer buffer = ByteBuffer.allocate(0x240000);

    public TradingLogWriter(String fileName) throws FileNotFoundException {
        this.outStream = new BufferedOutputStream(new FileOutputStream(fileName));
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.terminate) {
            ByteBuffer e = this.queue.poll();
            int i = 0;
            while (e != null) {
                try {
                    e.flip();
                    int n = e.array().length;
                    this.outStream.write(e.array(), 0, e.limit());
                    ++i;
                }
                catch (IOException ex) {
                    Logger.getLogger(TradingLogWriter.class.getName()).log(Level.SEVERE, null, ex);
                }
                e = this.queue.poll();
            }
            try {
                this.outStream.flush();
            }
            catch (IOException ex) {
                Logger.getLogger(TradingLogWriter.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (i == 0) {
                TradingLogWriter tradingLogWriter = this;
                synchronized (tradingLogWriter) {
                    ByteBuffer b;
                    int p;
                    if (this.queue.isEmpty() && (p = (b = this.newBuffer()).position()) > 0) {
                        this.queue.add(b);
                    }
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private ByteBuffer newBuffer() {
        ByteBuffer b = this.buffer;
        this.buffer = ByteBuffer.allocate(0x240000);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TradingLogRecord e) {
        long r = this.buffer.remaining();
        TradingLogWriter tradingLogWriter = this;
        synchronized (tradingLogWriter) {
            if (r < 72L) {
                this.queue.add(this.buffer);
                this.buffer = ByteBuffer.allocate(0x240000);
            } else {
                e.write(this.buffer);
            }
        }
        if (this.queue.size() > 1024) {
            while (this.queue.size() > 512) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void close() {
        this.terminate = true;
        try {
            this.outStream.close();
        }
        catch (IOException ex) {
            Logger.getLogger(TradingLogWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static class TradingLogRecord
    implements Serializable {
        private static final int OWNER_SIZE = 8;
        private static final int PARTNER_NAME_SIZE = 8;
        public static final int BLOCK_SIZE = 72;
        public byte orderType;
        public long time;
        public Action action;
        public long orderID;
        public String owner;
        public float volume;
        public float limit;
        public float stop;
        public float trasaction_volume;
        public float transaction_price;
        public long transaction_partner;
        public String transaction_partner_name;
        float currentPrice;

        public TradingLogRecord() {
        }

        public TradingLogRecord(long time, Action a, Order o) {
            this.time = time;
            this.action = a;
            this.orderID = o.id;
            this.orderType = o.getType();
            this.owner = o.getOwnerName();
            this.volume = o.getVolume();
            this.limit = o.getLimit();
            this.stop = o.getStop();
        }

        public void write(ByteBuffer buffer) {
            long p0 = buffer.position();
            buffer.putLong(this.time);
            buffer.put((byte)this.action.ordinal());
            buffer.put(this.orderType);
            buffer.putLong(this.orderID);
            buffer.putFloat(this.limit);
            buffer.putFloat(this.stop);
            buffer.putFloat(this.volume);
            buffer.putFloat(this.trasaction_volume);
            buffer.putFloat(this.transaction_price);
            buffer.putLong(this.transaction_partner);
            buffer.putFloat(this.currentPrice);
            this.writePaddedString(buffer, this.owner, 8);
            this.writePaddedString(buffer, this.transaction_partner_name, 8);
            long p1 = buffer.position();
            this.writePaddedString(buffer, "", (int)(72L - (p1 - p0)));
        }

        private void writePaddedString(ByteBuffer buffer, String s, int size2) {
            if (s == null) {
                s = "";
            }
            byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
            int length = Math.min(bytes.length, size2);
            buffer.put(bytes, 0, length);
            for (int i = length; i < size2; ++i) {
                buffer.put((byte)0);
            }
        }

        public static TradingLogRecord read(ByteBuffer buffer) {
            TradingLogRecord entry = new TradingLogRecord();
            entry.time = buffer.getLong();
            byte actionOrdinal = buffer.get();
            entry.action = actionOrdinal >= 0 && actionOrdinal < Action.values().length ? Action.values()[actionOrdinal] : Action.CREATE_ORDER;
            entry.orderType = buffer.get();
            entry.orderID = buffer.getLong();
            entry.limit = buffer.getFloat();
            entry.stop = buffer.getFloat();
            entry.volume = buffer.getFloat();
            entry.trasaction_volume = buffer.getFloat();
            entry.transaction_price = buffer.getFloat();
            entry.transaction_partner = buffer.getLong();
            entry.currentPrice = buffer.getFloat();
            entry.owner = TradingLogRecord.readPaddedString(buffer, 8);
            entry.transaction_partner_name = TradingLogRecord.readPaddedString(buffer, 8);
            return entry;
        }

        private static String readPaddedString(ByteBuffer buffer, int size2) {
            byte[] bytes = new byte[size2];
            buffer.get(bytes);
            int length = 0;
            for (int i = 0; i < size2 && bytes[i] != 0; ++i) {
                ++length;
            }
            return new String(bytes, 0, length, StandardCharsets.UTF_8);
        }

        public static enum Action {
            CREATE_ORDER,
            CANCEL_ORDER,
            CLOSE_ORDER,
            SELL,
            BUY;

        }
    }
}

