/*
 * Decompiled with CFR 0.152.
 */
package sesim.util;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class FastEventSet<T>
implements Iterable<T> {
    private final ArrayList<T> order = new ArrayList();
    private final IdentityHashMap<T, Boolean> alive = new IdentityHashMap();

    public void add(T event) {
        if (this.alive.put(event, Boolean.TRUE) == null) {
            this.order.add(event);
        }
    }

    public boolean remove(T event) {
        return this.alive.remove(event) != null;
    }

    public int size() {
        return this.alive.size();
    }

    public boolean isEmpty() {
        return this.alive.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                while (this.pos < FastEventSet.this.order.size() && !FastEventSet.this.alive.containsKey(FastEventSet.this.order.get(this.pos))) {
                    ++this.pos;
                }
                return this.pos < FastEventSet.this.order.size();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object event = FastEventSet.this.order.get(this.pos);
                ++this.pos;
                return event;
            }
        };
    }

    public void clear() {
        this.order.clear();
        this.alive.clear();
    }
}

