/*
 * Decompiled with CFR 0.152.
 */
package sesim.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class FastIterableSet<T extends Node<T>> {
    private T head = null;
    private T tail = null;
    private final Map<Object, T> map;

    public FastIterableSet() {
        this.map = new HashMap<Object, T>();
    }

    public FastIterableSet(int capacity) {
        this.map = new HashMap<Object, T>(capacity);
    }

    public void add(T event) {
        if (this.map.putIfAbsent(event, event) == null) {
            if (this.tail == null) {
                this.tail = event;
                this.head = this.tail;
            } else {
                this.tail.setNext(event);
                this.tail = event;
            }
            event.setNext(null);
        }
    }

    public boolean remove(Object key) {
        Node node = (Node)this.map.remove(key);
        return node != null;
    }

    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private T current;
            private T nextValid;
            {
                this.current = FastIterableSet.this.head;
                this.nextValid = null;
            }

            private void advance() {
                while (this.current != null && !FastIterableSet.this.map.containsKey(this.current)) {
                    this.current = (Node)this.current.getNext();
                }
                this.nextValid = this.current;
            }

            @Override
            public boolean hasNext() {
                if (this.nextValid == null) {
                    this.advance();
                }
                return this.nextValid != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object result = this.nextValid;
                this.current = (Node)result.getNext();
                this.nextValid = null;
                return result;
            }
        };
    }

    public void compact() {
        if (this.head == null) {
            return;
        }
        Node prev = null;
        for (Object curr = this.head; curr != null; curr = (Node)curr.getNext()) {
            if (!this.map.containsKey(curr)) continue;
            if (prev != null) {
                prev.setNext(curr);
            }
            prev = (Node)curr;
        }
        this.head = this.map.isEmpty() ? null : (Node)this.map.values().iterator().next();
        this.tail = prev;
        if (this.tail != null) {
            this.tail.setNext(null);
        }
    }

    public static interface Node<T> {
        public T getNext();

        public void setNext(T var1);
    }
}

