/*
 * Decompiled with CFR 0.152.
 */
package traders.GroovyTrader;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.swing.JDialog;
import org.json.JSONObject;
import sesim.Account;
import sesim.AutoTraderBase;
import sesim.AutoTraderGui;
import sesim.Logger;
import sesim.Market;
import sesim.Order;
import sesim.Quote;
import sesim.Scheduler;
import sesim.Sim;
import traders.GroovyTrader.GroovyTraderGui;

public class GroovyTrader
extends AutoTraderBase {
    static HashMap<String, Class<? extends Script>> scripts = new HashMap();
    String sourceCode = null;
    Script groovyScript;
    final String CFG_SRC = "src";
    AccountApi accountApi;
    SeSimApi sesimApi;

    @Override
    public void reset() {
        scripts = new HashMap();
    }

    public GroovyTrader() {
        if (this.getSourceCode() != null) {
            return;
        }
        try (InputStream is = this.getClass().getResourceAsStream("/files/GroovyTrader/default.groovy");){
            String content;
            if (is == null) {
                throw new IOException("SQL-Resource nicht im JAR gefunden: ");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                content = sb.toString();
            }
            this.setSeourceCode(content);
        }
        catch (IOException ex) {
            Logger.error("Cannot load /files/GroovyTrader/default.groovy", new Object[0]);
        }
    }

    @Override
    public void start() {
        this.accountApi = new AccountApi();
        this.sesimApi = new SeSimApi();
        Binding binding = new Binding();
        binding.setVariable("account", this.accountApi);
        binding.setVariable("sesim", this.sesimApi);
        try {
            Class<? extends Script> groovyScriptClass = this.getGroovyClass();
            if (groovyScriptClass == null) {
                return;
            }
            this.groovyScript = groovyScriptClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.groovyScript.setBinding(binding);
            this.groovyScript.invokeMethod("start", new Object[0]);
        }
        catch (Exception e) {
            this.logGroovyError("[Calling start()]", e);
        }
    }

    void logGroovyError(String extra, Exception e) {
        Throwable cause = e.getCause();
        if (cause != null) {
            String line = "";
            for (StackTraceElement ste : cause.getStackTrace()) {
                if (ste.getFileName() == null || !ste.getFileName().endsWith(".groovy")) continue;
                line = String.format("%s:%s, line %d", ste.getFileName(), ste.getMethodName(), ste.getLineNumber());
            }
            Logger.error("GroovyTrader '%s'%s: %s: %s", this.getName(), extra, line, cause.toString());
        } else {
            Logger.error("GroovyTrader '%s'%s: %s", this.getName(), extra, e.getMessage());
        }
    }

    @Override
    public JDialog getGuiConsole(Frame parent) {
        return null;
    }

    @Override
    public boolean getDevelStatus() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return "Groovy Trader";
    }

    @Override
    public AutoTraderGui getGui() {
        return new GroovyTraderGui(this);
    }

    @Override
    public JSONObject getConfig() {
        JSONObject r = new JSONObject();
        r.put("src", this.getSourceCode());
        return r;
    }

    @Override
    public void setConfig(JSONObject cfg) {
        this.setSeourceCode(cfg.optString("src", null));
    }

    @Override
    public void processEvent(long time, Scheduler.Event e) {
    }

    final String getSourceCode() {
        return this.sourceCode;
    }

    final void setSeourceCode(String s) {
        this.sourceCode = s;
    }

    Class<? extends Script> getGroovyClass() {
        Class<? extends Script> c = scripts.get(this.getStrategyName());
        if (c != null) {
            return c;
        }
        return this.compileSource();
    }

    Class<? extends Script> compileSource() {
        Class groovyScriptClass;
        GroovyClassLoader loader = new GroovyClassLoader();
        String source = this.getSourceCode();
        try {
            groovyScriptClass = loader.parseClass(source, this.getStrategyName() + ".groovy");
        }
        catch (Exception e) {
            this.logGroovyError("[compile source]", e);
            return null;
        }
        scripts.put(this.getStrategyName(), groovyScriptClass);
        return groovyScriptClass;
    }

    public class AccountApi {
        public float getCashBalance() {
            return GroovyTrader.this.account.getMoney();
        }

        public float getShares() {
            return GroovyTrader.this.account.getShares();
        }
    }

    public class SeSimApi
    implements Market.AccountListener {
        public final byte BUYLIMIT = (byte)2;
        public final byte SELLIMIT = (byte)3;
        public final byte SELL = 1;
        public final byte BUY = 0;
        public final byte STOPLOSS = (byte)5;
        String groovyAccountUpdateFun = null;

        SeSimApi() {
            GroovyTrader.this.account.setListener(this);
        }

        public Order createOrder(byte type, double vol, double limit, double stop) {
            limit = GroovyTrader.this.se.roundMoney(limit);
            vol = GroovyTrader.this.se.roundShares(vol);
            return GroovyTrader.this.se.createOrder(GroovyTrader.this.account, type, (float)vol, (float)limit, (float)stop);
        }

        public void logError(String msg, Object ... args) {
            Logger.error(msg, args);
        }

        public void logInfo(String msg, Object ... args) {
            Logger.info(msg, args);
        }

        public boolean cancleOrder(Order o) {
            if (o == null) {
                return false;
            }
            return GroovyTrader.this.se.cancelOrder(GroovyTrader.this.account, o.getID());
        }

        public Quote getLastQuote() {
            return GroovyTrader.this.se.getLastQuoete();
        }

        public float getLastPrice() {
            return this.getLastQuote().getPrice();
        }

        public boolean scheduleOnce(String groovyFun, long timer) {
            GroovyTimerEvent g = new GroovyTimerEvent(groovyFun, timer);
            GroovyTrader.this.sim.addEvent(GroovyTrader.this.sim.getCurrentTimeMillis() + timer, g);
            return true;
        }

        public long getRandom(long a, long b) {
            return Sim.random.nextLong(a, b);
        }

        public double getRandom(double a, double b) {
            return Sim.random.nextDouble(a, b);
        }

        public void setStatus(String s, Object ... args) {
            GroovyTrader.this.setStatus(s, args);
        }

        public String getName() {
            return GroovyTrader.this.getName();
        }

        public GroovyPriceEvent scheduleOnPriceAbove(String groovyFun, double price) {
            GroovyPriceEvent e = new GroovyPriceEvent(groovyFun, GroovyTrader.this.sim.getExchange(), price);
            GroovyTrader.this.sim.getExchange().sheduleOnPriceAbove(e);
            return e;
        }

        public void cancelScheduleOnPriceAbove(GroovyPriceEvent e) {
            GroovyTrader.this.sim.getExchange().cancelScheduleOnPriceAbove(e);
        }

        public GroovyPriceEvent scheduleOnPriceBelow(String groovyFun, double price) {
            GroovyPriceEvent e = new GroovyPriceEvent(groovyFun, GroovyTrader.this.sim.getExchange(), price);
            GroovyTrader.this.sim.getExchange().sheduleOnPriceBelow(e);
            return e;
        }

        public void cancelSchedulePriceBelow(GroovyPriceEvent e) {
            GroovyTrader.this.sim.getExchange().cancelScheduleOnPriceBelow(e);
        }

        @Override
        public void accountUpdated(Account a, Order o) {
            if (this.groovyAccountUpdateFun != null) {
                try {
                    Object object = GroovyTrader.this.groovyScript.invokeMethod(this.groovyAccountUpdateFun, new Object[]{o});
                }
                catch (Exception e) {
                    GroovyTrader.this.logGroovyError("[accountupdate]", e);
                }
            }
        }

        public void onAccountUpdate(String groovyFun) {
            this.groovyAccountUpdateFun = groovyFun;
        }

        private class GroovyTimerEvent
        extends Scheduler.Event
        implements Scheduler.EventProcessor {
            final String groovyFun;

            public GroovyTimerEvent(String fun, long t) {
                super(GroovyTrader.this);
                this.eventProcessor = this;
                this.groovyFun = fun;
            }

            @Override
            public void processEvent(long time, Scheduler.Event e) {
                try {
                    Object object = GroovyTrader.this.groovyScript.invokeMethod(this.groovyFun, new Object[0]);
                }
                catch (Exception ex) {
                    String extra = String.format("[scheduleOnce(%s)]", this.groovyFun);
                    GroovyTrader.this.logGroovyError(extra, ex);
                }
            }
        }

        public class GroovyPriceEvent
        extends Market.PriceEvent
        implements Scheduler.EventProcessor {
            final String groovyFun;

            public GroovyPriceEvent(String fun, Market se, double price) {
                super(se, price);
                this.eventProcessor = this;
                this.groovyFun = fun;
            }

            @Override
            public void processEvent(long time, Scheduler.Event e) {
                try {
                    Object object = GroovyTrader.this.groovyScript.invokeMethod(this.groovyFun, new Object[0]);
                }
                catch (Exception ex) {
                    GroovyTrader.this.logGroovyError("[price Event]", ex);
                }
            }
        }
    }
}

