/*
 * Decompiled with CFR 0.152.
 */
package traders.GroovyTrader;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.rsta.ui.search.ReplaceDialog;
import org.fife.rsta.ui.search.SearchEvent;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import sesim.AutoTraderGui;
import traders.GroovyTrader.GroovyTrader;

public class GroovyTraderGui
extends AutoTraderGui
implements SearchListener {
    RSyntaxTextArea textArea;
    GroovyTrader trader;
    ReplaceDialog replaceDialog;
    FindDialog findDialog;

    public GroovyTraderGui(GroovyTrader trader) {
        this.trader = trader;
        this.initComponents();
        this.setLayout(new BorderLayout());
        this.textArea = new RSyntaxTextArea(20, 60);
        this.textArea.setSyntaxEditingStyle("text/groovy");
        this.textArea.setCodeFoldingEnabled(true);
        this.setText(trader.getSourceCode());
        RTextScrollPane sp = new RTextScrollPane(this.textArea);
        this.add((Component)sp, "Center");
        final JDialog parent = (JDialog)SwingUtilities.getWindowAncestor(this);
        this.findDialog = new FindDialog((Dialog)parent, (SearchListener)this);
        this.findDialog.setModalityType(Dialog.ModalityType.MODELESS);
        this.findDialog.pack();
        this.findDialog.setMinimumSize(this.findDialog.getSize());
        this.replaceDialog = new ReplaceDialog((Dialog)parent, (SearchListener)this);
        this.replaceDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        SearchContext context = this.findDialog.getSearchContext();
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isControlDown() && e.getKeyCode() == 70) {
                    GroovyTraderGui.this.findDialog.setAlwaysOnTop(true);
                    GroovyTraderGui.this.findDialog.setLocationRelativeTo(parent);
                    GroovyTraderGui.this.findDialog.setVisible(true);
                } else if (e.isControlDown() && e.getKeyCode() == 72) {
                    GroovyTraderGui.this.replaceDialog.setVisible(true);
                }
            }
        });
        this.setVisible(true);
    }

    void setText(String text) {
        this.textArea.setText(text);
    }

    String getText() {
        return this.textArea.getText();
    }

    @Override
    public void save() {
        this.trader.setSeourceCode(this.getText());
    }

    private void initComponents() {
        this.setLayout(null);
    }

    @Override
    public void searchEvent(SearchEvent e) {
        SearchResult result;
        SearchEvent.Type type = e.getType();
        SearchContext context = e.getSearchContext();
        switch (type) {
            default: {
                result = SearchEngine.markAll(this.textArea, context);
                break;
            }
            case FIND: {
                result = SearchEngine.find(this.textArea, context);
                if (result.wasFound() && !result.isWrapped()) break;
                UIManager.getLookAndFeel().provideErrorFeedback(this.textArea);
                break;
            }
            case REPLACE: {
                result = SearchEngine.replace(this.textArea, context);
                if (result.wasFound() && !result.isWrapped()) break;
                UIManager.getLookAndFeel().provideErrorFeedback(this.textArea);
                break;
            }
            case REPLACE_ALL: {
                result = SearchEngine.replaceAll(this.textArea, context);
                JOptionPane.showMessageDialog(null, result.getCount() + " occurrences replaced.");
            }
        }
        if (result.wasFound()) {
            String text = "Text found; occurrences marked: " + result.getMarkedCount();
        } else if (type == SearchEvent.Type.MARK_ALL) {
            if (result.getMarkedCount() > 0) {
                String text = "Occurrences marked: " + result.getMarkedCount();
            } else {
                String text = "";
            }
        } else {
            String text = "Text not found";
        }
    }

    @Override
    public String getSelectedText() {
        return this.textArea.getSelectedText();
    }
}

