/*
 * Decompiled with CFR 0.152.
 */
package traders.ManTrader;

import java.awt.Font;
import java.text.DecimalFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import sesim.Account;
import sesim.Market;
import sesim.Quote;

public class AccountBalance
extends JPanel
implements Market.QuoteReceiver {
    Account account;
    ExecutorService executor = Executors.newSingleThreadExecutor();
    boolean busy;
    boolean update;
    Quote quote;
    private JLabel cashLabel;
    private JLabel equity;
    private JLabel freeMargin;
    private JLabel jLabel1;
    private JLabel marginUsed;
    private JLabel moneyLabelText;
    private JLabel sharesLabelText;
    private JLabel sharesLabelText1;
    private JLabel totalLabel;
    private JLabel volAvailLabel;

    public AccountBalance(Account a) {
        this.initComponents();
        this.account = a;
        if (a == null) {
            return;
        }
        a.getDefaultMarket().addQuoteReceiver(this);
    }

    public AccountBalance() {
        this((Account)null);
    }

    public void updateBalance(Account account) {
        DecimalFormat mf = account.getDefaultMarket().getMoneyFormatter();
        this.cashLabel.setText(mf.format(account.getMoney()));
        DecimalFormat sf = account.getDefaultMarket().getSharesFormatter();
        this.marginUsed.setText(mf.format(account.getMarginUsed()));
        this.freeMargin.setText(mf.format(account.getFreeMargin()));
        this.equity.setText(mf.format(account.getEquity()));
        float lp = account.getDefaultMarket().getLastPrice();
        float total = lp * account.getShares() + account.getMoney();
        float iniTotal = lp * account.getInitialShares() + account.getInitialMoney();
        float perc = total / (iniTotal / 100.0f) - 100.0f;
        String s = String.format("%s (%.1f%%)", mf.format(total), Float.valueOf(perc));
        this.totalLabel.setText(s);
    }

    @Override
    public void UpdateQuote(Quote q) {
        if (q == null) {
            return;
        }
        if (this.busy) {
            this.quote = q;
            this.update = true;
            return;
        }
        this.busy = true;
        this.update = true;
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    while (AccountBalance.this.update) {
                        Quote q = AccountBalance.this.quote;
                        AccountBalance.this.update = false;
                        if (q == null) {
                            return;
                        }
                        SwingUtilities.invokeLater(() -> AccountBalance.this.updateBalance(AccountBalance.this.account));
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                finally {
                    AccountBalance.this.busy = false;
                }
            }
        });
    }

    private void initComponents() {
        this.moneyLabelText = new JLabel();
        this.sharesLabelText = new JLabel();
        this.freeMargin = new JLabel();
        this.volAvailLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.marginUsed = new JLabel();
        this.sharesLabelText1 = new JLabel();
        this.cashLabel = new JLabel();
        this.equity = new JLabel();
        this.totalLabel = new JLabel();
        this.moneyLabelText.setText("Cash:");
        this.sharesLabelText.setText("Margin used");
        this.freeMargin.setText("0.0");
        this.volAvailLabel.setText("Free Margin");
        this.jLabel1.setText("Equity");
        this.marginUsed.setText("0");
        this.sharesLabelText1.setFont(new Font("Noto Sans", 0, 24));
        this.sharesLabelText1.setText("Total:");
        this.cashLabel.setText("0.0000");
        this.equity.setHorizontalAlignment(4);
        this.equity.setText("0");
        this.totalLabel.setFont(new Font("Noto Sans", 0, 24));
        this.totalLabel.setHorizontalAlignment(4);
        this.totalLabel.setText("0.0000");
        GroupLayout layout2 = new GroupLayout(this);
        this.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.sharesLabelText1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.volAvailLabel, GroupLayout.Alignment.LEADING, -2, 77, -2).addComponent(this.sharesLabelText, GroupLayout.Alignment.LEADING, -1, 118, Short.MAX_VALUE).addComponent(this.moneyLabelText, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.freeMargin, -1, -1, Short.MAX_VALUE).addComponent(this.marginUsed, -1, -1, Short.MAX_VALUE).addComponent(this.equity, -1, -1, Short.MAX_VALUE).addComponent(this.totalLabel, -1, 162, Short.MAX_VALUE).addComponent(this.cashLabel, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.moneyLabelText).addComponent(this.cashLabel)).addGap(12, 12, 12).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.volAvailLabel).addComponent(this.freeMargin)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sharesLabelText).addComponent(this.marginUsed)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 17, -2).addComponent(this.equity)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sharesLabelText1).addComponent(this.totalLabel)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

