/*
 * Decompiled with CFR 0.152.
 */
package traders;

import org.json.JSONObject;
import sesim.AutoTraderBase;
import sesim.AutoTraderGui;
import sesim.Order;
import sesim.Scheduler;

public class MarketMaker
extends AutoTraderBase {
    int numPositions = 15;
    float timerInterval = 3.0f;
    float depthPercent = 8.0f;
    private MMOrder[] orders;
    private Scheduler.Event TIMEREVENT;

    @Override
    public void start() {
        this.initOrders();
        this.TIMEREVENT = new Scheduler.Event(this);
        this.sim.addEvent(this.sim.getCurrentTimeMillis() + (long)(1000.0f * this.timerInterval), this.TIMEREVENT);
    }

    private void initOrders() {
        float centerPrice = this.se.getLastPrice();
        float lowestPrice = centerPrice - this.depthPercent * centerPrice / 100.0f;
        this.orders = new MMOrder[this.numPositions];
        float dist = (centerPrice - lowestPrice) / (float)(this.numPositions + 1);
        float cashPerBuyOrder = this.account.getMoney() / (float)(this.numPositions + 1);
        float price = lowestPrice + dist;
        for (int i = 0; i < this.numPositions; ++i) {
            this.orders[i] = new MMOrder();
            this.orders[i].buyLimit = this.se.roundMoney(price);
            this.orders[i].sellLimit = this.se.roundMoney(price += dist);
            this.orders[i].volume = this.se.roundShares(cashPerBuyOrder / price);
            this.orders[i].o = this.se.createOrder(this.account, (byte)2, this.orders[i].volume, this.orders[i].buyLimit, 0.0f);
        }
        this.setStatus("%f - %f", Float.valueOf(lowestPrice), Float.valueOf(centerPrice));
    }

    private void flipOrders() {
        for (int i = 0; i < this.numPositions; ++i) {
            Order n;
            Order o = this.orders[i].o;
            if (this.orders[i].o == null || o.getStatus() != 4) continue;
            if (o.getType() == 3) {
                n = this.se.createOrder(this.account, (byte)2, this.orders[i].volume, this.orders[i].buyLimit, 0.0f);
                if (n == null) continue;
                this.orders[i].o = n;
                continue;
            }
            n = this.se.createOrder(this.account, (byte)3, this.orders[i].volume, this.orders[i].sellLimit, 0.0f);
            if (n == null) continue;
            this.orders[i].o = n;
        }
    }

    private boolean readjustOrders() {
        for (int i = 0; i < this.numPositions; ++i) {
            byte s;
            if (this.orders[i].o == null || (s = this.orders[i].o.getStatus()) == 1) continue;
            return false;
        }
        float price = this.se.getLastPrice();
        if (price <= this.orders[this.numPositions - 1].sellLimit) {
            return false;
        }
        for (int i = 0; i < this.numPositions; ++i) {
            if (this.orders[i].o == null) continue;
            this.se.cancelOrder(this.account, this.orders[i].o.getID());
        }
        this.initOrders();
        return true;
    }

    @Override
    public void processEvent(long time, Scheduler.Event e) {
        if (!this.readjustOrders()) {
            this.flipOrders();
        }
        this.sim.addEvent(this.sim.getCurrentTimeMillis() + (long)(1000.0f * this.timerInterval), this.TIMEREVENT);
    }

    @Override
    public boolean getDevelStatus() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return "MarketMaker";
    }

    @Override
    public AutoTraderGui getGui() {
        return null;
    }

    @Override
    public JSONObject getConfig() {
        return new JSONObject();
    }

    @Override
    public void setConfig(JSONObject cfg) {
    }

    class MMOrder {
        Order o = null;
        float buyLimit;
        float sellLimit;
        float volume;

        MMOrder() {
        }
    }
}

