/*
 * Decompiled with CFR 0.152.
 */
package traders;

import org.json.JSONArray;
import org.json.JSONObject;
import sesim.Account;
import sesim.AutoTraderBase;
import sesim.AutoTraderGui;
import sesim.Market;
import sesim.Order;
import sesim.Quote;
import sesim.Scheduler;
import sesim.Sim;
import traders.RandomTraderGuiA;

public class RandomTraderA
extends AutoTraderBase
implements Market.AccountListener {
    public float[] initial_delay = new float[]{0.0f, 7.0f};
    public float[] sell_volume = new float[]{100.0f, 100.0f};
    public float[] sell_limit = new float[]{-2.0f, 2.0f};
    public float[] sell_wait = new float[]{10.0f, 50.0f};
    public float[] wait_after_sell = new float[]{0.0f, 0.0f};
    public float[] buy_volume = new float[]{100.0f, 100.0f};
    public float[] buy_limit = new float[]{-2.0f, 2.0f};
    public float[] buy_wait = new float[]{10.0f, 50.0f};
    public float[] wait_after_buy = new float[]{0.0f, 0.0f};
    public float[] wait_after_fail = new float[]{1.0f, 15.0f};
    final String INITIAL_DELAY = "initial_delay";
    final String SELL_VOLUME = "sell_volume";
    final String BUY_VOLUME = "buy_volume";
    final String SELL_LIMIT = "sell_limit";
    final String BUY_LIMIT = "buy_limit";
    final String SELL_WAIT = "sell_wait";
    final String BUY_WAIT = "buy_wait";
    final String WAIT_AFTER_SELL = "sell_wait_after";
    final String WAIT_AFTER_BUY = "buy_wait_after";
    final String WAIT_AFTER_FAIL = "wait_after_fail";
    long wait_after_timeout = 1000L;
    private final Scheduler.Event TRADEEVENT = new Scheduler.Event(this);
    private long tradeEventTime;
    private final Scheduler.Event ORDERFILLEDEVENT = new Scheduler.Event(this);
    private Order currentOrder = null;

    @Override
    public void start() {
        Account a = this.account;
        a.setListener(this);
        long delay = (long)(this.getRandom(this.initial_delay[0], this.initial_delay[1]) * 1000.0f);
        this.setStatus("Inital delay: %d", delay);
        this.tradeEventTime = delay + this.sim.getCurrentTimeMillis();
        this.sim.addEvent(this.tradeEventTime, this.TRADEEVENT);
    }

    @Override
    public void processEvent(long time, Scheduler.Event e) {
        if (time != this.tradeEventTime) {
            // empty if block
        }
        if (e == this.TRADEEVENT) {
            long t = 0L;
            if (this.account.getShares() == 0.0f && (double)this.account.getMoney() < 0.3) {
                this.setStatus("Ruined", new Object[0]);
            }
            t = this.currentOrder == null ? this.doBuyOrSell() : this.handleCurrentOrder();
            this.tradeEventTime = t + this.sim.getCurrentTimeMillis();
            this.sim.addEvent(this.tradeEventTime, e);
        }
    }

    @Override
    public String getDisplayName() {
        return "Random Trader (A)";
    }

    @Override
    public AutoTraderGui getGui() {
        return new RandomTraderGuiA(this);
    }

    @Override
    public JSONObject getConfig() {
        JSONObject cfg = new JSONObject();
        cfg.put("initial_delay", this.initial_delay);
        cfg.put("sell_volume", this.sell_volume);
        cfg.put("buy_volume", this.buy_volume);
        cfg.put("sell_limit", this.sell_limit);
        cfg.put("buy_limit", this.buy_limit);
        cfg.put("sell_wait", this.sell_wait);
        cfg.put("buy_wait", this.buy_wait);
        cfg.put("sell_wait_after", this.wait_after_sell);
        cfg.put("buy_wait_after", this.wait_after_buy);
        cfg.put("base", this.getClass().getCanonicalName());
        return cfg;
    }

    private float[] to_float(JSONArray a) {
        float[] ret2 = new float[a.length()];
        for (int i = 0; i < a.length(); ++i) {
            ret2[i] = (float)a.getDouble(i);
        }
        return ret2;
    }

    @Override
    public void setConfig(JSONObject cfg) {
        if (cfg == null) {
            return;
        }
        this.initial_delay = this.to_float(cfg.getJSONArray("initial_delay"));
        this.sell_volume = this.to_float(cfg.getJSONArray("sell_volume"));
        this.buy_volume = this.to_float(cfg.getJSONArray("buy_volume"));
        this.sell_limit = this.to_float(cfg.getJSONArray("sell_limit"));
        this.buy_limit = this.to_float(cfg.getJSONArray("buy_limit"));
        this.sell_wait = this.to_float(cfg.getJSONArray("sell_wait"));
        this.buy_wait = this.to_float(cfg.getJSONArray("buy_wait"));
        this.wait_after_sell = this.to_float(cfg.getJSONArray("sell_wait_after"));
        this.wait_after_buy = this.to_float(cfg.getJSONArray("buy_wait_after"));
    }

    @Override
    public boolean getDevelStatus() {
        return true;
    }

    @Override
    public void accountUpdated(Account a, Order o) {
        if (this.currentOrder == null) {
            return;
        }
        if (this.currentOrder.getStatus() != 4) {
            return;
        }
        boolean rc = this.sim.delEvent(this.tradeEventTime, this.TRADEEVENT);
        this.tradeEventTime = this.currentOrder.getType() == 2 ? (long)(this.getRandom(this.wait_after_buy) * 1000.0f) : (long)(this.getRandom(this.wait_after_sell) * 1000.0f);
        this.tradeEventTime += this.sim.getCurrentTimeMillis();
        this.currentOrder = null;
        this.sim.addEvent(this.tradeEventTime, this.TRADEEVENT);
    }

    private Action getAction() {
        if (Sim.randNextInt(2) == 0) {
            return Action.BUY;
        }
        return Action.SELL;
    }

    private long handleCurrentOrder() {
        Order o = this.currentOrder;
        this.currentOrder = null;
        byte s = o.getStatus();
        if (s == 1 || s == 3) {
            this.se.cancelOrder(this.account, o.getID());
            this.currentOrder = null;
            this.setStatus("Sleep after timeout", new Object[0]);
            return (long)(this.getRandom(this.wait_after_fail) * 1000.0f);
        }
        if (o.getType() == 2) {
            this.setStatus("Sleep after buy", new Object[0]);
            long r = (long)(this.getRandom(this.wait_after_buy) * 1000.0f);
            return r;
        }
        this.setStatus("Sleep after sell", new Object[0]);
        return (long)(this.getRandom(this.wait_after_sell) * 1000.0f);
    }

    private long doBuyOrSell() {
        Action a = this.getAction();
        switch (a.ordinal()) {
            case 0: {
                Order o = this.doBuy();
                if (o == null) {
                    this.setStatus("Buy failed", new Object[0]);
                    float r = this.getRandom(this.wait_after_fail) * 1000.0f;
                    return (long)r;
                }
                if (o.getStatus() == 4) {
                    this.setStatus("Sleep after buy", new Object[0]);
                    return (long)(this.getRandom(this.wait_after_buy) * 1000.0f);
                }
                this.currentOrder = o;
                this.setStatus("Waiting for buy order", new Object[0]);
                return (long)(this.getRandom(this.buy_wait) * 1000.0f);
            }
            case 1: {
                Order o = this.doSell();
                if (o == null) {
                    this.setStatus("Sell failed", new Object[0]);
                    float r = this.getRandom(this.wait_after_fail) * 1000.0f;
                    return (long)r;
                }
                if (o.getStatus() == 4) {
                    this.setStatus("Sleep after sell", new Object[0]);
                    return (long)(this.getRandom(this.wait_after_sell) * 1000.0f);
                }
                this.currentOrder = o;
                this.setStatus("Waiting for sell order", new Object[0]);
                return (long)(this.getRandom(this.sell_wait) * 1000.0f);
            }
        }
        return (long)(this.getRandom(this.wait_after_fail) * 1000.0f);
    }

    protected float getRandom(float min2, float max2) {
        RandomTraderA randomTraderA = this;
        double r = randomTraderA.sim.randNextDouble();
        return (float)((double)(max2 - min2) * r + (double)min2);
    }

    protected float getRandom(float[] minmax) {
        return this.getRandom(minmax[0], minmax[1]);
    }

    private float getRandomAmmount(float val, float[] minmax) {
        float min2 = val * minmax[0] / 100.0f;
        float max2 = val * minmax[1] / 100.0f;
        return this.getRandom(min2, max2);
    }

    private Order xdoBuy() {
        byte type = 2;
        float money = this.getRandomAmmount(this.account.getMoney(), this.buy_volume);
        Quote q = this.se.getBestPrice_0();
        float lp = q.getPrice();
        float limit = lp + (float)Sim.random.nextLong(0L, 4L) - 2.0f;
        float volume2 = money / limit;
        limit = this.se.roundMoney(limit);
        volume2 = this.se.roundShares(volume2);
        if (limit <= 0.0f) {
            return null;
        }
        return this.se.createOrder(this.account, type, volume2, limit, 0.0f);
    }

    double getRandomPrice(double lastPrice, double tickSize, double minPercent, double maxPercent) {
        int minTicks = (int)Math.round(lastPrice * minPercent / 100.0 / tickSize);
        int maxTicks = (int)Math.round(lastPrice * maxPercent / 100.0 / tickSize);
        if (minTicks > -1 && minTicks < 1) {
            int n = minTicks = minPercent < 0.0 ? -1 : 1;
        }
        if (maxTicks > -1 && maxTicks < 1) {
            maxTicks = maxPercent < 0.0 ? -1 : 1;
        }
        int tickChange = Sim.random.nextInt(maxTicks - minTicks + 1) + minTicks;
        double newPrice = lastPrice + (double)tickChange * tickSize;
        newPrice = (double)Math.round(newPrice / tickSize) * tickSize;
        return newPrice;
    }

    private Order doBuy() {
        float money = this.getRandomAmmount(this.account.getMoney(), this.buy_volume);
        Quote q = this.se.getBestPrice_0();
        float lp = q.getPrice();
        float limit = (float)this.getRandomPrice(lp, 0.01, this.buy_limit[0], this.buy_limit[1]);
        float volume2 = money / limit;
        volume2 = this.se.roundShares(volume2);
        if (limit <= 0.0f) {
            return null;
        }
        return this.se.createOrder(this.account, (byte)2, volume2, limit, 0.0f);
    }

    private Order doSell() {
        float volume2 = this.getRandomAmmount(this.account.getShares(), this.sell_volume);
        volume2 = this.se.roundShares(volume2);
        Quote q = this.se.getBestPrice_0();
        float lp = q.getPrice();
        float limit = (float)this.getRandomPrice(lp, 0.01, this.sell_limit[0], this.sell_limit[1]);
        this.se.roundMoney(limit);
        if (limit <= 0.0f) {
            return null;
        }
        return this.se.createOrder(this.account, (byte)3, volume2, limit, 0.0f);
    }

    private static enum Action {
        BUY,
        SELL;

    }
}

