/*
 * Decompiled with CFR 0.152.
 */
package traders;

import java.util.Iterator;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import sesim.Account;
import sesim.AutoTraderBase;
import sesim.AutoTraderGui;
import sesim.Quote;
import sesim.Scheduler;
import sesim.Sim;

public class RandomTraderB
extends AutoTraderBase {
    public Float[] initial_delay = new Float[]{Float.valueOf(0.0f), Float.valueOf(5.0f)};
    public Float[] sell_volume = new Float[]{Float.valueOf(100.0f), Float.valueOf(100.0f)};
    public Float[] sell_limit = new Float[]{Float.valueOf(-2.0f), Float.valueOf(2.0f)};
    public Long[] sell_wait = new Long[]{10000L, 50000L};
    public Long[] wait_after_sell = new Long[]{1000L, 30000L};
    public Float[] buy_volume = new Float[]{Float.valueOf(100.0f), Float.valueOf(100.0f)};
    public Float[] buy_limit = new Float[]{Float.valueOf(-2.0f), Float.valueOf(2.0f)};
    public Long[] buy_wait = new Long[]{10000L, 50000L};
    public Long[] wait_after_buy = new Long[]{10L, 30L};
    final String INITIAL_DELAY = "initla_delay";
    final String SELL_VOLUME = "sell_volume";
    final String BUY_VOLUME = "buy_volume";
    final String SELL_LIMIT = "sell_limit";
    final String BUY_LIMIT = "buy_limit";
    final String SELL_WAIT = "sell_wait";
    final String BUY_WAIT = "buy_wait";
    final String WAIT_AFTER_SELL = "sell_wait_after";
    final String WAIT_AFTER_BUY = "buy_wait_after";
    Action mode = Action.RANDOM;

    @Override
    public void start() {
        long delay = (long)(this.getRandom(this.initial_delay[0].floatValue(), this.initial_delay[1].floatValue()) * 1000.0f);
    }

    @Override
    public void processEvent(long time, Scheduler.Event e) {
        long rc = this.doTrade();
    }

    @Override
    public String getDisplayName() {
        return "Random Trader B";
    }

    @Override
    public AutoTraderGui getGui() {
        return null;
    }

    @Override
    public JSONObject getConfig() {
        JSONObject jo = new JSONObject();
        jo.put("initla_delay", this.initial_delay);
        jo.put("sell_volume", this.sell_volume);
        jo.put("buy_volume", this.buy_volume);
        jo.put("sell_limit", this.sell_limit);
        jo.put("buy_limit", this.buy_limit);
        jo.put("sell_wait", this.sell_wait);
        jo.put("buy_wait", this.buy_wait);
        jo.put("sell_wait_after", this.wait_after_sell);
        jo.put("buy_wait_after", this.wait_after_buy);
        jo.put("base", this.getClass().getCanonicalName());
        return jo;
    }

    private Float[] to_float(JSONArray a) {
        Float[] ret2 = new Float[a.length()];
        for (int i = 0; i < a.length(); ++i) {
        }
        return ret2;
    }

    private Long[] to_long(JSONArray a) {
        Long[] ret2 = new Long[a.length()];
        for (int i = 0; i < a.length(); ++i) {
            ret2[i] = a.getLong(i);
        }
        return ret2;
    }

    @Override
    public void setConfig(JSONObject cfg) {
        if (cfg == null) {
            return;
        }
        try {
            this.initial_delay = this.to_float(cfg.getJSONArray("initla_delay"));
            this.sell_volume = this.to_float(cfg.getJSONArray("sell_volume"));
            this.buy_volume = this.to_float(cfg.getJSONArray("buy_volume"));
            this.sell_limit = this.to_float(cfg.getJSONArray("sell_limit"));
            this.buy_limit = this.to_float(cfg.getJSONArray("buy_limit"));
            this.sell_wait = this.to_long(cfg.getJSONArray("sell_wait"));
            this.buy_wait = this.to_long(cfg.getJSONArray("buy_wait"));
            this.wait_after_sell = this.to_long(cfg.getJSONArray("sell_wait_after"));
            this.wait_after_buy = this.to_long(cfg.getJSONArray("buy_wait_after"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean getDevelStatus() {
        return true;
    }

    public long cancelOrders() {
        int n = this.account.getNumberOfOpenOrders();
        if (n > 0) {
            Account ad = this.account;
            Set<Long> keys2 = ad.getOrders().keySet();
            Iterator<Long> it = keys2.iterator();
            while (it.hasNext()) {
                boolean bl = this.se.cancelOrder(this.account, it.next());
            }
        }
        return n;
    }

    protected Action getAction() {
        if (Sim.randNextInt(2) == 0) {
            return Action.BUY;
        }
        return Action.SELL;
    }

    long doTrade() {
        this.cancelOrders();
        Action a = this.getAction();
        switch (a.ordinal()) {
            case 0: {
                boolean rc = this.doBuy();
                if (rc) {
                    this.mode = Action.BUY;
                    return this.getRandom(this.buy_wait);
                }
                return 5000L;
            }
            case 1: {
                boolean rc = this.doSell();
                if (rc) {
                    this.mode = Action.SELL;
                    return this.getRandom(this.sell_wait);
                }
                return 5000L;
            }
        }
        return 0L;
    }

    protected float getRandom(float min2, float max2) {
        RandomTraderB randomTraderB = this;
        float r = (float)randomTraderB.sim.randNextDouble();
        return (max2 - min2) * r + min2;
    }

    protected int getRandom(Long[] minmax) {
        return Math.round(this.getRandom(minmax[0].longValue(), minmax[1].longValue()));
    }

    float getStart() {
        return 0.0f;
    }

    protected float getRandomAmmount(float val, Float[] minmax) {
        float min2 = val * minmax[0].floatValue() / 100.0f;
        float max2 = val * minmax[1].floatValue() / 100.0f;
        return this.getRandom(min2, max2);
    }

    public boolean doBuy() {
        Account account = this.account;
        byte type = 2;
        if (account == null) {
            return false;
        }
        float money = this.getRandomAmmount(account.getMoney(), this.buy_volume);
        Quote q = this.se.getBestPrice_0();
        float lp = q == null ? this.getStart() : q.getPrice();
        float limit = lp + this.getRandomAmmount(lp, this.buy_limit);
        float volume2 = money / limit;
        limit = this.se.roundMoney(limit);
        if ((volume2 = this.se.roundShares(volume2)) <= 0.0f || money <= 0.0f) {
            return false;
        }
        this.se.createOrder(account, type, volume2, limit, 0.0f);
        return true;
    }

    public boolean doSell() {
        Account account = this.account;
        byte type = 3;
        float volume2 = this.getRandomAmmount(account.getShares(), this.sell_volume);
        volume2 = this.se.roundShares(volume2);
        Quote q = this.se.getBestPrice_0();
        float lp = q == null ? this.getStart() : q.getPrice();
        float limit = lp + this.getRandomAmmount(lp, this.sell_limit);
        this.se.roundMoney(limit);
        if (volume2 <= 0.0f || limit <= 0.0f) {
            return false;
        }
        this.se.createOrder(account, type, volume2, limit, 0.0f);
        return true;
    }

    protected static enum Action {
        BUY,
        SELL,
        RANDOM;

    }
}

