/*
 * Decompiled with CFR 0.152.
 */
package traders;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import sesim.Account;
import sesim.AutoTraderBase;
import sesim.AutoTraderGui;
import sesim.Market;
import sesim.Order;
import sesim.Quote;
import sesim.Scheduler;
import sesim.Sim;
import traders.RandomTraderLGui;

public class RandomTraderL
extends AutoTraderBase
implements Market.AccountListener {
    public long[] initialDelay = new long[]{0L, 0L};
    public long[] amountToBuy = new long[]{1000L, 1000L};
    public long[] amountToSell = new long[]{1000L, 1000L};
    public long minAmountToBuyDeviation = 0L;
    public long minAmountToSellDeviation = 0L;
    public long[] buyLimit = new long[]{-20L, 20L};
    public long[] sellLimit = new long[]{-20L, 20L};
    public long minBuyDeviation = 1L;
    public long minSellDeviation = 1L;
    public long[] buyOrderTimeout = new long[]{10000L, 50000L};
    public long[] sellOrderTimeout = new long[]{10000L, 50000L};
    public long[] sleepAfterBuy = new long[]{0L, 0L};
    public long[] sleepAfterSell = new long[]{0L, 0L};
    public float[] wait_after_fail = new float[]{1.0f, 5.0f};
    public long bankrupt_shares = 0L;
    public long bankrupt_cash = 0L;
    final String INITIAL_DELAY = "initial_delay";
    final String AMOUNT_TO_SELL = "amount_to_sell";
    final String AMOUNT_TO_BUY = "amount_to_buy";
    final String SELL_LIMIT = "sell_limit";
    final String BUY_LIMIT = "buy_limit";
    final String SELL_ORDER_TIMEOUT = "sell_order_timeout";
    final String BUY_ORDER_TIMEOUT = "buy_order_timeout";
    final String SLEEP_AFTER_SELL = "sleep_after_sell";
    final String SLEEP_AFTER_BUY = "sleep_after_buy";
    final String BANKRUPT_SHARES = "bankrupt_shares";
    final String BANKRUPT_CASH = "bankrupt_cash";
    final String MIN_AMOUNT_TO_SELL_DEVIATION = "min_amount_to_sell_deviation";
    final String MIN_AMOUNT_TO_BUY_DEVIATION = "min_amount_to_buy_deviation";
    final String MIN_BUY_DEVIATION = "min_buy_deviation";
    final String MIN_SELL_DEVIATION = "min_sell_deviation";
    final String WAIT_AFTER_FAIL = "wait_after_fail";
    long wait_after_timeout = 1000L;
    private final Scheduler.Event TRADEEVENT = new Scheduler.Event(this);
    private long tradeEventTime;
    private final Scheduler.Event ORDERFILLEDEVENT = new Scheduler.Event(this);
    private Order currentOrder = null;

    @Override
    public void start() {
        Account a = this.account;
        a.setListener(this);
        long delay = this.getRandom(this.initialDelay[0], this.initialDelay[1]);
        this.setStatus("Inital delay: %d", delay);
        this.tradeEventTime = delay + this.sim.getCurrentTimeMillis();
        this.sim.addEvent(this.tradeEventTime, this.TRADEEVENT);
    }

    @Override
    public void processEvent(long time, Scheduler.Event e) {
        if (time != this.tradeEventTime) {
            // empty if block
        }
        if (e == this.TRADEEVENT) {
            long t = 0L;
            if (this.account.getShares_Long() < this.bankrupt_shares && this.account.getMoney_Long() < this.bankrupt_cash) {
                this.setStatus("Ruined", new Object[0]);
            }
            t = this.currentOrder == null ? this.doBuyOrSell() : this.handleCurrentOrder();
            this.tradeEventTime = t + this.sim.getCurrentTimeMillis();
            this.sim.addEvent(this.tradeEventTime, e);
        }
    }

    @Override
    public String getDisplayName() {
        return "Simple Random Strategy";
    }

    @Override
    public AutoTraderGui getGui() {
        return new RandomTraderLGui(this);
    }

    @Override
    public JSONObject getConfig() {
        JSONObject cfg = new JSONObject();
        double[] fields = new double[]{(double)Math.round((double)this.initialDelay[0] / 1000.0 * 10.0) / 10.0, (double)Math.round((double)this.initialDelay[1] / 1000.0 * 10.0) / 10.0};
        cfg.put("initial_delay", fields);
        fields = new double[]{(double)Math.round((double)this.amountToBuy[0] / 10.0 * 10.0) / 10.0, (double)Math.round((double)this.amountToBuy[1] / 10.0 * 10.0) / 10.0};
        cfg.put("amount_to_buy", fields);
        fields = new double[]{(double)Math.round((double)this.amountToSell[0] / 10.0 * 10.0) / 10.0, (double)Math.round((double)this.amountToSell[1] / 10.0 * 10.0) / 10.0};
        cfg.put("amount_to_sell", fields);
        fields = new double[]{(double)Math.round((double)this.buyLimit[0] / 10.0 * 10.0) / 10.0, (double)Math.round((double)this.buyLimit[1] / 10.0 * 10.0) / 10.0};
        cfg.put("buy_limit", fields);
        fields = new double[]{(double)Math.round((double)this.sellLimit[0] / 10.0 * 10.0) / 10.0, (double)Math.round((double)this.sellLimit[1] / 10.0 * 10.0) / 10.0};
        cfg.put("sell_limit", fields);
        fields = new double[]{(double)Math.round((double)this.buyOrderTimeout[0] / 1000.0 * 10.0) / 10.0, (double)Math.round((double)this.buyOrderTimeout[1] / 1000.0 * 10.0) / 10.0};
        cfg.put("buy_order_timeout", fields);
        fields = new double[]{(double)Math.round((double)this.sellOrderTimeout[0] / 1000.0 * 10.0) / 10.0, (double)Math.round((double)this.sellOrderTimeout[1] / 1000.0 * 10.0) / 10.0};
        cfg.put("sell_order_timeout", fields);
        fields = new double[]{(double)Math.round((double)this.sleepAfterBuy[0] / 1000.0 * 10.0) / 10.0, (double)Math.round((double)this.sleepAfterBuy[1] / 1000.0 * 10.0) / 10.0};
        cfg.put("sleep_after_buy", fields);
        fields = new double[]{(double)Math.round((double)this.sleepAfterSell[0] / 1000.0 * 10.0) / 10.0, (double)Math.round((double)this.sleepAfterSell[1] / 1000.0 * 10.0) / 10.0};
        cfg.put("sleep_after_sell", fields);
        cfg.put("bankrupt_shares", this.bankrupt_shares);
        cfg.put("bankrupt_cash", this.bankrupt_cash);
        cfg.put("min_amount_to_buy_deviation", this.minAmountToBuyDeviation);
        cfg.put("min_amount_to_sell_deviation", this.minAmountToSellDeviation);
        cfg.put("min_buy_deviation", this.minBuyDeviation);
        cfg.put("min_sell_deviation", this.minSellDeviation);
        return cfg;
    }

    private float[] to_float(JSONArray a) {
        float[] ret2 = new float[a.length()];
        for (int i = 0; i < a.length(); ++i) {
            ret2[i] = (float)a.getDouble(i);
        }
        return ret2;
    }

    @Override
    public void setConfig(JSONObject cfg) {
        if (cfg == null) {
            return;
        }
        try {
            this.initialDelay[0] = (long)(1000.0 * cfg.getJSONArray("initial_delay").getDouble(0));
            this.initialDelay[1] = (long)(1000.0 * cfg.getJSONArray("initial_delay").getDouble(1));
            this.amountToBuy[0] = (long)(10.0 * cfg.getJSONArray("amount_to_buy").getDouble(0));
            this.amountToBuy[1] = (long)(10.0 * cfg.getJSONArray("amount_to_buy").getDouble(1));
            this.amountToSell[0] = (long)(10.0 * cfg.getJSONArray("amount_to_sell").getDouble(0));
            this.amountToSell[1] = (long)(10.0 * cfg.getJSONArray("amount_to_sell").getDouble(1));
            this.buyLimit[0] = (long)(10.0 * cfg.getJSONArray("buy_limit").getDouble(0));
            this.buyLimit[1] = (long)(10.0 * cfg.getJSONArray("buy_limit").getDouble(1));
            this.sellLimit[0] = (long)(10.0 * cfg.getJSONArray("sell_limit").getDouble(0));
            this.sellLimit[1] = (long)(10.0 * cfg.getJSONArray("sell_limit").getDouble(1));
            this.buyOrderTimeout[0] = (long)(1000.0 * cfg.getJSONArray("buy_order_timeout").getDouble(0));
            this.buyOrderTimeout[1] = (long)(1000.0 * cfg.getJSONArray("buy_order_timeout").getDouble(1));
            this.sellOrderTimeout[0] = (long)(1000.0 * cfg.getJSONArray("sell_order_timeout").getDouble(0));
            this.sellOrderTimeout[1] = (long)(1000.0 * cfg.getJSONArray("sell_order_timeout").getDouble(1));
            this.sleepAfterBuy[0] = (long)(1000.0 * cfg.getJSONArray("sleep_after_buy").getDouble(0));
            this.sleepAfterBuy[1] = (long)(1000.0 * cfg.getJSONArray("sleep_after_buy").getDouble(1));
            this.sleepAfterSell[0] = (long)(1000.0 * cfg.getJSONArray("sleep_after_sell").getDouble(0));
            this.sleepAfterSell[1] = (long)(1000.0 * cfg.getJSONArray("sleep_after_sell").getDouble(1));
            this.bankrupt_shares = cfg.getLong("bankrupt_shares");
            this.bankrupt_cash = cfg.getLong("bankrupt_cash");
            this.minAmountToBuyDeviation = cfg.getLong("min_amount_to_buy_deviation");
            this.minAmountToSellDeviation = cfg.getLong("min_amount_to_sell_deviation");
            this.minBuyDeviation = cfg.getLong("min_buy_deviation");
            this.minSellDeviation = cfg.getLong("min_sell_deviation");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public boolean getDevelStatus() {
        return false;
    }

    @Override
    public void accountUpdated(Account a, Order o) {
        if (this.currentOrder == null) {
            return;
        }
        if (this.currentOrder.getStatus() != 4) {
            return;
        }
        boolean rc = this.sim.delEvent(this.tradeEventTime, this.TRADEEVENT);
        this.tradeEventTime = this.currentOrder.getType() == 2 ? this.getRandom(this.sleepAfterBuy[0], this.sleepAfterBuy[1]) : this.getRandom(this.sleepAfterSell[0], this.sleepAfterSell[1]);
        this.tradeEventTime += this.sim.getCurrentTimeMillis();
        this.currentOrder = null;
        this.sim.addEvent(this.tradeEventTime, this.TRADEEVENT);
    }

    private Action getAction() {
        if (Sim.randNextInt(2) == 0) {
            return Action.BUY;
        }
        return Action.SELL;
    }

    private long handleCurrentOrder() {
        Order o = this.currentOrder;
        this.currentOrder = null;
        byte s = o.getStatus();
        if (s == 1 || s == 3) {
            this.se.cancelOrder(this.account, o.getID());
            this.currentOrder = null;
            this.setStatus("Sleep after timeout", new Object[0]);
            return (long)(this.getRandom(this.wait_after_fail) * 1000.0f);
        }
        if (o.getType() == 2) {
            this.setStatus("Sleep after buy", new Object[0]);
            long r = this.getRandom(this.sleepAfterBuy[0], this.sleepAfterBuy[1]);
            return r;
        }
        this.setStatus("Sleep after sell", new Object[0]);
        return this.getRandom(this.sleepAfterSell[0], this.sleepAfterSell[1]);
    }

    private long doBuyOrSell() {
        Action a = this.getAction();
        switch (a.ordinal()) {
            case 0: {
                Order o = this.doBuy();
                if (o == null) {
                    this.setStatus("No trade possible", new Object[0]);
                    float r = this.getRandom(this.wait_after_fail) * 1000.0f;
                    return (long)r;
                }
                if (o.getStatus() == 4) {
                    this.setStatus("Holding", new Object[0]);
                    return this.getRandom(this.sleepAfterBuy[0], this.sleepAfterBuy[1]);
                }
                this.currentOrder = o;
                this.setStatus("Waiting for buy order", new Object[0]);
                return this.getRandom(this.buyOrderTimeout[0], this.buyOrderTimeout[1]);
            }
            case 1: {
                Order o = this.doSell();
                if (o == null) {
                    this.setStatus("No trade possible", new Object[0]);
                    float r = this.getRandom(this.wait_after_fail) * 1000.0f;
                    return (long)r;
                }
                if (o.getStatus() == 4) {
                    this.setStatus("Cool down", new Object[0]);
                    return this.getRandom(this.sleepAfterSell[0], this.sleepAfterSell[1]);
                }
                this.currentOrder = o;
                this.setStatus("Waiting for sell order", new Object[0]);
                return this.getRandom(this.sellOrderTimeout[0], this.sellOrderTimeout[1]);
            }
        }
        return (long)(this.getRandom(this.wait_after_fail) * 1000.0f);
    }

    protected float getRandom(float min2, float max2) {
        double r = Sim.randNextDouble();
        return (float)((double)(max2 - min2) * r + (double)min2);
    }

    protected long getRandom(long min2, long max2) {
        double r = Sim.randNextDouble();
        return (long)((double)(max2 - min2) * r + (double)min2);
    }

    protected float getRandom(float[] minmax) {
        return this.getRandom(minmax[0], minmax[1]);
    }

    private float getRandomAmmount(float val, float[] minmax) {
        float min2 = val * minmax[0] / 100.0f;
        float max2 = val * minmax[1] / 100.0f;
        return this.getRandom(min2, max2);
    }

    private Order doBuy() {
        long money_avail = this.account.getMoney_Long();
        long money = RandomTraderL.getRandomDelta_Long(money_avail, this.amountToBuy[0], this.amountToBuy[1], this.minAmountToBuyDeviation);
        if (money > money_avail) {
            money = money_avail;
        }
        Quote q = this.se.getBestPrice_0();
        long lp = q.getPrice_Long();
        long limit = RandomTraderL.getRandomPrice_Long(lp, this.buyLimit[0], this.buyLimit[1], this.minBuyDeviation);
        long volume2 = money / limit;
        return this.se.createOrder_Long(this.account, (byte)2, volume2, limit, 0L, 1);
    }

    private Order doSell() {
        long shares = this.account.getShares_Long();
        long volume2 = RandomTraderL.getRandomDelta_Long(shares, this.amountToSell[0], this.amountToSell[1], this.minAmountToSellDeviation);
        if (volume2 > shares) {
            volume2 = shares;
        }
        Quote q = this.se.getBestPrice_0();
        long lp = q.getPrice_Long();
        long limit = RandomTraderL.getRandomPrice_Long(lp, this.sellLimit[0], this.sellLimit[1], this.minSellDeviation);
        return this.se.createOrder_Long(this.account, (byte)3, volume2, limit, 0L, 1);
    }

    private static enum Action {
        BUY,
        SELL;

    }
}

