/*
 * Decompiled with CFR 0.152.
 */
package chart;

import gui.Globals;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import sesim.Market;
import sesim.OHLCData;
import sesim.OHLCDataItem;
import sesim.Quote;
import sesim.util.MinMax;

public class Chart
extends JPanel
implements Market.QuoteReceiver,
Scrollable {
    private int emWidth;
    private int xAxisAreaHight = 3;
    private double x_unit_width = 1.0;
    private float candleWidth = (float)(this.x_unit_width * (double)this.emWidth * (double)0.9f);
    private int leftYAxisAreaWidth = 0;
    private int rightYAxisAreaWidth = 10;
    private int first_bar;
    private int last_bar;
    private int mouseX = -1;
    private int mouseY = -1;
    private boolean mouseInside = false;
    protected Color xl_color = null;
    protected Color xl_bgcolor;
    ChartType ct;
    boolean autoScroll;
    protected OHLCData data;
    ArrayList<SubChartDef> charts;
    private float fontHeight;
    private int lastMaxPos;
    ExecutorService executor;
    boolean busy;
    boolean update;

    public Chart() {
        this.xl_bgcolor = Globals.colors.bg;
        this.ct = ChartType.CANDLESTICK;
        this.autoScroll = true;
        this.charts = new ArrayList();
        this.lastMaxPos = 0;
        this.executor = Executors.newSingleThreadExecutor();
        this.busy = false;
        this.update = false;
        this.initComponents();
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Chart.this.mouseX = e.getX();
                Chart.this.mouseY = e.getY();
                Chart.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Chart.this.mouseInside = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Chart.this.mouseInside = false;
                Chart.this.repaint();
            }
        });
    }

    public void setXUnitWidth(double w) {
        this.x_unit_width = w;
        this.candleWidth = (float)(this.x_unit_width * (double)this.emWidth * (double)0.9f);
        this.updateView();
        this.revalidate();
        this.repaint();
    }

    public double getXUnitWidth() {
        return this.x_unit_width;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getVisibleRect().width / 10;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getVisibleRect().width / 2;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    protected void setXLegendHeight(int h) {
        this.xAxisAreaHight = h;
    }

    String formatTimeMillis(long t) {
        long seconds = t / 1000L % 60L;
        long minutes = t / 1000L / 60L % 60L;
        long hours = t / 1000L / 3600L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    private void drawXLegend_r(Graphics2D g, XLegendDef xld) {
        double xxx;
        double btl;
        Rectangle clip = this.getVisibleRect();
        Color cur = g.getColor();
        if (this.xl_color != null) {
            g.setColor(this.xl_color);
        }
        g.drawLine(clip.x, clip.y, clip.width, clip.y);
        Dimension dim = this.getSize();
        long big_tick = 1L;
        while ((btl = (double)((long)this.emWidth * ++big_tick) * this.x_unit_width) < (xxx = (double)(7 * this.emWidth))) {
        }
        long n = this.first_bar;
        for (double x = (double)this.emWidth * this.x_unit_width * (double)this.first_bar; n < (long)this.last_bar && x < (double)dim.width; ++n, x += (double)this.emWidth * this.x_unit_width) {
            if (n % big_tick == 1L) {
                g.drawLine((int)x, clip.y, (int)x, clip.y + this.emWidth);
                String text = this.formatTimeMillis(0L + n * (long)this.data.getFrameSize());
                int swidth = g.getFontMetrics().stringWidth(text);
                g.drawString(text, (int)x - swidth / 2, clip.y + this.emWidth * 2);
            } else {
                g.drawLine((int)x, clip.y, (int)x, clip.y + this.emWidth / 2);
            }
            if (n % big_tick != 0L) continue;
        }
        g.setColor(cur);
    }

    private void drawXLegend(Graphics2D g, XLegendDef xld) {
        Rectangle clip = this.getVisibleRect();
        if (this.xl_bgcolor != null) {
            Color cur = g.getColor();
            g.setColor(this.xl_bgcolor);
            g.fillRect(clip.x, clip.height - this.emWidth * this.xAxisAreaHight - 1, clip.width, this.emWidth * this.xAxisAreaHight + 1);
            g.drawRect(clip.x, clip.height - this.emWidth * this.xAxisAreaHight - 1, clip.width, this.emWidth * this.xAxisAreaHight + 1);
            g.setColor(cur);
        }
        Graphics2D g2 = (Graphics2D)g.create();
        int w = clip.width - (this.leftYAxisAreaWidth * this.emWidth + this.rightYAxisAreaWidth * this.emWidth);
        int y = clip.height - this.xAxisAreaHight * this.emWidth;
        g2.translate(this.leftYAxisAreaWidth * this.emWidth, y);
        g2.setClip(clip.x, clip.y, w, this.xAxisAreaHight * this.emWidth);
        this.drawXLegend_r(g2, xld);
        g2.dispose();
    }

    private void drawLineItem(DrawCtx ctx, int prevx, int x, OHLCDataItem prev, OHLCDataItem i) {
        Graphics2D g = ctx.g;
        if (prev == null) {
            prev = i;
        }
        int y1 = (int)ctx.getY(prev.getClose());
        int y2 = (int)ctx.getY(i.getClose());
        Color cur = g.getColor();
        g.setColor(Color.RED);
        g.drawLine(prevx, y1, x, y2);
        g.setColor(cur);
    }

    private void drawCandleItem(DrawCtx ctx, SubChartDef d, int prevx, int x, OHLCDataItem prev, OHLCDataItem i) {
        Graphics2D g = ctx.g;
        if (i.getOpen() < i.getClose()) {
            int xl = (int)((float)x + this.candleWidth / 2.0f);
            g.setColor(d.textcolor);
            g.drawLine(xl, (int)ctx.getY(i.getClose()), xl, (int)ctx.getY(i.getHigh()));
            g.drawLine(xl, (int)ctx.getY(i.getLow()), xl, (int)ctx.getY(i.getOpen()));
            float w = this.candleWidth;
            float h = (int)(ctx.getY(i.getOpen()) - ctx.getY(i.getClose()));
            g.setColor(Color.GREEN);
            g.fillRect(x, (int)ctx.getY(i.getClose()), (int)w, (int)h);
            g.setColor(d.textcolor);
            g.drawRect(x, (int)ctx.getY(i.getClose()), (int)w, (int)h);
        } else {
            int xl = (int)((float)x + this.candleWidth / 2.0f);
            g.setColor(d.textcolor);
            g.drawLine(xl, (int)ctx.getY(i.getHigh()), xl, (int)ctx.getY(i.getClose()));
            g.drawLine(xl, (int)ctx.getY(i.getOpen()), xl, (int)ctx.getY(i.getLow()));
            float w = this.candleWidth;
            float h = (int)(ctx.getY(i.getClose()) - ctx.getY(i.getOpen()));
            g.setColor(Color.RED);
            g.fillRect(x, (int)ctx.getY(i.getOpen()), (int)w, (int)h);
            g.setColor(d.textcolor);
            g.drawRect(x, (int)ctx.getY(i.getOpen()), (int)w, (int)h);
        }
    }

    private void drawBarItem(DrawCtx ctx, int prevx, int x, OHLCDataItem prev, OHLCDataItem i) {
        Graphics2D g = ctx.g;
        g.setColor(Color.gray);
        g.drawLine(x, (int)ctx.getY(0.0), x, (int)ctx.getY(i.getVolume()));
        float w = this.candleWidth;
        int h = (int)ctx.getY(0.0) - (int)ctx.getY(i.getVolume());
        g.fillRect(x, (int)ctx.getY(0.0) - h, (int)w, h);
        Rectangle r = ctx.rect;
    }

    private void drawItem(DrawCtx ctx, SubChartDef d, int prevx, int x, OHLCDataItem prev, OHLCDataItem i) {
        switch (this.ct.ordinal()) {
            case 0: {
                this.drawCandleItem(ctx, d, prevx, x, prev, i);
                break;
            }
            case 1: {
                this.drawLineItem(ctx, prevx, x, prev, i);
                break;
            }
            case 3: {
                this.drawBarItem(ctx, prevx, x, prev, i);
            }
        }
    }

    private void drawYLegend(DrawCtx ctx, SubChartDef d) {
        Graphics2D g = ctx.gyr;
        Rectangle clip = g.getClipBounds();
        if (d.bgcolor != null) {
            Color cur = ctx.g.getColor();
            g.setColor(d.rightYColor);
            g.fillRect(0, 0, clip.width, clip.height);
            g.setColor(cur);
        }
        g.setColor(d.textcolor);
        int yw = this.rightYAxisAreaWidth * this.emWidth;
        g.drawLine(0, 0, 0, clip.height);
        double y1 = ctx.getY(ctx.c_mm.getMin());
        double y2 = ctx.getY(ctx.c_mm.getMax());
        double R = ctx.c_mm.getMax() - ctx.c_mm.getMin();
        int anzahlTicks = (int)((double)clip.height / ((double)this.fontHeight * 1.2));
        double S_strich = R / (double)anzahlTicks;
        double P = Math.pow(10.0, Math.floor(Math.log10(S_strich)));
        double S_normiert = S_strich / P;
        double S = S_normiert <= 1.0 ? 1.0 * P : (S_normiert <= 2.0 ? 2.0 * P : (S_normiert <= 5.0 ? 5.0 * P : 10.0 * P));
        double Y_min = Math.floor(ctx.c_mm.getMin() / S) * S;
        double Y_max = Math.ceil(ctx.c_mm.getMax() / S) * S;
        int last_y = clip.height;
        for (double label = Y_min; label <= ctx.c_mm.getMax() + S * 0.001; label += S) {
            int y = (int)ctx.getY((float)label);
            if ((float)y + this.fontHeight > (float)clip.height || (float)y + this.fontHeight > (float)last_y) continue;
            g.drawLine(clip.width + clip.x - yw, y, clip.width + clip.x - yw + this.emWidth, y);
            g.drawString(d.yformatter.format(label), (float)(clip.width + clip.x - yw) + (float)this.emWidth * 1.5f, (float)y + this.fontHeight / 3.0f);
            last_y = y;
        }
    }

    void drawMainChart(DrawCtx ctx, SubChartDef d) {
        if (d.bgcolor != null) {
            Color cur = ctx.g.getColor();
            ctx.g.setColor(d.bgcolor);
            ctx.g.fillRect(0, 0, ctx.rect.width, ctx.height);
            ctx.g.setColor(Color.BLACK);
            ctx.g.drawLine(0, 0, ctx.width, 0);
            ctx.g.setColor(cur);
        }
        OHLCDataItem prev = null;
        for (int i = this.first_bar; i < this.last_bar && i < this.data.size(); ++i) {
            OHLCDataItem di = this.data.get(i);
            int x = (int)((double)((i - this.first_bar) * this.emWidth) * this.x_unit_width);
            this.drawItem(ctx, d, (int)((double)x - (double)this.emWidth * this.x_unit_width), x, prev, di);
            prev = di;
        }
    }

    protected void addChart(SubChartDef d) {
        this.charts.add(d);
    }

    public long locatonToTime(Point p) {
        Point panelLocationOnScreen = this.getLocationOnScreen();
        this.mouseX = p.x - panelLocationOnScreen.x;
        this.mouseY = p.y - panelLocationOnScreen.y;
        Rectangle clip = this.getVisibleRect();
        double bars = (double)clip.width / ((double)this.emWidth * this.x_unit_width) * (double)this.data.getFrameSize();
        long n = (long)(bars * (double)(this.mouseX + 1) / (double)clip.width);
        return n;
    }

    void drawCross(Graphics2D g) {
        if (!this.mouseInside) {
            return;
        }
        Point mouseOnScreen = MouseInfo.getPointerInfo().getLocation();
        Point panelLocationOnScreen = this.getLocationOnScreen();
        this.mouseX = mouseOnScreen.x - panelLocationOnScreen.x;
        this.mouseY = mouseOnScreen.y - panelLocationOnScreen.y;
        int size2 = 10;
        g.drawLine(this.mouseX - size2, this.mouseY, this.mouseX + size2, this.mouseY);
        g.drawLine(this.mouseX, this.mouseY - size2, this.mouseX, this.mouseY + size2);
        Rectangle clip = this.getVisibleRect();
        int h1 = 0;
        Color c = Color.BLUE;
        SubChartDef cd = null;
        for (SubChartDef d : this.charts) {
            int chartwin_height = clip.height - this.xAxisAreaHight * this.emWidth;
            int subchartwin_height = (int)((float)chartwin_height * d.height);
            if (this.mouseY < h1 + subchartwin_height) {
                c = d.crossColor;
                cd = d;
                break;
            }
            h1 += subchartwin_height;
        }
        if (this.mouseX >= 0 && this.mouseY >= 0) {
            g.setColor(c);
            g.drawLine(0, this.mouseY, this.getWidth(), this.mouseY);
            g.drawLine(this.mouseX, 0, this.mouseX, this.getHeight());
        }
        double bars = (double)clip.width / ((double)this.emWidth * this.x_unit_width) * (double)this.data.getFrameSize();
        long n = (long)(bars * (double)(this.mouseX + 1) / (double)clip.width);
        String text = this.formatTimeMillis(n);
        FontMetrics fm = g.getFontMetrics();
        int textWidth = fm.stringWidth(text);
        int textHeight = fm.getHeight();
        int padding = 4;
        DrawCtx ctx = this.makeDrawCtx(cd, g, h1);
        if (ctx == null) {
            return;
        }
        int x = this.mouseX - (textWidth + 2 * padding) / 2;
        if (x < this.getVisibleRect().x) {
            x = this.getVisibleRect().x;
        }
        if (x + (textWidth + 2 * padding) >= this.getVisibleRect().x + ctx.g.getClipBounds().width) {
            x = this.getVisibleRect().x + ctx.g.getClipBounds().width - (textWidth + 2 * padding);
        }
        int y = clip.height - (textHeight + 2 * padding);
        g.setColor(Globals.colors.bgLightYellow);
        g.fillRect(x, y, textWidth + 2 * padding, textHeight + 2 * padding);
        g.setColor(Globals.colors.text);
        g.drawRect(x, y, textWidth + 2 * padding, textHeight + 2 * padding);
        g.drawString(text, x + padding, y + fm.getAscent() + padding);
        AffineTransform gTransform = g.getTransform();
        Point2D mouse = new Point(this.mouseX, this.mouseY);
        if (gTransform != null && !gTransform.isIdentity()) {
            mouse = gTransform.transform(mouse, null);
        }
        AffineTransform inverse = null;
        try {
            inverse = ctx.gyr.getTransform().createInverse();
        }
        catch (Exception exception) {
            // empty catch block
        }
        double val = ctx.getValAtY(this.mouseY - h1);
        text = String.format("%.2f", val);
        textWidth = fm.stringWidth(text);
        Point2D p = inverse.transform(mouse, null);
        y = (int)p.getY() - (textHeight + 2 * padding) / 2;
        x = this.emWidth * this.rightYAxisAreaWidth - (textWidth + 2 * padding);
        if (y < 0) {
            y = 0;
        }
        if (y + textHeight + 2 * padding >= ctx.height) {
            y = ctx.height - (textHeight + 2 * padding) - 1;
        }
        ctx.gyr.setColor(Globals.colors.bgLightYellow);
        ctx.gyr.fillRect(x, y, textWidth + 2 * padding, textHeight + 2 * padding);
        ctx.gyr.setColor(Globals.colors.text);
        ctx.gyr.drawRect(x, y, textWidth + 2 * padding, textHeight + 2 * padding);
        ctx.gyr.drawString(text, x + padding, y + fm.getAscent() + padding);
    }

    DrawCtx makeDrawCtx(SubChartDef d, Graphics2D g, int h) {
        Graphics2D g2;
        if (d == null) {
            return null;
        }
        Rectangle clip = this.getVisibleRect();
        DrawCtx ctx = new DrawCtx();
        switch (d.type.ordinal()) {
            case 3: {
                ctx.c_mm = d.data.getVolMinMax(this.first_bar, this.last_bar);
                ctx.c_mm.setMin(0.0);
                break;
            }
            default: {
                ctx.c_mm = d.data.getMinMax(this.first_bar, this.last_bar);
            }
        }
        ctx.log = d.log;
        int chartwin_height = clip.height - this.xAxisAreaHight * this.emWidth;
        ctx.height = (int)((float)chartwin_height * d.height);
        int pad_top = (int)((float)this.emWidth * d.pad_top);
        int pad_bot = (int)((float)this.emWidth * d.pad_bot);
        int chartWidth = clip.width - (this.leftYAxisAreaWidth * this.emWidth + this.rightYAxisAreaWidth * this.emWidth);
        ctx.rect = new Rectangle(0, pad_top, chartWidth, ctx.height - pad_top - pad_bot);
        ctx.width = chartWidth;
        ctx.c_yscaling = (double)ctx.rect.height / ctx.c_mm.getDiff();
        ctx.g = g2 = (Graphics2D)g.create();
        ctx.g.translate(this.leftYAxisAreaWidth * this.emWidth + clip.x, h);
        ctx.g.setClip(0, 0, chartWidth, ctx.height);
        g2 = (Graphics2D)g.create();
        ctx.gyr = g2;
        ctx.gyr.translate(clip.x + this.leftYAxisAreaWidth * this.emWidth + chartWidth, h);
        ctx.gyr.setClip(0, 0, this.rightYAxisAreaWidth * this.emWidth, ctx.height);
        return ctx;
    }

    void drawAll(Graphics2D g) {
        Rectangle clip = this.getVisibleRect();
        int chartWidth = clip.width - (this.leftYAxisAreaWidth * this.emWidth + this.rightYAxisAreaWidth * this.emWidth);
        this.first_bar = (int)((double)clip.x / (this.x_unit_width * (double)this.emWidth));
        this.last_bar = 1 + (int)((double)(clip.x + chartWidth) / (this.x_unit_width * (double)this.emWidth));
        int h1 = 0;
        for (SubChartDef d : this.charts) {
            DrawCtx ctx = new DrawCtx();
            if (d.data == null) {
                // empty if block
            }
            switch (d.type.ordinal()) {
                case 3: {
                    ctx.c_mm = d.data.getVolMinMax(this.first_bar, this.last_bar);
                    ctx.c_mm.setMin(0.0);
                    break;
                }
                default: {
                    ctx.c_mm = d.data.getMinMax(this.first_bar, this.last_bar);
                }
            }
            this.ct = d.type;
            ctx = this.makeDrawCtx(d, g, h1);
            if (d.bgcolor == Color.WHITE) {
                // empty if block
            }
            this.drawMainChart(ctx, d);
            ctx.g.dispose();
            Graphics2D g2 = (Graphics2D)g.create();
            this.drawYLegend(ctx, d);
            h1 += ctx.height;
        }
        this.drawCross(g);
    }

    protected void setupSubCharts() {
    }

    @Override
    public final void paintComponent(Graphics g) {
        if (Globals.sim == null || this.data == null || this.data.size() == 0) {
            return;
        }
        super.paintComponent(g);
        this.updateView();
        this.fontHeight = g.getFontMetrics().getHeight();
        this.emWidth = g.getFontMetrics().charWidth('M');
        this.candleWidth = (float)(this.x_unit_width * (double)this.emWidth * (double)0.9f);
        this.charts = new ArrayList();
        this.setupSubCharts();
        XLegendDef xld = new XLegendDef();
        this.drawXLegend((Graphics2D)g, xld);
        this.drawAll((Graphics2D)g);
    }

    @Override
    public void repaint() {
        this.updateView();
        super.repaint();
    }

    void updateView() {
        JViewport vp = (JViewport)this.getParent();
        if (vp == null) {
            return;
        }
        Rectangle clip = vp.getViewRect();
        Point pp = vp.getViewPosition();
        JScrollPane scrollPane = (JScrollPane)vp.getParent();
        JScrollBar hsb = scrollPane.getHorizontalScrollBar();
        int maxPos = this.getPreferredSize().width - vp.getWidth();
        int num_bars = this.data.size();
        int pwidth = (int)(this.x_unit_width * (double)(this.emWidth * (num_bars + 1)) + (double)(this.emWidth * (20 + this.leftYAxisAreaWidth)));
        if (pwidth < clip.width) {
            pwidth = clip.width;
        }
        Dimension gdim = this.getParent().getSize();
        this.setPreferredSize(new Dimension(pwidth, gdim.height));
        if (this.autoScroll && (pp.x <= this.lastMaxPos && pp.x > this.lastMaxPos - 50 || pp.x <= maxPos && pp.x > maxPos - 50)) {
            this.lastMaxPos = pwidth - vp.getWidth();
            int currentYPos = vp.getViewPosition().y;
            vp.setViewPosition(new Point(this.lastMaxPos, currentYPos));
        }
    }

    public void aUpdateQuote(Quote q) {
    }

    @Override
    public void UpdateQuote(Quote q) {
        if (this.busy) {
            this.update = true;
            return;
        }
        this.busy = true;
        this.update = true;
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    while (Chart.this.update) {
                        Chart.this.update = false;
                        SwingUtilities.invokeLater(() -> {
                            Chart.this.updateView();
                            Chart.this.revalidate();
                            Chart.this.repaint();
                        });
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                finally {
                    Chart.this.busy = false;
                }
            }
        });
    }

    private void initComponents() {
        this.setBackground(Color.white);
        this.setBorder(null);
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(300, 300));
        this.setRequestFocusEnabled(false);
        GroupLayout layout2 = new GroupLayout(this);
        this.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 589, Short.MAX_VALUE));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    protected static enum ChartType {
        CANDLESTICK,
        LINE,
        BAR,
        VOL;

    }

    class XLegendDef {
        XLegendDef() {
        }

        String getAt(int unit) {
            int fs = Chart.this.data.getFrameSize();
            return Chart.this.formatTimeMillis(0 + unit * fs);
        }
    }

    class DrawCtx {
        MinMax c_mm = null;
        double c_yscaling;
        public int height;
        Rectangle rect;
        Graphics2D g;
        private Graphics2D gyr;
        private int width;
        boolean log;

        DrawCtx() {
        }

        double getDiff() {
            if (this.log) {
                return (float)(Math.log(this.c_mm.getMax()) - Math.log(this.c_mm.getMin()));
            }
            return this.c_mm.getDiff();
        }

        double getY(double y) {
            double ys = (double)this.rect.height / this.getDiff();
            if (this.log) {
                return (double)(this.rect.height + this.rect.y) - (double)((float)Math.log(y) - (float)Math.log(this.c_mm.getMin())) * ys;
            }
            return (double)this.rect.height - (y - this.c_mm.getMin()) * this.c_yscaling + (double)this.rect.y;
        }

        double getValAtY(double y) {
            if (this.log) {
                double ys = (double)this.rect.height / this.getDiff();
                return (float)Math.exp((double)(this.rect.height + this.rect.y) / ys + (double)((float)Math.log(this.c_mm.getMin())) - y / ys);
            }
            return -(y - (double)this.rect.y - (double)this.rect.height) / this.c_yscaling + this.c_mm.getMin();
        }
    }

    public class SubChartDef {
        public float height;
        public float paddingTop = 0.0f;
        public float paddingBottom = 0.0f;
        public ChartType type;
        public OHLCData data;
        public Color bgcolor = null;
        public Color textcolor = null;
        public boolean leftYAxis = false;
        public boolean righYAxis = true;
        public OHLCData rightYData = null;
        public Color rightYColor = Color.GREEN;
        public OHLCData lefttYData = null;
        public boolean log = false;
        public Color crossColor;
        public float pad_top = 0.0f;
        public float pad_bot = 0.0f;
        public DecimalFormat yformatter;
    }
}

