/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.Chart;
import gui.Globals;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class MainChart
extends Chart {
    ButtonGroup typeGroup = new ButtonGroup();
    private final String[] ctxMenuCompressionText = new String[]{"5 s", "10 s", "15 s", "30 s", "1 m", "2 m", "5 m", "10 m", "15 m", "30 m", "1 h", "2 h", "4 h", "1 d", "2 d"};
    private final Integer[] ctxMenuCompressionValues = new Integer[]{5000, 10000, 15000, 30000, 60000, 120000, 300000, 600000, 900000, 1800000, 3600000, 0x6DDD00, 14400000, 86400000, 172800000};
    private final Integer default_cmopression = 3600000;
    Point popupPoint = null;
    private Chart.ChartType chart_type = Chart.ChartType.CANDLESTICK;
    private JRadioButtonMenuItem candleTypeMEnuItem;
    private JMenu compMenu;
    private JPopupMenu ctxMenu;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JRadioButtonMenuItem lineTypeItem;
    private JCheckBoxMenuItem logMenu;
    private JMenuItem setBreakPoint;
    private ButtonGroup typeButtonGroup;
    private JMenu typeMenu;

    public MainChart() {
        this.initComponents();
        this.initCtxMenu();
        this.setCompression();
        this.candleTypeMEnuItem.setSelected(true);
    }

    @Override
    protected void setupSubCharts() {
        Chart.SubChartDef main = new Chart.SubChartDef(this);
        main.height = 0.8f;
        main.type = this.chart_type;
        main.data = this.data;
        main.bgcolor = Globals.colors.bg;
        main.paddingTop = 0.02f;
        main.log = this.logMenu.isSelected();
        main.rightYData = this.data;
        main.rightYColor = Globals.colors.bg;
        main.crossColor = Globals.colors.text;
        main.pad_top = 1.0f;
        main.pad_bot = 1.0f;
        main.yformatter = Globals.sim.getDefaultMarket().getCurrency().getFormatter();
        main.textcolor = Globals.colors.text;
        this.addChart(main);
        Chart.SubChartDef vol = new Chart.SubChartDef(this);
        vol.height = 0.2f;
        vol.paddingTop = 0.08f;
        vol.type = Chart.ChartType.VOL;
        vol.data = this.data;
        vol.bgcolor = Globals.colors.bg;
        vol.rightYData = this.data;
        vol.rightYColor = Globals.colors.bg;
        vol.crossColor = Globals.colors.text;
        vol.pad_top = 1.0f;
        vol.yformatter = Globals.sim.getDefaultMarket().getAsset().getFormatter();
        vol.textcolor = Globals.colors.text;
        this.addChart(vol);
    }

    private void showCtxMenu(MouseEvent evt) {
        this.ctxMenu.setVisible(true);
        this.ctxMenu.show(this, evt.getX(), evt.getY());
        this.invalidate();
        this.repaint();
    }

    private void initCtxMenu() {
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < this.ctxMenuCompressionValues.length; ++i) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(this.ctxMenuCompressionText[i]);
            group.add(item);
            if (Objects.equals(this.ctxMenuCompressionValues[i], this.default_cmopression)) {
                item.setSelected(true);
            }
            item.addActionListener(evt -> this.ctxMenuCompActionPerformed(evt));
            this.compMenu.add(item);
        }
        this.ctxMenu.addPopupMenuListener(new PopupMenuAdapter(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                MainChart.this.repaint();
            }
        });
    }

    protected final void setCompression0(int timeFrame) {
        SwingUtilities.invokeLater(() -> {
            this.data = Globals.sim.getDefaultMarket().getOHLCdata(timeFrame);
            this.invalidate();
            this.repaint();
        });
    }

    void setCompression() {
        for (int i = 0; i < this.ctxMenuCompressionText.length; ++i) {
            JRadioButtonMenuItem item = (JRadioButtonMenuItem)this.compMenu.getItem(i);
            if (!item.isSelected()) continue;
            this.setCompression0(this.ctxMenuCompressionValues[i]);
        }
    }

    protected void doRedraw() {
        SwingUtilities.invokeLater(() -> {
            this.invalidate();
            this.repaint();
        });
    }

    public void initChart() {
        this.setCompression();
        this.doRedraw();
    }

    private void ctxMenuCompActionPerformed(ActionEvent evt) {
        this.setCompression();
        String cmd = evt.getActionCommand();
        for (int i = 0; i < this.ctxMenuCompressionText.length; ++i) {
            if (!this.ctxMenuCompressionText[i].equals(cmd)) continue;
            this.setCompression0(this.ctxMenuCompressionValues[i]);
        }
    }

    private void initComponents() {
        this.ctxMenu = new JPopupMenu();
        this.compMenu = new JMenu();
        this.typeMenu = new JMenu();
        this.lineTypeItem = new JRadioButtonMenuItem();
        this.candleTypeMEnuItem = new JRadioButtonMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.logMenu = new JCheckBoxMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.setBreakPoint = new JMenuItem();
        this.typeButtonGroup = new ButtonGroup();
        this.compMenu.setText("Compression");
        this.ctxMenu.add(this.compMenu);
        this.typeMenu.setText("Chart Type");
        this.typeButtonGroup.add(this.lineTypeItem);
        this.lineTypeItem.setMnemonic('l');
        this.lineTypeItem.setText("Line");
        this.lineTypeItem.setActionCommand("LINE");
        this.lineTypeItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MainChart.this.lineTypeItemItemStateChanged(evt);
            }
        });
        this.lineTypeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainChart.this.lineTypeItemActionPerformed(evt);
            }
        });
        this.typeMenu.add(this.lineTypeItem);
        this.typeButtonGroup.add(this.candleTypeMEnuItem);
        this.candleTypeMEnuItem.setMnemonic('c');
        this.candleTypeMEnuItem.setText("Candle Stick");
        this.candleTypeMEnuItem.setActionCommand("CNADLESTICK");
        this.candleTypeMEnuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MainChart.this.candleTypeMEnuItemItemStateChanged(evt);
            }
        });
        this.typeMenu.add(this.candleTypeMEnuItem);
        this.ctxMenu.add(this.typeMenu);
        this.ctxMenu.add(this.jSeparator1);
        this.logMenu.setMnemonic('l');
        this.logMenu.setText("Log Scale");
        this.logMenu.setToolTipText("");
        this.logMenu.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MainChart.this.logMenuItemStateChanged(evt);
            }
        });
        this.ctxMenu.add(this.logMenu);
        this.ctxMenu.add(this.jSeparator2);
        this.setBreakPoint.setText("Set breakpoint");
        this.setBreakPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainChart.this.setBreakPointActionPerformed(evt);
            }
        });
        this.ctxMenu.add(this.setBreakPoint);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                MainChart.this.formMouseWheelMoved(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MainChart.this.formMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                MainChart.this.formMouseReleased(evt);
            }
        });
        GroupLayout layout2 = new GroupLayout(this);
        this.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void formMouseWheelMoved(MouseWheelEvent evt) {
        double n = evt.getPreciseWheelRotation() * -1.0;
        double u = this.getXUnitWidth();
        if (n < 0.0) {
            if (u > 0.3) {
                this.setXUnitWidth(u + 0.1 * n);
            }
        } else {
            this.setXUnitWidth(u + 0.1 * n);
        }
        this.invalidate();
        this.repaint();
    }

    private void formMouseReleased(MouseEvent evt) {
        if (!evt.isPopupTrigger()) {
            return;
        }
        this.showCtxMenu(evt);
    }

    private void formMousePressed(MouseEvent evt) {
        if (!evt.isPopupTrigger()) {
            return;
        }
        this.showCtxMenu(evt);
    }

    private void logMenuItemStateChanged(ItemEvent evt) {
        this.doRedraw();
    }

    private void lineTypeItemActionPerformed(ActionEvent evt) {
    }

    private void candleTypeMEnuItemItemStateChanged(ItemEvent evt) {
        if (this.candleTypeMEnuItem.isSelected()) {
            this.chart_type = Chart.ChartType.CANDLESTICK;
        }
        this.doRedraw();
    }

    private void lineTypeItemItemStateChanged(ItemEvent evt) {
        if (this.lineTypeItem.isSelected()) {
            this.chart_type = Chart.ChartType.LINE;
        }
        this.doRedraw();
    }

    private void setBreakPointActionPerformed(ActionEvent evt) {
        if (this.popupPoint == null) {
            return;
        }
        Long t = this.locatonToTime(this.popupPoint);
        System.out.println("Time:" + t);
        Globals.sim.addBreakPoint(t, Globals.theApp::acceptBreakPoint);
    }

    abstract class PopupMenuAdapter
    implements PopupMenuListener {
        PopupMenuAdapter() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            SwingUtilities.invokeLater(() -> {
                Point p;
                MainChart.this.popupPoint = p = MainChart.this.ctxMenu.getLocationOnScreen();
                System.out.println("Popup-Position = " + p);
            });
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

