/*
 * Decompiled with CFR 0.152.
 */
package gui.AssetEditor;

import gui.AssetEditor.AssetEditorDialog;
import gui.AssetEditor.AssetListPanel;
import gui.EscDialog;
import gui.Globals;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.json.JSONObject;

public class AssetListDialog
extends EscDialog {
    String symbold = null;
    private AssetListPanel assetListPanel;
    private ButtonGroup buttonGroup1;
    private JButton createMarketButton;
    private JButton deleteButton;
    private JButton jButton1;
    private JButton jButton2;
    private JButton newButton;
    private JButton okButton;

    public AssetListDialog(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.initComponents();
        JSONObject cfg = Globals.getConfig();
        this.assetListPanel.setConfig(cfg);
        MouseAdapter l = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AssetListDialog.this.doEdit();
                }
            }
        };
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.okButton = new JButton();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.assetListPanel = new AssetListPanel();
        this.createMarketButton = new JButton();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Edit Assets");
        this.setModal(true);
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssetListDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.newButton.setText("Create Asset ...");
        this.newButton.setToolTipText("Creates a new Asset");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssetListDialog.this.newButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setText("Delete Asset");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssetListDialog.this.deleteButtonActionPerformed(evt);
            }
        });
        this.createMarketButton.setText("Create Market");
        this.createMarketButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssetListDialog.this.createMarketButtonActionPerformed(evt);
            }
        });
        this.jButton1.setText("Delete Market");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssetListDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssetListDialog.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.assetListPanel, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout2.createSequentialGroup().addComponent(this.createMarketButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 34, Short.MAX_VALUE).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addComponent(this.newButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton, -2, 116, -2).addGap(1, 1, 1)).addGroup(GroupLayout.Alignment.TRAILING, layout2.createSequentialGroup().addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2))))).addContainerGap()));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addComponent(this.assetListPanel, -1, 351, Short.MAX_VALUE).addGap(17, 17, 17).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE).addComponent(this.createMarketButton, -1, -1, Short.MAX_VALUE).addComponent(this.newButton, -1, -1, Short.MAX_VALUE).addComponent(this.deleteButton, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.jButton2)).addContainerGap()));
        this.pack();
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        AssetEditorDialog d = new AssetEditorDialog(this);
        d.setModal(true);
        d.setLocationRelativeTo(this);
        d.setVisible(true);
        if (d.symbol == null) {
            return;
        }
        this.assetListPanel.addAsset(d.symbol, d.name, d.decimals);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        JSONObject cfg = this.assetListPanel.getConfig();
        Globals.putConfig(cfg);
        this.dispose();
    }

    private void doEdit() {
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.assetListPanel.delAsset();
    }

    private void createMarketButtonActionPerformed(ActionEvent evt) {
        this.assetListPanel.createMarket();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.assetListPanel.delCurrency();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(AssetListDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(AssetListDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(AssetListDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(AssetListDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AssetListDialog dialog = new AssetListDialog(new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

