/*
 * Decompiled with CFR 0.152.
 */
package gui.AssetEditor;

import gui.AssetEditor.GuiSelectionList;
import gui.Globals;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import sesim.Config;

public class AssetListPanel
extends JPanel
implements GuiSelectionList {
    JSONObject cfg;
    public JTable assetTable;
    private JComboBox<String> currencyCombobox;
    private JComboBox<String> defaultAssetComboBox;
    private JComboBox<String> defaultcurrencyComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable marketsTable;

    public AssetListPanel() {
        this.initComponents();
        if (Globals.prefs_new == null) {
            return;
        }
        JSONArray assets = Globals.getConfig().optJSONArray("assets");
        this.assetTable.setRowSelectionAllowed(true);
        this.marketsTable.getColumnModel().getColumn(1).setCellRenderer(new InitialPriceRenderer());
    }

    public void addRow() {
        DefaultTableModel model = (DefaultTableModel)this.assetTable.getModel();
        model.setRowCount(model.getRowCount() + 1);
        model.setValueAt("New asset", model.getRowCount() - 1, 0);
    }

    public void addAsset(String symbol, String name, int decimals) {
        if (symbol.length() == 0) {
            return;
        }
        JSONObject assets = this.cfg.optJSONObject("assets");
        if (assets == null) {
            assets = new JSONObject();
        }
        JSONObject a = new JSONObject();
        a.put("name", name);
        a.put("decimals", decimals);
        assets.put(symbol, a);
        this.cfg.put("assets", assets);
        this.updateAll();
    }

    public void delAsset() {
        int row = this.assetTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        this.updateCfg();
        String symbol = (String)this.assetTable.getModel().getValueAt(row, 0);
        JSONObject assets = Config.getAssets(this.cfg);
        assets.remove(symbol);
        this.putAssets(assets);
        JSONObject c = Config.getMarkets(this.cfg);
        c.remove(symbol);
        this.putCurrencies(c);
        this.updateAll();
    }

    public void delCurrency() {
        this.updateCfg();
        String selected = (String)this.currencyCombobox.getSelectedItem();
        JSONObject c = Config.getMarkets(this.cfg);
        c.remove(selected);
        this.putCurrencies(c);
        this.updateAll();
    }

    private void putAssets(JSONObject assets) {
        this.cfg.put("assets", assets);
    }

    public JSONObject getConfig() {
        TableCellEditor editor = this.marketsTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        if ((editor = this.assetTable.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
        this.updateCfg();
        return this.cfg;
    }

    private void updateAll() {
        JSONObject assets = this.cfg.optJSONObject("assets");
        DefaultTableModel model = (DefaultTableModel)this.assetTable.getModel();
        model.setRowCount(0);
        if (assets != null) {
            for (String symbol : assets.keySet()) {
                JSONObject jo = assets.optJSONObject(symbol);
                if (jo == null) {
                    jo = new JSONObject();
                }
                model.addRow(new Object[]{symbol, jo.optString("name", null), jo.optInt("decimals", 0)});
            }
        }
        this.updateCurrencies();
        this.updateMarkets();
        this.defaultAssetComboBox.setSelectedItem(Config.getDefaultAsset(this.cfg));
        this.defaultcurrencyComboBox.setSelectedItem(Config.getDefaultCurrency(this.cfg));
    }

    private void updateCfg() {
        JSONObject assets = new JSONObject();
        DefaultTableModel amodel = (DefaultTableModel)this.assetTable.getModel();
        for (int row = 0; row < amodel.getRowCount(); ++row) {
            String symbol = (String)amodel.getValueAt(row, 0);
            String name = (String)amodel.getValueAt(row, 1);
            int decimals = (Integer)amodel.getValueAt(row, 2);
            JSONObject o = new JSONObject();
            o.put("decimals", decimals);
            o.put("name", name);
            assets.put(symbol, o);
        }
        this.putAssets(assets);
        String currency = (String)this.currencyCombobox.getSelectedItem();
        DefaultTableModel mmodel = (DefaultTableModel)this.marketsTable.getModel();
        for (int row = 0; row < mmodel.getRowCount(); ++row) {
            String symbol = (String)mmodel.getValueAt(row, 0);
            Float initial_price = Float.valueOf(((Float)mmodel.getValueAt(row, 1)).floatValue());
            boolean auto_initial_price = (Boolean)mmodel.getValueAt(row, 2);
            JSONObject o = new JSONObject();
            o.put("initial_price", initial_price);
            o.put("auto_initial_price", auto_initial_price);
            this.putMarket(currency, symbol, o);
        }
        Config.putDefaultCurrency(this.cfg, (String)this.defaultcurrencyComboBox.getSelectedItem());
        Config.putDefaultAsset(this.cfg, (String)this.defaultAssetComboBox.getSelectedItem());
    }

    private void putCurrencies(JSONObject currencies) {
        this.cfg.put("markets", currencies);
    }

    JSONObject getMarkets(String currency) {
        JSONObject currencies = Config.getMarkets(this.cfg);
        JSONObject markets = currencies.optJSONObject(currency);
        if (markets == null) {
            return new JSONObject();
        }
        return markets;
    }

    private void putMarkets(String currency, JSONObject markets) {
        JSONObject currencies = Config.getMarkets(this.cfg);
        currencies.put(currency, markets);
        this.putCurrencies(currencies);
    }

    private JSONObject getMarket(String currency, String symbol) {
        JSONObject markets = this.getMarkets(currency);
        JSONObject market = markets.optJSONObject(symbol);
        if (market == null) {
            return new JSONObject();
        }
        return market;
    }

    private void putMarket(String currency, String symbol, JSONObject data) {
        JSONObject markets = this.getMarkets(currency);
        markets.put(symbol, data);
        this.putMarkets(currency, markets);
    }

    void updateCurrencies() {
        JSONObject markets = Config.getMarkets(this.cfg);
        String selected = (String)this.currencyCombobox.getSelectedItem();
        String selectedDefault = (String)this.defaultcurrencyComboBox.getSelectedItem();
        this.currencyCombobox.removeAllItems();
        this.defaultcurrencyComboBox.removeAllItems();
        for (String currency : markets.keySet()) {
            this.currencyCombobox.addItem(currency);
            this.defaultcurrencyComboBox.addItem(currency);
        }
        this.currencyCombobox.setSelectedItem(selected);
        this.defaultcurrencyComboBox.setSelectedItem(selectedDefault);
    }

    void updateMarkets() {
        JSONObject assets = Config.getAssets(this.cfg);
        String currency = (String)this.currencyCombobox.getSelectedItem();
        JSONObject markets = this.getMarkets(currency);
        DefaultTableModel model = (DefaultTableModel)this.marketsTable.getModel();
        model.setRowCount(0);
        if (Config.getAsset(this.cfg, currency) == null) {
            return;
        }
        for (String symbol : assets.keySet()) {
            if (symbol.equals(currency)) continue;
            JSONObject market = this.getMarket(currency, symbol);
            model.addRow(new Object[]{symbol, Float.valueOf((float)market.optDouble("initial_price", 100.0)), market.optBoolean("auto_initial_price", true), market.optBoolean("enable", true)});
        }
        String selected = (String)this.defaultAssetComboBox.getSelectedItem();
        String defaultCurrency = (String)this.defaultcurrencyComboBox.getSelectedItem();
        this.defaultAssetComboBox.removeAllItems();
        for (String symbol : assets.keySet()) {
            if (symbol.equals(defaultCurrency)) continue;
            this.defaultAssetComboBox.addItem(symbol);
        }
        this.defaultAssetComboBox.setSelectedItem(selected);
    }

    void addSelectedAssetToMarket() {
        int row = this.assetTable.getSelectedRow();
        String symbol = (String)this.assetTable.getModel().getValueAt(row, 0);
        String currency = (String)this.currencyCombobox.getSelectedItem();
        if (currency.equals(symbol)) {
            return;
        }
        JSONObject market = new JSONObject();
        market.put("initial_price", 110);
        this.putMarket(currency, symbol, market);
    }

    public void setConfig(JSONObject cfg) {
        this.cfg = cfg;
        this.updateAll();
    }

    public void createMarket() {
        int row = this.assetTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        String symbol = (String)this.assetTable.getModel().getValueAt(row, 0);
        JSONObject markets = Config.getMarkets(this.cfg);
        JSONObject m = markets.optJSONObject(symbol);
        if (m != null) {
            return;
        }
        markets.put(symbol, new JSONObject());
        this.putCurrencies(markets);
        this.updateAll();
        this.currencyCombobox.setSelectedItem(symbol);
        this.updateAll();
    }

    @Override
    public JSONObject getSelectedObject() {
        int row = this.assetTable.getSelectedRow();
        String symbol = (String)this.assetTable.getValueAt(row, 0);
        return null;
    }

    final void reload() {
    }

    private TableModel getModel() {
        class TModel
        extends DefaultTableModel {
            TModel(Object[] object, int i) {
                super(object, i);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        }
        TModel model = new TModel(new Object[]{"Symbol", "Name", "Type"}, 0);
        this.assetTable.setAutoCreateRowSorter(true);
        this.assetTable.getTableHeader().setReorderingAllowed(false);
        return model;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.assetTable = new JTable();
        this.currencyCombobox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.marketsTable = new JTable();
        this.jLabel3 = new JLabel();
        this.defaultcurrencyComboBox = new JComboBox();
        this.jLabel4 = new JLabel();
        this.defaultAssetComboBox = new JComboBox();
        this.assetTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Symbol", "Name", "Decimals"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Integer.class};
                this.canEdit = new boolean[]{false, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.assetTable.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.assetTable);
        this.currencyCombobox.setModel(new DefaultComboBoxModel<String>(new String[]{"DDM"}));
        this.currencyCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssetListPanel.this.currencyComboboxActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Currency:");
        this.jLabel2.setText("Assets:");
        this.marketsTable.setModel(new DefaultTableModel(new Object[][]{{"DDM/RBTN", new Float(100.0), null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Pair", "Initial Price", "Auto Initial Price", "Enable"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Float.class, Boolean.class, Boolean.class};
                this.canEdit = new boolean[]{false, true, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane2.setViewportView(this.marketsTable);
        this.jLabel3.setText("Markets:");
        this.defaultcurrencyComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.defaultcurrencyComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssetListPanel.this.defaultcurrencyComboBoxActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Default market:");
        this.defaultAssetComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.defaultAssetComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssetListPanel.this.defaultAssetComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout2 = new GroupLayout(this);
        this.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 577, Short.MAX_VALUE).addGroup(layout2.createSequentialGroup().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2)).addGap(0, 528, Short.MAX_VALUE)).addGroup(layout2.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.currencyCombobox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.defaultcurrencyComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.defaultAssetComboBox, -2, -1, -2).addContainerGap()));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout2.createSequentialGroup().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.currencyCombobox, -2, -1, -2).addComponent(this.defaultcurrencyComboBox, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.defaultAssetComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 185, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 112, -2)));
    }

    private void currencyComboboxActionPerformed(ActionEvent evt) {
        this.updateMarkets();
    }

    private void defaultcurrencyComboBoxActionPerformed(ActionEvent evt) {
    }

    private void defaultAssetComboBoxActionPerformed(ActionEvent evt) {
    }

    public class InitialPriceRenderer
    extends DefaultTableCellRenderer {
        private static final int INITIAL_PRICE_COLUMN_INDEX = 1;
        private static final int AUTO_INITIAL_PRICE_COLUMN_INDEX = 2;

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cellComponent = super.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
            if (column == 1) {
                Object autoPriceValue = table2.getModel().getValueAt(row, 2);
                if (autoPriceValue instanceof Boolean && ((Boolean)autoPriceValue).booleanValue()) {
                    Color disabledBg = UIManager.getColor("TextField.disabledBackground");
                    if (disabledBg == null) {
                        disabledBg = UIManager.getColor("Panel.background");
                    }
                    cellComponent.setBackground(disabledBg);
                    Color disabledFg = UIManager.getColor("textInactiveText");
                    if (disabledFg == null) {
                        disabledFg = UIManager.getColor("controlDkShadow");
                    }
                    cellComponent.setForeground(disabledFg);
                } else {
                    cellComponent.setBackground(isSelected ? table2.getSelectionBackground() : table2.getBackground());
                    cellComponent.setForeground(isSelected ? table2.getSelectionForeground() : table2.getForeground());
                }
                this.setHorizontalAlignment(4);
            } else {
                cellComponent.setBackground(isSelected ? table2.getSelectionBackground() : table2.getBackground());
                cellComponent.setForeground(isSelected ? table2.getSelectionForeground() : table2.getForeground());
                this.setHorizontalAlignment(2);
            }
            return cellComponent;
        }
    }
}

