/*
 * Decompiled with CFR 0.152.
 */
package gui.BreakPoints;

import gui.Globals;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.TreeMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import sesim.Sim;

public class BreakPointsDialog
extends JDialog {
    DefaultTableModel model;
    private JButton add;
    private JSpinner bpTimeSpinner;
    private JButton del;
    private JButton done;
    private JScrollPane jScrollPane1;
    private JTable list;

    public BreakPointsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.model = (DefaultTableModel)this.list.getModel();
        this.updateTable();
    }

    private void updateTable() {
        this.model.setRowCount(0);
        TreeMap<Long, Sim.BreakPoint> bplist = Globals.sim.getBreakPoints();
        for (Long time : bplist.keySet()) {
            Sim.BreakPoint bp = bplist.get(time);
            this.model.addRow(new Object[]{bp, time});
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.list = new JTable();
        this.done = new JButton();
        this.del = new JButton();
        this.add = new JButton();
        this.bpTimeSpinner = new JSpinner();
        this.setDefaultCloseOperation(2);
        this.list.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"ID", "Time"}){
            Class[] types;
            {
                this.types = new Class[]{Object.class, Long.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        this.done.setText("done");
        this.done.addActionListener(this::doneActionPerformed);
        this.del.setText("Del");
        this.del.addActionListener(this::delActionPerformed);
        this.add.setText("Add");
        this.add.addActionListener(this::addActionPerformed);
        this.bpTimeSpinner.setModel(new SpinnerNumberModel((Number)0L, null, null, (Number)1L));
        GroupLayout layout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 556, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout2.createSequentialGroup().addContainerGap().addComponent(this.bpTimeSpinner, -2, 286, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.add).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.del).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.done).addContainerGap()));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addComponent(this.jScrollPane1, -2, 252, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.done).addComponent(this.del).addComponent(this.add).addComponent(this.bpTimeSpinner, -2, -1, -2)).addGap(0, 19, Short.MAX_VALUE)));
        this.pack();
    }

    private void doneActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void delActionPerformed(ActionEvent evt) {
        int[] rows = this.list.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            long t = (Long)this.model.getValueAt(i, 1);
            Globals.sim.removeBreakPoint(t);
            this.model.removeRow(rows[i]);
        }
    }

    private void addActionPerformed(ActionEvent evt) {
        Long bp = (Long)this.bpTimeSpinner.getValue();
        Globals.sim.addBreakPoint(bp, Globals.theApp::acceptBreakPoint);
        this.updateTable();
    }
}

