/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Globals;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.Arrays;
import java.util.EventObject;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import sesim.Config;

public class EditAutoTraderList
extends JPanel {
    static final int NAME_COL = 0;
    static final int COUNT_COL = 1;
    static final int STRATEGY_COL = 2;
    static final int CASH_COL = 3;
    static final int SHARES_COL = 4;
    static final int COLOR_COL = 5;
    static final int EXCLUDEINITIAL_COL = 6;
    static final int ENABLED_COL = 7;
    DefaultTableModel model;
    private JScrollPane jScrollPane1;
    private JTable list;
    private JLabel summary;

    private String getColumnHeader(int i) {
        JTableHeader th = this.list.getTableHeader();
        return (String)th.getColumnModel().getColumn(i).getHeaderValue();
    }

    void save() {
        TableCellEditor editor = this.list.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        DefaultTableModel m = (DefaultTableModel)this.list.getModel();
        JTableHeader th = this.list.getTableHeader();
        JSONArray ja = new JSONArray();
        for (int i = 0; i < m.getRowCount(); ++i) {
            JSONObject jo = new JSONObject();
            Object cw = m.getValueAt(i, 0);
            jo.put("Name", (String)cw);
            cw = m.getValueAt(i, 1);
            jo.put("Count", (Integer)cw);
            cw = m.getValueAt(i, 2);
            jo.put("Strategy", (String)cw);
            cw = m.getValueAt(i, 3);
            jo.put("Cash", (Double)cw);
            cw = m.getValueAt(i, 4);
            jo.put("Shares", (Double)cw);
            cw = m.getValueAt(i, 5);
            if (cw == null) {
                jo.put("Color", new JSONArray());
            } else {
                int[] ca = new int[]{((Color)cw).getRed(), ((Color)cw).getGreen(), ((Color)cw).getBlue()};
                jo.put("Color", new JSONArray(ca));
            }
            cw = m.getValueAt(i, 6);
            jo.put("ExcludeInitial", (Boolean)cw);
            cw = m.getValueAt(i, 7);
            jo.put("Enabled", (Boolean)cw);
            ja.put(jo);
        }
        Globals.putTraders(ja);
    }

    final void load() {
        JSONArray traders = Config.getTraders(Globals.getConfig());
        DefaultTableModel model = (DefaultTableModel)this.list.getModel();
        model.setRowCount(traders.length());
        for (int row = 0; row < traders.length(); ++row) {
            JSONObject rowobj = traders.getJSONObject(row);
            String name = rowobj.optString("Name", "");
            this.list.getModel().setValueAt(name, row, 0);
            int count2 = rowobj.optInt("Count", 0);
            this.list.getModel().setValueAt(count2, row, 1);
            String strategy = rowobj.optString("Strategy", "");
            this.list.getModel().setValueAt(strategy, row, 2);
            Double val = rowobj.optDouble("Cash", 0.0);
            this.list.getModel().setValueAt(val, row, 3);
            val = rowobj.optDouble("Shares", 0.0);
            this.list.getModel().setValueAt(val, row, 4);
            JSONArray a = rowobj.optJSONArray("Color");
            Color c = null;
            if (a != null && a.length() == 3) {
                c = new Color(a.optInt(0, 255), a.optInt(1, 255), a.optInt(2, 255));
            }
            this.list.getModel().setValueAt(c, row, 5);
            boolean b = rowobj.optBoolean("ExcludeInitial", false);
            this.list.getModel().setValueAt(b, row, 6);
            b = rowobj.optBoolean("Enabled", false);
            this.list.getModel().setValueAt(b, row, 7);
        }
    }

    public void deleteSelectedRows() {
        int i;
        DefaultTableModel model = (DefaultTableModel)this.list.getModel();
        int[] selectedRows = this.list.getSelectedRows();
        if (selectedRows.length == 0) {
            return;
        }
        for (i = 0; i < selectedRows.length; ++i) {
            selectedRows[i] = this.list.convertRowIndexToModel(selectedRows[i]);
        }
        Arrays.sort(selectedRows);
        for (i = selectedRows.length - 1; i >= 0; --i) {
            int modelRowIndex = selectedRows[i];
            model.removeRow(modelRowIndex);
        }
        this.list.clearSelection();
        this.summary.setText(String.format("Initial price: %.2f", Float.valueOf(this.caclculateInitialPrice())));
        System.out.println(selectedRows.length + " Zeile(n) aus der Tabelle gel\u00f6scht.");
    }

    private float caclculateInitialPrice() {
        double money = 0.0;
        double shares = 0.0;
        for (int r = 0; r < this.model.getRowCount(); ++r) {
            Boolean e = (Boolean)this.model.getValueAt(r, 7);
            if (e == null || !e.booleanValue() || (e = (Boolean)this.model.getValueAt(r, 6)) == null || e.booleanValue()) continue;
            int count2 = 0;
            try {
                count2 = (Integer)this.model.getValueAt(r, 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                money += (Double)this.model.getValueAt(r, 3) * (double)count2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                shares += (Double)this.model.getValueAt(r, 4) * (double)count2;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (float)(money / shares);
    }

    public EditAutoTraderList() {
        this.initComponents();
        if (Globals.sim == null) {
            return;
        }
        this.load();
        this.list.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.list.setSurrendersFocusOnKeystroke(true);
        JComboBox comboBox = new JComboBox();
        JSpinner cashSpinner = new JSpinner(new SpinnerNumberModel(0.0, 0.0, Double.MAX_VALUE, 0.1));
        Globals.getStrategiesIntoComboBox(comboBox);
        this.model = (DefaultTableModel)this.list.getModel();
        this.list.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(comboBox));
        ColorChooserEditor colorEditor = new ColorChooserEditor();
        ColorCellRenderer colorRenderer = new ColorCellRenderer();
        this.list.getColumnModel().getColumn(5).setCellEditor(colorEditor);
        this.list.getColumnModel().getColumn(5).setCellRenderer(colorRenderer);
        this.list.setRowHeight(30);
        this.list.getModel().addTableModelListener(e -> this.summary.setText(String.format("Initial price: %.2f", Float.valueOf(this.caclculateInitialPrice()))));
        this.summary.setText(String.format("Initial price: %.2f", Float.valueOf(this.caclculateInitialPrice())));
    }

    void add() {
        DefaultTableModel model = (DefaultTableModel)this.list.getModel();
        model.setRowCount(model.getRowCount() + 1);
        model.setValueAt("New Trader", model.getRowCount() - 1, 0);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.list = new AutoTraderTable();
        this.summary = new JLabel();
        this.list.setAutoCreateRowSorter(true);
        this.list.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Count", "Strategy", "Cash", "Shares", "Color", "Exclude", "Enabled"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, Integer.class, Object.class, Double.class, Double.class, Object.class, Boolean.class, Boolean.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        if (this.list.getColumnModel().getColumnCount() > 0) {
            this.list.getColumnModel().getColumn(1).setPreferredWidth(30);
        }
        this.summary.setText("Text");
        GroupLayout layout2 = new GroupLayout(this);
        this.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addComponent(this.summary, -2, 264, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 753, Short.MAX_VALUE)).addContainerGap()));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 283, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.summary).addContainerGap()));
    }

    class ColorChooserEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private Color currentColor;
        private final JButton button = new JButton();
        private static final String EDIT = "edit";

        public ColorChooserEditor() {
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
            this.button.setOpaque(true);
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table2, Object value, boolean isSelected, int row, int column) {
            this.currentColor = (Color)value;
            if (this.currentColor != null) {
                this.button.setBackground(this.currentColor);
            } else {
                this.button.setBackground(UIManager.getColor("Button.background"));
            }
            return this.button;
        }

        public void old_actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                Color initialColor = this.currentColor != null ? this.currentColor : Color.WHITE;
                Color newColor = JColorChooser.showDialog(this.button, "W\u00e4hle eine Farbe", initialColor);
                if (newColor != null) {
                    this.currentColor = newColor;
                } else if (newColor != null || this.currentColor != null) {
                    // empty if block
                }
                this.fireEditingStopped();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                AtomicReference<Object> selectedColorRef = new AtomicReference<Object>(null);
                JColorChooser chooser = new JColorChooser(this.currentColor != null ? this.currentColor : Color.WHITE);
                ActionListener okListener = evt -> selectedColorRef.set(chooser.getColor());
                ActionListener cancelListener = evt -> {};
                ActionListener resetListener = evt -> {
                    selectedColorRef.set(null);
                    ((JDialog)((JButton)evt.getSource()).getTopLevelAncestor()).dispose();
                };
                JDialog dialog = JColorChooser.createDialog(this.button, "W\u00e4hle oder setze Standardfarbe", true, chooser, okListener, cancelListener);
                Component[] components = dialog.getContentPane().getComponents();
                if (components.length > 0 && components[components.length - 1] instanceof Container) {
                    Container buttonBar = (Container)components[components.length - 1];
                    JButton resetButton = new JButton("Default Color (NULL)");
                    resetButton.addActionListener(resetListener);
                    buttonBar.add((Component)resetButton, 0);
                }
                dialog.setVisible(true);
                Color newColor = selectedColorRef.get();
                if (newColor != null || selectedColorRef.get() == null) {
                    this.currentColor = newColor;
                }
                this.fireEditingStopped();
            }
        }
    }

    class ColorCellRenderer
    extends DefaultTableCellRenderer {
        private final Color DEFAULT_TABLE_BACKGROUND = UIManager.getColor("Table.background");

        ColorCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
            JLabel label = (JLabel)component;
            label.setText("");
            if (isSelected && value == null) {
                return component;
            }
            Color color = (Color)value;
            if (color != null) {
                label.setBackground(color);
                label.setForeground(Color.black);
            } else {
                label.setBackground(this.DEFAULT_TABLE_BACKGROUND);
                label.setForeground(UIManager.getColor("Table.foreground"));
            }
            return component;
        }
    }

    class AutoTraderTable
    extends JTable {
        private final int[] CUSTOM_EDITOR_COLUMNS;

        public AutoTraderTable() {
            this.CUSTOM_EDITOR_COLUMNS = new int[]{1, 3, 4, 5};
        }

        public AutoTraderTable(TableModel dm) {
            super(dm);
            this.CUSTOM_EDITOR_COLUMNS = new int[]{1, 3, 4, 5};
        }

        @Override
        public boolean editCellAt(int row, int column, EventObject e) {
            boolean isCustomEditorColumn = false;
            for (int colIndex : this.CUSTOM_EDITOR_COLUMNS) {
                if (column != colIndex) continue;
                isCustomEditorColumn = true;
                break;
            }
            if (isCustomEditorColumn) {
                KeyEvent ke;
                MouseEvent me;
                if (e instanceof MouseEvent && (me = (MouseEvent)e).getClickCount() < 2) {
                    return false;
                }
                if (e instanceof KeyEvent && (ke = (KeyEvent)e).getKeyCode() != 32) {
                    return false;
                }
            }
            return super.editCellAt(row, column, e);
        }
    }

    class oldColorRenderer
    extends DefaultTableCellRenderer {
        private final Color DEFAULT_COLOR = UIManager.getColor("Table.background");

        oldColorRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
            Color color = (Color)value;
            if (color != null) {
                component.setBackground(color);
                component.setForeground(Color.black);
                ((JLabel)component).setText("");
            } else {
                component.setBackground(this.DEFAULT_COLOR);
                component.setForeground(UIManager.getColor("Table.foreground"));
                ((JLabel)component).setText("");
            }
            if (isSelected) {
                component.setBackground(table2.getSelectionBackground());
                component.setForeground(table2.getSelectionForeground());
            }
            return component;
        }
    }

    class oldColorChooserEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private Color currentColor;
        private final JButton button = new JButton();
        private static final String EDIT = "edit";

        public oldColorChooserEditor() {
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
            this.button.setOpaque(true);
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table2, Object value, boolean isSelected, int row, int column) {
            this.currentColor = (Color)value;
            if (this.currentColor == null) {
                this.currentColor = Color.WHITE;
            }
            this.button.setBackground(this.currentColor);
            return this.button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                Color newColor = JColorChooser.showDialog(this.button, "W\u00e4hle eine Farbe f\u00fcr den Trader", this.currentColor != null ? this.currentColor : Color.WHITE);
                if (newColor != null) {
                    this.currentColor = newColor;
                }
                this.fireEditingStopped();
            }
        }
    }

    class old2SpinnerCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        final JSpinner spinner;

        public old2SpinnerCellEditor(double initialValue, double minimum, double maximum, double stepSize) {
            this.spinner = new JSpinner(new SpinnerNumberModel(initialValue, minimum, maximum, stepSize));
        }

        public old2SpinnerCellEditor(int initialValue, int minimum, int maximum, int stepSize) {
            this.spinner = new JSpinner(new SpinnerNumberModel(initialValue, minimum, maximum, stepSize));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table2, Object value, boolean isSelected, int row, int column) {
            this.spinner.setValue(value);
            return this.spinner;
        }

        @Override
        public Object getCellEditorValue() {
            return this.spinner.getValue();
        }
    }

    class SpinnerCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        final JSpinner spinner;
        private final JFormattedTextField textField;

        public SpinnerCellEditor(double initialValue, double minimum, double maximum, double stepSize) {
            this.spinner = new JSpinner(new SpinnerNumberModel(initialValue, minimum, maximum, stepSize));
            this.textField = ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
            this.addEnterListener();
        }

        public SpinnerCellEditor(int initialValue, int minimum, int maximum, int stepSize) {
            this.spinner = new JSpinner(new SpinnerNumberModel(initialValue, minimum, maximum, stepSize));
            this.textField = ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
            this.addEnterListener();
        }

        private void addEnterListener() {
            JFormattedTextField textField = ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
            textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        try {
                            SpinnerCellEditor.this.spinner.commitEdit();
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        SpinnerCellEditor.this.fireEditingStopped();
                        e.consume();
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table2, Object value, boolean isSelected, int row, int column) {
            this.spinner.setValue(value);
            SwingUtilities.invokeLater(() -> {
                this.textField.requestFocusInWindow();
                this.textField.selectAll();
            });
            return this.spinner;
        }

        @Override
        public Object getCellEditorValue() {
            return this.spinner.getValue();
        }
    }
}

