/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Globals;
import gui.SeSimApplication;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.LookAndFeel;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class EditPreferencesDialog
extends JDialog {
    UIManager.LookAndFeelInfo[] lafInfo;
    LookAndFeel old_laf;
    LookAndFeel new_laf;
    private JButton applyButton;
    private JButton cancelButton;
    private JTextField dataDirectory;
    private JCheckBox decoratedDialogs;
    private JCheckBox decoratedFrames;
    private JCheckBox godmodeCheckBox;
    private JComboBox<String> jComboBox1;
    private JCheckBox jDevleopmentFeaturesCheckBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JTextField jTextField1;
    private JComboBox<String> lafComboBox;
    private JCheckBox lightWightPopups;
    private JButton okButton;
    private JButton selectFileButton;

    public EditPreferencesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(this.getParent());
        this.old_laf = UIManager.getLookAndFeel();
        this.lafInfo = UIManager.getInstalledLookAndFeels();
        this.lafComboBox.removeAllItems();
        for (UIManager.LookAndFeelInfo lafInfo1 : this.lafInfo) {
            this.lafComboBox.addItem(lafInfo1.getName());
        }
        this.lafComboBox.setSelectedItem(Globals.prefs_new.get("laf", "Nimbus"));
        String selstr = Globals.prefs_new.get("devel_status", "false");
        this.jDevleopmentFeaturesCheckBox.setSelected(selstr.equals("true"));
        selstr = Globals.prefs_new.get("godmode", "false");
        this.godmodeCheckBox.setSelected(selstr.equals("true"));
        String dataDir = Globals.prefs_new.get("datadir", null);
        if (dataDir == null) {
            String userHome = System.getProperty("user.home", "");
            Path path = Paths.get(userHome, ".opensesim");
            dataDir = path.toString();
        }
        this.dataDirectory.setText(dataDir);
        this.decoratedDialogs.setSelected(Globals.prefs_new.getBoolean("laf_decorated_dialogs", true));
        this.decoratedFrames.setSelected(Globals.prefs_new.getBoolean("laf_decorated_frames", true));
        this.lightWightPopups.setSelected(Globals.prefs_new.getBoolean("laf_lightweight_popups", true));
    }

    private void initComponents() {
        this.godmodeCheckBox = new JCheckBox();
        this.jTextField1 = new JTextField();
        this.jComboBox1 = new JComboBox();
        this.cancelButton = new JButton();
        this.applyButton = new JButton();
        this.okButton = new JButton();
        this.jDevleopmentFeaturesCheckBox = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.dataDirectory = new JTextField();
        this.jLabel2 = new JLabel();
        this.selectFileButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.lafComboBox = new JComboBox();
        this.decoratedDialogs = new JCheckBox();
        this.decoratedFrames = new JCheckBox();
        this.lightWightPopups = new JCheckBox();
        this.godmodeCheckBox.setText("Godmode");
        this.godmodeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPreferencesDialog.this.godmodeCheckBoxActionPerformed(evt);
            }
        });
        this.jTextField1.setText("Minium OHLC compression:");
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPreferencesDialog.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.cancelButton.setMnemonic('c');
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPreferencesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.applyButton.setMnemonic('a');
        this.applyButton.setText("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPreferencesDialog.this.applyButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('o');
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPreferencesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jDevleopmentFeaturesCheckBox.setText("Develeopment");
        this.jLabel2.setText("Data directory");
        this.selectFileButton.setText("Select ...");
        this.selectFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPreferencesDialog.this.selectFileButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Look and Feel:");
        this.lafComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.lafComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPreferencesDialog.this.lafComboBoxActionPerformed(evt);
            }
        });
        this.decoratedDialogs.setText("Decorated dialogs");
        this.decoratedFrames.setText("Decorated frames");
        this.lightWightPopups.setText("Lightweight Popups");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lafComboBox, -2, 197, -2)).addComponent(this.decoratedDialogs).addComponent(this.decoratedFrames).addComponent(this.lightWightPopups)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.lafComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decoratedDialogs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.decoratedFrames).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lightWightPopups).addContainerGap(12, Short.MAX_VALUE)));
        GroupLayout layout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING).addGroup(layout2.createSequentialGroup().addContainerGap().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addComponent(this.jDevleopmentFeaturesCheckBox).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout2.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(layout2.createSequentialGroup().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout2.createSequentialGroup().addGap(9, 9, 9).addComponent(this.jLabel2))).addGap(0, 146, Short.MAX_VALUE)).addComponent(this.dataDirectory, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectFileButton))).addContainerGap()));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dataDirectory, -2, -1, -2).addComponent(this.selectFileButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 76, Short.MAX_VALUE).addComponent(this.jDevleopmentFeaturesCheckBox).addGap(34, 34, 34).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.applyButton).addComponent(this.okButton)).addContainerGap()));
        this.pack();
    }

    private void lafComboBoxActionPerformed(ActionEvent evt) {
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    void resetUI() {
        for (Window w : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(w);
        }
    }

    private void safeLiveLAFChange(String lafName) {
        this.dispose();
        Timer timer = new Timer(100, e -> {
            try {
                String className = this.findClassNameForLAF(lafName);
                UIManager.setLookAndFeel(className);
                for (Window w : Window.getWindows()) {
                    if (!(w instanceof JFrame) || !w.isVisible()) continue;
                    SwingUtilities.updateComponentTreeUI(w);
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    private String findClassNameForLAF(String lafName) {
        UIManager.LookAndFeelInfo[] lafInfo;
        for (UIManager.LookAndFeelInfo info : lafInfo = UIManager.getInstalledLookAndFeels()) {
            if (!info.getName().equals(lafName)) continue;
            return info.getClassName();
        }
        return lafName;
    }

    private void nuclearUIUpdate() {
        try {
            Window[] windows;
            PopupFactory.setSharedInstance(new PopupFactory());
            for (Window window : windows = Window.getWindows()) {
                if (!window.isDisplayable()) continue;
                this.updateWindowAndAllChildren(window);
            }
            ToolTipManager.sharedInstance().setInitialDelay(300);
            ToolTipManager.sharedInstance().setDismissDelay(10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateWindowAndAllChildren(Window window) {
        SwingUtilities.updateComponentTreeUI(window);
        this.updateMenuBarRecursively(window);
        if (window instanceof Container) {
            this.updateContainerRecursively(window);
        }
        window.revalidate();
        window.repaint();
    }

    private void updateMenuBarRecursively(Window window) {
        JMenuBar menuBar = null;
        if (window instanceof JFrame) {
            menuBar = ((JFrame)window).getJMenuBar();
        } else if (window instanceof JDialog) {
            menuBar = ((JDialog)window).getJMenuBar();
        }
        if (menuBar != null) {
            SwingUtilities.updateComponentTreeUI(menuBar);
            for (int i = 0; i < menuBar.getMenuCount(); ++i) {
                JMenu menu = menuBar.getMenu(i);
                if (menu == null) continue;
                this.updateMenuAndPopup(menu);
            }
        }
    }

    private void updateMenuAndPopup(JMenu menu) {
        try {
            menu.updateUI();
            JPopupMenu popupMenu = menu.getPopupMenu();
            if (popupMenu != null) {
                this.updatePopupAndChildren(popupMenu);
            }
            for (Component comp : menu.getMenuComponents()) {
                if (comp instanceof JMenu) {
                    this.updateMenuAndPopup((JMenu)comp);
                    continue;
                }
                if (!(comp instanceof JComponent)) continue;
                ((JComponent)comp).updateUI();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateContainerRecursively(Container container) {
        for (Component comp : container.getComponents()) {
            JPopupMenu componentPopup;
            if (comp instanceof JComponent) {
                ((JComponent)comp).updateUI();
            }
            if (comp instanceof JComponent && (componentPopup = ((JComponent)comp).getComponentPopupMenu()) != null) {
                this.updatePopupAndChildren(componentPopup);
            }
            if (comp instanceof JPopupMenu) {
                this.updatePopupAndChildren((JPopupMenu)comp);
            }
            if (!(comp instanceof Container)) continue;
            this.updateContainerRecursively((Container)comp);
        }
    }

    private void updatePopupAndChildren(JPopupMenu popup) {
        try {
            SwingUtilities.updateComponentTreeUI(popup);
            popup.updateUI();
            for (Component child : popup.getComponents()) {
                if (!(child instanceof JComponent)) continue;
                ((JComponent)child).updateUI();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void restartApplication() {
        try {
            String javaBin = System.getProperty("java.home") + "/bin/java";
            String classpath = System.getProperty("java.class.path");
            String mainClass = SeSimApplication.class.getName();
            ProcessBuilder builder = new ProcessBuilder(javaBin, "-cp", classpath, mainClass);
            builder.start();
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Bitte starten Sie die Anwendung manuell neu.", "Info", 1);
            System.exit(0);
        }
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        String selected = (String)this.lafComboBox.getSelectedItem();
        Globals.prefs_new.put("laf", selected);
        Globals.prefs_new.putBoolean("laf_decorated_dialogs", this.decoratedDialogs.isSelected());
        Globals.prefs_new.putBoolean("laf_decorated_frames", this.decoratedFrames.isSelected());
        Globals.prefs_new.putBoolean("laf_lightweight_popups", this.lightWightPopups.isSelected());
        boolean restart = false;
        if (!this.old_laf.getName().equals(selected)) {
            restart = true;
        }
        if (this.lightWightPopups.isSelected() != JPopupMenu.getDefaultLightWeightPopupEnabled()) {
            restart = true;
        }
        if (!restart) {
            return;
        }
        int option = JOptionPane.showConfirmDialog(this, "\u2713 Look and Feel has changed\n\nIt is recomended to reastart the application.\n\nRestart now?", "Settings saved", 0, 1);
        if (option == 0) {
            this.restartApplication();
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.applyButtonActionPerformed(evt);
        String selected = (String)this.lafComboBox.getSelectedItem();
        Globals.prefs_new.put("laf", selected);
        String sel = this.jDevleopmentFeaturesCheckBox.isSelected() ? "true" : "false";
        Globals.prefs_new.put("devel_status", sel);
        sel = this.godmodeCheckBox.isSelected() ? "true" : "false";
        Globals.prefs_new.put("godmode", sel);
        Globals.notifyCfgListeners();
        this.dispose();
    }

    private void godmodeCheckBoxActionPerformed(ActionEvent evt) {
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
    }

    private void selectFileButtonActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        fileChooser.setCurrentDirectory(new File(this.dataDirectory.getText()));
        fileChooser.setFileHidingEnabled(false);
        int option = fileChooser.showSaveDialog(null);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(EditPreferencesDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(EditPreferencesDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(EditPreferencesDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(EditPreferencesDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditPreferencesDialog dialog = new EditPreferencesDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

